(function(blocks, element, components, blockEditor) {
    var el = element.createElement;
    var registerBlockType = blocks.registerBlockType;
    var Button = components.Button;
    var Placeholder = components.Placeholder;
    var useBlockProps = blockEditor.useBlockProps;

    registerBlockType('redesignee/widget-block', {
        title: 'Redesignee Widget',
        icon: 'layout',
        category: 'widgets',
        keywords: ['redesignee', 'custom', 'html'],
        attributes: {
            widgetHtml: { type: 'string', default: '' },
            widgetId: { type: 'string', default: '' },
            instanceId: { type: 'string', default: '' } // Unique ID for this block instance
        },

        edit: function(props) {
            var attributes = props.attributes;
            var blockProps = useBlockProps({ className: 'rd-gutenberg-block' });

            // 1. Handle Button Click
            var openRedesignee = function() {
                if (window.Redesignee && window.Redesignee.openModal) {
                    window.Redesignee.openModal({
                        mode: attributes.widgetHtml ? 'edit' : 'add',
                        existingCode: attributes.widgetHtml,
                        widgetId: attributes.widgetId,
                        onSave: function(newCode, newId) {
                            // Update Block Attributes
                            props.setAttributes({
                                widgetHtml: newCode,
                                widgetId: newId,
                                instanceId: Date.now().toString()
                            });
                        }
                    });
                } else {
                    alert('Redesignee Editor is loading... please wait a moment.');
                }
            };

            // 2. Determine Label
            var labelText = attributes.widgetHtml ? 'Edit Widget' : 'Add Widget';
            var instructions = attributes.widgetHtml
                ? 'Widget is active. Click below to edit content/styles.'
                : 'Click to open the library and select a widget.';

            // 3. Render Editor UI (Placeholder)
            return el('div', blockProps,
                el(Placeholder, {
                        icon: 'layout',
                        label: 'Redesignee Widget',
                        instructions: instructions
                    },
                    el(Button, {
                        variant: 'primary',
                        onClick: openRedesignee,
                        style: { backgroundColor: '#764fe3', color: 'white' } // Brand color
                    }, labelText))
            );
        },

        save: function(props) {
            // 4. Save Logic: Output raw HTML for the frontend
            return el('div', {
                className: 'redesignee-block-output',
                dangerouslySetInnerHTML: { __html: props.attributes.widgetHtml }
            });
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.components,
    window.wp.blockEditor
);