jQuery(document).ready(function($) {

    // 1. DYNAMIC CLICK LISTENER
    $('body').on('click', '.elementor-control-open_library_btn button', function(e) {
        e.preventDefault();
        e.stopPropagation();


        // Get the currently selected widget in Elementor
        if (typeof elementor === 'undefined' || !elementor.selection) {
            console.error('[RD] Elementor API not found');
            return;
        }

        const selectedElements = elementor.selection.getElements();
        if (!selectedElements || selectedElements.length === 0) {
            alert('Please select a Redesignee widget first.');
            return;
        }

        // Get the model/settings from the first selected element
        const widgetContainer = selectedElements[0];
        const settingsModel = widgetContainer.settings; // Access the settings backbone model

        if (!settingsModel) {
            console.error('[RD] Could not find widget settings');
            return;
        }

        // Extract Data
        const currentCode = settingsModel.get('widget_html');
        const currentWidgetId = settingsModel.get('widget_id');
        const mode = (currentCode && currentCode.length > 50) ? 'edit' : 'add';


        // Call the Modal
        if (window.Redesignee && window.Redesignee.openModal) {
            window.Redesignee.openModal({
                mode: mode,
                widgetId: currentWidgetId,
                existingCode: currentCode,

                onSave: function(newCode, widgetId) {

                    const newSettings = { widget_html: newCode };
                    if (widgetId) newSettings.widget_id = widgetId;

                    if (window.$e) {
                        $e.run('document/elements/settings', {
                            container: widgetContainer.container || widgetContainer,
                            settings: newSettings,
                            options: { external: true }
                        });
                    } else {
                        settingsModel.set(newSettings);
                    }

                    $(e.currentTarget).text('Edit Widget');
                }
            });
        } else {
            alert('Library script not loaded yet. Please wait.');
        }
    });

    // 2. TEXT UPDATE HELPER
    if (typeof elementor !== 'undefined') {
        elementor.hooks.addAction('panel/open_editor/widget/redesignee_widget', function(panel, model, view) {
            setTimeout(function() {
                const hasContent = !!model.getSetting('widget_html');

                // FIX: Change view.$el to panel.$el
                // We need to search in the Sidebar Panel, not the Widget Preview
                const $btn = panel.$el.find('.elementor-control-open_library_btn button');

                if ($btn.length) {
                    $btn.text(hasContent ? 'Edit Widget' : 'Open Widget Library');
                }
            }, 100);
        });
    }
});