<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Redesignee_Elementor_Widget extends \Elementor\Widget_Base {

    public function get_name() { return 'redesignee_widget'; }

    // FIX 1: Updated Text Domain to 'redesignee'
    public function get_title() { return esc_html__( 'Redesignee Widget', 'redesignee' ); }

    public function get_icon() { return 'eicon-code'; }
    public function get_categories() { return [ 'general' ]; }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Widget Settings', 'redesignee' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // 1. The Button to Open the Library
        $this->add_control(
            'open_library_btn',
            [
                'label' => esc_html__( 'Customize Widget', 'redesignee' ),
                'type' => \Elementor\Controls_Manager::BUTTON,
                'button_type' => 'success',
                'text' => esc_html__( 'Open Widget Library', 'redesignee' ),
                'event' => 'redesignee:open_library', // We listen for this in JS
            ]
        );

        // 2. Hidden Control to store the HTML/CSS/JS blob
        $this->add_control(
            'widget_html',
            [
                // FIX 1: Updated Text Domain
                'label' => esc_html__( 'Widget Code (Hidden)', 'redesignee' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => '',
                'classes' => 'redesignee-hidden-control', // Helper class to hide it via CSS if needed
            ]
        );

        // 3. Hidden Control to store the ID (for re-opening the correct editor)
        $this->add_control(
            'widget_id',
            [
                'label' => 'Widget ID',
                'type' => \Elementor\Controls_Manager::HIDDEN,
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $html = $settings['widget_html'];

        if ( empty( $html ) ) {
            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                echo '<div style="padding: 40px; background: #f0f0f0; border: 2px dashed #ccc; text-align: center; color: #555;">';
                echo '<h3 style="margin:0 0 10px;">' . esc_html__( 'Redesignee Widget', 'redesignee' ) . '</h3>';
                echo '<p>' . esc_html__( 'Click "Open Widget Library" in the sidebar to select a widget.', 'redesignee' ) . '</p>';
                echo '</div>';
            }
            return;
        }

        echo '<div class="redesignee-elementor-wrapper">';

        echo $html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

        echo '</div>';
    }
}