<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class Redesignee_Elementor_Extension {
    public function __construct() {
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
        add_action( 'elementor/editor/after_enqueue_scripts', [ $this, 'enqueue_editor_scripts' ] );
    }

    public function register_widgets( $widgets_manager ) {
        // Load the widget file
        require_once( __DIR__ . '/widgets/redesignee-widget.php' );

        // Register the widget
        $widgets_manager->register( new \Redesignee_Elementor_Widget() );
    }

    public function enqueue_editor_scripts() {
        wp_enqueue_script(
            'redesignee-elementor-handler',
            plugins_url( '../js/admin-elementor.js', __FILE__ ),
            [ 'jquery', 'elementor-editor', 'redesignee-editor-overlay' ],
            '1.0',
            true
        );
    }
}

new Redesignee_Elementor_Extension();