<?php
/**
 * Popup template for displaying recently viewed products.
 *
 * This template is used to display the products that the user has recently viewed.
 * It is included in the popup that appears when the user clicks on the "Recently Viewed Products" link.
 *
 */

defined( 'ABSPATH' ) || exit;

$max_products = get_option( 'wrvpp_max_products', 3 );
$position     = get_option( 'wrvpp_popup_position', 'bottom-right' );
$link_text    = get_option( 'wrvpp_popup_link_text', __( 'View All', 'recently-viewed-products-popup-woo' ) );
$counter      = 0;
?>

<ul class="wrvpp-product-list wrvpp-product-list-<?php echo esc_attr( $position ); ?>">
    <?php while ( $query->have_posts() ) : $query->the_post(); global $product; ?>
        <li class="wrvpp-product">
            <a href="<?php echo esc_url( $product->get_permalink() ); ?>" title="<?php echo esc_attr( $product->get_name() ); ?>">
                <?php echo wp_kses_post( $product->get_image( 'thumbnail' ) ); ?>
            </a>
        </li>
        <?php $counter++; ?>
        <?php if ( $counter >= $max_products ) break; ?>
    <?php endwhile; ?>
    <li><a href="#" id="wrvpp-view-all"><?php echo esc_html( $link_text ); ?></a></li>
</ul>