<?php
/**
 * Modal template for displaying recently viewed products.
 */

defined( 'ABSPATH' ) || exit;


if ( wp_doing_ajax() ) {
    // Fix add to cart URL for simple products in AJAX context
    add_filter('woocommerce_product_add_to_cart_url', 'wrvpp_fix_add_to_cart_url', 10, 2);
    function wrvpp_fix_add_to_cart_url( $url, $product ) {
        if ( $product->is_type('simple') && $product->is_purchasable() && $product->is_in_stock() ) {
            if ( wp_get_referer() ) {
                return add_query_arg( 'add-to-cart', $product->get_id(), wp_get_referer() );
            }
            return add_query_arg( 'add-to-cart', $product->get_id(), get_permalink( $product->get_id() ) );
        }
        return $url;
    }
}
?>

<?php if ( ! wp_doing_ajax() ) : ?>
    <div class="wrvpp-modal-overlay"></div>
<?php endif; ?>
<div id="wrvpp-modal" class="wrvpp-modal woocommerce">
    <div class="wrvpp-modal-content">
        <div class="wrvpp-modal-header">
            <h4><?php echo esc_html( get_option( 'wrvpp_modal_title', __( 'Recently Viewed Products', 'recently-viewed-products-popup-woo' ) ) ); ?></h4>
            <span class="wrvpp-close">&times;</span>
        </div>
        <div class="wrvpp-modal-body">
            <?php woocommerce_product_loop_start(); ?>
            
                <?php
                foreach ( $viewed_products as $viewed_product_id ) {
                    $post_object = get_post( $viewed_product_id );
                    if ( ! $post_object || 'product' !== $post_object->post_type ) continue;
                    setup_postdata( $GLOBALS['post'] = $post_object );
                    wc_get_template_part( 'content', 'product' );
                }
                ?>
            
            <?php woocommerce_product_loop_end(); ?>
        </div>
    </div>
</div>
<?php
if ( wp_doing_ajax() ) {
    // Remove the filter after use to avoid affecting other parts
    remove_filter( 'woocommerce_product_add_to_cart_url', 'wrvpp_fix_add_to_cart_url', 10 );
}