<?php
/**
 * Plugin Name: Recently Viewed Products Popup for WooCommerce
 * Description: Display recently viewed products in a small, fixed, cache-friendly popup on WooCommerce pages, with a modal window to view more.
 * Version: 1.1.0
 * Author: Martonix
 * Author URI: https://profiles.wordpress.org/martonix/
 * Required Plugin: woocommerce
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: recently-viewed-products-popup-woo
 * Domain Path: /languages
 * 
 */

defined( 'ABSPATH' ) || exit;

define( 'WRVPP_PLUGIN_VERSION', '1.1.0' );
define( 'WRVPP_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'WRVPP_PLUGIN_URL', plugin_dir_url( __FILE__ ) );


function wrvpp_run_plugin() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', function() {
            echo '<div class="notice notice-error"><p>' . esc_html__( 'Woo Recently Viewed Products Popup requires WooCommerce to be installed and activated.', 'recently-viewed-products-popup-woo' ) . '</p></div>';
        } );
        return;
    }
    require_once WRVPP_PLUGIN_DIR . 'includes/class-wrvpp-main.php';
    // Initialize the main plugin class.
    $wrvpp_main = new WRVPP_Main();
}
add_action( 'plugins_loaded', 'wrvpp_run_plugin' );

/**
 * Add settings link to the plugin action links.
 *
 * @param array $links Existing links.
 * @return array Modified links.
 */
function wrvpp_plugin_action_links( $links ) {
    $settings_link = '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=products&section=wrvpp' ) . '">' . esc_html__( 'Settings', 'recently-viewed-products-popup-woo' ) . '</a>';
    array_unshift( $links, $settings_link );
    return $links;
}
add_action( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'wrvpp_plugin_action_links' );
