<?php
/**
 * Settings class for the Recently Viewed Products Popup plugin.
 */
class WRVPP_Settings {

    /**
     * Initialize the settings page.
     */
    public function init() {
        add_action( 'woocommerce_get_sections_products', array( $this, 'add_settings_section' ), 10 );
        add_filter( 'woocommerce_get_settings_products', array( $this, 'add_settings_fields' ), 10, 2 );
    }

    /**
     * Add a new section to the WooCommerce products settings.
     *
     * @param array $sections Existing sections.
     * @return array Modified sections.
     */
    public function add_settings_section( $sections ) {
        $sections['wrvpp'] = __( 'Recently Viewed Products Popup', 'recently-viewed-products-popup-woo' );
        return $sections;
    }

    /**
     * Add settings fields to the new section.
     *
     * @param array $settings Existing settings.
     * @param string $current_section Current section.
     * @return array Modified settings.
     */
    public function add_settings_fields( $settings, $current_section ) {
        if ( 'wrvpp' === $current_section ) {
            $settings = array();

            $settings[] = array(
                'name' => __( 'Recently Viewed Products Popup Settings', 'recently-viewed-products-popup-woo' ),
                'type' => 'title',
                'id'   => 'wrvpp_settings',
            );

            $settings[] = array(
                'name'     => __( 'Enable Popup', 'recently-viewed-products-popup-woo' ),
                'desc'     => __( 'Enable the recently viewed products popup.', 'recently-viewed-products-popup-woo' ),
                'id'       => 'wrvpp_enable_popup',
                'type'     => 'checkbox',
                'default'  => 'yes',
            );

            $settings[] = array(
                'name'     => __( 'Display Popup On', 'recently-viewed-products-popup-woo' ),
                'desc_tip' => __( 'Choose where the popup should be displayed.', 'recently-viewed-products-popup-woo' ),
                'id'       => 'wrvpp_display_on',
                'type'     => 'multiselect',
                'class'    => 'wc-enhanced-select',
                'default'  => array( 'is_product' ),
                'options'  => array(
                    'all_pages'           => __( 'All Pages', 'recently-viewed-products-popup-woo' ),
                    'is_product'          => __( 'Single Product', 'recently-viewed-products-popup-woo' ),
                    'is_shop'             => __( 'Shop', 'recently-viewed-products-popup-woo' ),
                    'is_product_category' => __( 'Product Category', 'recently-viewed-products-popup-woo' ),
                    'is_cart'             => __( 'Cart', 'recently-viewed-products-popup-woo' ),
                ),
            );

            $settings[] = array(
                'name'     => __( 'Number of Products to Save', 'recently-viewed-products-popup-woo' ),
                'desc_tip' => __( 'Maximum number of recently viewed products saved per user.', 'recently-viewed-products-popup-woo' ),
                'id'       => 'wrvpp_limit_products',
                'type'     => 'number',
                'min'      => 1,
                'default'  => 15,
            );

            $settings[] = array(
                'name'     => __( 'Maximum Products to Display', 'recently-viewed-products-popup-woo' ),
                'desc_tip' => __( 'Maximum number of recently viewed products to show in the popup.', 'recently-viewed-products-popup-woo' ),
                'id'       => 'wrvpp_max_products',
                'type'     => 'number',
                'min'      => 1,
                'default'  => 3,
            );

            $settings[] = array(
                'name'     => __( 'Popup Position', 'recently-viewed-products-popup-woo' ),
                'desc_tip' => __( 'Choose where the popup appears on the screen.', 'recently-viewed-products-popup-woo' ),
                'id'       => 'wrvpp_popup_position',
                'type'     => 'select',
                'default'  => 'bottom-right',
                'options'  => array(
                    'bottom-left'  => __( 'Bottom Left', 'recently-viewed-products-popup-woo' ),
                    'bottom-right' => __( 'Bottom Right', 'recently-viewed-products-popup-woo' ),
                ),
            );

            $settings[] = array(
                'name' => __( 'Popup Link Text', 'recently-viewed-products-popup-woo' ),
                'desc_tip' => __( 'Text for the link that opens the modal window.', 'recently-viewed-products-popup-woo' ),
                'id'       => 'wrvpp_popup_link_text',
                'type'     => 'text',
                'default'  => __( 'View All', 'recently-viewed-products-popup-woo' ),
                'class'    => 'wrvpp-modal-settings',
            );

            $settings[] = array(
                'name'     => __( 'Modal Title', 'recently-viewed-products-popup-woo' ),
                'desc_tip' => __( 'Title displayed at the top of the modal window.', 'recently-viewed-products-popup-woo' ),
                'id'       => 'wrvpp_modal_title',
                'type'     => 'text',
                'default'  => __( 'Recently Viewed Products', 'recently-viewed-products-popup-woo' ),
                'class'    => 'wrvpp-modal-settings',
            );

            $settings[] = array(
                'type' => 'sectionend',
                'id'   => 'wrvpp_settings',
            );
        }

        return $settings;
    }

}
