(function() {
    'use strict';

    if (typeof wrvpp_tracking_params === 'undefined') {
        return;
    }

    var productId = wrvpp_tracking_params.product_id ? parseInt(wrvpp_tracking_params.product_id) : 0;
    if ( ! productId ) {
        return;
    }

    var trackLimit = wrvpp_tracking_params.track_limit ? parseInt(wrvpp_tracking_params.track_limit) : 15;
    var cookieDays = wrvpp_tracking_params.cookie_days ? parseInt(wrvpp_tracking_params.cookie_days) : 30;
    var cookieName = wrvpp_tracking_params.cookie_name || 'wrvpp_recently_viewed_products';

    function wrvpp_getCookie(name) {
        const nameEQ = name + "=";
        const decodedCookie = decodeURIComponent(document.cookie);
        const cookies = decodedCookie.split(';');
        for ( let i = 0; i < cookies.length; i++ ) {
            let cookie = cookies[i].trim();
            if ( cookie.indexOf(nameEQ) === 0 ) {
                return cookie.substring(nameEQ.length);
            }
        }
        
        return null;
    }

    function wrvpp_setCookie(name, value, days) {
        const date = new Date();
        date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
        document.cookie = `${name}=${encodeURIComponent(value)}; expires=${date.toUTCString()}; path=/`;
    }

    // Update cookie with current product
    var viewed = wrvpp_getCookie(cookieName);
    viewed = viewed ? viewed.split('|').map(n => parseInt(n)) : [];

    // Remove if already exists and add to front
    viewed = viewed.filter( id => id !== productId );
    viewed.unshift(productId);

    // Limit to trackLimit
    viewed = viewed.slice(0, trackLimit);
    wrvpp_setCookie(cookieName, viewed.join('|'), cookieDays);

})();
