(function($) {

    $(document).ready(function() {

        if (typeof wrvpp_params === 'undefined') {
            return;
        }

        let cookieName = wrvpp_params.cookie_name || 'wrvpp_recently_viewed_products';

        function wrvpp_getCookie(name) {
            var nameEQ = name + "=";
            var decodedCookie = decodeURIComponent(document.cookie);
            var cookies = decodedCookie.split(';');

            for (var i = 0; i < cookies.length; i++) {
                var cookie = cookies[i].trim();
                if (cookie.indexOf(nameEQ) === 0) {
                    return cookie.substring(nameEQ.length);
                }
            }
            return null;
        }

        function wrvpp_init_slick() {
            var $products = $('#wrvpp-modal .products');
            if ($products.length && !$products.hasClass('slick-initialized')) {
                $products.slick({
                    slidesToShow: 4,
                    slidesToScroll: 1,
                    infinite: false,
                    autoplay: false,
                    responsive: [
                        { breakpoint: 1024, settings: { slidesToShow: 3 } },
                        { breakpoint: 768, settings: { slidesToShow: 2 } },
                        { breakpoint: 480, settings: { slidesToShow: 1 } }
                    ]
                });
            }
        }

        wrvpp_init_slick();
    
        function closeModal(e) {
            e.preventDefault();
            $('body').removeClass('open-modal');
        }

        // Get viewed products from cookie
        var viewed = wrvpp_getCookie(cookieName);
        viewed = viewed ? viewed.split('|').map(Number) : [];

        if (viewed.length > 0) {
            // Add containers if not present
            if (!$('.wrvpp-product-list').length) {
                $('body').append('<div class="wrvpp-product-list"></div>');
            }
            if (!$('#wrvpp-modal').length) {
                $('body').append('<div class="wrvpp-modal-overlay"></div><div id="wrvpp-modal"></div>');
            }

            var $popup = $('.wrvpp-product-list');
            var $modal = $('#wrvpp-modal');

            $.ajax({
                url: wrvpp_params.ajax_url,
                type: 'POST',
                data: {
                    action: 'wrvpp_get_recently_viewed',
                    nonce: wrvpp_params.nonce,
                    product_id: wrvpp_params.product_id,
                    viewed_products: viewed
                },
                success: function(response) {
                    if ( response.success ) {
                        $popup.replaceWith( response.data.popup );
                        $modal.replaceWith( response.data.modal );
                        wrvpp_init_slick();
                    } else {
                        console.error( response.data.message );
                    }
                },
                error: function() {
                    console.error( 'An error occurred while fetching recently viewed products.' );
                }
            });
        }

        $(document).on('click', '#wrvpp-view-all', function(e) {
            e.preventDefault();
            $('body').addClass('open-modal');
        });
        $(document).on('click', '.wrvpp-close', closeModal);
        $(document).on('click', '.wrvpp-modal-overlay', closeModal);
        $(document).on('keydown', function(e) {
            if (e.key === 'Escape' && $('body').hasClass('open-modal')) {
                closeModal(e);
            }
        });
   
    });

})(jQuery);

