jQuery(document).ready(function($) {
    const $select = $('#wrvpp_display_on');
    const ALL_PAGES = 'all_pages';

    $select.on('select2:select', function(e) {
        const selectedId = e.params.data?.id;
        const currentValues = $select.val() || [];
        
        let newValues;
        if (selectedId === ALL_PAGES) {
            newValues = [ALL_PAGES];
        } else if (currentValues.includes(ALL_PAGES)) {
            newValues = currentValues.filter(value => value !== ALL_PAGES);
        } else {
            return;
        }

        if (newValues.toString() !== currentValues.toString()) {
            $select.val(newValues).trigger('change');
        }
    });
});