<?php
/**
 * Plugin Name: reCaptcha By Roger
 * Plugin URI: https://betterhowto.com
 * Description: Improve Google Analytics Bot Detection With reCaptcha
 * Version: 1.0
 * Author: Roger
 * Author URI: http://betterhowto.com
 * License: GPL2
 */

$notice = "";
$rcptha_site_key_value   = get_option("rcptha_site_key_value" , false);
$rcptha_secret_key_value = get_option("rcptha_secret_key_value" , false);

function rcptha_recaptcha_enqueue_scripts() {
    global $rcptha_site_key_value;
    if($rcptha_site_key_value !== false){
        wp_enqueue_script( 'google-re-captcha-custom-api', 'https://www.google.com/recaptcha/api.js?render='.$rcptha_site_key_value, array('jquery'));
        wp_enqueue_script( 'admin-recaptcha-ajax', plugin_dir_url(__FILE__).'recaptcha.js', array('jquery'), time() );
        wp_localize_script( 'admin-recaptcha-ajax', 'recaptcha_ajax', array( 'ajax_url' => admin_url( 'admin-ajax.php' ), 'recaptcha_key' => "$rcptha_site_key_value" ) );
    }
}
add_action( 'wp_enqueue_scripts', 'rcptha_recaptcha_enqueue_scripts' );
add_action ( 'admin_enqueue_scripts', function () {
    if (is_admin ())
        wp_enqueue_media ();
        wp_enqueue_style('admin-datatables', plugin_dir_url(__FILE__).'/DataTables/datatables.min.css');
        wp_enqueue_script('admin-datatable', plugin_dir_url(__FILE__).'/DataTables/datatables.min.js', array('jquery'));
} );        


// -- Custom uploadings pin tables init
function rcptha_activate_db()
{
    global $table_prefix, $wpdb;
    $tblname = 'roger_recaptcha_logs';
    $wp_track_table = $table_prefix . "$tblname";
    #Check to see if the table exists already, if not, then create it
    if($wpdb->get_var( "show tables like '$wp_track_table'" ) != $wp_track_table)
    {
        $sql = "CREATE TABLE $wp_track_table (
                `id` int(11) NOT NULL AUTO_INCREMENT,
                `referer` text,
                `ua` text,
                `remoteip` text,
                `ray` text,
                `path` text,
                `hostname` text,
                `score` text,
                `create_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                    PRIMARY KEY (`id`)
                ) ENGINE=InnoDB DEFAULT CHARSET=latin1; ";
        require_once( ABSPATH . '/wp-admin/includes/upgrade.php' );
        dbDelta($sql);
    }
}
register_activation_hook( __FILE__, 'rcptha_activate_db' );

/*
 -- Delete db log
*/
if(isset($_POST['recaptchalogdelete'])){
    global $table_prefix, $wpdb;
    $tblname = 'roger_recaptcha_logs';
    $wp_track_table = $table_prefix . "$tblname";
    
    $wpdb->delete( $wp_track_table, array( 'id' => sanitize_text_field($_POST['recaptchalogid']) ) );
    // -- error checking
    if($wpdb->last_error !== '') {
        $notice = '<div id="message" class="error notice is-dismissible"><p>WordPress database error: ['.$wpdb->last_error.']</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
    }else{
        $notice = '<div id="message" class="updated notice is-dismissible"><p>Record Deleted Successfully.</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
    }
}


/*
 -- Admin page for SiteKey & SecretKey settings
*/

function recaptcha_admin_settings_page()
{
     add_menu_page(
        'ReCaptcha Logs',
        'ReCaptcha Logs',
        'manage_options',
        'recaptcha-logs',
        'rcptha_admin_page_view',
        'dashicons-database'
    );

    add_submenu_page(
        'recaptcha-logs',
        'Settings Admin', 
        'ReCaptcha Keys', 
        'manage_options', 
        'recaptcha-settings', 
        'recaptcha_settings'
    );

}
add_action( 'admin_menu', 'recaptcha_admin_settings_page' );

/*
 -- Save Settings keys
*/
if(isset($_POST['recaptcha_save_keys'])) {
    $rcptha_site_key_value = sanitize_text_field($_POST['rcptha_site_key_value']);
    $rcptha_secret_key_value = sanitize_text_field($_POST['rcptha_secret_key_value']);

    if(isset($_POST['server_log'])){
        update_option( 'is_log_active', 'checked' );
    }
    else{
        update_option( 'is_log_active', '' );
    }

     // -- db logs
    if(isset($_POST['roger_db_log'])){
        update_option( 'is_db_log_active', 'checked' );
    }else{
        update_option( 'is_db_log_active', '' );
    }

    update_option( "rcptha_site_key_value", $rcptha_site_key_value );
    update_option( "rcptha_secret_key_value", $rcptha_secret_key_value );
    $notice = '<div id="message" class="updated notice is-dismissible"><p>Captcha Keys Saved Successfully.</p><button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button></div>';
}


function recaptcha_settings() {
    global $notice,$rcptha_site_key_value,$rcptha_secret_key_value;
    echo $notice;
    ?>
    <h2>Google reCaptcha Settings</h2>
    <form method="POST">
        <table>
            <tr>
                <td>Site Key:</td>
                <td><input type="text" required class="regular-text" value="<?=$rcptha_site_key_value?>" name="rcptha_site_key_value" placeholder="reCaptcha Site Key"></td>
            </tr>
            
            <tr>
                <td>Secret Key:</td>
                <td><input type="text" required class="regular-text" value="<?=$rcptha_secret_key_value?>" name="rcptha_secret_key_value" placeholder="reCaptcha Secret Key"></td>
            </tr>

            <tr>
                <td>Activate Server Log:</td>
                <td><input type="checkbox" class="regular-text" name="server_log" <?=get_option( 'is_log_active' , 'checked')?>></td>
            </tr>


            <tr>
                <td>Active Database Log:</td>
                <td><input type="checkbox" class="regular-text" name="roger_db_log" <?=get_option( 'is_db_log_active' , '')?>></td>
            </tr>

            <tr>
                <td colspan="2">
                    <input type="submit" value="Save Keys" name="recaptcha_save_keys" class="button-primary" />
                </td>
            </tr>
        </table>
    </form>
    <?php
}


add_action( 'wp_ajax_nopriv_recaptcha_analytics', 'recaptcha_analytics_ajax_action' );
add_action( 'wp_ajax_recaptcha_analytics', 'recaptcha_analytics_ajax_action' );
function recaptcha_analytics_ajax_action() {
    global $rcptha_secret_key_value;
    if($rcptha_secret_key_value !== false){
        // reCaptcha info
        $url = 'https://www.google.com/recaptcha/api/siteverify';        
        $secret = $rcptha_secret_key_value;
        $remoteip = $_SERVER['REMOTE_ADDR'] ?? null;
        $ray = $_SERVER['HTTP_CF_RAY'] ?? null;

        if (!$remoteip) {
            rcptha_betterDie("Could not get remoteip");
        }

        // Form info
        $action = sanitize_text_field($_POST['captcha_action'])?? null;
        $token = sanitize_text_field($_POST['token']) ?? null;
        $path = sanitize_text_field($_POST['path']) ?? null;

       
        if (empty($action) || empty($token)) {
            rcptha_betterDie("Empty action or token in call to " . $_SERVER['PHP_SELF']);
        }

        // Botscore
        $botscore = sanitize_text_field($_COOKIE['_rbs']) ?? null;

        $body = array(
            'secret' => $secret,
            'remoteip' => $remoteip,
            'action' => $action,
            'response' => $token
        );

        $args = array(
            'body'        => $body,
        );

        $response = wp_remote_post( $url, $args );

        if ($response['body'] === false) {
            rcptha_betterDie("fetch($url) failed. " . $_SERVER['PHP_SELF']);
        }

        //refresh the cookie
        $curlJson = json_decode($response['body'], true);
        if ($curlJson === false) {
            rcptha_betterDie("Recd. a non JSON response from Google: $response");
        }

        $success = $curlJson['success'] ?? false;

        if (!$success) {
            log($curlJson);
            rcptha_betterDie("Google failed to validate request. Response: $response");
        }

        
        setcookie('_rbs', $curlJson['score'], time()+3600, '/','', 0); 

        //defining the answer
        $answer = $response['body'];

        header("Content-Type: application/json");
        header('cache-control: no-cache, must-revalidate, max-age=0');

        // only fire $answer if botscore cookie is not set or different from actual score
        if ($botscore != $curlJson['score']) {
            echo $answer;
            
            $active_log = get_option( 'is_log_active' );
            if($active_log !== ''){
               rcptha_writeLogMessage($curlJson);
            }

            // -- Database Logs
            $db_logs = get_option( 'is_db_log_active' );
            if($db_logs !== ''){
               rcptha_writeDatabaseLog($curlJson);
            }  

        } else {
            echo json_encode(['result'=>"nochange"]);
        }
    }

    exit;
}

// -- Plugin settings URls
add_filter('plugin_action_links_'.plugin_basename(__FILE__), 'rcptha_add_plugin_page_settings_link');
function rcptha_add_plugin_page_settings_link( $links ) {
    $links[] = '<a href="' . admin_url( 'admin.php?page=recaptcha-settings' ) . '">' . __('Settings') . '</a>';
    return $links;
}

function rcptha_betterDie($message, $response_code = 400) {
    http_response_code($response_code);
    error_log($message);
    die();
}

function rcptha_writeLogMessage($response) {
    $data = [];
    $data['referer'] = sanitize_text_field($_SERVER['HTTP_REFERER']) ?? null;
    $data['ua'] = sanitize_text_field($_SERVER['HTTP_USER_AGENT']) ?? null;
    $data['remoteip'] = sanitize_text_field($_SERVER['REMOTE_ADDR']) ?? null;
    $data['ray'] = sanitize_text_field($_SERVER['HTTP_CF_RAY']) ?? null;
    $data['path'] = sanitize_text_field($_POST['path']) ?? null;
    $merge = $data + $response;
    rcptha_writeLogFile($merge);
}

function rcptha_writeLogFile(array $info) : void {
    $prefix = date('yy-m-d-h-');
    $pathPrefix = date('yy-m-d');
    $id = isset($_SERVER['UNIQUE_ID']) ? $prefix . $_SERVER['UNIQUE_ID'] : uniqid($prefix, true);
    $logDir = dirname(__FILE__) . '/captchaLogs/' . $pathPrefix;
    if (!@mkdir($logDir) && !is_dir($logDir)) {
        throw new RuntimeException(sprintf('Directory "%s" was not created', $logDir));
    }
    $filename = $logDir . "/$id.json";
    file_put_contents($filename, json_encode($info, JSON_PARTIAL_OUTPUT_ON_ERROR, 10));
}

// -- save Logs to database 
function rcptha_writeDatabaseLog($src) {
    global $table_prefix, $wpdb;
    $tblname = 'roger_recaptcha_logs';
    $wp_track_table = $table_prefix . "$tblname";
    
    // db run
    $wpdb->insert($wp_track_table,
        array(
            "referer" => $_SERVER['HTTP_REFERER'],
            "ua" => $_SERVER['HTTP_USER_AGENT'],
            "remoteip" => $_SERVER['REMOTE_ADDR'],
            "ray" => $_SERVER['HTTP_CF_RAY'],
            "path" => parse_url($_SERVER['HTTP_REFERER'],PHP_URL_PATH),
            "hostname" => $src['hostname'],
            "score" => $src['score']
        )
    );
    //var_dump($wpdb->last_error);
}

// -- admin dashboard settings
include_once( "admin_dashboard/menu_page.php" );
?>