grecaptcha = window.grecaptcha || {};
grecaptcha.ready(function() {
    const params = new URLSearchParams(document.location.search.substring(1));
    const action = params.get("utm_source") || "homepage";
    grecaptcha.execute(recaptcha_ajax.recaptcha_key, {action})
        .then(token => sendRecaptchaToken(token, action));
});

function sendRecaptchaToken(token, action) {
    let xhr = new XMLHttpRequest();
    xhr.onload = function () {
        if (xhr.status != 200) {
            return;
        }
        let greResult = JSON.parse(xhr.response);
        if (greResult) {
            if (greResult.result && greResult.result != "nochange") {
                window.dataLayer.push({
                    event: "recaptcha",
                    recaptchaAnswer: greResult.success,
                    recaptchaScore: greResult.score,
                });
            }
        }
    };
    xhr.open("POST", recaptcha_ajax.ajax_url, true);
    xhr.setRequestHeader(
        "Content-type",
        "application/x-www-form-urlencoded"
    );
    let p = new URLSearchParams();
    p.append("token", token);
    p.append("captcha_action", action);
    p.append("action", "recaptcha_analytics");
    p.append("path", document.location.href);
    xhr.send(p);
}