/* /assets/js/mrw-widget.js - Versión 1.4.5 Estabilizada */
(function() {
    if ( typeof rtwfmData === 'undefined' || !rtwfmData.apiUrl || !rtwfmData.token ) {
        console.warn('Matomo Widget: Configuration missing.');
        return;
    }

    const API_URL = rtwfmData.apiUrl;
    const SITE_ID = rtwfmData.siteId;
    const TOKEN   = rtwfmData.token;
    const CONF_NOTIFY = (rtwfmData.confNotify === '1');
    const CONF_MODE   = rtwfmData.confMode;
    const CONF_THRESH = parseInt(rtwfmData.confThresh);
    const CONF_SOUND  = (rtwfmData.confSound === '1');
    const STR = rtwfmData.strings;

    let audioUnlocked = false;
    function unlockAudioSystem() {
        if (!audioUnlocked) {
            const player = document.getElementById('rtwfm-alert-audio');
            if(player) {
                player.play().then(() => {
                    player.pause();
                    player.currentTime = 0;
                    audioUnlocked = true;
                }).catch((e) => {});
            }
            document.removeEventListener('click', unlockAudioSystem);
            document.removeEventListener('touchstart', unlockAudioSystem);
            document.removeEventListener('keydown', unlockAudioSystem);
        }
    }
    document.addEventListener('click', unlockAudioSystem);
    document.addEventListener('touchstart', unlockAudioSystem);
    document.addEventListener('keydown', unlockAudioSystem);

    function playNotificationSound() {
        const player = document.getElementById('rtwfm-alert-audio');
        if(!player || !audioUnlocked) return;
        player.currentTime = 0;
        player.volume = 1.0;
        var promise = player.play();
        if (promise !== undefined) {
            promise.then(_ => {}).catch(error => { console.error("Audio Error:", error); });
        }
    }

    const setSafe = (id, val) => { const el = document.getElementById(id); if (el) el.innerText = val; };
    const getEl = (id) => document.getElementById(id);
    const buildUrl = (method, extra = '') => `${API_URL}index.php?module=API&method=${method}&idSite=${SITE_ID}&format=JSON&token_auth=${TOKEN}${extra}&random=${Date.now()}`;
    const valOrUnk = (val) => (val && val !== '' && val !== '-' && val !== null) ? val : STR.unknown;

    function maskIp(ip) {
        if(!ip || ip === STR.unknown) return ip;
        if(ip.match(/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/)) return ip.replace(/\.\d{1,3}$/, '.*');
        if(ip.indexOf(':') > -1) return ip.substring(0, ip.lastIndexOf(':')) + ':*';
        return ip;
    }

    function getMinutesSinceMidnight() {
        const now = new Date();
        const midnight = new Date(now.getFullYear(), now.getMonth(), now.getDate(), 0, 0, 0);
        return Math.max(1, Math.floor((now - midnight) / 60000));
    }

    function getLocalDateStr() {
        const d = new Date();
        return d.getFullYear() + '-' + String(d.getMonth() + 1).padStart(2, '0') + '-' + String(d.getDate()).padStart(2, '0');
    }

    function getYesterdayDateStr() {
        const d = new Date();
        d.setDate(d.getDate() - 1);
        return d.getFullYear() + '-' + String(d.getMonth() + 1).padStart(2, '0') + '-' + String(d.getDate()).padStart(2, '0');
    }

    let lastVisitCount = 0, lastVisitorID = null, isFirstLoad = true;

    function sendNotification(title, body) {
        if (!("Notification" in window)) return;
        if (Notification.permission === "granted") {
            try {
                new Notification(title, { body: body, icon: rtwfmData.iconUrl });
                if(CONF_SOUND) playNotificationSound();
            } catch (e) {}
        }
    }

    function checkAlerts(currentCount, latestVisitor) {
        if (!CONF_NOTIFY) return;
        if (isFirstLoad) {
            lastVisitCount = currentCount;
            if(latestVisitor) lastVisitorID = latestVisitor.visitorId;
            isFirstLoad = false;
            return;
        }
        if (CONF_MODE === 'threshold' && currentCount >= CONF_THRESH) {
            if (currentCount > lastVisitCount) sendNotification(STR.trafficHigh, STR.visitsActive + " " + currentCount);
        } else {
            if (latestVisitor && latestVisitor.visitorId !== lastVisitorID) {
                const country = latestVisitor.country || STR.unknown;
                let actionText = STR.navigating;
                if(latestVisitor.actionDetails && latestVisitor.actionDetails.length > 0) {
                    actionText = latestVisitor.actionDetails[latestVisitor.actionDetails.length-1].pageTitle || STR.action;
                }
                sendNotification(STR.newVisit + " (" + country + ")", actionText);
            }
        }
        lastVisitCount = currentCount;
        if(latestVisitor) lastVisitorID = latestVisitor.visitorId;
    }

    function renderTrend(elementId, todayVal, yesterdayVal) {
        const el = getEl(elementId);
        if(!el) return;
        if (yesterdayVal === 0) {
            el.innerHTML = '<span class="trend-icon">−</span> 0%';
            el.className = 'trend-badge trend-neutral';
            el.title = STR.yesterday0;
            return;
        }
        const diff = todayVal - yesterdayVal;
        const percent = Math.round((Math.abs(diff) / yesterdayVal) * 100);
        if (diff > 0) { el.innerHTML = '<span class="trend-icon">▲</span> ' + percent + '%'; el.className = 'trend-badge trend-up'; }
        else if (diff < 0) { el.innerHTML = '<span class="trend-icon">▼</span> ' + percent + '%'; el.className = 'trend-badge trend-down'; }
        else { el.innerHTML = '<span class="trend-icon">=</span> 0%'; el.className = 'trend-badge trend-neutral'; }
        el.title = STR.yesterday + " " + yesterdayVal;
    }

    let chartVisits = null, chartPerf = null, globalHistoryData = null;

    async function fetchAllGraphs() {
        const btnV = getEl('btn-refresh-visits'), btnP = getEl('btn-refresh-perf');
        if(btnV) btnV.classList.add('spinning'); if(btnP) btnP.classList.add('spinning');
        try {
            const resVisits = await fetch(buildUrl('VisitsSummary.get', '&period=day&date=last30')).then(r => r.json());
            globalHistoryData = resVisits;
            const resPerf = await fetch(buildUrl('PagePerformance.get', '&period=day&date=last30')).then(r => r.json());
            const minsToday = getMinutesSinceMidnight();
            const resLiveToday = await fetch(buildUrl('Live.getCounters', '&lastMinutes=' + minsToday)).then(r => r.json());
            const labels = [], dataPoints = [], todayStr = getLocalDateStr();
            const liveVal = (resLiveToday && resLiveToday[0]) ? resLiveToday[0].visits : 0;
            for (const [dStr, metrics] of Object.entries(resVisits)) {
                const d = new Date(dStr);
                labels.push(d.toLocaleDateString(document.documentElement.lang, { weekday: 'short', day: 'numeric', month: 'short' }));
                dataPoints.push(dStr === todayStr ? liveVal : (metrics.nb_visits || 0));
            }
            if (chartVisits) chartVisits.destroy();
            const ctxV = document.getElementById('matomoChart');
            if (ctxV) {
                chartVisits = new Chart(ctxV, {
                    type: 'line',
                    data: { labels: labels, datasets: [{ label: STR.visits, data: dataPoints, borderColor: '#2271b1', backgroundColor: '#2271b1', borderWidth: 2, pointRadius: 3, pointHoverRadius: 5, tension: 0, fill: false }] },
                    options: { responsive: true, maintainAspectRatio: false, plugins: { legend: { display: false }, tooltip: { backgroundColor: 'rgba(0,0,0,0.9)', displayColors: false, callbacks: { label: (c) => c.parsed.y + ' ' + STR.visits } } }, scales: { y: { beginAtZero: true }, x: { grid: { display: false } } } }
                });
            }
            const dsN = [], dsS = [], dsT = [], dsD1 = [], dsD2 = [], dsL = [];
            for (const [dStr, m] of Object.entries(resPerf)) {
                dsN.push(m.avg_time_network || 0); dsS.push(m.avg_time_server || 0); dsT.push(m.avg_time_transfer || 0);
                dsD1.push(m.avg_time_dom_processing || 0); dsD2.push(m.avg_time_dom_completion || 0); dsL.push(m.avg_time_on_load || 0);
            }
            if (chartPerf) chartPerf.destroy();
            const ctxP = document.getElementById('perfChart');
            if (ctxP) {
                chartPerf = new Chart(ctxP, {
                    type: 'bar',
                    data: { labels: labels, datasets: [
                        { label: STR.perfNetwork, data: dsN, backgroundColor: '#0077b6' }, { label: STR.perfServer, data: dsS, backgroundColor: '#e08e0b' },
                        { label: STR.perfTransfer, data: dsT, backgroundColor: '#d63638' }, { label: STR.perfDomProc, data: dsD1, backgroundColor: '#6f42c1' },
                        { label: STR.perfDomComp, data: dsD2, backgroundColor: '#28a745' }, { label: STR.perfOnLoad, data: dsL, backgroundColor: '#17a2b8' }
                    ]},
                    options: { 
                        responsive: true, maintainAspectRatio: false, interaction: { mode: 'index', intersect: false },
                        scales: { x: { stacked: true, grid: { display: false } }, y: { stacked: true, beginAtZero: true } },
                        plugins: { legend: { display: false }, tooltip: { backgroundColor: 'rgba(0,0,0,0.9)', callbacks: { label: (c) => parseFloat(c.parsed.y).toFixed(2) + 's ' + c.dataset.label, footer: (items) => { let sum = 0; items.forEach(it => sum += it.parsed.y); return sum.toFixed(2) + 's Total'; } } } }
                    }
                });
            }
        } catch (e) { console.error(e); } finally { if(btnV) btnV.classList.remove('spinning'); if(btnP) btnP.classList.remove('spinning'); }
    }

    async function fetchRealTimeData() {
        const dot = getEl('m-dot'), status = getEl('m-status');
        if(!dot || !status) return;
        try {
            dot.classList.add('active');
            status.innerText = STR.updating;
            const minsToday = getMinutesSinceMidnight();
            const [res3m, res30m, resLiveToday, res24h, resLog] = await Promise.all([
                fetch(buildUrl('Live.getCounters', '&lastMinutes=3')).then(r => r.json()),
                fetch(buildUrl('Live.getCounters', '&lastMinutes=30')).then(r => r.json()),
                fetch(buildUrl('Live.getCounters', '&lastMinutes=' + minsToday)).then(r => r.json()),
                fetch(buildUrl('Live.getCounters', '&lastMinutes=1440')).then(r => r.json()),
                fetch(buildUrl('Live.getLastVisitsDetails', '&filter_limit=10')).then(r => r.json())
            ]);
            if (res3m.result === 'error') throw new Error(res3m.message);
            const currentActive = parseInt(res3m[0]?.visits || 0);
            checkAlerts(currentActive, (resLog && resLog.length > 0) ? resLog[0] : null);
            const todayVisits = resLiveToday[0]?.visits || 0, todayActions = resLiveToday[0]?.actions || 0;
            const yesterdayStr = getYesterdayDateStr();
            let yVisits = 0, yActions = 0;
            if (globalHistoryData && globalHistoryData[yesterdayStr]) {
                yVisits = globalHistoryData[yesterdayStr].nb_visits || 0;
                yActions = globalHistoryData[yesterdayStr].nb_actions || 0;
            }
            setSafe('val-live', currentActive); setSafe('val-live-vis', currentActive); setSafe('val-live-act', res3m[0]?.actions || 0);
            setSafe('val-uniq', todayVisits); setSafe('val-page', todayActions);
            renderTrend('trend-uniq', todayVisits, yVisits); renderTrend('trend-page', todayActions, yActions);
            setSafe('val-24-v', (res24h[0]?.visits || 0) + ' ' + STR.visits); setSafe('val-24-a', (res24h[0]?.actions || 0) + ' ' + STR.actions);
            setSafe('val-30-v', (res30m[0]?.visits || 0) + ' ' + STR.visits); setSafe('val-30-a', (res30m[0]?.actions || 0) + ' ' + STR.actions);

            let html = '';
            if (resLog && resLog.length > 0) {
                resLog.forEach(v => {
                    const fixUrl = (u) => (u && u.startsWith('http')) ? u : API_URL + u;
                    const date = new Date(v.serverTimestamp * 1000);
                    const timeStr = date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit', second: '2-digit' });
                    const dateStr = date.toLocaleDateString([], { weekday: 'short', day: 'numeric' });
                    
                    const tCountry = valOrUnk(v.countryPretty || v.country), tRegion = valOrUnk(v.region), tCity = valOrUnk(v.city), tIP = maskIp(valOrUnk(v.visitIp)), tID = valOrUnk(v.visitorId), tLang = (v.browserLanguage) ? STR.langCode + " " + v.browserLanguage : STR.unknown;
                    const flagTooltipHtml = `<div class="m-tooltip-box"><span class="ft-row"><span class="ft-label">${STR.txtCountry}</span> <span class="ft-val">${tCountry}</span></span><span class="ft-row"><span class="ft-label">${STR.txtRegion}</span> <span class="ft-val">${tRegion}</span></span><span class="ft-row"><span class="ft-label">${STR.txtCity}</span> <span class="ft-val">${tCity}</span></span><span class="ft-row"><span class="ft-label">${STR.txtLang}</span> <span class="ft-val">${tLang}</span></span><span class="ft-row"><span class="ft-label">${STR.txtIP}</span> <span class="ft-val">${tIP}</span></span><span class="ft-row"><span class="ft-label">${STR.txtID}</span> <span class="ft-val">${tID}</span></span></div>`;

                    const flag = v.countryFlag ? `<div class="flag-wrapper"><img src="${fixUrl(v.countryFlag)}">${flagTooltipHtml}</div>` : '';
                    const browser = v.browserIcon ? `<img src="${fixUrl(v.browserIcon)}" title="${v.browserName}">` : '';
                    const os = v.operatingSystemIcon ? `<img src="${fixUrl(v.operatingSystemIcon)}" title="${v.operatingSystemName}">` : '';
                    const profileUrl = `${API_URL}index.php?module=CoreHome&action=index&idSite=${SITE_ID}&period=day&date=today#?idSite=${SITE_ID}&period=day&date=today&category=Dashboard_Dashboard&subcategory=1&popover=visitorProfile%243A${v.visitorId}`;
                    const rawDuration = v.visitDuration || 0;
                    const loadBadge = rawDuration > 0 ? `<span class="load-time-badge">${Math.floor(rawDuration / 60)}m ${rawDuration % 60}s</span>` : '';

                    // LÓGICA DE REFERER ESTABILIZADA
                    let refHtml = STR.directEntry;
                    const rType = v.referrerType, rName = v.referrerName || '';
                    if (rType === 'search' || rType === 'social') {
                        const subfolder = (rType === 'search') ? 'searchEngines' : 'socials';
                        let fileName = rName.toLowerCase().trim().replace(/\s+/g, '');

                        // MAPEO QUIRÚRGICO DE EXCEPCIONES
                        if (fileName.includes('yandex')) fileName = 'yandex.ru';
                        else if (fileName.includes('bluesky') || fileName.includes('bsky')) fileName = 'bsky.app';
                        else if (fileName.includes('google')) fileName = 'google.com';
                        else if (fileName.includes('bing')) fileName = 'bing';
                        else if (fileName.includes('brave')) fileName = 'brave';
                        else if (fileName.includes('twitter') || fileName === 'x') fileName = 'twitter.com';

                        const iconPath = `${API_URL}plugins/Morpheus/icons/dist/${subfolder}/${fileName}.png`;
                        
                        refHtml = `<span class="ref-icon-wrap" style="display:inline-flex;align-items:center;">
                            <img src="${iconPath}" style="height:16px;width:16px;margin-right:5px;" 
                                 onerror="
                                    const s = this.src;
                                    if(s.includes('.com.png') || s.includes('.ru.png') || s.includes('.app.png')){
                                        this.style.display='none'; 
                                        this.nextElementSibling.style.display='inline-block';
                                    } else {
                                        this.src = s.replace('.png', '.com.png');
                                    }
                                 ">
                            <span class="dashicons dashicons-share-alt2" style="display:none; font-size:14px; margin-right:5px; color:#999;"></span>
                            <span>${rName}</span>
                        </span>`;

                        if (rType === 'search' && v.referrerKeyword && v.referrerKeyword !== STR.keywordUndef) {
                            refHtml += ` <i style="font-size:11px;color:#888;">"${v.referrerKeyword}"</i>`;
                        }
                    } else if (rType === 'website') {
                        refHtml = STR.refPrefix + ' <a href="' + (v.referrerUrl || '#') + '" target="_blank" style="color:#666">' + rName + '</a>';
                    } else if (rType === 'campaign') {
                        refHtml = STR.campPrefix + ' ' + rName;
                    }

                    let actHtml = '';
                    if (v.actionDetails) {
                        v.actionDetails.forEach(a => {
                            let dIco = 'dashicons-portfolio';
                            switch(a.type) { case 'download': dIco = 'dashicons-download'; break; case 'outlink': dIco = 'dashicons-external'; break; case 'event': dIco = 'dashicons-megaphone'; break; case 'search': dIco = 'dashicons-search'; break; }
                            const timeSpent = a.timeSpent ? (Math.floor(a.timeSpent / 60) > 0 ? Math.floor(a.timeSpent / 60) + 'm ' : '') + (a.timeSpent % 60) + 's' : '0s';
                            const tooltip = `<div class="m-tooltip-box"><div class="at-url">${a.url || ''}</div><div class="at-title">${(a.pageTitle || '').replace(/"/g, '&quot;')}</div><div class="at-meta">${STR.txtTime} ${timeSpent}</div></div>`;
                            actHtml += `<a href="${a.url || '#'}" target="_blank" class="action-wrapper"><span class="dashicons ${dIco}"></span>${tooltip}</a>`;
                        });
                    }
                    html += `<div class="visitor-row"><div class="v-line"><b>${timeStr}</b> ${loadBadge} <span style="font-size:11px;color:#888">(${dateStr})</span><span class="v-icons" style="display:flex;align-items:center;gap:3px;">${flag}${browser}${os}</span><a href="${profileUrl}" target="_blank" class="profile-link dashicons dashicons-businessperson" title="Profile"></a></div><div class="v-line v-ref">${refHtml}</div><div class="v-line v-actions">${actHtml}</div></div>`;
                });
            } else { html = '<div style="padding:20px;text-align:center;color:#ccc;">' + STR.loading + '</div>'; }
            if(getEl('log-content')) getEl('log-content').innerHTML = html;
            status.innerText = STR.live + new Date().toLocaleTimeString() + ')';
        } catch (err) { console.error(err); status.innerText = 'Error'; } finally { dot.classList.remove('active'); }
    }

    fetchAllGraphs();
    fetchRealTimeData();
    setInterval(fetchRealTimeData, 10000);
    if (getEl('btn-refresh-visits')) getEl('btn-refresh-visits').addEventListener('click', fetchAllGraphs);
    if (getEl('btn-refresh-perf')) getEl('btn-refresh-perf').addEventListener('click', fetchAllGraphs);
})();