/* /assets/js/mrw-settings.js */
document.addEventListener('DOMContentLoaded', function() {
    
    // Check if params exist (Renamed to rtwfmSettingsParams)
    if(typeof rtwfmSettingsParams === 'undefined') return;

    // Test Sound logic
    const testAudioObj = new Audio(rtwfmSettingsParams.testAudioUrl);

    // Make global so button onclick works (renamed function)
    window.rtwfmTestNotification = function() {
        if (!("Notification" in window)) { 
            alert(rtwfmSettingsParams.strNoSupport); 
            return; 
        }
        
        const iconUrl = rtwfmSettingsParams.iconUrl;

        if (Notification.permission === "granted") {
            new Notification(rtwfmSettingsParams.strTestTitle, { 
                body: rtwfmSettingsParams.strTestBody, 
                icon: iconUrl 
            });
            testAudioObj.play().catch(e => alert("Error: " + e));
        } else if (Notification.permission !== "denied") {
            Notification.requestPermission().then(function (permission) {
                if (permission === "granted") {
                    new Notification(rtwfmSettingsParams.strTestTitle, { 
                        body: rtwfmSettingsParams.strPermissionGranted, 
                        icon: iconUrl 
                    });
                    testAudioObj.play();
                }
            });
        } else {
            alert(rtwfmSettingsParams.strDenied);
        }
    };
});