<?php
/*
Plugin Name: Rank Jet Ai SEO Optimization
Plugin URI: https://rankjet.ai/
Description: AI-powered SEO plugin that helps you optimize your WordPress site with AI-generated meta tags, keyword suggestions, and content analysis.
Version: 1.0.9
Author: wpdive
Author URI: https://wpdive.com
Text Domain: rankjet-ai
Domain Path: /lang
Requires at least: 5.4
Tested up to: 6.9
Requires PHP: 7.4
License: GPLv3 or later
License URI: https://www.gnu.org/licenses/gpl-3.0.html
*/


defined('ABSPATH') or die('You cannot access this file directly.');

// Define plugin constants
define('RANKJET_AI_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('RANKJET_AI_PLUGIN_URL', plugin_dir_url(__FILE__));
define('RANKJET_AI_VERSION', '1.0.9');

// Include the initializer
require_once RANKJET_AI_PLUGIN_DIR . 'inc/init/class-rankjet-ai-init.php';

// Initialize the plugin
new Rankjet_Ai_Init();

// Activation hook for database tables
register_activation_hook(__FILE__, function() {
    // Include redirect classes for installation
    require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-redirect-cache.php';
    require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-redirects.php';
    require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-404-monitor.php';
    
    // Install database tables
    Rankjet_Ai_Redirects::install();
    Rankjet_Ai_404_Monitor::install();
    
    // Set default options
    add_option('rankjet_auto_redirect_slug_change', 'yes');
    add_option('rankjet_404_log_retention', 30);
});
