<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
    xmlns:html="http://www.w3.org/TR/REC-html40"
    xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>XML Sitemap</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="robots" content="noindex,follow"/>
    <style type="text/css">
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            color: #1e293b;
            line-height: 1.6;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        .header {
            background: linear-gradient(135deg, #4F46E5 0%, #7C3AED 100%);
            border-radius: 16px;
            padding: 40px;
            margin-bottom: 32px;
            color: #fff;
            box-shadow: 0 10px 40px rgba(79, 70, 229, 0.3);
        }
        .header h1 {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .header h1 svg {
            width: 40px;
            height: 40px;
        }
        .header p {
            font-size: 16px;
            opacity: 0.9;
            margin-bottom: 20px;
        }
        .header .meta {
            display: flex;
            gap: 24px;
            flex-wrap: wrap;
        }
        .header .meta-item {
            background: rgba(255,255,255,0.15);
            padding: 8px 16px;
            border-radius: 8px;
            font-size: 14px;
            font-weight: 500;
        }
        .header .meta-item strong {
            color: #fff;
        }
        .branding {
            font-size: 12px;
            opacity: 0.8;
            margin-top: 20px;
            padding-top: 16px;
            border-top: 1px solid rgba(255,255,255,0.2);
        }
        .branding a {
            color: #fff;
            text-decoration: none;
            font-weight: 600;
        }
        .branding a:hover {
            text-decoration: underline;
        }
        .card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            overflow: hidden;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th {
            background: #f8fafc;
            text-align: left;
            padding: 16px 20px;
            font-size: 12px;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: #64748b;
            border-bottom: 2px solid #e2e8f0;
        }
        td {
            padding: 16px 20px;
            border-bottom: 1px solid #f1f5f9;
            font-size: 14px;
        }
        tr:last-child td {
            border-bottom: none;
        }
        tr:hover td {
            background: #f8fafc;
        }
        td a {
            color: #4F46E5;
            text-decoration: none;
            font-weight: 500;
            word-break: break-all;
        }
        td a:hover {
            text-decoration: underline;
            color: #4338CA;
        }
        .date {
            color: #64748b;
            font-size: 13px;
        }
        .footer {
            text-align: center;
            padding: 32px 20px;
            color: #64748b;
            font-size: 13px;
        }
        .footer a {
            color: #4F46E5;
            text-decoration: none;
            font-weight: 600;
        }
        .footer a:hover {
            text-decoration: underline;
        }
        .badge {
            display: inline-block;
            background: linear-gradient(135deg, #4F46E5 0%, #7C3AED 100%);
            color: #fff;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        @media (max-width: 768px) {
            .header {
                padding: 24px;
            }
            .header h1 {
                font-size: 24px;
            }
            .header .meta {
                flex-direction: column;
                gap: 8px;
            }
            th, td {
                padding: 12px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>
                <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <path d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2"></path>
                    <rect x="9" y="3" width="6" height="4" rx="2"></rect>
                    <path d="M9 14l2 2 4-4"></path>
                </svg>
                XML Sitemap
            </h1>
            <p>This sitemap contains all URLs for search engine indexing.</p>
            <div class="meta">
                <div class="meta-item">
                    <strong><xsl:value-of select="count(sitemap:sitemapindex/sitemap:sitemap)"/></strong> Sitemaps
                </div>
                <div class="meta-item">
                    <span class="badge">Sitemap Index</span>
                </div>
            </div>
            <div class="branding">
                ⚡ Generated by <a href="https://rankjet.ai" target="_blank">RankJet AI</a> - Smart SEO for WordPress
            </div>
        </div>
        
        <div class="card">
            <table>
                <thead>
                    <tr>
                        <th style="width: 60%;">Sitemap URL</th>
                        <th style="width: 40%;">Last Modified</th>
                    </tr>
                </thead>
                <tbody>
                    <xsl:for-each select="sitemap:sitemapindex/sitemap:sitemap">
                        <tr>
                            <td>
                                <a href="{sitemap:loc}"><xsl:value-of select="sitemap:loc"/></a>
                            </td>
                            <td class="date">
                                <xsl:value-of select="concat(substring(sitemap:lastmod, 1, 10), ' ', substring(sitemap:lastmod, 12, 8))"/>
                            </td>
                        </tr>
                    </xsl:for-each>
                </tbody>
            </table>
        </div>
        
        <div class="footer">
            Powered by <a href="https://rankjet.ai" target="_blank">RankJet AI</a> • XML Sitemap Plugin for WordPress
        </div>
    </div>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
