# RankJet AI XML Sitemap - .htaccess Rules

This document provides the `.htaccess` rewrite rules for serving the XML Sitemap at pretty URLs.

> **Note:** WordPress typically handles these rewrites automatically through its rewrite API. The rules below are only needed if you experience issues or need to configure an Apache server manually.

## Rewrite Rules

Add the following rules to your WordPress root `.htaccess` file, **before** the `# BEGIN WordPress` section:

```apache
# BEGIN RankJet AI Sitemap
<IfModule mod_rewrite.c>
RewriteEngine On
RewriteBase /

# Sitemap Index
RewriteRule ^sitemap_index\.xml$ /index.php?rankjet_sitemap=index [L,QSA]

# Post Sitemap (with optional pagination)
RewriteRule ^post-sitemap([0-9]*)\.xml$ /index.php?rankjet_sitemap=post&rankjet_sitemap_page=$1 [L,QSA]

# Page Sitemap (with optional pagination)
RewriteRule ^page-sitemap([0-9]*)\.xml$ /index.php?rankjet_sitemap=page&rankjet_sitemap_page=$1 [L,QSA]

# Category Sitemap (with optional pagination)
RewriteRule ^category-sitemap([0-9]*)\.xml$ /index.php?rankjet_sitemap=category&rankjet_sitemap_page=$1 [L,QSA]

# Tag Sitemap (with optional pagination)
RewriteRule ^post_tag-sitemap([0-9]*)\.xml$ /index.php?rankjet_sitemap=post_tag&rankjet_sitemap_page=$1 [L,QSA]

# Custom Post Type Sitemaps (generic pattern)
RewriteRule ^([a-z_]+)-sitemap([0-9]*)\.xml$ /index.php?rankjet_sitemap=$1&rankjet_sitemap_page=$2 [L,QSA]
</IfModule>
# END RankJet AI Sitemap
```

## Sitemap URLs

Once configured, your sitemaps will be available at:

| Sitemap Type | URL Pattern |
|--------------|-------------|
| Sitemap Index | `https://yourdomain.com/sitemap_index.xml` |
| Posts | `https://yourdomain.com/post-sitemap.xml` |
| Posts (Page 2) | `https://yourdomain.com/post-sitemap2.xml` |
| Pages | `https://yourdomain.com/page-sitemap.xml` |
| Categories | `https://yourdomain.com/category-sitemap.xml` |
| Tags | `https://yourdomain.com/post_tag-sitemap.xml` |

## Nginx Configuration

For Nginx servers, add these location blocks:

```nginx
# RankJet AI Sitemap
location = /sitemap_index.xml {
    rewrite ^(.*)$ /index.php?rankjet_sitemap=index last;
}

location ~ ^/([a-z_]+)-sitemap([0-9]*)\.xml$ {
    rewrite ^/([a-z_]+)-sitemap([0-9]*)\.xml$ /index.php?rankjet_sitemap=$1&rankjet_sitemap_page=$2 last;
}
```

## Troubleshooting

### Sitemap returns 404
1. Go to **Settings > Permalinks** in WordPress admin
2. Click "Save Changes" (this flushes rewrite rules)
3. Try accessing the sitemap again

### Sitemap shows blank page
1. Check that the RankJet AI plugin is activated
2. Verify the sitemap is enabled in **RankJet AI > XML Sitemap**
3. Check PHP error logs for any issues

### Cache not updating
1. Go to **RankJet AI > XML Sitemap**
2. Click "Regenerate Sitemap" to clear the cache
3. The cache automatically clears when posts are published/updated

## Submit to Search Engines

Submit your sitemap to search engines:

- **Google Search Console**: https://search.google.com/search-console
- **Bing Webmaster Tools**: https://www.bing.com/webmasters

Add your sitemap URL: `https://yourdomain.com/sitemap_index.xml`
