<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Rankjet_Ai_Content_Service {

    private $integration;

    public function __construct($integration) {
        $this->integration = $integration;
    }

    /**
     * Generate content via API
     */
    public function generate_content($type, $context = [], $prompt = '') {
        $data = [
            'type' => $type,
            'context' => $context,
            'prompt' => $prompt
        ];
        
        return $this->integration->make_api_request('/plugin/generate', 'POST', $data);
    }

    /**
     * Get connections for a specific URL
     */
    public function get_connections($url) {
        return $this->integration->make_api_request('/plugin/connections', 'GET', ['url' => $url]);
    }

    /**
     * Check content originality via AI
     */
    public function check_originality($content) {
        $data = [
            'content' => $content
        ];
        
        return $this->integration->make_api_request('/plugin/originality', 'POST', $data);
    }

    /**
     * Analyze content semantically via AI
     */
    public function analyze_semantics($content) {
        $data = [
            'content' => $content
        ];
        
        return $this->integration->make_api_request('/plugin/semantic-analysis', 'POST', $data);
    }

    /**
     * Get keyword ideas/suggestions via AI
     */
    public function get_keyword_ideas($keyword, $post_title = '') {
        $data = [
            'keyword' => $keyword,
            'post_title' => $post_title
        ];
        
        return $this->integration->make_api_request('/plugin/keyword-ideas', 'POST', $data);
    }
}
