<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Rankjet_Ai_Init {

    public function __construct() {
        // Load dependencies
        $this->load_dependencies();

        // Load text domain
        add_action('plugins_loaded', [$this, 'load_textdomain']);

        // Initialize components
        $this->initialize_components();
        
        // Check for database upgrades (for existing installations)
        // Note: Redirect tables are created via the Setup Wizard UI for better UX
        // add_action('admin_init', [$this, 'check_db_upgrades']);
    }
    
    /**
     * Check and run database upgrades for existing installations
     * Note: This is currently disabled for redirects - users should use the Setup Wizard
     * This can be re-enabled for future features that need auto-migration
     */
    public function check_db_upgrades() {
        // Placeholder for future database upgrade checks
        // Redirect tables are now created via the Setup Wizard in the admin UI
    }

    /**
     * Load the plugin text domain for translation.
     */
    public function load_textdomain() {
        load_plugin_textdomain(
            'rankjet-ai',
            false,
            dirname(plugin_basename(RANKJET_AI_PLUGIN_DIR . 'rankjet-ai.php')) . '/lang'
        );
    }

    private function load_dependencies() {
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/admin/class-rankjet-ai-admin.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/admin/class-rankjet-ai-dashboard.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/admin/class-rankjet-ai-titles-meta.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/sitemap/class-rankjet-ai-sitemap.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/admin/class-rankjet-ai-sitemap-admin.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/integration/class-rankjet-ai-platform-integration.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/services/class-rankjet-ai-content-service.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/integration/class-rankjet-ai-page-data-handler.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/editor/class-rankjet-ai-editor.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/admin/class-rankjet-ai-schema-templates.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/frontend/class-rankjet-ai-frontend.php';
        
        // Redirect Manager module
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-redirect-cache.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-redirects.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-404-monitor.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-redirect-ai.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-slug-monitor.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/redirects/class-rankjet-ai-redirect-import.php';
    }

    private function initialize_components() {
        // Core Admin UI - Always loaded
        new Rankjet_Ai_Admin();
        new Rankjet_Ai_Dashboard();

        // Titles & Meta
        if (Rankjet_Ai_Dashboard::is_module_enabled('titles_meta')) {
            new Rankjet_Ai_Titles_Meta();
            new Rankjet_Ai_Schema_Templates();
        }

        // XML Sitemap
        if (Rankjet_Ai_Dashboard::is_module_enabled('xml_sitemap')) {
            new Rankjet_Ai_Sitemap();
            new Rankjet_Ai_Sitemap_Admin();
        }

        // AI Integration & Editor
        if (Rankjet_Ai_Dashboard::is_module_enabled('ai_integration')) {
            $integration = new Rankjet_Ai_Platform_Integration();
            new Rankjet_Ai_Page_Data_Handler();
            new Rankjet_Ai_Editor($integration);
            new Rankjet_Ai_Frontend();
        }
        
        // Redirect Manager components
        $redirects_enabled = Rankjet_Ai_Dashboard::is_module_enabled('redirects');
        $monitor_404_enabled = Rankjet_Ai_Dashboard::is_module_enabled('404_monitor');
        $slug_monitor_enabled = Rankjet_Ai_Dashboard::is_module_enabled('slug_monitor');

        // Load main redirects class if any module needing the UI is active (Redirects, 404 Monitor, or Slug Monitor)
        if ($redirects_enabled || $monitor_404_enabled || $slug_monitor_enabled) {
            new Rankjet_Ai_Redirects();
        }

        if ($monitor_404_enabled) {
            new Rankjet_Ai_404_Monitor();
        }

        if ($slug_monitor_enabled) {
            new Rankjet_Ai_Slug_Monitor();
        }

        if ($redirects_enabled) {
            new Rankjet_Ai_Redirect_Import();
        }
    }
}

