<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Rankjet_Ai_Frontend {

    private $variables;
    private $meta;
    private $schema;

    public function __construct() {
        // Load Dependencies
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/frontend/class-rankjet-ai-frontend-variables.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/frontend/class-rankjet-ai-frontend-meta.php';
        require_once RANKJET_AI_PLUGIN_DIR . 'inc/frontend/class-rankjet-ai-frontend-schema.php';

        // Instantiate
        $this->variables = new Rankjet_Ai_Frontend_Variables();
        $this->meta = new Rankjet_Ai_Frontend_Meta($this->variables);
        $this->schema = new Rankjet_Ai_Frontend_Schema($this->variables);

        // Assets
        add_action('wp_enqueue_scripts', [$this, 'enqueue_frontend_assets']);

        // SEO Hooks
        // 999 priority to ensure we override other plugins/themes
        add_filter('pre_get_document_title', [$this->meta, 'seo_title'], 999);
        
        // Remove default WP Title rendering so we can place it inside our block
        remove_action( 'wp_head', '_wp_render_title_tag', 1 );
        
        // Remove default robots tag so we can place it inside our block
        remove_action( 'wp_head', 'wp_robots', 1 );

        // Add our SEO block
        // Hook Meta Render
        add_action('wp_head', [$this->meta, 'render'], 1);
        // Hook Schema Render
        add_action('wp_head', [$this->schema, 'render'], 2);
    }

    public function enqueue_frontend_assets() {
        // Register frontend CSS (kept existing logic)
        wp_enqueue_style(
            'rankjet-ai-front-css',
            RANKJET_AI_PLUGIN_URL . 'assets/front/css/style.css',
            [],
            RANKJET_AI_VERSION,
            'all'
        );
    }
}
