<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Rankjet_Ai_Frontend_Variables {

    /**
     * Replace %variables% with actual data
     */
    public function replace_variables($text, $post_id) {
        if (strpos($text, '%') === false) {
            return $text;
        }

        // Initialize variables
        $post = null;
        $title = '';
        $seo_title = '';
        $seo_desc = '';
        $url = '';
        $username = '';
        $author_url = '';
        $archive_title = '';
        $archive_desc = '';
        $term_title = '';

        // Determine context
        if (is_home() || is_front_page()) {
            // Home/Blog
            $title = get_bloginfo('name');
            $seo_title = get_bloginfo('name') . ' - ' . get_bloginfo('description');
            $seo_desc = get_bloginfo('description');
            $url = home_url();
            $archive_title = get_bloginfo('name');
            $archive_desc = get_bloginfo('description');
        } elseif (is_category() || is_tag() || is_tax()) {
            // Term Archive
            $term = get_queried_object();
            if ($term) {
                $title = $term->name;
                $seo_title = $this->get_seo_title_raw(''); // This handles term logic
                $seo_desc = term_description();
                $url = get_term_link($term);
                $archive_title = get_the_archive_title();
                $archive_desc = get_the_archive_description();
                $term_title = $term->name;
            }
        } elseif (is_author()) {
            // Author Archive
            $author = get_queried_object(); // User object
            if ($author) {
                $title = $author->display_name;
                $seo_title = $this->get_seo_title_raw(''); 
                $seo_desc = get_the_author_meta('description', $author->ID);
                $url = get_author_posts_url($author->ID);
                $archive_title = get_the_archive_title();
                $archive_desc = get_the_author_meta('description', $author->ID);
                $term_title = $author->display_name;
                $username = $author->display_name;
                $author_url = get_author_posts_url($author->ID);
            }
        } elseif (is_singular() || $post_id) {
            // Single Post
             $post = get_post($post_id);
             if ($post) {
                $author_id = $post->post_author;
                $title = get_the_title($post_id);
                $seo_title = $this->get_seo_title_raw($post_id);
                $seo_desc = $this->get_seo_description_raw($post_id);
                $url = get_permalink($post_id);
                $username = get_the_author_meta('display_name', $author_id);
                $author_url = get_author_posts_url($author_id);
             }
        }

        // Custom Logo Logic
        $custom_logo_id = get_theme_mod('custom_logo');
        $logo_url = $custom_logo_id ? wp_get_attachment_image_url($custom_logo_id, 'full') : '';

        // Dynamic Variables
        $replacements = [
            '%title%' => $title,
            '%seo_title%' => $seo_title,
            '%seo_description%' => $seo_desc,
            '%sitename%' => get_bloginfo('name'),
            '%home_url%' => home_url(),
            '%site_logo%' => $logo_url,
            '%current_date%' => date_i18n(get_option('date_format')),
            '%current_time%' => date_i18n(get_option('time_format')),
            '%username%' => $username,
            '%author_url%' => $author_url,
            '%url%' => $url,
            '%archive_title%' => $archive_title,
            '%archive_description%' => $archive_desc,
            '%repl_term_title%' => $term_title,
        ];
        
        $text = str_replace(array_keys($replacements), array_values($replacements), $text);

        // Date Functions %date(format)%
        if ($post_id) {
            $text = preg_replace_callback('/%date\((.*?)\)%/', function($m) use ($post_id) {
                return get_the_date($m[1], $post_id);
            }, $text);

            $text = preg_replace_callback('/%modified\((.*?)\)%/', function($m) use ($post_id) {
                return get_the_modified_date($m[1], $post_id);
            }, $text);
            
            // Thumbnail
            if (strpos($text, '%post_thumbnail%') !== false) {
                $thumb = get_the_post_thumbnail_url($post_id, 'full');
                $text = str_replace('%post_thumbnail%', $thumb, $text);
            }

            // Categories and Tags
            if ($post) {
                $cats = get_the_category($post_id);
                $text = str_replace('%category%', !empty($cats) ? $cats[0]->name : '', $text);
                
                $tags = get_the_tags($post_id);
                $text = str_replace('%tag%', !empty($tags) ? $tags[0]->name : '', $text);
            }
        }

        // Custom Field Support: %customfield(field_name)% or %cf(field_name)%
        $text = preg_replace_callback('/%(customfield|cf)\((.*?)\)%/', function($matches) use ($post_id) {
            $key = $matches[2];
            return get_post_meta($post_id, $key, true) ?: ''; 
        }, $text);

        // 3. Post Date Replacements: %date(format)% or %modified(format)%
        $text = preg_replace_callback('/%(date|modified)\((.*?)\)%/', function($matches) use ($post_id) {
            $type = $matches[1];
            $format = $matches[2];
            
            if ($type === 'modified') {
                return get_the_modified_date($format, $post_id);
            } else {
                return get_the_date($format, $post_id);
            }
        }, $text);

        return $text;
    }

    // Helper to get raw SEO title without HTML tags or echoes
    public function get_seo_title_raw($post_id) {
        $custom = get_post_meta($post_id, '_rankjet_seo_title', true);
        if ($custom) return $custom;
        return get_the_title($post_id) . ' - ' . get_bloginfo('name'); // Fallback simplification
    }

    // Helper to get raw SEO description
    public function get_seo_description_raw($post_id) {
        $custom = get_post_meta($post_id, '_rankjet_seo_description', true);
        if ($custom) return $custom;
        
        // Fallback excerpt
        $post = get_post($post_id);
        if (!$post) return '';
        
        $excerpt = $post->post_excerpt;
        if (empty($excerpt)) {
            $excerpt = wp_trim_words(strip_shortcodes(wp_strip_all_tags($post->post_content)), 25, '...');
        }
        return $excerpt;
    }
}
