<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Rankjet_Ai_Admin {

    public function __construct() {
        add_action('admin_menu', [$this, 'register_admin_menu']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_assets']);
    }

    public function register_admin_menu() {
        // Main menu
        add_menu_page(
            __('Rankjet Ai', 'rankjet-ai'),
            __('Rankjet Ai', 'rankjet-ai'),
            'manage_options',
            'rankjet-ai',
            [$this, 'render_dashboard_page'],
            RANKJET_AI_PLUGIN_URL . 'assets/images/rankjet-icon-gray.png',
            20
        );

        // Dashboard submenu (renames the first submenu from "Rankjet.ai" to "Dashboard")
        add_submenu_page(
            'rankjet-ai',
            __('Dashboard', 'rankjet-ai'),
            __('Dashboard', 'rankjet-ai'),
            'manage_options',
            'rankjet-ai',
            [$this, 'render_dashboard_page']
        );

        // Integration submenu
        add_submenu_page(
            'rankjet-ai',
            __('Integration', 'rankjet-ai'),
            __('Integration', 'rankjet-ai'),
            'manage_options',
            'rankjet-ai-integration',
            [$this, 'render_integration_page']
        );
    }

    /**
     * Render the Integration settings page
     */
    public function render_integration_page() {
        // Enqueue the build script
        $asset_file = include(RANKJET_AI_PLUGIN_DIR . 'build/index.asset.php');
        
        wp_enqueue_script(
            'rankjet-ai-build',
            RANKJET_AI_PLUGIN_URL . 'build/index.js',
            array_merge($asset_file['dependencies'], ['wp-element', 'wp-components', 'wp-api-fetch']),
            $asset_file['version'],
            true
        );

        wp_enqueue_style(
            'rankjet-ai-style', 
            RANKJET_AI_PLUGIN_URL . 'build/index.css', 
            ['wp-components'], 
            $asset_file['version']
        );

        wp_enqueue_style(
            'rankjet-ai-integration-style', 
            RANKJET_AI_PLUGIN_URL . 'build/style-index.css', 
            [], 
            $asset_file['version']
        );

        // Integration settings data
        $integration = new Rankjet_Ai_Platform_Integration();
        $settings_data = [
            'api_token'      => get_option('rankjet_platform_api_token', ''),
            'website_id'     => get_option('rankjet_platform_website_id', ''),
            'is_connected'   => $integration->is_connected(),
            'ajax_url'       => admin_url('admin-ajax.php'),
            'nonce'          => wp_create_nonce('rankjet_save_token'),
            'plugin_version' => RANKJET_AI_VERSION,
            'site_name'      => get_bloginfo('name'),
            'platform_url'   => 'https://app.rankjet.ai',
        ];

        wp_localize_script('rankjet-ai-build', 'rankjetIntegrationSettings', $settings_data);
        
        ?>
        <div class="wrap">
            <h1 class="wp-heading-inline screen-reader-text"><?php _e('Integration', 'rankjet-ai'); ?></h1>
            <hr class="wp-header-end">
            <div id="rankjet-integration-root"></div>
        </div>
        <?php
    }

    public function enqueue_admin_assets($hook) {
        // Register admin CSS
        wp_register_style(
            'rankjet-ai-admin-css',
            RANKJET_AI_PLUGIN_URL . 'assets/css/admin.css',
            [],
            '1.1.0',
            'all'
        );

        wp_enqueue_style('rankjet-ai-admin-css');
    }

    public function render_dashboard_page() {
        // Enqueue the build script
        $asset_file = include(RANKJET_AI_PLUGIN_DIR . 'build/index.asset.php');
        
        wp_enqueue_script(
            'rankjet-ai-build',
            RANKJET_AI_PLUGIN_URL . 'build/index.js',
            array_merge($asset_file['dependencies'], ['wp-element', 'wp-components', 'wp-api-fetch']),
            $asset_file['version'],
            true
        );

        wp_enqueue_style(
            'rankjet-ai-style', 
            RANKJET_AI_PLUGIN_URL . 'build/index.css', 
            ['wp-components'], 
            $asset_file['version']
        );

        wp_enqueue_style(
            'rankjet-ai-dashboard-style', 
            RANKJET_AI_PLUGIN_URL . 'build/style-index.css', 
            [], 
            $asset_file['version']
        );

        // Get dashboard data from the Dashboard class
        $dashboard = new Rankjet_Ai_Dashboard();
        $settings_data = $dashboard->get_settings_data();

        wp_localize_script('rankjet-ai-build', 'rankjetDashboardSettings', $settings_data);
        
        ?>
        <div class="wrap">
            <h1 class="wp-heading-inline screen-reader-text"><?php _e('RankJet Dashboard', 'rankjet-ai'); ?></h1>
            <hr class="wp-header-end">
            <div id="rankjet-dashboard-root"></div>
        </div>
        <?php
    }
}
