<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap rankbot-wrap">
    <h1 class="screen-reader-text">RankBotAI llms.txt</h1>

    <div class="rankbot-dashboard-container">

        <div class="rankbot-header-flex rb-animate">
            <h2 class="rankbot-title">
                <span class="dashicons dashicons-media-text"></span> <?php echo esc_html__('llms.txt Generator', 'rankbotai-seo-optimizer'); ?>
            </h2>
            <div style="display:flex; align-items:center; gap: 12px;">
                <?php if ($file_exists): ?>
                    <span class="rankbot-status status-active"><div class="status-dot"></div> <?php echo esc_html__('File Active', 'rankbotai-seo-optimizer'); ?></span>
                    <a href="<?php echo esc_url($file_url); ?>" target="_blank" class="rankbot-btn" style="padding: 4px 12px; font-size: 12px; border: 1px solid #d1d5db; border-radius: 6px; text-decoration:none; color:#374151;">
                        <span class="dashicons dashicons-external" style="font-size:14px; width:14px; height:14px; margin-top:2px;"></span>
                        <?php echo esc_html__('View File', 'rankbotai-seo-optimizer'); ?>
                    </a>
                <?php else: ?>
                    <span class="rankbot-status status-inactive"><div class="status-dot"></div> <?php echo esc_html__('Not Created', 'rankbotai-seo-optimizer'); ?></span>
                <?php endif; ?>
            </div>
        </div>

        <!-- Info Card -->
        <div class="rankbot-card rb-animate rb-animate-delay-1" style="border-left: 3px solid #3b82f6; margin-bottom: 24px;">
            <div style="padding: 20px 24px; display:flex; gap: 16px; align-items:flex-start;">
                <div style="flex-shrink:0; width:40px; height:40px; background:#eff6ff; border-radius:10px; display:flex; align-items:center; justify-content:center;">
                    <span class="dashicons dashicons-info-outline" style="color:#3b82f6; font-size:20px; width:20px; height:20px;"></span>
                </div>
                <div>
                    <h4 style="margin:0 0 6px 0; font-size:15px; font-weight:600; color:#111827;"><?php echo esc_html__('What is llms.txt?', 'rankbotai-seo-optimizer'); ?></h4>
                    <p style="margin:0; font-size:14px; color:#6b7280; line-height:1.6;">
                        <?php echo esc_html__('llms.txt is a standard file (like robots.txt) that helps AI language models understand your website structure and content. It provides a machine-readable summary of your site, improving AI-powered search visibility and enabling better AI interactions with your content.', 'rankbotai-seo-optimizer'); ?>
                    </p>
                    <a href="https://llmstxt.org/" target="_blank" style="font-size:13px; color:#3b82f6; text-decoration:none; font-weight:500; display:inline-flex; align-items:center; gap:4px; margin-top:8px;">
                        <?php echo esc_html__('Learn more about the standard', 'rankbotai-seo-optimizer'); ?> <span class="dashicons dashicons-external" style="font-size:13px; width:13px; height:13px;"></span>
                    </a>
                </div>
            </div>
        </div>

        <!-- Editor Card -->
        <div class="rankbot-card rb-animate rb-animate-delay-2" style="margin-bottom: 24px;">
            <div class="rankbot-card-header" style="border-bottom: 1px solid #f3f4f6; padding: 18px 24px; margin-bottom:0; display:flex; justify-content:space-between; align-items:center;">
                <h3 style="margin:0; font-size:16px; font-weight:600; display:flex; align-items:center; gap:8px;">
                    <span class="dashicons dashicons-editor-code" style="color:#6366f1;"></span>
                    <?php echo esc_html__('llms.txt Content', 'rankbotai-seo-optimizer'); ?>
                </h3>
                <div style="display:flex; gap:8px;">
                    <button type="button" id="rb-llms-regenerate" class="rankbot-btn" style="padding:6px 14px; font-size:12px; border:1px solid #d1d5db; border-radius:6px; background:#fff; color:#374151; cursor:pointer;">
                        <span class="dashicons dashicons-update" style="font-size:14px; width:14px; height:14px; margin-right:4px;"></span>
                        <?php echo esc_html__('Auto-Generate', 'rankbotai-seo-optimizer'); ?>
                    </button>
                    <button type="button" id="rb-llms-preview" class="rankbot-btn" style="padding:6px 14px; font-size:12px; border:1px solid #d1d5db; border-radius:6px; background:#fff; color:#374151; cursor:pointer;">
                        <span class="dashicons dashicons-visibility" style="font-size:14px; width:14px; height:14px; margin-right:4px;"></span>
                        <?php echo esc_html__('Preview', 'rankbotai-seo-optimizer'); ?>
                    </button>
                </div>
            </div>

            <div style="padding: 0;">
                <textarea
                    name="llms_content"
                    id="rb-llms-editor"
                    style="width:100%; min-height:450px; padding:24px; font-family:SFMono-Regular, Consolas, 'Liberation Mono', Menlo, monospace; font-size:13px; line-height:1.7; border:none; border-top: 0; resize:vertical; color:#334155; background:#fafbfc; outline:none;"
                    placeholder="# Your Site Name&#10;&#10;> A brief description&#10;&#10;## About&#10;..."
                ><?php echo esc_textarea($saved_content); ?></textarea>
            </div>

            <!-- Save Bar -->
            <div style="padding:16px 24px; border-top: 1px solid #f3f4f6; display:flex; justify-content:space-between; align-items:center; background:#f9fafb;">
                <div style="font-size:13px; color:#6b7280;">
                    <span id="rb-llms-chars">0</span> <?php echo esc_html__('characters', 'rankbotai-seo-optimizer'); ?>
                    &middot;
                    <span id="rb-llms-lines">0</span> <?php echo esc_html__('lines', 'rankbotai-seo-optimizer'); ?>
                </div>
                <div style="display:flex; gap:10px; align-items:center;">
                    <?php if ($file_exists): ?>
                        <form method="post" style="display:inline;" onsubmit="return confirm('<?php echo esc_js(__('Delete llms.txt file?', 'rankbotai-seo-optimizer')); ?>');">
                            <?php wp_nonce_field('rankbot_llms_delete', '_wpnonce_delete'); ?>
                            <input type="hidden" name="rankbot_llms_action" value="delete">
                            <button type="submit" class="rankbot-btn btn-danger" style="padding:8px 16px; font-size:13px;">
                                <span class="dashicons dashicons-trash" style="font-size:14px; width:14px; height:14px;"></span>
                                <?php echo esc_html__('Delete File', 'rankbotai-seo-optimizer'); ?>
                            </button>
                        </form>
                    <?php endif; ?>
                    <form method="post" id="rb-llms-form">
                        <?php wp_nonce_field('rankbot_llms_save', '_wpnonce'); ?>
                        <input type="hidden" name="rankbot_llms_action" value="save">
                        <input type="hidden" name="llms_content" id="rb-llms-content-hidden" value="">
                        <button type="submit" class="rankbot-btn btn-primary" style="padding:8px 20px; font-size:13px;">
                            <span class="dashicons dashicons-saved" style="font-size:14px; width:14px; height:14px;"></span>
                            <?php echo esc_html__('Save & Deploy', 'rankbotai-seo-optimizer'); ?>
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Preview Modal -->
        <div id="rb-llms-preview-modal" style="display:none; position:fixed; inset:0; background:rgba(0,0,0,0.5); z-index:100000; align-items:center; justify-content:center;">
            <div style="background:white; width:90%; max-width:700px; max-height:80vh; border-radius:12px; overflow:hidden; display:flex; flex-direction:column; box-shadow:0 25px 50px -12px rgba(0,0,0,0.25);">
                <div style="padding:16px 24px; border-bottom:1px solid #e5e7eb; display:flex; justify-content:space-between; align-items:center; background:#f9fafb;">
                    <h3 style="margin:0; font-size:16px; font-weight:600;"><?php echo esc_html__('llms.txt Preview', 'rankbotai-seo-optimizer'); ?></h3>
                    <button type="button" id="rb-llms-preview-close" style="border:none; background:none; cursor:pointer; font-size:24px; color:#6b7280;">&times;</button>
                </div>
                <div id="rb-llms-preview-content" style="padding:24px; overflow-y:auto; flex:1; font-family:SFMono-Regular, Consolas, monospace; font-size:13px; line-height:1.7; white-space:pre-wrap; color:#334155; background:#fafbfc;">
                </div>
            </div>
        </div>

        <!-- Tips Card -->
        <div class="rankbot-card rb-animate rb-animate-delay-3">
            <div style="padding:20px 24px;">
                <h4 style="margin:0 0 12px 0; font-size:15px; font-weight:600; display:flex; align-items:center; gap:8px;">
                    <span class="dashicons dashicons-lightbulb" style="color:#f59e0b;"></span>
                    <?php echo esc_html__('Formatting Tips', 'rankbotai-seo-optimizer'); ?>
                </h4>
                <div style="display:grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap:16px;">
                    <div style="font-size:13px; color:#6b7280; line-height:1.6;">
                        <code style="background:#f3f4f6; padding:2px 6px; border-radius:3px; color:#4b5563; font-size:12px;"># Title</code> — <?php echo esc_html__('Main heading (site name)', 'rankbotai-seo-optimizer'); ?><br>
                        <code style="background:#f3f4f6; padding:2px 6px; border-radius:3px; color:#4b5563; font-size:12px;">> Quote</code> — <?php echo esc_html__('Site description/tagline', 'rankbotai-seo-optimizer'); ?><br>
                        <code style="background:#f3f4f6; padding:2px 6px; border-radius:3px; color:#4b5563; font-size:12px;">## Section</code> — <?php echo esc_html__('Content sections', 'rankbotai-seo-optimizer'); ?>
                    </div>
                    <div style="font-size:13px; color:#6b7280; line-height:1.6;">
                        <code style="background:#f3f4f6; padding:2px 6px; border-radius:3px; color:#4b5563; font-size:12px;">- [Title](URL)</code> — <?php echo esc_html__('Links to pages', 'rankbotai-seo-optimizer'); ?><br>
                        <code style="background:#f3f4f6; padding:2px 6px; border-radius:3px; color:#4b5563; font-size:12px;">- [Title](URL): desc</code> — <?php echo esc_html__('Links with description', 'rankbotai-seo-optimizer'); ?><br>
                        <code style="background:#f3f4f6; padding:2px 6px; border-radius:3px; color:#4b5563; font-size:12px;">Plain text</code> — <?php echo esc_html__('Regular paragraphs', 'rankbotai-seo-optimizer'); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>
