<?php
if (!defined('ABSPATH')) {
    exit;
}
?>
<div class="wrap rb-bulk-wrap">
    
    <!-- Notices Container (WP Standard) -->
    <div id="rb-notices-area">
        <!-- Notices will be injected here if needed or handled by WP -->
        <h1 style="display:none;">RankBot Bulk</h1> <!-- Semantic hidden H1 for WP a11y if needed -->
    </div>

    <div class="rb-header rb-animate">
        <h2 class="rb-title">
            <span class="dashicons dashicons-superhero" style="font-size: 32px; width: 32px; height: 32px;"></span>
            <?php esc_html_e('Bulk Processing', 'rankbotai-seo-optimizer'); ?>
        </h2>
    </div>

    <form method="get" action="<?php echo esc_url(admin_url('admin.php')); ?>">
        <input type="hidden" name="page" value="rankbot-bulk" />
        <?php wp_nonce_field('rankbot_bulk_filters', 'rankbot_bulk_nonce', false); ?>
        
        <!-- Filters Section (Static & Always Visible) -->
        <div class="rb-card rb-filters-card rb-animate rb-animate-delay-1" style="overflow: hidden;">
            <div class="rb-card-header" style="border-bottom: 1px solid #f1f5f9; padding: 16px 20px; background: #fff;">
                <div style="display:flex; align-items:center; gap:10px;">
                    <div style="width: 28px; height: 28px; background: #eff6ff; border-radius: 6px; display: flex; align-items: center; justify-content: center;">
                        <span class="dashicons dashicons-filter" style="color:#3b82f6; font-size: 16px; width: 16px; height: 16px;"></span>
                    </div>
                    <h3 style="margin:0; font-size:15px; font-weight:600; color:#1e293b;"><?php esc_html_e('Filters & Search', 'rankbotai-seo-optimizer'); ?></h3>
                </div>
            </div>
            
            <div class="rb-card-body">
                <!-- PROGRESS BAR: Initially hidden unless JS reveals it -->
                <div id="rb-bulk-progress" class="rb-progress-wrap" style="display:none; padding: 15px 20px; border-bottom: 1px solid #f1f5f9; background: #f0f9ff;">
                    <div style="display:flex; justify-content:space-between; margin-bottom: 8px;">
                        <span id="rb-bulk-progress-text" style="font-weight:600; color:#0369a1; font-size:13px;">...</span>
                        <a href="#" id="rb-bulk-stop" style="color:#ef4444; font-size:12px; text-decoration:none; border-bottom:1px dashed #ef4444;"><?php esc_html_e('Stop Processing', 'rankbotai-seo-optimizer'); ?></a>
                    </div>
                    <div class="rb-progress-bar-bg" style="height: 8px; background: #bae6fd; border-radius: 4px; overflow: hidden;">
                        <div id="rb-bulk-progress-bar" style="width: 0%; height: 100%; background: #0ea5e9; transition: width 0.3s ease;"></div>
                    </div>
                </div>

                <!-- TOP BAR: Search & Processing State -->
                <div class="rb-filter-toolbar">
                    <div class="rb-search-wrap">
                        <span class="dashicons dashicons-search rb-search-icon"></span>
                        <input id="rb-search" type="text" name="s" value="<?php echo esc_attr($search); ?>" placeholder="<?php esc_attr_e('Search by title or content...', 'rankbotai-seo-optimizer'); ?>">
                    </div>

                    <div class="rb-status-tabs-group">
                        <?php 
                        $rankbot_proc_state = isset($proc_state) ? sanitize_key((string) $proc_state) : 'all';
                        $rankbot_states = [
                            'all' => __('All Items', 'rankbotai-seo-optimizer'),
                            'processed' => __('Processed', 'rankbotai-seo-optimizer'),
                            'unprocessed' => __('Unprocessed', 'rankbotai-seo-optimizer'),
                            'errors' => __('Errors', 'rankbotai-seo-optimizer')
                        ];
                        foreach ($rankbot_states as $rankbot_state_key => $rankbot_state_label): ?>
                            <label>
                                <input type="radio" name="proc_state" value="<?php echo esc_attr($rankbot_state_key); ?>" <?php checked($rankbot_proc_state, $rankbot_state_key); ?> class="rb-status-radio" onchange="this.form.submit()">
                                <span class="rb-status-label"><?php echo esc_html($rankbot_state_label); ?></span>
                            </label>
                        <?php endforeach; ?>
                    </div>
                </div>

                <!-- ADVANCED FILTERS ROW -->
                <div class="rb-advanced-filters">
                    
                    <!-- Post Types -->
                    <div class="rb-filter-col">
                        <div class="rb-filter-title"><?php esc_html_e('Post Types', 'rankbotai-seo-optimizer'); ?></div>
                        <div>
                            <?php foreach ($supported_types as $rankbot_pt => $rankbot_obj): ?>
                                <label class="rb-pill-check">
                                    <input type="checkbox" name="post_type[]" value="<?php echo esc_attr($rankbot_pt); ?>" <?php checked(in_array($rankbot_pt, $post_types_in, true)); ?>>
                                    <span><?php echo esc_html($rankbot_obj->labels->singular_name); ?></span>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <!-- Statuses -->
                    <div class="rb-filter-col">
                        <div class="rb-filter-title"><?php esc_html_e('Status', 'rankbotai-seo-optimizer'); ?></div>
                        <div>
                            <?php 
                            $rankbot_status_labels = [
                                'publish' => __('Published', 'rankbotai-seo-optimizer'),
                                'draft' => __('Draft', 'rankbotai-seo-optimizer')
                            ];
                            foreach ($rankbot_status_labels as $rankbot_st => $rankbot_lbl): ?>
                                <label class="rb-pill-check">
                                    <input type="checkbox" name="post_status[]" value="<?php echo esc_attr($rankbot_st); ?>" <?php checked(in_array($rankbot_st, $post_statuses_in, true)); ?>>
                                    <span><?php echo esc_html($rankbot_lbl); ?></span>
                                </label>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <!-- Options -->
                    <div class="rb-filter-col">
                        <div class="rb-filter-title"><?php esc_html_e('Options', 'rankbotai-seo-optimizer'); ?></div>
                        <div>
                            <label class="rb-pill-check">
                                <input type="checkbox" name="no_keyword" value="1" <?php checked($no_keyword); ?>>
                                <span><?php esc_html_e('Missing Keyword', 'rankbotai-seo-optimizer'); ?></span>
                            </label>
                        </div>
                    </div>

                    <!-- SEO Score Slider -->
                    <div class="rb-filter-col" style="min-width: 180px;">
                        <div class="rb-filter-title"><?php esc_html_e('SEO Score', 'rankbotai-seo-optimizer'); ?> <span id="rb-score-display" style="float:right; font-weight:400;">(<?php echo esc_html(absint($score_min)); ?> - <?php echo esc_html(absint($score_max)); ?>)</span></div>
                        <div class="rb-dual-slider" style="margin-top: 8px;">
                            <input type="range" id="rb-score-min" name="score_min" min="0" max="100" value="<?php echo esc_attr($score_min); ?>" />
                            <input type="range" id="rb-score-max" name="score_max" min="0" max="100" value="<?php echo esc_attr($score_max); ?>" />
                            <div class="rb-slider-track"></div>
                            <div class="rb-slider-range" id="rb-slider-highlight"></div>
                        </div>
                    </div>
                    
                    <!-- Actions -->
                    <div class="rb-actions-row">
                        <button type="button" id="rb-btn-clear-process" class="rb-btn rb-btn-secondary" style="height: 36px; padding: 0 16px; margin-right: 8px; color: #dc2626; border-color: #fecaca; background: #fff;">
                            <span class="dashicons dashicons-trash" style="font-size: 16px; width: 16px; height: 16px; margin-top:2px; margin-right:4px;"></span>
                            <?php esc_html_e('Clear Queue', 'rankbotai-seo-optimizer'); ?>
                        </button>

                        <button type="button" id="rb-btn-clear-all-jobs" class="rb-btn rb-btn-secondary" style="height: 36px; padding: 0 16px; margin-right: 8px; color: #b91c1c; border-color: #fecaca; background: #fff;">
                            <span class="dashicons dashicons-dismiss" style="font-size: 16px; width: 16px; height: 16px; margin-top:2px; margin-right:4px;"></span>
                            <?php esc_html_e('Clear All Jobs', 'rankbotai-seo-optimizer'); ?>
                        </button>

                        <a href="<?php echo esc_url(admin_url('admin.php?page=rankbot-bulk')); ?>" class="rb-btn rb-btn-secondary" style="height: 36px; padding: 0 16px; display: inline-flex; align-items: center;">
                            <?php esc_html_e('Reset Filters', 'rankbotai-seo-optimizer'); ?>
                        </a>
                        <button type="submit" class="rb-btn rb-btn-primary" style="height: 36px; padding: 0 20px; font-weight: 500;">
                            <?php esc_html_e('Apply Filters', 'rankbotai-seo-optimizer'); ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Status + Spinner (shared for AJAX actions) -->
        <span class="spinner" id="rb-bulk-spinner" style="float:none; margin:0;"></span>
        <div id="rb-bulk-status" class="notice" style="display:none; margin: 20px 0;"></div>

        <!-- Table Card -->
        <div style="margin-top: 24px;">
            <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom: 12px;">
                <div style="display:flex; align-items:center; gap: 16px;">
                    <div style="font-size: 13px; color: var(--rb-text-secondary);">
                        <?php
                        $rankbot_found_posts = ($q instanceof WP_Query) ? absint($q->found_posts) : 0;
                        $rankbot_found_label = sprintf(
                            /* translators: %s: number of items found. */
                            __('Found %s items', 'rankbotai-seo-optimizer'),
                            '<strong>' . esc_html(number_format_i18n($rankbot_found_posts)) . '</strong>'
                        );
                        echo wp_kses_post($rankbot_found_label);
                        ?>
                    </div>
                </div>

                <div style="display:flex; align-items:center; gap: 12px;">
                    <!-- Top Per Page Selector -->
                     <div class="rb-per-page-wrap">
                        <span class="rb-label-sm"><?php esc_html_e('Per page:', 'rankbotai-seo-optimizer'); ?></span>
                        <input type="number" id="rb-per-page-top" name="per_page" value="<?php echo esc_attr($per_page); ?>" min="1" max="999" class="rb-input-number-sm" title="<?php esc_attr_e('Press Enter to apply', 'rankbotai-seo-optimizer'); ?>" />
                    </div>

                    <!-- Pagination Top -->
                    <?php if ($q->max_num_pages > 1): ?>
                        <div class="rb-mini-pagination">
                             <?php
                                echo wp_kses_post(paginate_links([
                                    'base' => add_query_arg('paged', '%#%'),
                                    'format' => '',
                                    'prev_text' => '<span class="dashicons dashicons-arrow-left-alt2"></span>',
                                    'next_text' => '<span class="dashicons dashicons-arrow-right-alt2"></span>',
                                    'total' => $q->max_num_pages,
                                    'current' => $paged,
                                    'mid_size' => 1
                                ]));
                             ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="rb-table-container">
                <table class="rb-table">
                    <thead>
                        <tr>
                            <th class="check-column"><input type="checkbox" id="rb-select-all" /></th>
                            <th><?php esc_html_e('Title', 'rankbotai-seo-optimizer'); ?></th>
                            <th style="width:100px;"><?php esc_html_e('Type', 'rankbotai-seo-optimizer'); ?></th>
                            <th style="width:100px;"><?php esc_html_e('Status', 'rankbotai-seo-optimizer'); ?></th>
                            <th style="width:90px;"><?php esc_html_e('Time', 'rankbotai-seo-optimizer'); ?></th>
                            <th style="width:80px;"><?php esc_html_e('Score', 'rankbotai-seo-optimizer'); ?></th>
                            <th style="width:120px;"><?php esc_html_e('Last Run', 'rankbotai-seo-optimizer'); ?></th>
                            <th style="width:140px;"><?php esc_html_e('Modified', 'rankbotai-seo-optimizer'); ?></th>
                            <th style="width:160px; text-align:right;"><?php esc_html_e('Actions', 'rankbotai-seo-optimizer'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($q->have_posts()): ?>
                            <?php while ($q->have_posts()): $q->the_post(); ?>
                                <?php
                                    $rankbot_post_id = get_the_ID();
                                    $rankbot_score = (int) get_post_meta($rankbot_post_id, '_rankbot_seo_score', true);
                                    $rankbot_post_status = (string) get_post_status($rankbot_post_id);
                                    $rankbot_post_type = (string) get_post_type($rankbot_post_id);
                                    
                                    // History / Last Run
                                    $rankbot_history = get_post_meta($rankbot_post_id, '_rankbot_history', true);
                                    $rankbot_last_run_date = '';
                                    $rankbot_last_action_label = '';
                                    $rankbot_last_icon = '';
                                    $rankbot_icon_color = '#94a3b8';

                                    if (is_array($rankbot_history) && !empty($rankbot_history)) {
                                        $rankbot_last_entry = end($rankbot_history);
                                        $rankbot_action_raw = isset($rankbot_last_entry['action']) ? (string) $rankbot_last_entry['action'] : 'Unknown';
                                        $rankbot_date_raw = isset($rankbot_last_entry['date']) ? (string) $rankbot_last_entry['date'] : '';

                                        if ($rankbot_date_raw) {
                                            $rankbot_last_run_date = gmdate('M j', strtotime($rankbot_date_raw));
                                        }

                                        $rankbot_last_action_label = $rankbot_action_raw;
                                        $rankbot_act_lower = strtolower($rankbot_action_raw);

                                        if (strpos($rankbot_act_lower, 'auto') !== false) {
                                            $rankbot_last_icon = 'dashicons-superhero';
                                            $rankbot_icon_color = '#3b82f6'; // Blue
                                        } elseif (strpos($rankbot_act_lower, 'research') !== false) {
                                            $rankbot_last_icon = 'dashicons-search';
                                            $rankbot_icon_color = '#f59e0b'; // Amber
                                        } elseif (strpos($rankbot_act_lower, 'snippet') !== false) {
                                            $rankbot_last_icon = 'dashicons-text-page';
                                            $rankbot_icon_color = '#8b5cf6'; // Purple
                                        } else {
                                            $rankbot_last_icon = 'dashicons-edit';
                                            $rankbot_icon_color = '#64748b'; // Slate
                                        }
                                    }

                                    $rankbot_badge_class = 'rb-badge-gray';
                                    if ($rankbot_post_status === 'publish') $rankbot_badge_class = 'rb-badge-green';
                                    if ($rankbot_post_status === 'draft') $rankbot_badge_class = 'rb-badge-blue';

                                    $rankbot_row_actions = $this->rankbot_available_actions_for_post_type($rankbot_post_type);
                                    
                                    // Check if active job exists
                                    $rankbot_is_active_job = isset($active_jobs[$rankbot_post_id]);
                                    $rankbot_active_job_status = '';
                                    if ($rankbot_is_active_job) {
                                        $rankbot_job_row = $active_jobs[$rankbot_post_id];
                                        if (is_array($rankbot_job_row)) {
                                            $rankbot_active_job_status = isset($rankbot_job_row['status']) ? (string) $rankbot_job_row['status'] : '';
                                        } elseif (is_object($rankbot_job_row)) {
                                            // Back-compat if $wpdb was queried without ARRAY_A.
                                            $rankbot_active_job_status = isset($rankbot_job_row->status) ? (string) $rankbot_job_row->status : '';
                                        }
                                    }
                                    $rankbot_active_job_status = strtolower(trim($rankbot_active_job_status));
                                    if ($rankbot_is_active_job && $rankbot_active_job_status === '') {
                                        // Defensive fallback to avoid warnings and keep UI consistent.
                                        $rankbot_active_job_status = 'processing';
                                    }

                                    $rankbot_active_job_elapsed = '';
                                    if ($rankbot_is_active_job) {
                                        $rankbot_started_at = '';
                                        $rankbot_created_at = '';
                                        if (is_array($rankbot_job_row)) {
                                            $rankbot_started_at = isset($rankbot_job_row['started_at']) ? (string) $rankbot_job_row['started_at'] : '';
                                            $rankbot_created_at = isset($rankbot_job_row['created_at']) ? (string) $rankbot_job_row['created_at'] : '';
                                        } elseif (is_object($rankbot_job_row)) {
                                            $rankbot_started_at = isset($rankbot_job_row->started_at) ? (string) $rankbot_job_row->started_at : '';
                                            $rankbot_created_at = isset($rankbot_job_row->created_at) ? (string) $rankbot_job_row->created_at : '';
                                        }

                                        $rankbot_start_ts = $rankbot_started_at !== '' ? strtotime($rankbot_started_at) : false;
                                        if (!$rankbot_start_ts) {
                                            $rankbot_start_ts = $rankbot_created_at !== '' ? strtotime($rankbot_created_at) : false;
                                        }
                                        if ($rankbot_start_ts) {
                                            $rankbot_now_ts = time();
                                            $rankbot_elapsed = max(0, $rankbot_now_ts - (int) $rankbot_start_ts);
                                            if ($rankbot_elapsed > 0) {
                                                $rankbot_active_job_elapsed = $this->rankbot_format_duration((int) $rankbot_elapsed);
                                            }
                                        }
                                    }
                                    $rankbot_active_job_label_map = [
                                        'queued' => __('Queued', 'rankbotai-seo-optimizer'),
                                        'pending' => __('Queued', 'rankbotai-seo-optimizer'),
                                        'processing' => __('Processing', 'rankbotai-seo-optimizer'),
                                        'retry_wait' => __('Retrying', 'rankbotai-seo-optimizer'),
                                        'dispatched' => __('Waiting', 'rankbotai-seo-optimizer'),
                                    ];
                                    $rankbot_active_job_label = isset($rankbot_active_job_label_map[$rankbot_active_job_status])
                                        ? $rankbot_active_job_label_map[$rankbot_active_job_status]
                                        : ($rankbot_active_job_status !== '' ? ucfirst($rankbot_active_job_status) : '');
                                ?>
                                <tr class="<?php echo $rankbot_is_active_job ? 'rb-row-active-job' : ''; ?>" data-object-id="<?php echo esc_attr($rankbot_post_id); ?>" data-object-type="post" data-job-status="<?php echo esc_attr($rankbot_active_job_status); ?>">
                                    <th class="check-column">
                                        <label style="display:flex; align-items:center; gap:6px;">
                                            <input type="checkbox" class="rb-item" value="<?php echo esc_attr($rankbot_post_id); ?>" <?php disabled($rankbot_is_active_job); ?> />
                                            <span class="rb-item-busy dashicons dashicons-hourglass" style="color:#f59e0b; <?php echo $rankbot_is_active_job ? '' : 'display:none;'; ?>" title="<?php echo esc_attr("Job is " . $rankbot_active_job_status); ?>"></span>
                                        </label>
                                    </th>
                                    <td>
                                        <strong><a href="<?php echo esc_url(get_edit_post_link($rankbot_post_id)); ?>" class="row-title"><?php the_title(); ?></a></strong>
                                        <div class="rb-job-status-pill" style="display:<?php echo $rankbot_is_active_job ? 'inline-block' : 'none'; ?>; font-size:10px; background:#e0f2fe; color:#0369a1; padding:2px 6px; border-radius:4px; margin-left:6px; vertical-align:middle;">
                                            <?php echo esc_html($rankbot_active_job_label); ?>
                                        </div>
                                    </td>
                                    <td><span class="rb-badge rb-badge-gray"><?php echo esc_html($rankbot_post_type); ?></span></td>
                                    <td><span class="rb-badge <?php echo esc_attr($rankbot_badge_class); ?>"><?php echo esc_html($rankbot_post_status); ?></span></td>
                                    <td style="color:#64748b; font-size:12px;">
                                        <?php
                                            if ($rankbot_is_active_job) {
                                                echo $rankbot_active_job_elapsed !== '' ? esc_html($rankbot_active_job_elapsed) : '<span style="color:#cbd5e1;">&mdash;</span>';
                                            } elseif (isset($last_completed_durations) && is_array($last_completed_durations) && isset($last_completed_durations[$rankbot_post_id])) {
                                                $rankbot_dur = (int) $last_completed_durations[$rankbot_post_id];
                                                echo $rankbot_dur > 0 ? esc_html($this->rankbot_format_duration($rankbot_dur)) : '<span style="color:#cbd5e1;">&mdash;</span>';
                                            } else {
                                                echo '<span style="color:#cbd5e1;">&mdash;</span>';
                                            }
                                        ?>
                                    </td>
                                    <td>
                                        <?php if ($rankbot_score > 80): ?>
                                            <span style="color:#059669; font-weight:700;"><?php echo esc_html($rankbot_score); ?></span>
                                        <?php elseif ($rankbot_score > 50): ?>
                                            <span style="color:#d97706; font-weight:700;"><?php echo esc_html($rankbot_score); ?></span>
                                        <?php else: ?>
                                            <span style="color:#dc2626; font-weight:700;"><?php echo esc_html($rankbot_score); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ($rankbot_last_action_label): ?>
                                            <div style="display:flex; align-items:center; gap:8px;" title="<?php echo esc_attr($rankbot_last_action_label); ?>">
                                                <span class="dashicons <?php echo esc_attr($rankbot_last_icon); ?>" style="color:<?php echo esc_attr($rankbot_icon_color); ?>; font-size:18px;"></span>
                                                <span style="font-size:12px; color:#64748b; font-weight:500;"><?php echo esc_html($rankbot_last_run_date); ?></span>
                                            </div>
                                        <?php else: ?>
                                            <span style="color:#cbd5e1;">&mdash;</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo esc_html(get_the_modified_date('M j, Y H:i')); ?></td>
                                    <td style="text-align:right;">
                                        <div class="rb-row-actions">
                                            <span class="rb-row-processing-label" style="color:#94a3b8; font-size:12px; font-style:italic; margin-right:8px; display:<?php echo $rankbot_is_active_job ? 'inline-block' : 'none'; ?>;">
                                                <?php echo esc_html($rankbot_active_job_label !== '' ? ($rankbot_active_job_label . '...') : __('Processing...', 'rankbotai-seo-optimizer')); ?>
                                            </span>

                                            <div class="rb-row-actions-buttons" style="display:<?php echo $rankbot_is_active_job ? 'none' : 'flex'; ?>; gap:8px; justify-content:flex-end; align-items:center;">
                                                <?php if (in_array('research', $rankbot_row_actions, true)): ?>
                                                    <button type="button" class="rb-run-one rb-icon-btn-secondary" data-action="research" data-id="<?php echo esc_attr($rankbot_post_id); ?>" title="<?php esc_attr_e('Run Keyword Research', 'rankbotai-seo-optimizer'); ?>" <?php disabled($rankbot_is_active_job); ?>>
                                                        <span class="dashicons dashicons-search"></span>
                                                    </button>
                                                <?php endif; ?>
                                                
                                                <?php if (in_array('snippet', $rankbot_row_actions, true)): ?>
                                                    <button type="button" class="rb-run-one rb-icon-btn-secondary" data-action="snippet" data-id="<?php echo esc_attr($rankbot_post_id); ?>" title="<?php esc_attr_e('Generate Snippet', 'rankbotai-seo-optimizer'); ?>" <?php disabled($rankbot_is_active_job); ?>>
                                                        <span class="dashicons dashicons-text-page"></span>
                                                    </button>
                                                <?php endif; ?>
                                                
                                                <?php if (in_array('auto', $rankbot_row_actions, true)): ?>
                                                    <button type="button" class="rb-run-one rb-btn-auto-lg" data-action="auto" data-id="<?php echo esc_attr($rankbot_post_id); ?>" title="<?php esc_attr_e('Start Full Optimization', 'rankbotai-seo-optimizer'); ?>" <?php disabled($rankbot_is_active_job); ?>>
                                                        <span class="dashicons dashicons-superhero"></span>
                                                        <span>Auto-Optimize</span>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; wp_reset_postdata(); ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="9" style="text-align:center; padding: 40px; color: var(--rb-text-secondary);">
                                    <?php esc_html_e('No items found matching your filters.', 'rankbotai-seo-optimizer'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination Bottom -->
            <div class="rb-pagination-footer">
                <div class="rb-per-page-wrap">
                    <span class="rb-label-sm"><?php esc_html_e('Rows per page:', 'rankbotai-seo-optimizer'); ?></span>
                    <input type="number" id="rb-per-page-bottom" name="rb_per_page_ui" value="<?php echo esc_attr($per_page); ?>" min="1" max="999" class="rb-input-number-sm" title="<?php esc_attr_e('Press Enter to apply', 'rankbotai-seo-optimizer'); ?>" />
                </div>

                <?php if ($q->max_num_pages > 1): ?>
                    <div class="rb-pagination-list">
                        <?php
                            echo wp_kses_post(paginate_links([
                                'base' => add_query_arg('paged', '%#%'),
                                'format' => '',
                                'prev_text' => '<span class="dashicons dashicons-arrow-left-alt2"></span>',
                                'next_text' => '<span class="dashicons dashicons-arrow-right-alt2"></span>',
                                'total' => $q->max_num_pages,
                                'current' => $paged,
                                'type' => 'plain' // Use plain so we can wrap them our way, or 'list'
                            ]));
                        ?>
                    </div>
                <?php endif; ?>
            </div>

        </div>
    </form>
</div>

<!-- Floating Action Bar -->
<div id="rb-selected-bar" class="rb-sticky-bar" style="display:none;">
    <div style="display:flex; align-items:center; gap:16px;">
        <div style="background:rgba(255,255,255,0.1); padding: 4px; border-radius: 50%;">
             <span class="dashicons dashicons-yes" style="color:#4ade80; font-size:20px; height:20px; width:20px;"></span>
        </div>
        <span id="rb-selected-count" style="font-weight:600; font-size:15px; color:white;"><?php esc_html_e('0 Selected', 'rankbotai-seo-optimizer'); ?></span>
    </div>
    
    <div class="rb-sticky-actions">
        <span style="color:rgba(255,255,255,0.5); font-size:12px; margin-right:8px; text-transform:uppercase; letter-spacing:0.05em;"><?php esc_html_e('Run Bulk:', 'rankbotai-seo-optimizer'); ?></span>
        
         <button type="button" class="rb-btn rb-btn-sm rb-btn-dark" data-selected-action="research">
            <span class="dashicons dashicons-search" style="font-size:14px; width:14px; height:14px;"></span>
            <?php esc_html_e('Keywords', 'rankbotai-seo-optimizer'); ?>
         </button>
         
         <button type="button" class="rb-btn rb-btn-sm rb-btn-dark" data-selected-action="snippet">
            <span class="dashicons dashicons-text-page" style="font-size:14px; width:14px; height:14px;"></span>
            <?php esc_html_e('Snippet', 'rankbotai-seo-optimizer'); ?>
         </button>
         
         <button type="button" class="rb-btn rb-btn-primary rb-btn-sm" data-selected-action="auto">
            <span class="dashicons dashicons-superhero" style="font-size:14px; width:14px; height:14px;"></span>
            <?php esc_html_e('Optimize', 'rankbotai-seo-optimizer'); ?>
         </button>
    </div>
</div>
