<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap rankbot-wrap">
    
    <!-- Header for Notices -->
    <h1 class="screen-reader-text">RankBotAI SEO</h1> 
    
    <div class="rankbot-dashboard-container">

    <div class="rankbot-header-flex rb-animate">
        <h2 class="rankbot-title">
            <span class="dashicons dashicons-superhero"></span> RankBotAI
        </h2>
        <div style="display:flex; align-items:center; gap: 15px;">
            <?php if ($key): ?>
                <form method="get" style="display:inline-block;">
                    <input type="hidden" name="page" value="rankbotai-seo-optimizer">
                    <select name="period" onchange="this.form.submit()" style="font-size: 13px; height: 32px; border-color: #d1d5db; border-radius: 4px; padding: 0 24px 0 8px;">
                        <option value="7" <?php selected($period, '7'); ?>><?php echo esc_html__('Last 7 Days', 'rankbotai-seo-optimizer'); ?></option>
                        <option value="30" <?php selected($period, '30'); ?>><?php echo esc_html__('Last 30 Days', 'rankbotai-seo-optimizer'); ?></option>
                        <option value="all" <?php selected($period, 'all'); ?>><?php echo esc_html__('All Time', 'rankbotai-seo-optimizer'); ?></option>
                    </select>
                </form>
                <span class="rankbot-status status-active"><div class="status-dot"></div> <?php echo esc_html__('Active', 'rankbotai-seo-optimizer'); ?></span>
            <?php else: ?>
                <span class="rankbot-status status-inactive"><div class="status-dot"></div> <?php echo esc_html__('Not Connected', 'rankbotai-seo-optimizer'); ?></span>
            <?php endif; ?>
        </div>
    </div>

    <!-- Notices -->
    <?php if ($error): ?>
        <div class="notice notice-error inline" style="margin: 0 0 20px 0;"><p><?php echo esc_html($error); ?></p></div>
    <?php endif; ?>
    <?php if (!empty($success)): ?>
        <div class="notice notice-success inline" style="margin: 0 0 20px 0;"><p><?php echo esc_html($success === 'connected' ? __('Connected successfully!', 'rankbotai-seo-optimizer') : __('Settings updated.', 'rankbotai-seo-optimizer')); ?></p></div>
    <?php endif; ?>

    <?php if ($key): ?>
        <!-- Connected Dashboard -->
        
        <!-- Stats Grid -->
        <div class="rankbot-stats-grid">
            <!-- Balance Card -->
            <div class="stat-card primary rb-animate rb-animate-delay-1">
                <div style="display: flex; flex-direction: column; height: 100%; justify-content: space-between;">
                    <div>
                        <div class="stat-label"><?php echo esc_html__('Plan', 'rankbotai-seo-optimizer'); ?></div>
                        <div class="stat-value" style="font-size: 22px; margin-bottom: 8px;"><?php echo esc_html($plan); ?></div>
                        
                        <div class="stat-label" style="opacity: 0.9; margin-top: 12px; margin-bottom: 4px;"><?php echo esc_html__('Balance', 'rankbotai-seo-optimizer'); ?></div>
                        <div class="stat-value"><?php echo esc_html(number_format_i18n((float)$balance, 0)); ?></div>
                    </div>
                    
                    <div style="margin-top: 16px;">
                        <button type="button" id="rankbot-manage-plan-btn" style="background: rgba(255,255,255,0.2); border:none; cursor:pointer; width:100%; color:white; text-decoration:none; display:block; text-align:center; padding: 8px; border-radius: 6px; font-size: 13px; font-weight: 500; transition: background 0.2s;">
                            <?php echo esc_html__('Manage Subscription & Top Up', 'rankbotai-seo-optimizer'); ?>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Total Processed -->
            <?php 
                $rankbot_pLabel = '';
                if ($period === '7') {
                    $rankbot_pLabel = (string) __(' (Last 7d)', 'rankbotai-seo-optimizer');
                } elseif ($period === '30') {
                    $rankbot_pLabel = (string) __(' (Last 30d)', 'rankbotai-seo-optimizer');
                } elseif ($period === 'all') {
                    $rankbot_pLabel = (string) __(' (All Time)', 'rankbotai-seo-optimizer');
                }
            ?>
            <div class="stat-card rb-animate rb-animate-delay-2">
                <div>
                    <div class="stat-label"><?php echo esc_html__('Processed', 'rankbotai-seo-optimizer'); ?> <?php echo esc_html($rankbot_pLabel); ?></div>
                    <div class="stat-value">
                       <?php echo esc_html(number_format_i18n((int)($stats['period']['optimizations'] ?? 0))); ?>
                    </div>
                    <div style="font-size: 11px; color: #9ca3af; margin-top: 6px;">
                       <?php echo esc_html__('Total:', 'rankbotai-seo-optimizer'); ?> <?php echo esc_html(number_format_i18n((int)($stats['total']['optimizations'] ?? 0))); ?>
                    </div>
                </div>
                <div style="margin-top: auto; padding-top: 10px;">
                    <span class="dashicons dashicons-admin-page" style="color: #cbd5e1; font-size: 24px;"></span>
                </div>
            </div>

            <!-- Total Tokens Spent -->
            <div class="stat-card rb-animate rb-animate-delay-3">
                <div>
                          <div class="stat-label"><?php echo esc_html__('Spent', 'rankbotai-seo-optimizer'); ?> <?php echo esc_html($rankbot_pLabel); ?></div>
                    <div class="stat-value">
                       <?php echo esc_html(number_format_i18n((float)($stats['period']['tokens_spent'] ?? 0), 2)); ?>
                    </div>
                     <div style="font-size: 11px; color: #9ca3af; margin-top: 6px;">
                              <?php echo esc_html__('Total:', 'rankbotai-seo-optimizer'); ?> <?php echo esc_html(number_format_i18n((float)($stats['total']['tokens_spent'] ?? 0), 2)); ?>
                    </div>
                </div>
                <div style="margin-top: auto; padding-top: 10px;">
                    <span class="dashicons dashicons-chart-bar" style="color: #e2e8f0; font-size: 24px;"></span>
                </div>
            </div>
            
            <!-- Most Popular Type -->
            <div class="stat-card rb-animate rb-animate-delay-4">
                <div>
                    <div class="stat-label"><?php echo esc_html__('Top Content', 'rankbotai-seo-optimizer'); ?> <?php echo esc_html($rankbot_pLabel); ?></div>
                    <div class="stat-value" style="font-size: 20px;">
                       <?php 
                           if (!empty($stats['period']['by_type'])) {
                               $rankbot_topType = array_key_first($stats['period']['by_type']);
                               $rankbot_topCount = isset($stats['period']['by_type'][$rankbot_topType]) ? (int)$stats['period']['by_type'][$rankbot_topType] : 0;
                               echo esc_html(ucfirst((string)$rankbot_topType)) . ' <span style="font-size:14px; color:#9ca3af;">(' . esc_html((string)$rankbot_topCount) . ')</span>';
                           } else {
                               echo '-';
                           }
                       ?>
                    </div>
                     <div style="font-size: 11px; color: #9ca3af; margin-top: 6px;">
                        &nbsp;
                    </div>
                </div>
                <div style="margin-top: auto; padding-top: 10px;">
                    <span class="dashicons dashicons-media-document" style="color: #e2e8f0; font-size: 24px;"></span>
                </div>
            </div>
        </div>

        <!-- Graphs / Activity Section -->
        <div class="rb-animate rb-animate-delay-5" style="display: grid; grid-template-columns: 2fr 1fr; gap: 20px; margin-bottom: 20px;">
            <div class="rankbot-card" style="margin-bottom: 0;">
                 <div class="rankbot-card-header" style="border-bottom: 1px solid #f3f4f6; padding-bottom: 15px; margin-bottom: 20px; display: flex; justify-content: space-between;">
                    <h3 style="margin:0; font-size:16px; font-weight: 600;"><?php echo esc_html__('Daily Token Usage', 'rankbotai-seo-optimizer'); ?></h3>
                </div>
                
                <div style="height: 250px; position: relative;">
                    <canvas id="usageChart"></canvas>
                </div>
            </div>

            <!-- Type Stats -->
            <div class="rankbot-card" style="margin-bottom: 0;">
                <div class="rankbot-card-header" style="border-bottom: 1px solid #f3f4f6; padding-bottom: 15px; margin-bottom: 20px;">
                    <h3 style="margin:0; font-size:16px; font-weight: 600;"><?php echo esc_html__('By Resource Type', 'rankbotai-seo-optimizer'); ?></h3>
                </div>
                
                <?php if (!empty($stats['period']['by_type'])): ?>
                    <table class="details-table">
                        <?php foreach ($stats['period']['by_type'] as $type => $rankbot_count): ?>
                        <tr>
                            <td class="details-label" style="text-transform: capitalize;"><?php echo esc_html($type); ?></td>
                            <td class="details-value" style="font-weight: 600; text-align: right;"><?php echo esc_html(number_format_i18n((float) $rankbot_count)); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                <?php else: ?>
                    <p style="color: #9ca3af; text-align: center; margin-top: 40px;"><?php echo esc_html__('No activity yet.', 'rankbotai-seo-optimizer'); ?></p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Connection Details Card -->
        <div class="rankbot-card rb-animate rb-animate-delay-6">
            <div style="display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid #f3f4f6; padding-bottom:16px; margin-bottom:16px;">
                <h3 style="margin:0; font-size:16px;">Connection Details</h3>
                <?php
                $rankbot_is_verified = is_array($connectionParams) && isset($connectionParams['site']['id']);
                ?>
                <div class="rankbot-status <?php echo $rankbot_is_verified ? 'status-active' : 'status-inactive'; ?>" style="padding: 2px 8px; font-size: 11px;">
                    <?php echo esc_html($rankbot_is_verified ? __('Verified', 'rankbotai-seo-optimizer') : __('Not Verified', 'rankbotai-seo-optimizer')); ?>
                </div>
            </div>
            
            <table class="details-table">
                <tbody>
                    <tr>
                        <td class="details-label"><?php echo esc_html__('Connected Domain', 'rankbotai-seo-optimizer'); ?></td>
                        <?php
                        $rankbot_connected_domain = $connectionParams['site']['domain'] ?? '';
                        if (is_string($rankbot_connected_domain) && $rankbot_connected_domain !== '') {
                            $rankbot_parsed_host = (string) wp_parse_url($rankbot_connected_domain, PHP_URL_HOST);
                            if ($rankbot_parsed_host) {
                                $rankbot_connected_domain = $rankbot_parsed_host;
                            } else {
                                // If backend stored host or host/path, strip to host.
                                $rankbot_connected_domain = preg_replace('#^https?://#i', '', $rankbot_connected_domain);
                                $rankbot_connected_domain = preg_replace('#/.*$#', '', $rankbot_connected_domain);
                                $rankbot_connected_domain = preg_replace('/:\\d+$/', '', $rankbot_connected_domain);
                            }
                        }

                        if (!$rankbot_connected_domain) {
                            $rankbot_connected_domain = '';
                            if (!empty($_SERVER['HTTP_HOST'])) {
                                $rankbot_connected_domain = sanitize_text_field((string) wp_unslash($_SERVER['HTTP_HOST']));
                                $rankbot_connected_domain = preg_replace('/:\\d+$/', '', $rankbot_connected_domain);
                            }
                        }
                        ?>
                        <td class="details-value"><?php echo esc_html($rankbot_connected_domain ?: __('Unknown', 'rankbotai-seo-optimizer')); ?></td>
                    </tr>
                    <tr>
                        <td class="details-label"><?php echo esc_html__('API License Key', 'rankbotai-seo-optimizer'); ?></td>
                        <td class="details-value">
                            <code style="background: #f3f4f6; padding: 4px 8px; border-radius: 4px; color: #4b5563;">
                                <?php echo esc_html(substr($key, 0, 12) . '****************' . substr($key, -4)); ?>
                            </code>
                        </td>
                    </tr>
                </tbody>
            </table>

            <div style="margin-top: 24px; display:flex; justify-content:space-between; align-items:center;">
                <?php if (isset($magicToken) && $magicToken): ?>
                    <?php
                    $rankbot_magic_url = rtrim($this->api->get_api_url(), '/') . '/magic-login?token=' . rawurlencode((string) $magicToken);
                    ?>
                    <a href="<?php echo esc_url($rankbot_magic_url); ?>" target="_blank" class="rankbot-btn btn-primary">
                        <?php echo esc_html__('Open Cloud Dashboard', 'rankbotai-seo-optimizer'); ?> <span class="dashicons dashicons-external" style="margin-left:4px;"></span>
                    </a>
                <?php else: ?>
                    <span></span>
                <?php endif; ?>

                <form method="post" onsubmit="return confirm(<?php echo wp_json_encode((string) __('Disconnect RankBot?', 'rankbotai-seo-optimizer')); ?>);">
                    <?php wp_nonce_field('rankbot_action', '_wpnonce'); ?>
                    <input type="hidden" name="rankbot_action" value="disconnect">
                    <button type="submit" class="rankbot-btn btn-danger"><?php echo esc_html__('Disconnect', 'rankbotai-seo-optimizer'); ?></button>
                </form>
            </div>
        </div>

    <?php else: ?>
        <!-- Disconnected State -->
        <div class="rankbot-card rb-animate-scale" style="text-align: center; padding: 60px 20px; max-width: 600px; margin: 40px auto;">
            <div style="width: 64px; height: 64px; background: #e0e7ff; color: #4f46e5; border-radius: 16px; display: flex; align-items: center; justify-content: center; margin: 0 auto 24px auto;">
                <span class="dashicons dashicons-superhero" style="font-size: 32px; width: 32px; height: 32px;"></span>
            </div>
            
            <h2 style="font-size: 24px; margin-bottom: 12px; color: #111827;"><?php echo esc_html__('Connect RankBotAI', 'rankbotai-seo-optimizer'); ?></h2>
            <p style="color: #6b7280; font-size: 16px; margin: 0 auto 32px auto; max-width: 400px; line-height: 1.5;">
                <?php echo esc_html__('Link your site to access AI content generation tools directly within your editor.', 'rankbotai-seo-optimizer'); ?>
            </p>

            <?php 
            $rankbot_domain = (string) wp_parse_url(home_url(), PHP_URL_HOST);
            $rankbot_connectUrl = rtrim($this->api->get_api_url(), '/') . '/connect?domain=' . rawurlencode($rankbot_domain) . '&callback=' . rawurlencode(admin_url('admin.php?page=rankbotai-seo-optimizer'));
            ?>
            
            <a href="<?php echo esc_url($rankbot_connectUrl); ?>" target="_blank" class="rankbot-btn btn-primary" style="padding: 12px 32px; font-size: 16px;">
                <?php echo esc_html__('Connect Now', 'rankbotai-seo-optimizer'); ?>
            </a>
            
            <div style="margin-top: 40px; padding-top: 20px; border-top: 1px solid #f3f4f6;">
                <button type="button" onclick="document.getElementById('manual-form').style.display = 'block'; this.style.display='none';" class="btn-text">
                    <?php echo esc_html__('Enter Key Manually', 'rankbotai-seo-optimizer'); ?>
                </button>
                
                <div id="manual-form" style="display: none; margin-top: 20px; text-align: left;">
                    <form method="post" style="background: #f9fafb; padding: 20px; border-radius: 8px;">
                        <?php wp_nonce_field('rankbot_action', '_wpnonce'); ?>
                        <input type="hidden" name="rankbot_action" value="save_settings">
                        <input type="hidden" name="api_url" value="<?php echo esc_url($this->api->get_api_url()); ?>">

                        <label style="display:block; font-weight:500; margin-bottom:8px;"><?php echo esc_html__('License Key', 'rankbotai-seo-optimizer'); ?></label>
                        <div style="display:flex; gap:10px;">
                            <input type="text" name="api_key" placeholder="rk_live_..." style="flex:1; padding:8px 12px; border:1px solid #d1d5db; border-radius:6px;">
                            <button type="submit" class="rankbot-btn btn-primary"><?php echo esc_html__('Save', 'rankbotai-seo-optimizer'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Plan Modal -->
    <div id="rankbot-plan-modal" style="display:none; position:fixed; inset:0; background:rgba(0,0,0,0.5); z-index:100000; align-items:center; justify-content:center;">
        <div style="background:white; width:90%; max-width:900px; max-height:90vh; border-radius:12px; overflow:hidden; display:flex; flex-direction:column; box-shadow:0 25px 50px -12px rgba(0,0,0,0.25);">
            <!-- Header -->
            <div style="padding:16px 24px; border-bottom:1px solid #e5e7eb; display:flex; justify-content:space-between; align-items:center; background:#f9fafb;">
                <h3 style="margin:0; font-size:18px; font-weight:600; color:#111827;"><?php echo esc_html__('Manage Subscription & Top-up', 'rankbotai-seo-optimizer'); ?></h3>
                <button type="button" onclick="document.getElementById('rankbot-plan-modal').style.display='none'" style="border:none; background:none; cursor:pointer; font-size:24px; color:#6b7280;">&times;</button>
            </div>
            
            <!-- Content -->
            <div style="display:flex; flex-direction:column; flex:1; overflow:hidden; background:#f8fafc;">
                
                <!-- Tabs -->
                <div style="background:white; border-bottom:1px solid #e5e7eb; padding:0 24px;">
                    <button type="button" onclick="rbSwitchTab('subs')" id="rb-tab-subs" style="background:transparent; border:none; border-bottom:2px solid #4f46e5; color:#4f46e5; padding:16px 4px; margin-right:24px; font-weight:600; font-size:14px; cursor:pointer;"><?php echo esc_html__('Subscriptions', 'rankbotai-seo-optimizer'); ?></button>
                    <button type="button" onclick="rbSwitchTab('packets')" id="rb-tab-packets" style="background:transparent; border:none; border-bottom:2px solid transparent; color:#6b7280; padding:16px 4px; margin-right:24px; font-weight:500; font-size:14px; cursor:pointer;"><?php echo esc_html__('One-time Packets', 'rankbotai-seo-optimizer'); ?></button>
                    <button type="button" onclick="rbSwitchTab('free')" id="rb-tab-free" style="background:transparent; border:none; border-bottom:2px solid transparent; color:#6b7280; padding:16px 4px; font-weight:500; font-size:14px; cursor:pointer;"><?php echo esc_html__('Free Tier', 'rankbotai-seo-optimizer'); ?></button>
                </div>

                <div style="padding:24px; overflow-y:auto; flex:1;">
                    <div id="rankbot-plans-loader" style="text-align:center; padding:40px;">
                        <span class="spinner is-active" style="float:none; margin:0;"></span> <?php echo esc_html__('Loading plans...', 'rankbotai-seo-optimizer'); ?>
                    </div>
                    
                    <div id="rankbot-content-container" style="display:none;">
                        
                        <!-- Subscriptions View -->
                        <div id="rb-view-subs">
                            <div style="display:flex; justify-content:flex-end; margin-bottom:20px;">
                                 <div style="background:#e5e7eb; padding:4px; border-radius:8px; display:inline-flex;">
                                                <button type="button" id="rb-bill-monthly" onclick="rbSetBilling('monthly')" style="border:none; background:white; padding:6px 16px; border-radius:6px; font-size:13px; font-weight:600; color:#111827; cursor:pointer; box-shadow:0 1px 2px rgba(0,0,0,0.1); transition:all 0.2s;"><?php echo esc_html__('Monthly', 'rankbotai-seo-optimizer'); ?></button>
                                                <button type="button" id="rb-bill-yearly" onclick="rbSetBilling('yearly')" style="border:none; background:transparent; padding:6px 16px; border-radius:6px; font-size:13px; font-weight:600; color:#4b5563; cursor:pointer; transition:all 0.2s;"><?php echo esc_html__('Yearly', 'rankbotai-seo-optimizer'); ?> <span style="font-size:10px; color:#059669; font-weight:800;">-20%</span></button>
                                 </div>
                            </div>
                            <div id="rankbot-plans-list-subs" style="display:grid; grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); gap:20px;"></div>
                            <p id="rb-msg-no-subs" style="display:none; text-align:center; color:#6b7280; padding:20px;"><?php echo esc_html__('No subscription plans available.', 'rankbotai-seo-optimizer'); ?></p>
                        </div>

                        <!-- Packets View -->
                        <div id="rb-view-packets" style="display:none;">
                            <div id="rankbot-plans-list-packets" style="display:grid; grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); gap:20px;"></div>
                            <p id="rb-msg-no-packets" style="display:none; text-align:center; color:#6b7280; padding:20px;"><?php echo esc_html__('No token packets available.', 'rankbotai-seo-optimizer'); ?></p>
                        </div>

                         <!-- Free View -->
                        <div id="rb-view-free" style="display:none;">
                            <div id="rankbot-plans-list-free" style="display:grid; grid-template-columns: repeat(auto-fit, minmax(260px, 1fr)); gap:20px;"></div>
                        </div>

                    </div>
                </div>
            </div>
            
            <!-- Footer -->
            <div style="padding:16px 24px; border-top:1px solid #e5e7eb; background:white; text-align:right;">
                <button type="button" onclick="document.getElementById('rankbot-plan-modal').style.display='none'" class="button"><?php echo esc_html__('Close', 'rankbotai-seo-optimizer'); ?></button>
            </div>
        </div>
    </div>
    <?php
    wp_enqueue_script(
        'rankbot-admin-plans',
        RANKBOT_PLUGIN_URL . 'assets/js/rankbot-admin-plans.js',
        array( 'jquery' ),
        defined( 'RANKBOT_VERSION' ) ? RANKBOT_VERSION : '1.0.0',
        true
    );
    wp_localize_script( 'rankbot-admin-plans', 'rankbotDashPlansData', array(
        'nonce'   => wp_create_nonce( 'rankbot_optimize' ),
        'apiUrl'  => esc_url( rtrim( (string) $this->api->get_api_url(), '/' ) ),
        'authKey' => esc_js( $this->api->get_key() ),
        'i18n'    => array(
            'items_suffix'        => __( ' items', 'rankbotai-seo-optimizer' ),
            /* translators: %s: dollar amount saved per year */
            'save_per_year'       => __( 'Save $%s/year', 'rankbotai-seo-optimizer' ),
            'most_popular'        => __( 'MOST POPULAR', 'rankbotai-seo-optimizer' ),
            'free'                => __( 'Free', 'rankbotai-seo-optimizer' ),
            'tokens'              => __( 'Tokens', 'rankbotai-seo-optimizer' ),
            'buy_pack'            => __( 'Buy Pack', 'rankbotai-seo-optimizer' ),
            'subscribe'           => __( 'Subscribe', 'rankbotai-seo-optimizer' ),
            'activate_free'       => __( 'Activate Free', 'rankbotai-seo-optimizer' ),
            'custom_packet'       => __( 'Custom Packet', 'rankbotai-seo-optimizer' ),
            'enter_tokens_amount' => __( 'Enter Tokens Amount', 'rankbotai-seo-optimizer' ),
            /* translators: %s: minimum number of tokens */
            'min_tokens'          => __( 'Min. %s tokens', 'rankbotai-seo-optimizer' ),
            'one_time_purchase'   => __( 'One-time purchase', 'rankbotai-seo-optimizer' ),
            'never_expires'       => __( 'Never expires', 'rankbotai-seo-optimizer' ),
            'buy_custom'          => __( 'Buy Custom', 'rankbotai-seo-optimizer' ),
            'failed_load_plans'   => __( 'Failed to load plans. Please try again later.', 'rankbotai-seo-optimizer' ),
            'network_error'       => __( 'Network error. Please check your connection.', 'rankbotai-seo-optimizer' ),
            'billing_monthly'     => __( 'Monthly', 'rankbotai-seo-optimizer' ),
            'billing_yearly'      => __( 'Yearly', 'rankbotai-seo-optimizer' ),
        ),
    ) );
    ?>

    </div>
</div>
