/**
 * RankBotAI – Sidebar Metabox (Restore Backup)
 *
 * Used in the post/page/product edit sidebar (render_stats_metabox).
 * Localized object: rankbotSidebarData
 *   - postId (int)    Current post ID
 *   - nonce  (string) Security nonce
 *
 * @package RankBotAI
 */

/* global jQuery, ajaxurl, rankbotSidebarData */

jQuery(document).ready(function ($) {
    'use strict';

    // Scope to the sidebar panel
    var postId = rankbotSidebarData.postId;
    var nonce  = rankbotSidebarData.nonce;

    function log(msg, err) {
        $('#rankbot-sidebar-log').html(msg).css('color', err ? '#c53030' : '#b45309').show();
    }

    function notify(msg, type) {
        try {
            if (window.wp && wp.data && wp.data.dispatch) {
                wp.data.dispatch('core/notices').createNotice(
                    type === 'error' ? 'error' : 'success',
                    msg,
                    { isDismissible: true }
                );
                return;
            }
        } catch (e) { /* no-op */ }

        if (type === 'error') {
            alert('Ошибка: ' + msg);
        } else {
            alert(msg);
        }
    }

    // ---------- Restore Button ----------

    $(document).on('click', '#rb-side-restore', function () {
        $('#rb-restore-modal').css('display', 'flex');
        $('#rb-restore-list').html('<p>Loading...</p>');

        $.post(ajaxurl, {
            action:  'rankbot_get_backups',
            post_id: postId,
            nonce:   nonce
        }, function (res) {
            if (res.success && res.data.backups.length > 0) {
                var html = '<table style="width:100%; border-collapse:collapse;">';
                res.data.backups.forEach(function (b) {
                    var typeLabel = b.action ? String(b.action) : 'legacy';
                    html += '<tr style="border-bottom:1px solid #eee;">';
                    html += '<td style="padding:8px;">' + b.date + '<br><span style="font-size:11px; color:#64748b;">' + typeLabel + '</span></td>';
                    html += '<td style="padding:8px; text-align:right;"><button class="button button-small rb-do-restore" data-ts="' + b.timestamp + '">Restore</button></td>';
                    html += '</tr>';
                });
                html += '</table>';
                $('#rb-restore-list').html(html);
            } else {
                $('#rb-restore-list').html('<p>No backups found.</p>');
            }
        });
    });

    // ---------- Do Restore Action ----------

    $(document).on('click', '.rb-do-restore', function () {
        if (!confirm('This will Revert title, content and excerpt to this version. Continue?')) {
            return;
        }
        var ts = $(this).data('ts');

        $.post(ajaxurl, {
            action:    'rankbot_restore_backup',
            post_id:   postId,
            timestamp: ts,
            nonce:     nonce
        }, function (res) {
            if (res.success) {
                alert('Restored successfully.');
                location.reload();
            } else {
                alert('Error: ' + res.data);
            }
        });
    });
});
