/**
 * RankBotAI – History Page (Clear Local History Modal)
 *
 * Used on the RankBot history admin page.
 * Localized object: rankbotHistoryData
 *   - canClear          (boolean) Whether the clear button should be functional
 *   - nonce             (string)  Security nonce
 *   - i18n.failedToClear (string) Translatable error message
 *
 * @package RankBotAI
 */

/* global jQuery, ajaxurl, rankbotHistoryData */

(function ($) {
    'use strict';

    var canClear = !!rankbotHistoryData.canClear;
    var $btn     = $('#rb-clear-local-history');
    var $modal   = $('#rb-clear-history-modal');

    if (!$btn.length) {
        return;
    }

    function openModal() {
        $modal.css('display', 'flex');
    }

    function closeModal() {
        $modal.hide();
    }

    $btn.on('click', function () {
        if (!canClear) {
            return;
        }
        openModal();
    });

    $('#rb-clear-history-cancel').on('click', closeModal);

    $modal.on('click', function (e) {
        if (e.target === this) {
            closeModal();
        }
    });

    $('#rb-clear-history-confirm').on('click', function () {
        if (!canClear) {
            return;
        }

        $(this).prop('disabled', true).text('Deleting...');

        $.post(ajaxurl, {
            action: 'rankbot_clear_local_history',
            nonce:  rankbotHistoryData.nonce
        }).done(function (resp) {
            if (resp && resp.success) {
                window.location.reload();
                return;
            }
            alert(
                (resp && resp.data)
                    ? resp.data
                    : (rankbotHistoryData.i18n && rankbotHistoryData.i18n.failedToClear
                        ? rankbotHistoryData.i18n.failedToClear
                        : 'Failed to clear local history')
            );
        }).fail(function () {
            alert('Network error');
        }).always(function () {
            $('#rb-clear-history-confirm').prop('disabled', false).text('Delete');
            closeModal();
        });
    });
})(jQuery);
