/**
 * RankBotAI – Admin Dashboard Plans Modal
 *
 * Used on the main admin dashboard page (admin-page.php).
 * Localized object: rankbotDashPlansData
 *   nonce    (string)
 *   apiUrl   (string)
 *   authKey  (string)
 *   i18n     (object) – all translatable strings
 */
(function ($) {
    'use strict';

    var rbI18n = rankbotDashPlansData.i18n || {};
    var rbPlansData = [];
    var rbBillingMode = 'monthly';
    var apiUrl = rankbotDashPlansData.apiUrl;
    var authKey = rankbotDashPlansData.authKey;
    var nonce = rankbotDashPlansData.nonce;

    window.rbCalcCustom = function (val) {
        var t = parseInt(val) || 0;
        var rate = 44.00;
        var price = (t / 1000) * rate;
        var items = Math.floor(t / 3);

        var elPrice = document.getElementById('rb-custom-price');
        var elEst = document.getElementById('rb-custom-est');
        var btn = document.getElementById('rb-custom-btn');

        if (elPrice) elPrice.innerText = '$' + price.toFixed(2);
        if (elEst) elEst.innerText = '~' + items.toLocaleString() + (rbI18n.items_suffix || ' items');

        if (btn) {
            if (t >= 10) {
                btn.disabled = false;
                btn.style.color = '#4f46e5';
                btn.style.borderColor = '#4f46e5';
                btn.style.cursor = 'pointer';
            } else {
                btn.disabled = true;
                btn.style.color = '#9ca3af';
                btn.style.borderColor = '#d1d5db';
                btn.style.cursor = 'not-allowed';
            }
        }
    };

    window.rbBuyCustom = function () {
        var t = document.getElementById('rb-custom-input').value;
        var baseUrl = apiUrl + '/dashboard/topup';
        var url = baseUrl + '?billing=one-time&custom_tokens=' + t + '&auth_key=' + authKey;
        window.open(url, '_blank');
    };

    window.rbSwitchTab = function (tab) {
        ['subs', 'packets', 'free'].forEach(function (t) {
            var el = document.getElementById('rb-tab-' + t);
            if (t === tab) {
                el.style.borderBottom = '2px solid #4f46e5';
                el.style.color = '#4f46e5';
                el.style.fontWeight = '600';
            } else {
                el.style.borderBottom = '2px solid transparent';
                el.style.color = '#6b7280';
                el.style.fontWeight = '500';
            }
            var view = document.getElementById('rb-view-' + t);
            if (t === tab) view.style.display = 'block';
            else view.style.display = 'none';
        });
    };

    window.rbSetBilling = function (mode) {
        rbBillingMode = mode;
        var btnM = document.getElementById('rb-bill-monthly');
        var btnY = document.getElementById('rb-bill-yearly');

        if (mode === 'monthly') {
            btnM.style.background = 'white';
            btnM.style.boxShadow = '0 1px 2px rgba(0,0,0,0.1)';
            btnM.style.color = '#111827';
            btnY.style.background = 'transparent';
            btnY.style.boxShadow = 'none';
            btnY.style.color = '#4b5563';
        } else {
            btnY.style.background = 'white';
            btnY.style.boxShadow = '0 1px 2px rgba(0,0,0,0.1)';
            btnY.style.color = '#111827';
            btnM.style.background = 'transparent';
            btnM.style.boxShadow = 'none';
            btnM.style.color = '#4b5563';
        }
        rbRenderPlans();
    };

    function rbRenderPlans() {
        var listSubs = $('#rankbot-plans-list-subs');
        var listPackets = $('#rankbot-plans-list-packets');
        var listFree = $('#rankbot-plans-list-free');

        if (!rbPlansData || !rbPlansData.length) return;

        var htmlSubs = '';
        var htmlPackets = '';
        var htmlFree = '';

        rbPlansData.forEach(function (p) {
            var isPacket = p.type !== 'subscription';
            var basePrice = Number(p.price);
            var price = basePrice;
            var label = '/mo';
            var billingParam = 'monthly';
            var savingsHtml = '';

            if (!isPacket && basePrice > 0) {
                if (rbBillingMode === 'yearly') {
                    var oldPrice = price * 12;
                    price = price * 12 * 0.8;
                    label = '/yr';
                    billingParam = 'yearly';
                    var savedAmount = oldPrice - price;
                    var fmt = rbI18n.save_per_year || 'Save $%s/year';
                    savingsHtml = '<div style="background:#ecfdf5; color:#065f46; font-size:12px; padding:4px 8px; border-radius:6px; margin-bottom:12px; font-weight:700; display:inline-block;">' + fmt.replace('%s', savedAmount.toFixed(0)) + '</div>';
                }
            } else if (isPacket) {
                billingParam = 'one-time';
            }

            var featuresHtml = '';
            if (p.features_list && p.features_list.length) {
                featuresHtml = '<ul style="margin:16px 0; padding:0; list-style:none; font-size:13px; color:#4b5563; text-align:left;">';
                p.features_list.forEach(function (f) {
                    featuresHtml += '<li style="margin-bottom:8px; display:flex; align-items:start;"><span class="dashicons dashicons-yes" style="color:#059669; margin-right:8px; font-size:16px; width:16px; height:16px; margin-top:2px;"></span> <span style="flex:1;">' + rbEscapeHtml(f) + '</span></li>';
                });
                featuresHtml += '</ul>';
            }

            var estItems = Math.floor(Number(p.tokens) / 3);
            var btnUrl = apiUrl + '/dashboard/topup?plan_id=' + p.id + '&billing=' + billingParam + '&auth_key=' + authKey;
            var isHighlight = (p.highlight == 1);

            var card = '<div style="border:1px solid ' + (isHighlight ? '#6366f1' : '#e5e7eb') + '; border-radius:12px; padding:24px; text-align:center; position:relative; background:white; display:flex; flex-direction:column; box-shadow:' + (isHighlight ? '0 10px 15px -3px rgba(99, 102, 241, 0.1), 0 4px 6px -2px rgba(99, 102, 241, 0.05)' : '0 1px 3px 0 rgba(0, 0, 0, 0.1)') + ';">' +
                (isHighlight && !isPacket ? '<div style="position:absolute; top:-12px; left:50%; transform:translateX(-50%); background:#6366f1; color:white; font-size:11px; font-weight:bold; padding:4px 12px; border-radius:99px; box-shadow:0 2px 4px rgba(99,102,241,0.3);">' + rbEscapeHtml(rbI18n.most_popular || 'MOST POPULAR') + '</div>' : '') +
                '<h4 style="margin:0 0 8px 0; font-size:18px; font-weight:700; color:#1f2937;">' + rbEscapeHtml(p.name) + '</h4>' +
                '<div style="display:flex; justify-content:center; align-items:baseline; margin-bottom:4px;">' +
                '<span style="font-size:32px; font-weight:800; color:#111827;">' + (basePrice > 0 ? '$' + price.toFixed(2) : rbEscapeHtml(rbI18n.free || 'Free')) + '</span>' +
                (!isPacket && basePrice > 0 ? '<span style="color:#6b7280; font-size:14px; margin-left:4px;">' + label + '</span>' : '') +
                '</div>' +
                savingsHtml +
                '<div style="color:#6b7280; font-size:13px; font-weight:500; margin-bottom:4px; font-family:monospace;">' + p.tokens.toLocaleString() + ' ' + rbEscapeHtml(rbI18n.tokens || 'Tokens') + '</div>' +
                '<div style="color:#6366f1; font-size:12px; font-weight:600; margin-bottom:20px;">~' + estItems.toLocaleString() + rbEscapeHtml(rbI18n.items_suffix || ' items') + '</div>' +
                '<div style="border-top:1px solid #f3f4f6; margin-bottom:16px; width:100%;"></div>' +
                featuresHtml +
                '<div style="margin-top:auto; width:100%;"><a href="' + btnUrl + '" target="_blank" class="button" style="display:flex; justify-content:center; align-items:center; width:100%; height:auto; padding:10px 16px; font-size:14px; font-weight:600; transition:all 0.2s; ' + (isHighlight ? 'background:#4f46e5; color:white; border:none;' : 'background:#fff; color:#4f46e5; border:1px solid #4f46e5;') + '">' +
                (basePrice > 0 ? (isPacket ? rbEscapeHtml(rbI18n.buy_pack || 'Buy Pack') : rbEscapeHtml(rbI18n.subscribe || 'Subscribe')) : rbEscapeHtml(rbI18n.activate_free || 'Activate Free')) + ' &rarr;</a></div>' +
                '</div>';

            if (isPacket) {
                htmlPackets += card;
            } else if (basePrice === 0) {
                htmlFree += card;
            } else {
                htmlSubs += card;
            }
        });

        var customCard = '<div style="border:1px solid #e5e7eb; border-radius:12px; padding:24px; text-align:center; position:relative; background:white; display:flex; flex-direction:column; box-shadow:0 1px 3px 0 rgba(0, 0, 0, 0.1);">' +
            '<h4 style="margin:0 0 8px 0; font-size:18px; font-weight:700; color:#1f2937;">' + rbEscapeHtml(rbI18n.custom_packet || 'Custom Packet') + '</h4>' +
            '<div style="display:flex; justify-content:center; align-items:baseline; margin-bottom:4px;"><span id="rb-custom-price" style="font-size:32px; font-weight:800; color:#111827;">$0.00</span></div>' +
            '<div style="margin-bottom:20px;">' +
            '<label style="display:block; text-align:left; font-size:12px; font-weight:600; color:#374151; margin-bottom:4px;">' + rbEscapeHtml(rbI18n.enter_tokens_amount || 'Enter Tokens Amount') + '</label>' +
            '<input type="number" id="rb-custom-input" oninput="rbCalcCustom(this.value)" placeholder="e.g. 5000" style="width:100%; padding:8px 12px; border:1px solid #d1d5db; border-radius:6px; font-size:14px;">' +
            '<div style="text-align:left; font-size:11px; color:#6b7280; margin-top:4px;">' + (rbI18n.min_tokens || 'Min. %s tokens').replace('%s', '10') + '</div></div>' +
            '<div id="rb-custom-est" style="color:#6366f1; font-size:12px; font-weight:600; margin-bottom:20px;">~0' + rbEscapeHtml(rbI18n.items_suffix || ' items') + '</div>' +
            '<div style="border-top:1px solid #f3f4f6; margin-bottom:16px; width:100%;"></div>' +
            '<ul style="margin:16px 0; padding:0; list-style:none; font-size:13px; color:#4b5563; text-align:left;">' +
            '<li style="margin-bottom:8px; display:flex; align-items:start;"><span class="dashicons dashicons-yes" style="color:#059669; margin-right:8px; font-size:16px; width:16px; height:16px; margin-top:2px;"></span> <span style="flex:1;">' + rbEscapeHtml(rbI18n.one_time_purchase || 'One-time purchase') + '</span></li>' +
            '<li style="margin-bottom:8px; display:flex; align-items:start;"><span class="dashicons dashicons-yes" style="color:#059669; margin-right:8px; font-size:16px; width:16px; height:16px; margin-top:2px;"></span> <span style="flex:1;">' + rbEscapeHtml(rbI18n.never_expires || 'Never expires') + '</span></li>' +
            '</ul>' +
            '<div style="margin-top:auto; width:100%;"><button type="button" id="rb-custom-btn" onclick="rbBuyCustom()" disabled class="button" style="display:flex; justify-content:center; align-items:center; width:100%; height:auto; padding:10px 16px; font-size:14px; font-weight:600; background:#fff; color:#9ca3af; border:1px solid #d1d5db; cursor:not-allowed;">' +
            rbEscapeHtml(rbI18n.buy_custom || 'Buy Custom') + ' &rarr;</button></div></div>';
        htmlPackets += customCard;

        listSubs.html(htmlSubs);
        $('#rb-msg-no-subs').css('display', htmlSubs ? 'none' : 'block');
        listPackets.html(htmlPackets);
        $('#rb-msg-no-packets').css('display', htmlPackets ? 'none' : 'block');
        listFree.html(htmlFree);
    }

    function rbEscapeHtml(text) {
        if (!text) return '';
        return text.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;").replace(/"/g, "&quot;").replace(/'/g, "&#039;");
    }
    window.rbEscapeHtml = rbEscapeHtml;

    $(document).ready(function () {
        $('#rankbot-manage-plan-btn').on('click', function (e) {
            e.preventDefault();
            $('#rankbot-plan-modal').css('display', 'flex');
            loadPlans();
        });

        $('#rankbot-plan-modal').on('click', function (e) {
            if (e.target === this) {
                $(this).hide();
            }
        });

        function loadPlans() {
            var loader = $('#rankbot-plans-loader');
            var container = $('#rankbot-content-container');

            if (rbPlansData.length > 0) return;

            $.post(ajaxurl, {
                action: 'rankbot_get_plans',
                nonce: nonce
            }, function (res) {
                loader.hide();
                container.show();

                if (res.success && res.data.plans) {
                    rbPlansData = res.data.plans;
                    rbRenderPlans();
                } else {
                    container.html('<p style="color:#ef4444; text-align:center;">' + rbEscapeHtml(rbI18n.failed_load_plans || 'Failed to load plans. Please try again later.') + '</p>');
                }
            }).fail(function () {
                loader.hide();
                container.show().html('<p style="color:#ef4444; text-align:center;">' + rbEscapeHtml(rbI18n.network_error || 'Network error. Please check your connection.') + '</p>');
            });
        }
    });

})(jQuery);
