(function () {
  'use strict';

  function init() {
    if (!window.RankBotAdminDashboard) return;
    
    // Check if Chart.js is loaded
    if (typeof Chart === 'undefined') {
        console.warn('RankBotAI: Chart.js library not loaded.');
        return;
    }

    var canvas = document.getElementById('usageChart');
    if (!canvas) return;
    
    // Clear context to be safe or check if chart instance exists
    var ctx = canvas.getContext('2d');
    var labels = window.RankBotAdminDashboard.chartLabels || [];
    var data = window.RankBotAdminDashboard.chartData || [];

    // Ensure numeric data
    data = data.map(function(d) { return Number(d) || 0; });

    // Destroy existing chart to prevent memory leaks or double rendering
    if (window.rankbotUsageChart instanceof Chart) {
      window.rankbotUsageChart.destroy();
    }

    // Chart.js Configuration
    window.rankbotUsageChart = new Chart(ctx, {
      type: 'bar',
      data: {
        labels: labels,
        datasets: [{
          label: 'Tokens Spent',
          data: data,
          backgroundColor: 'rgba(99, 102, 241, 0.8)', // Indigo-500
          borderColor: '#4f46e5',
          borderWidth: 1,
          borderRadius: 4,
          maxBarThickness: 40,
          hoverBackgroundColor: '#4f46e5'
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
             display: false
          },
          tooltip: {
            backgroundColor: '#1f2937',
            padding: 12,
            cornerRadius: 8,
            titleFont: { size: 13, weight: '600', family: '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif' },
            bodyFont: { size: 13, family: '-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif' },
            displayColors: false,
            callbacks: {
              label: function(context) {
                var label = context.dataset.label || '';
                if (label) {
                    label += ': ';
                }
                if (context.parsed.y !== null) {
                    label += new Intl.NumberFormat('en-US').format(context.parsed.y);
                }
                return label;
              }
            }
          }
        },
        scales: {
          y: {
            beginAtZero: true,
            grid: {
              color: '#f3f4f6',
              borderDash: [4, 4],
              drawBorder: false
            },
            ticks: {
              font: { size: 11, family: 'monospace' },
              color: '#9ca3af',
              padding: 10
            },
            border: { display: false }
          },
          x: {
            grid: {
              display: false,
              drawBorder: false
            },
            ticks: {
              font: { size: 11 },
              color: '#6b7280'
            },
            border: { display: false }
          }
        },
        interaction: {
            mode: 'index',
            intersect: false,
        },
        animation: {
            duration: 1000,
            easing: 'easeOutQuart'
        }
      }
    });
  }

  // Initialize on load
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
})();
