(function(){
	function $(root, selector){ return root.querySelector(selector); }
	function setText(el, text){ if(el){ el.textContent = text; } }
	function setCode(el, code){ if(el){ el.textContent = code; } }

	function buildSnippets(endpoint){
		var js = "fetch('" + endpoint + "')\n  .then(r => r.json())\n  .then(data => console.log(data))\n  .catch(err => console.error(err));";

		var php = "<?php\\n" +
			"$response = wp_remote_get('" + endpoint + "');\\n" +
			"if (is_wp_error($response)) {\\n" +
			"    error_log($response->get_error_message());\\n" +
			"    return;\\n" +
			"}\\n" +
			"$body = wp_remote_retrieve_body($response);\\n" +
			"$data = json_decode($body, true);\\n" +
			"var_dump($data);\\n" +
			"?>";

		return { js: js, php: php };
	}

	function handleCopy(button, input){
		button.addEventListener('click', function(){
			input.select();
			input.setSelectionRange(0, 99999);
			document.execCommand('copy');
			button.textContent = 'Copied!';
			setTimeout(function(){ button.textContent = 'Copy URL'; }, 1200);
		});
	}

	function attach(container){
		var button = $(container, '.randapigen-button');
var result = $(container, '.randapigen-result');
var name = $(container, '.randapigen-name');
var category = $(container, '.randapigen-category');
var summary = $(container, '.randapigen-summary');
var endpointInput = $(container, '.randapigen-endpoint');
var copyBtn = $(container, '.randapigen-copy-url');
var codeJs = $(container, '.randapigen-code-js code');
var codePhp = $(container, '.randapigen-code-php code');
		var favBtn;
		var favList;

		if (!button) return;

		button.addEventListener('click', function(){
			button.disabled = true;
			button.textContent = 'Drawing...';
			var restUrl = (window.RANDAPIGEN_DATA && window.RANDAPIGEN_DATA.restUrl) || container.getAttribute('data-rest-url');
var headers = {};
if (window.RANDAPIGEN_DATA && window.RANDAPIGEN_DATA.nonce) {
	headers['X-WP-Nonce'] = window.RANDAPIGEN_DATA.nonce;
			}
			fetch(restUrl, { headers: headers, credentials: 'same-origin' })
				.then(function(r){ return r.json(); })
				.then(function(data){
					setText(name, data.name || '');
					setText(category, data.category ? ('Category: ' + data.category) : '');
					setText(summary, data.summary || '');
					endpointInput.value = data.endpoint || '';
					var snip = buildSnippets(data.endpoint || '');
					setCode(codeJs, snip.js);
					setCode(codePhp, snip.php);
					result.hidden = false;
					ensureFavoritesUI(container, data);
				})
				.catch(function(err){
					console.error(err);
					alert('Failed to draw an API.');
				})
				.finally(function(){
					button.disabled = false;
					button.textContent = 'Draw me an API!';
				});
		});

		if (copyBtn && endpointInput){
			handleCopy(copyBtn, endpointInput);
		}
	}

	function ensureFavoritesUI(container, data){
		var favWrap = container.querySelector('.randapigen-favorites');
if (!favWrap){
	favWrap = document.createElement('div');
	favWrap.className = 'randapigen-favorites';
	favWrap.innerHTML = '<button type="button" class="randapigen-fav-btn">Favorite</button> <ul class="randapigen-fav-list"></ul>';
	container.appendChild(favWrap);
}
var favBtn = favWrap.querySelector('.randapigen-fav-btn');
var favList = favWrap.querySelector('.randapigen-fav-list');
var key = 'randapigen_favorites';
		favBtn.onclick = function(){
			try{
				var favs = JSON.parse(localStorage.getItem(key) || '[]');
				var item = { name: data.name, endpoint: data.endpoint };
				var exists = favs.some(function(f){ return f.endpoint === item.endpoint; });
				if (!exists){
					favs.push(item);
					localStorage.setItem(key, JSON.stringify(favs));
				}
				renderFavs();
			} catch(e){ console.warn(e); }
		};
		function renderFavs(){
			var favs = [];
			try{ favs = JSON.parse(localStorage.getItem(key) || '[]'); } catch(e){}
			favList.innerHTML = '';
			favs.forEach(function(f, idx){
				var li = document.createElement('li');
				var a = document.createElement('a');
				a.href = f.endpoint; a.target = '_blank'; a.rel = 'noopener'; a.textContent = f.name || f.endpoint;
				var rm = document.createElement('button');
				rm.type = 'button'; rm.textContent = 'Remove'; rm.style.marginLeft = '8px';
				rm.onclick = function(){
					var favs2 = favs.filter(function(ff){ return ff.endpoint !== f.endpoint; });
					localStorage.setItem(key, JSON.stringify(favs2));
					renderFavs();
				};
				li.appendChild(a); li.appendChild(rm);
				favList.appendChild(li);
			});
		}
		renderFavs();
	}

	document.addEventListener('DOMContentLoaded', function(){
		var containers = document.querySelectorAll('.randapigen-widget');
		containers.forEach(attach);
	});
})();


