<?php
/**
 * Plugin Name: Qumo AI Forms
 * Description: Easily embed your Qumo forms into WordPress pages. Add forms either as embedded content or as a floating chat button that opens in a popup window.
 * Version: 1.0.0
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * Author: Qumo AI Team
 * Author URI: https://qumo.ai/
 * Text Domain: qumo-ai-forms
 * Domain Path: /languages
 * License: GPL v2 or later
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Add version check for WordPress
function qumo_ai_forms_check_wp_version() {
    if ( version_compare( get_bloginfo( 'version' ), '5.8', '<' ) ) {
        add_action( 'admin_notices', 'qumo_ai_forms_wp_version_notice' );
        deactivate_plugins( plugin_basename( __FILE__ ) );
    }
}
add_action( 'admin_init', 'qumo_ai_forms_check_wp_version' );

// Add version check for PHP
function qumo_ai_forms_check_php_version() {
    if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
        add_action( 'admin_notices', 'qumo_ai_forms_php_version_notice' );
        deactivate_plugins( plugin_basename( __FILE__ ) );
    }
}
add_action( 'admin_init', 'qumo_ai_forms_check_php_version' );

// WordPress version notice
function qumo_ai_forms_wp_version_notice() {
    echo '<div class="error"><p>';
    echo esc_html(sprintf( 
        /* translators: %s: Required WordPress version. */
        __( 'Qumo AI Forms requires WordPress version %s or higher. Please upgrade WordPress to use this plugin.', 'qumo-ai-forms' ),
        '5.8'
    ));
    echo '</p></div>';
}

// PHP version notice
function qumo_ai_forms_php_version_notice() {
    echo '<div class="error"><p>';
    echo esc_html(sprintf( 
        /* translators: %s: Required PHP version. */
        __( 'Qumo AI Forms requires PHP version %s or higher. Please upgrade PHP to use this plugin.', 'qumo-ai-forms' ),
        '7.4'
    ));
    echo '</p></div>';
}

// Define plugin constants
define('QUMO_AI_FORMS_VERSION', '1.0.0');
define('QUMO_AI_FORMS_PATH', plugin_dir_path(__FILE__));
define('QUMO_AI_FORMS_URL', plugin_dir_url(__FILE__));

// Include widget class
require_once QUMO_AI_FORMS_PATH . 'includes/class-qumo-ai-widget.php';

// Include block functionality
require_once QUMO_AI_FORMS_PATH . 'blocks/class-qumo-blocks.php';

// Register uninstall hook
register_uninstall_hook(__FILE__, 'qumo_ai_forms_uninstall');

// Uninstall callback function (optional, for additional cleanup)
function qumo_ai_forms_uninstall() {
    // This can be left empty if uninstall.php handles all cleanup
}

// Initialize plugin
function qumo_ai_forms_init() {   
    // Register the widget
    add_action('widgets_init', function() {
        register_widget('Qumo_AI_Widget');
    });
}
add_action('plugins_loaded', 'qumo_ai_forms_init');
