(function() {
    document.addEventListener('DOMContentLoaded', function() {
        // Find all chat icon instances
        var chatIcons = document.querySelectorAll('.qumo-chat-icon-button');
        
        chatIcons.forEach(function(icon) {
            var popupId = icon.getAttribute('data-popup-id');
            var popup = document.getElementById(popupId);
            
            if (!popup) return; // Skip if popup element not found
            
            var closeBtn = popup.querySelector('.qumo-chat-popup-overlay-close');
            var iconContainer = icon.closest('.qumo-chat-icon');
            var iconText = iconContainer.querySelector('.qumo-chat-icon-text');
            var iframe = popup.querySelector('iframe');
            
            // Handle iframe load events
            if (iframe) {
                iframe.addEventListener('load', function() {
                    popup.classList.remove('loading');
                });
            }
            
            // Toggle popup when icon is clicked
            icon.addEventListener('click', function(event) {
                event.preventDefault();
                event.stopPropagation();
                
                // Add loading class
                popup.classList.add('loading');
                
                // Open the popup
                popup.classList.add('show');
                
                // Hide the icon text when popup is shown
                if (iconText) {
                    iconText.classList.add('hidden');
                }
                
                // Load the iframe content if not loaded yet
                if (iframe && !iframe.src) {
                    iframe.src = iframe.getAttribute('data-src');
                } else {
                    // If iframe is already loaded, remove loading class
                    popup.classList.remove('loading');
                }
            });
            
            // Close popup when X is clicked
            if (closeBtn) {
                closeBtn.addEventListener('click', function(event) {
                    event.preventDefault();
                    event.stopPropagation();
                    popup.classList.remove('show');
                    
                    // Show the icon text again when popup is closed
                    if (iconText) {
                        iconText.classList.remove('hidden');
                    }
                });
            }
            
            // Close popup when clicking outside
            document.addEventListener('click', function(event) {
                if (!popup.contains(event.target) && event.target !== icon && 
                    !event.target.closest('.qumo-chat-icon-button')) {
                    popup.classList.remove('show');
                    
                    // Show the icon text again when popup is closed
                    if (iconText) {
                        iconText.classList.remove('hidden');
                    }
                }
            });
        });

        // Handle text bubble close buttons
        document.querySelectorAll('.qumo-chat-icon-text-close').forEach(function(closeBtn) {
            var textBubble = closeBtn.closest('.qumo-chat-icon-text');
            var textId = textBubble.getAttribute('data-text-id');
            
            // Check if this text was previously closed
            if (localStorage.getItem('qumo_text_' + textId) === 'closed') {
                textBubble.classList.add('hidden');
            }
            
            closeBtn.addEventListener('click', function(event) {
                event.preventDefault();
                event.stopPropagation();
                
                // Hide the text bubble
                textBubble.classList.add('hidden');
                
                // Store the closed state
                localStorage.setItem('qumo_text_' + textId, 'closed');
            });
        });
    });
})();
