<?php
/**
 * Plugin Name: Quiet Admin - Clean Dashboard & Controls
 * Plugin URI: https://element.ps/
 * Description: Hide noisy admin notices, disable comments, and clean the dashboard (core + plugin widgets) with a simple UI.
 * Version: 2.0.4
 * Author: Element Media
 * Author URI: https://element.ps/
 * Text Domain: quiet-admin
 * Domain Path: /languages
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 6.1
 * Requires PHP: 7.4
 */

if ( ! defined( 'ABSPATH' ) ) { exit; }

define( 'QUIETADMIN_VERSION', '2.0.4' );
define( 'QUIETADMIN_FILE', __FILE__ );
define( 'QUIETADMIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
define( 'QUIETADMIN_DIR_URL', plugin_dir_url( __FILE__ ) );


function quietadmin_maybe_migrate_options() {
    $map = [
        'qa_dashboard' => 'quietadmin_dashboard',
        'qa_notices'   => 'quietadmin_notices',
        'qa_comments'  => 'quietadmin_comments',
    ];
    foreach ( $map as $old => $new ) {
        $old_val = get_option( $old, null );
        if ( null !== $old_val && null === get_option( $new, null ) ) {
            update_option( $new, $old_val );
        }
    }
}
add_action( 'plugins_loaded', 'quietadmin_maybe_migrate_options' );

require_once QUIETADMIN_DIR_PATH . 'includes/class-qa-settings.php';
\QuietAdmin\Settings::instance();
