<?php
namespace QuietAdmin\Features;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class Welcome {
    public function id(){ return 'welcome'; }
    public function title(){ return __( 'Welcome', 'quiet-admin' ); }

    // No hooks/behavior needed — this is just UI
    public function boot() : void {}

    public function render_settings() : void {
        // Resolve base URL for your settings page (adjust slug if needed)
        $base = function_exists('menu_page_url')
            ? menu_page_url('quiet-admin', false) // your settings page slug
            : admin_url('options-general.php?page=quiet-admin');

        $url_dashboard = add_query_arg( 'tab', 'dashboard', $base );
        $url_notices   = add_query_arg( 'tab', 'notices', $base );
        $url_comments  = add_query_arg( 'tab', 'comments', $base );

        $version = defined('QUIETADMIN_VERSION') ? QUIETADMIN_VERSION : '';

        ?>
        <div class="qa-welcome" style="max-width:880px">
            <h2 style="margin-bottom:4px">
                <?php echo esc_html__( 'Quiet Admin', 'quiet-admin' ); ?>
                <?php if ( $version ) : ?>
                    <span style="font-size:.7em;opacity:.7">v<?php echo esc_html( $version ); ?></span>
                <?php endif; ?>
            </h2>
            <p class="description" style="margin-top:0">
                <?php echo esc_html__( 'Tidy up the WordPress admin for a calmer, faster workflow.', 'quiet-admin' ); ?>
            </p>

            <hr style="border:0;border-top:1px solid #e2e4e7;margin:14px 0" />

            <h3><?php echo esc_html__( 'What you can do', 'quiet-admin' ); ?></h3>
            <ul style="list-style:disc;padding-left:20px;margin: 8px 0 14px;">
                <li><?php echo esc_html__( 'Hide Dashboard widgets (core + plugins) with a simple checklist.', 'quiet-admin' ); ?></li>
                <li><?php echo esc_html__( 'Enable Zen Mode to hide the footer and “Screen Options”.', 'quiet-admin' ); ?></li>
                <li><?php echo esc_html__( 'Silence noisy admin notices while keeping success messages visible.', 'quiet-admin' ); ?></li>
                <li><?php echo esc_html__( '(Optional) Clean up comments (if you enabled that feature).', 'quiet-admin' ); ?></li>
            </ul>

            <div style="display:flex;gap:8px;flex-wrap:wrap;margin:12px 0;">
                <a href="<?php echo esc_url( $url_dashboard ); ?>" class="button button-primary">
                    <?php echo esc_html__( 'Dashboard Cleanup', 'quiet-admin' ); ?>
                </a>
                <a href="<?php echo esc_url( $url_notices ); ?>" class="button">
                    <?php echo esc_html__( 'Notices', 'quiet-admin' ); ?>
                </a>
                <a href="<?php echo esc_url( $url_comments ); ?>" class="button">
                    <?php echo esc_html__( 'Comments', 'quiet-admin' ); ?>
                </a>
            </div>

            <hr style="border:0;border-top:1px solid #e2e4e7;margin:14px 0" />

            <h3><?php echo esc_html__( 'Tips', 'quiet-admin' ); ?></h3>
            <ol style="padding-left:20px;margin: 8px 0 0;">
                <li><?php echo esc_html__( 'Start with “Dashboard Cleanup” to hide the widgets you don’t use.', 'quiet-admin' ); ?></li>
                <li><?php echo esc_html__( 'Enable Zen Mode if you prefer a minimal Dashboard.', 'quiet-admin' ); ?></li>
                <li><?php echo esc_html__( 'If notices are too chatty, switch the Notices tab to “Non-critical” or “All”.', 'quiet-admin' ); ?></li>
            </ol>
        </div>
        <?php
    }

    // Present for interface parity; nothing to save
    public function save_from_request( array $src ) : void {}
}
