<?php
namespace QuietAdmin\Features;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class Notices {
    private $option_key = 'quietadmin_notices';
    private $opts = null;

    public function id(){ return 'notices'; }
    public function title(){ return __( 'Admin Notices', 'quiet-admin' ); }

    public function defaults(){ return [ 'mode' => 'none' ]; }

    private function get_options(){
        if ( isset( $this->opts ) ) return $this->opts;
        $stored = get_option( $this->option_key, [] );
        $this->opts = wp_parse_args( is_array( $stored ) ? $stored : [], $this->defaults() );
        return $this->opts;
    }

    private function update_options( array $opts ){
        $this->opts = $opts;
        update_option( $this->option_key, $this->opts );
    }

    public function boot(){
        add_filter( 'admin_body_class', [ $this, 'admin_body_class' ] );
        add_action( 'admin_enqueue_scripts', function () {
            wp_register_style( 'quietadmin-notices', QUIETADMIN_DIR_URL . 'assets/notices.css', [], QUIETADMIN_VERSION );
            wp_enqueue_style( 'quietadmin-notices' );
        } );
    }

    public function admin_body_class( $classes ) {
        $o = $this->get_options();

        $show_all = false;
        if ( isset( $_GET['quietadmin_show_all'] ) ) {
            $flag  = sanitize_text_field( wp_unslash( $_GET['quietadmin_show_all'] ) );
            $nonce = isset( $_GET['_wpnonce'] ) ? sanitize_text_field( wp_unslash( $_GET['_wpnonce'] ) ) : '';
            if ( wp_verify_nonce( $nonce, 'quietadmin_show_all' ) && ( $flag === '1' || $flag === 'true' ) ) {
                $show_all = true;
            }
        }
        if ( $show_all ) { return $classes; }

        $mode = isset( $o['mode'] ) ? $o['mode'] : 'none';
        if ( $mode === 'non_critical' ) { $classes .= ' qa-hide-notices-noncritical'; }
        if ( $mode === 'all' )          { $classes .= ' qa-hide-notices-all'; }
        return $classes;
    }

    public function render_settings(){
        $o = $this->get_options(); ?>
        <div class="qa-grid">
            <label>
                <input type="radio" name="quietadmin_notices[mode]" value="none" <?php checked( $o['mode'], 'none' ); ?> />
                <?php echo esc_html__( 'Show all notices (default)', 'quiet-admin' ); ?>
            </label>
            <label>
                <input type="radio" name="quietadmin_notices[mode]" value="non_critical" <?php checked( $o['mode'], 'non_critical' ); ?> />
                <?php echo esc_html__( 'Hide non-critical notices', 'quiet-admin' ); ?>
            </label>
            <label>
                <input type="radio" name="quietadmin_notices[mode]" value="all" <?php checked( $o['mode'], 'all' ); ?> />
                <?php echo esc_html__( 'Hide all notices', 'quiet-admin' ); ?>
            </label>
        </div>
        <p class="description">
            <?php
            $url = wp_nonce_url( add_query_arg( 'quietadmin_show_all', '1', admin_url() ), 'quietadmin_show_all' );

            $text = sprintf(
                /* translators: %s is a URL the admin can visit once to temporarily show all notices. */
                __( 'Need to see everything temporarily? Use this URL once: %s', 'quiet-admin' ),
                '<code>' . esc_url( $url ) . '</code>'
            );

            // Allow the <code> tag, escape everything else safely.
            echo wp_kses_post( $text );
            ?>
        </p>
        <?php
    }

    public function save_from_request( array $src ){
        if ( empty( $src['quietadmin_notices'] ) || ! is_array( $src['quietadmin_notices'] ) ) return;
        $in   = $src['quietadmin_notices'];
        $mode = isset( $in['mode'] ) ? sanitize_text_field( $in['mode'] ) : 'none';
        if ( ! in_array( $mode, [ 'none', 'non_critical', 'all' ], true ) ) { $mode = 'none'; }
        $next = $this->get_options();
        $next['mode'] = $mode;
        $this->update_options( $next );
    }
}
