<?php
namespace QuietAdmin\Features;

if ( ! defined( 'ABSPATH' ) ) { exit; }

class Comments {
    private $option_key = 'quietadmin_comments';
    private $opts = null;

    public function id(){ return 'comments'; }
    public function title(){ return __( 'Comments', 'quiet-admin' ); }

    public function defaults(){
        return [
            'mode'  => 'none', // none|all|types
            'types' => [],
        ];
    }

    private function get_options(){
        if ( isset($this->opts) ) return $this->opts;
        $stored = get_option( $this->option_key, [] );
        $this->opts = wp_parse_args( is_array($stored) ? $stored : [], $this->defaults() );
        return $this->opts;
    }

    private function update_options( array $opts ){
        $this->opts = $opts;
        update_option( $this->option_key, $this->opts );
    }

    public function boot(){
        add_action( 'admin_init', [ $this, 'maybe_disable_admin_ui' ] );
        add_filter( 'comments_open', [ $this, 'filter_comments_open' ], 99, 2 );
        add_filter( 'pings_open',    [ $this, 'filter_comments_open' ], 99, 2 );
        add_filter( 'rest_endpoints',[ $this, 'filter_rest_endpoints' ] );
        add_filter( 'xmlrpc_methods',[ $this, 'filter_xmlrpc_methods' ] );
    }

    private function mode(){ $o = $this->get_options(); return $o['mode']; }

    public function filter_comments_open( $open, $post_id ){
        $o = $this->get_options();
        if ( $o['mode'] === 'all' ) return false;
        if ( $o['mode'] === 'types' ){
            $post = get_post( $post_id );
            if ( $post && in_array( $post->post_type, (array) $o['types'], true ) ) return false;
        }
        return $open;
    }

    public function maybe_disable_admin_ui(){
        $o = $this->get_options();
        if ( $o['mode'] === 'none' ) return;
        // Remove menu & dashboard bits
        remove_menu_page( 'edit-comments.php' );
        add_action( 'admin_init', function(){
            remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
            remove_meta_box( 'commentstatusdiv', 'post', 'normal' );
            remove_meta_box( 'commentsdiv', 'post', 'normal' );
        }, 99 );
    }

    public function filter_rest_endpoints( $endpoints ){
        $o = $this->get_options();
        if ( $o['mode'] === 'none' ) return $endpoints;
        unset( $endpoints['/wp/v2/comments'] );
        return $endpoints;
    }

    public function filter_xmlrpc_methods( $methods ){
        $o = $this->get_options();
        if ( $o['mode'] === 'none' ) return $methods;
        unset( $methods['wp.newComment'] );
        return $methods;
    }

    public function render_settings(){
        $o = $this->get_options(); ?>
        <div class="qa-field">
            <label><input type="radio" name="quietadmin_comments[mode]" value="none" <?php checked( $o['mode'], 'none' ); ?>/> <?php echo esc_html__( 'Do not disable', 'quiet-admin' ); ?></label>
        </div>
        <div class="qa-field">
            <label><input type="radio" name="quietadmin_comments[mode]" value="all" <?php checked( $o['mode'], 'all' ); ?>/> <?php echo esc_html__( 'Disable everywhere', 'quiet-admin' ); ?></label>
        </div>
        <div class="qa-field">
            <label><input type="radio" name="quietadmin_comments[mode]" value="types" <?php checked( $o['mode'], 'types' ); ?>/> <?php echo esc_html__( 'Disable for selected post types', 'quiet-admin' ); ?></label>
            <div class="qa-choices" style="margin-left:12px;margin-top:6px;">
                <?php foreach( get_post_types( [ 'public' => true ], 'objects' ) as $pt ): 
                    $on = in_array( $pt->name, (array) $o['types'], true ); ?>
                    <label><input type="checkbox" name="quietadmin_comments[types][]" value="<?php echo esc_attr($pt->name); ?>" <?php checked( $on, true ); ?>/> <?php echo esc_html( $pt->labels->name ); ?></label>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }

    public function save_from_request( array $src ){
        if ( empty($src['quietadmin_comments']) || ! is_array($src['quietadmin_comments']) ) return;
        $in = $src['quietadmin_comments'];
        $mode = isset($in['mode']) ? sanitize_text_field($in['mode']) : 'none';
        if ( ! in_array($mode, ['none','all','types'], true ) ) $mode = 'none';
        $types = isset($in['types']) && is_array($in['types']) ? array_map('sanitize_text_field', $in['types']) : [];

        $next = $this->get_options();
        $next['mode']  = $mode;
        $next['types'] = $types;
        $this->update_options( $next );
    }
}
