<?php
/*
Plugin Name: Quidget – AI Chatbot & Live Chat
Plugin URI: https://quidget.ai/
Description: AI-powered chatbot and live chat plugin for WordPress...
Version: 1.1.6
Author: hordienkoa
License: GPL-2.0-or-later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: quidget-chat
Requires at least: 5.0
Requires PHP: 7.4
*/

if (!defined('ABSPATH')) exit;

// Include settings page
require_once plugin_dir_path(__FILE__) . 'includes/settings.php';

// Activation hook — add default option
function quidgetchatai_activate() {
    if (get_option('quidgetchatai_widget_id') === false) {
        add_option('quidgetchatai_widget_id', '');
    }
}
register_activation_hook(__FILE__, 'quidgetchatai_activate');

// Enqueue Quidget script on frontend
function quidgetchatai_enqueue_script() {
    $widget_id = get_option('quidgetchatai_widget_id', '');
    if (!empty($widget_id)) {
        wp_enqueue_script('quidget-chat', 'https://quidget.ai/webchat/quidget.loader.js', [], '1.1.6', true);

        add_filter('script_loader_tag', function($tag, $handle) use ($widget_id) {
            if ($handle === 'quidget-chat') {
                return str_replace('<script ', '<script async data-id="' . esc_attr($widget_id) . '" ', $tag);
            }
            return $tag;
        }, 10, 2);
    }
}
add_action('wp_enqueue_scripts', 'quidgetchatai_enqueue_script');

function quidgetchatai_add_iframe_after_body() {
    $widget_id = get_option('quidgetchatai_widget_id', '');
    if (!empty($widget_id)) {
        ?>
        <iframe
            src="https://quidget.ai/webchat/chat-iframe.html?id=<?php echo esc_attr($widget_id); ?>"
            id="quidget-chat-iframe"
            title="Quidget | Train AI Chatbots with Your Data for 24/7 Customer Support"
            frameborder="0"
            height="620"
            data-no-lazy="1"
            data-lazy="false"
            data-skip-lazy="1"
            data-skip-lazy="true"
            data-no-lazyload="true"
            data-lazy-fallback="false"
            class="no-lazy no-lazyload skip-lazy a3-notlazy lazyload-disabled" 
            width="380"
            style="position: fixed; z-index: -1;"
        ></iframe>
        <?php
    }
}
add_action('wp_footer', 'quidgetchatai_add_iframe_after_body');

// Admin styles
function quidgetchatai_admin_styles($hook) {
    if ($hook === 'toplevel_page_quidgetchatai-settings') {
        wp_enqueue_style('quidget-admin-style', plugin_dir_url(__FILE__) . 'assets/styles.css', [], '1.1.6');
    }
}
add_action('admin_enqueue_scripts', 'quidgetchatai_admin_styles');

// Uninstall hook — remove saved option
function quidgetchatai_uninstall() {
    delete_option('quidgetchatai_widget_id');
}
register_uninstall_hook(__FILE__, 'quidgetchatai_uninstall');
