<?php
if (!defined('ABSPATH')) exit;

// Register setting
function quidgetchatai_register_settings() {
    register_setting('quidgetchatai_settings_group', 'quidgetchatai_widget_id', 'sanitize_text_field');
}
add_action('admin_init', 'quidgetchatai_register_settings');

// Add admin menu
function quidgetchatai_register_options_page() {
    add_menu_page(
        __('Quidget Chat Settings', 'quidget-chat'),
        __('Quidget Chat', 'quidget-chat'),
        'manage_options',
        'quidgetchatai-settings',
        'quidgetchatai_options_page',
        plugins_url('../assets/img/mark.svg', __FILE__)
    );
}
add_action('admin_menu', 'quidgetchatai_register_options_page');

// Settings page UI
function quidgetchatai_options_page() {
    ?>
    <div class="quidget-logo"></div>
    <div class="quidget-admin-container">
        <div class="quidget-settings">
            <h1><?php esc_html_e('Your Hybrid AI Agent', 'quidget-chat'); ?></h1>
            <form method="post" action="options.php" class="quidget-form-inline">
                <?php 
                settings_fields('quidgetchatai_settings_group');
                wp_nonce_field('quidgetchatai_save_settings', 'quidgetchatai_nonce'); 
                ?>

                <label for="quidgetchatai_widget_id"><strong><?php esc_html_e('Web Chat ID:', 'quidget-chat'); ?></strong></label>
                <input placeholder="<?php esc_attr_e('Web Chat ID ...', 'quidget-chat'); ?>" type="text" id="quidgetchatai_widget_id" name="quidgetchatai_widget_id" 
                    value="<?php echo esc_attr(get_option('quidgetchatai_widget_id')); ?>" />
                
                <?php submit_button(__('Save Settings', 'quidget-chat'), '', '', true); ?>
            </form>

            <p><?php esc_html_e('Set Up in Seconds:', 'quidget-chat'); ?></p>
            <ol>
                <li>
                    <?php esc_html_e('Sign in to', 'quidget-chat'); ?> 
                    <a href="<?php echo esc_url('https://app.quidget.ai/sign-in'); ?>" target="_blank" rel="noopener noreferrer"><?php esc_html_e('Quidget', 'quidget-chat'); ?></a>
                    <?php esc_html_e('or create a', 'quidget-chat'); ?> 
                    <a href="<?php echo esc_url('https://app.quidget.ai/sign-up'); ?>" target="_blank" rel="noopener noreferrer"><?php esc_html_e('free account', 'quidget-chat'); ?></a>.
                </li>
                <li><?php esc_html_e('Go to Test & Install → Copy your Web Chat ID.', 'quidget-chat'); ?></li>
                <li><?php esc_html_e('Paste it below → Save.', 'quidget-chat'); ?></li>
            </ol>
        </div>
        <div class="quidget-help">
            <h3><?php esc_html_e('Need help?', 'quidget-chat'); ?></h3>
            <p><?php esc_html_e('Find your Web Chat ID in your', 'quidget-chat'); ?> 
                <a href="<?php echo esc_url('https://app.quidget.ai/sign-in'); ?>" target="_blank" rel="noopener noreferrer">
                    <?php esc_html_e('Quidget Dashboard', 'quidget-chat'); ?>
                </a> 
                <?php esc_html_e('under Settings.', 'quidget-chat'); ?>
            </p>

            <a href="<?php echo esc_url('https://app.quidget.ai/sign-in'); ?>" title="Quidget App" target="_blank" rel="noopener noreferrer" class="button">
                <?php esc_html_e('Go to Quidget Dashboard', 'quidget-chat'); ?>
            </a>
        </div>
    </div>
    <?php
}
