<?php
if ( ! defined('ABSPATH') ) exit;

class ICGPT_Validator {
    public static function currency_code_is_valid($code) {
        return (bool) preg_match('/^[A-Z]{3}$/', $code);
    }
    public static function availability($status) {
        return in_array($status, ['in_stock','out_of_stock','preorder'], true) ? $status : 'out_of_stock';
    }
    public static function bool_string($b) {
        return $b ? 'true' : 'false';
    }
    public static function price_format($amount, $currency) {
        $amount = wc_format_decimal($amount, 2);
        return $amount.' '.$currency;
    }
    public static function str($v, $max=5000) {
        $v = wp_strip_all_tags((string)$v);
        if ( strlen($v) > $max ) $v = mb_substr($v, 0, $max);
        return $v;
    }
}