<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class ICGPT_Settings {
    public function __construct() {
        add_action( 'admin_menu', [ $this, 'menu' ] );
        add_action( 'admin_init', [ $this, 'register' ] );
    }

    public function menu() {
        add_submenu_page(
            'woocommerce',
            esc_html__( 'Instant Checkout (ChatGPT)', 'quickshop-ai-for-chatgpt' ), 
            esc_html__( 'AI Checkout', 'quickshop-ai-for-chatgpt' ),               
            'manage_woocommerce',
            'icgpt-settings',
            [ $this, 'render' ]
        );
    }

    public function register() {
        register_setting( 'icgpt', 'icgpt_enable', [ 'type' => 'boolean', 'sanitize_callback' => 'rest_sanitize_boolean' ] );
        register_setting( 'icgpt', 'icgpt_merchant_id', [ 'type' => 'string', 'sanitize_callback' => 'sanitize_text_field' ] );
       
	   	   
	   register_setting(
    'icgpt',
    'icgpt_webhook_secret',
    [
        'type'              => 'string',      
        'sanitize_callback' => function ( $val ) {
            $current = (string) get_option( 'icgpt_webhook_secret', '' );
            $val     = is_string( $val ) ? trim( $val ) : '';          
            if ( $val === '' ) {
                return $current;
            }          
            $val = preg_replace( '~[^A-Za-z0-9_\-\.=]~', '', $val );          
            if ( strlen( $val ) < 16 || strlen( $val ) > 256 ) {
            
                return $current;
            }
            return $val;
        },
        'default'           => '',
        'show_in_rest'      => false,
			]
		);
       
        register_setting( 'icgpt', 'icgpt_test_mode', [ 'type' => 'boolean', 'sanitize_callback' => 'rest_sanitize_boolean' ] );

        add_settings_section(
            'icgpt_main',
            esc_html__( '', 'quickshop-ai-for-chatgpt' ), 
            '__return_false',
            'icgpt'
        );

		add_settings_field( 'icgpt_merchant_id', esc_html__( 'Merchant ID', 'quickshop-ai-for-chatgpt' ), function () {
		$v = (string) get_option( 'icgpt_merchant_id', '' );

		printf(
			'<input type="text" name="icgpt_merchant_id" value="%s" class="regular-text" placeholder="%s">',
			esc_attr( $v ),
			esc_attr__( 'merch_123', 'quickshop-ai-for-chatgpt' )
		);

		printf(
			'<p class="description">%s</p>',
			esc_html__( 'Assigned during OpenAI merchant onboarding.', 'quickshop-ai-for-chatgpt' )
		);
		}, 'icgpt', 'icgpt_main' );     
				 add_settings_field( 'icgpt_webhook_secret', esc_html__( 'Secret Key', 'quickshop-ai-for-chatgpt' ), function () {
				$v          = (string) get_option( 'icgpt_webhook_secret', '' );
				$url_rotate = wp_nonce_url( admin_url( 'admin-post.php?action=icgpt_rotate_secret' ), 'icgpt_rotate_secret' );

				echo '<div style="display:flex;gap:6px;align-items:center">';

				printf(
					'<input type="text" id="icgpt_secret" value="%s" class="regular-text" readonly>',
					esc_attr( $v )
				);
				
				printf(
					'<button type="button" class="button icgpt-copy" data-copy="%s">%s</button>',
					esc_attr( '#icgpt_secret' ),
					esc_html__( 'Copy', 'quickshop-ai-for-chatgpt' )
				);
				
				printf(
					'<a class="button button-secondary" href="%s">%s</a>',
					esc_url( $url_rotate ),
					esc_html__( 'Rotate', 'quickshop-ai-for-chatgpt' )
				);

				echo '</div>';
				echo '<p> This key must match the one in your ChatGPT merchant settings. Rotating here requires updating it there too.</p>';
			}, 
			
			'icgpt', 'icgpt_main' );
			add_settings_field( 'icgpt_test_mode', esc_html__( 'Test mode', 'quickshop-ai-for-chatgpt' ), function () {
			$v    = (bool) get_option( 'icgpt_test_mode', true );
			$checked = $v ? 'checked' : ''; 
			printf(
				
				'<label><input type="checkbox" name="icgpt_test_mode" value="1"%s> %s</label>',
				esc_attr( $checked ),
				esc_html__( 'Allows you to place a test order. Uncheck this if you go live.', 'quickshop-ai-for-chatgpt' )
			);
		}, 'icgpt', 'icgpt_main' );

		add_settings_field( 'icgpt_enable', esc_html__( 'Go Live', 'quickshop-ai-for-chatgpt' ), function () {
		$v       = (bool) get_option( 'icgpt_enable', false );
		$checked = $v ? 'checked' : ''; 

		printf(
			'<label><input type="checkbox" name="icgpt_enable" value="1" %s> %s</label>',
			esc_attr( $checked ),
			esc_html__( 'Your WooCommerce products are visible in ChatGPT Search and Instant Checkout.', 'quickshop-ai-for-chatgpt' )
		);
		}, 'icgpt', 'icgpt_main' );        
    }

    public function render() {		
		echo '<div class="icgpt-wrap"><h1>' . esc_html__( 'Instant Checkout for ChatGPT', 'quickshop-ai-for-chatgpt' ) . '</h1>';
        echo '<p class="minititle">' . esc_html__( 'Sell your WooCommerce products in ChatGPT', 'quickshop-ai-for-chatgpt' ) . '</p>';				
			
        echo '<div class="wrap icgpt-wrap">';           
        if ( class_exists( 'ICGPT_Onboarding' ) ) {
            $onb = new ICGPT_Onboarding();
			if ( method_exists( $onb, 'render_section' ) ) {
			ob_start();
			$onb->render_section(); 
			$html = ob_get_clean();
			echo wp_kses_post( $html );
			} else {
                $feed   = rest_url( 'icgpt/v1/feed' );
                $wh     = rest_url( 'icgpt/v1/webhook/order' );
                $secret_raw = get_option( 'icgpt_webhook_secret', '' );

                echo '<ol class="icgpt-steps">';
                echo '<li><strong>' . esc_html__( 'Apply as a merchant', 'quickshop-ai-for-chatgpt' ) . '</strong></li>';
                echo '<li><strong>' . esc_html__( 'Enter your Merchant IDs', 'quickshop-ai-for-chatgpt' ) . '</strong></li>';
                echo '<li><strong>' . esc_html__( 'Product Feed URL:', 'quickshop-ai-for-chatgpt' ) . '</strong> <code>' . esc_html( $feed ) . '</code></li>';
                echo '<li><strong>' . esc_html__( 'Webhook URL:', 'quickshop-ai-for-chatgpt' ) . '</strong> <code>' . esc_html( $wh ) . '</code> — ';
                echo '<strong>' . esc_html__( 'Secret:', 'quickshop-ai-for-chatgpt' ) . '</strong> <code>' . esc_html( $secret_raw ) . '</code></li>';
                echo '<li>' . esc_html__( 'Enable products in the “AI Checkout (ChatGPT)” box', 'quickshop-ai-for-chatgpt' ) . '</li>';
                echo '<li>' . esc_html__( 'Send Test Order, verify a Paid order is created', 'quickshop-ai-for-chatgpt' ) . '</li>';
                echo '<li>' . esc_html__( 'Go live: disable Test Mode, watch Logs', 'quickshop-ai-for-chatgpt' ) . '</li>';
                echo '</ol>';
            }
        }
		
        echo '<div class="icgpt-cards">';
		/*
        echo '<div class="icgpt-card">';
        echo '<h2>' . esc_html__( 'Endpoints', 'quickshop-ai-for-chatgpt' ) . '</h2>';
        $feed = rest_url( 'icgpt/v1/feed' );
        $wh   = rest_url( 'icgpt/v1/webhook/order' );
        echo '<p>' . esc_html__( 'Product Feed:', 'quickshop-ai-for-chatgpt' ) . ' <code id="icgpt_feed">' . esc_html( $feed ) . '</code> ';
        echo '<button type="button" class="button icgpt-copy" data-copy="#icgpt_feed">' . esc_html__( 'Copy', 'quickshop-ai-for-chatgpt' ) . '</button></p>';
        echo '<p>' . esc_html__( 'Order Webhook:', 'quickshop-ai-for-chatgpt' ) . ' <code id="icgpt_wh">' . esc_html( $wh ) . '</code> ';
        echo '<button type="button" class="button icgpt-copy" data-copy="#icgpt_wh">' . esc_html__( 'Copy', 'quickshop-ai-for-chatgpt' ) . '</button></p>';
        echo '</div>';
		*/
        echo '<div class="icgpt-card hidelogs">';
        echo '<h2>' . esc_html__( 'Logs (latest 50)', 'quickshop-ai-for-chatgpt' ) . '</h2>';
        $logs = ICGPT_Logger::get_logs( 50 );
        if ( $logs ) {
            echo '<table class="widefat striped"><thead><tr><th>' . esc_html__( 'Date (UTC)', 'quickshop-ai-for-chatgpt' ) . '</th><th>' . esc_html__( 'Level', 'quickshop-ai-for-chatgpt' ) . '</th><th>' . esc_html__( 'Message', 'quickshop-ai-for-chatgpt' ) . '</th><th>' . esc_html__( 'Context', 'quickshop-ai-for-chatgpt' ) . '</th></tr></thead><tbody>';
            foreach ( $logs as $r ) {
                echo '<tr><td>' . esc_html( gmdate( 'Y-m-d H:i:s', strtotime( $r['created_at'] ) ) ) . '</td><td>' . esc_html( $r['level'] ) . '</td>';
                echo '<td>' . esc_html( mb_strimwidth( $r['message'], 0, 140, '…' ) ) . '</td>';
                echo '<td><code>' . esc_html( mb_strimwidth( (string) $r['context'], 0, 140, '…' ) ) . '</code></td></tr>';
            }
            echo '</tbody></table>';
        } else {
            echo '<p>' . esc_html__( 'No logs yet.', 'quickshop-ai-for-chatgpt' ) . '</p>';
        }
        echo '</div>';
        echo '</div>';

        echo '<hr><h2>' . esc_html__( '', 'quickshop-ai-for-chatgpt' ) . '</h2>';
        echo '<form class="formpost" method="post" action="options.php">';
        settings_fields( 'icgpt' );
        do_settings_sections( 'icgpt' );
        submit_button();
        echo '</form>';

        if ( get_option( 'icgpt_test_mode' ) ) {
            $url_test = wp_nonce_url( admin_url( 'admin-post.php?action=icgpt_send_test_order' ), 'icgpt_send_test' );
            echo '<h2 class="testorder">' . esc_html__( 'Send test order', 'quickshop-ai-for-chatgpt' ) . '</h2>';
            echo '<p class="testorder">' . esc_html__( 'Simulates a ChatGPT purchase which you should see in WooCommerce orders.', 'quickshop-ai-for-chatgpt' ) . '</p>';
            echo '<a class="testorder button button-primary" href="' . esc_url( $url_test ) . '">' . esc_html__( 'Send Test Order', 'quickshop-ai-for-chatgpt' ) . '</a>';
        }
	
		echo '<style>
		.icgpt-guide h1{text-align: center;color: #1d2327;font-size: 2em; margin-top:25px;}
		.icgpt-guide ol{margin-left:1.3em}
		.icgpt-guide pre{white-space:pre-wrap;word-break:break-word;padding:.6em .8em;background:#f6f7f7;border:1px solid #ccd0d4;border-radius:3px}
		.icgpt-guide code{background:#f6f7f7;padding:2px 4px;border-radius:3px}
		.icgpt-guide ul{list-style:disc;margin-left:1.3em}
		</style>';

		$guide = <<<HTML
		<div class="icgpt-guide">
		  <h1>How to Get Your Products Visible in ChatGPT Search</h1>
		  <p>If you want your products to appear in ChatGPT’s shopping results, here are the key steps and best practices gathered from current data:</p>
		  <ol>
			<li><strong>Let ChatGPT crawl your site</strong>. Be sure you allow <code>oai-searchbot</code> in <code>robots.txt</code>:
			  <pre><code>User-agent: oai-searchbot
		Allow: /</code></pre>
			</li>

			<li><strong>Use natural, search-friendly product titles;</strong> (how people actually search).
			  <br>Example: <em>“Stainless Steel Water Bottle”</em> instead of <em>“HydraCup 2.0”</em>.
			</li>

			<li><strong>Add Product structured data (JSON-LD)</strong> for every product. This helps ChatGPT and Bing understand and display your products accurately. Include:
			  <ul>
				<li>Product name</li>
				<li>Price &amp; availability</li>
				<li>Reviews/ratings</li>
				<li>Images</li>
				<li>Description</li>
			  </ul>
				<p>Example:</p>
			  <pre><code>&lt;script type="application/ld+json"&gt;
		{
		  "@context": "https://schema.org",
		  "@type": "Product",
		  "name": "Stainless Steel Water Bottle",
		  "description": "Durable stainless steel water bottle perfect for jogging.",
		  "image": ["https://example.com/images/bottle.jpg"],
		  "sku": "WAT-1",
		  "brand": { "@type": "Brand", "name": "YourBrandName" },
		  "offers": {
			"@type": "Offer",
			"price": "24.99",
			"priceCurrency": "USD",
			"availability": "https://schema.org/InStock",
			"url": "https://example.com/product/water-bottle"
		  },
		  "aggregateRating": {
			"@type": "AggregateRating",
			"ratingValue": "4.7",
			"reviewCount": "182"
		  }
		}
		&lt;/script&gt;</code></pre>
			</li>

			<li><strong>Submit your products to Google Merchant Center.</strong> ChatGPT also pulls product data from Google shopping feed, so connecting your store there increases visibility.</li>
			<li><strong>Fill the official ChatGPT product discovery form</strong> (on OpenAI’s site).</li>

			<li><strong>Optimize product descriptions</strong>:
			  <ul>
				<li>Highlight benefits, not just features.</li>
				<li>Mention price, quality, handmade, awards, eco-friendly, etc.</li>
				<li>Use multiple lifestyle images showing the product in real use.</li>
				<li>Keep content fresh and up to date (outdated listings get skipped).</li>
				<li>Encourage and display reviews, since ChatGPT favors trusted and well-reviewed products.</li>
			  </ul>
			</li>

			<li><strong>Focus on Bing SEO.</strong> ChatGPT currently uses Bing’s index as a major data source, so optimizing for Bing could be more effective than focusing only on Google.</li>
		  </ol>

		  <p><em>Note:</em> ChatGPT surfaces products using Bing, Google, and its own web index. Doing all of the above maximizes visibility across all three.</p>
		</div>
		HTML;

		$allowed = array_merge(
			wp_kses_allowed_html( 'post' ),
			[
			  'div'  => [ 'class' => [] ],
			  'h3'   => [],
			  'ol'   => [],
			  'ul'   => [],
			  'li'   => [],
			  'pre'  => [],
			  'code' => [],
			  'em'   => [],
			  'strong' => [],
			]
		);

		echo wp_kses( $guide, $allowed );
        echo '</div>';
    }
}