<?php
if ( ! defined('ABSPATH') ) exit;

class ICGPT_Product_Flags {
    const META_ENABLE_SEARCH   = '_icgpt_enable_search';
    const META_ENABLE_CHECKOUT = '_icgpt_enable_checkout';

    public function __construct() {
        add_action('add_meta_boxes', [$this, 'add_box']);
        add_action('save_post_product', [$this, 'save'], 10, 2);      
    }

		public function add_box() {
			add_meta_box(
				'icgpt_flags',
				esc_html__( 'ChatGPT Instant Checkout', 'quickshop-ai-for-chatgpt' ), 
				[ $this, 'render' ],
				'product',
				'side',
				'default'
			);
		}
				public function render( $post ) {					
					$on = (bool) get_post_meta( $post->ID, self::META_ENABLE_SEARCH,   true )
					   || (bool) get_post_meta( $post->ID, self::META_ENABLE_CHECKOUT, true );

					wp_nonce_field( 'icgpt_flags_nonce', 'icgpt_flags_nonce' );

					echo '<label>';
					echo '<input type="checkbox" name="icgpt_enable_ai" value="1" ' . checked( $on, true, false ) . '>';
					echo ' ' . esc_html__( 'Visible in ChatGPT', 'quickshop-ai-for-chatgpt' );
					echo '</label>';

					echo '<p class="description">' .
						 esc_html__( 'When checked, this product can be found in ChatGPT and purchased with Instant Checkout.', 'quickshop-ai-for-chatgpt' ) .
						 '</p>';
				}
						
				public function save( $post_id, $post ) {
					$nonce = isset( $_POST['icgpt_flags_nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['icgpt_flags_nonce'] ) ) : '';
					if ( ! $nonce || ! wp_verify_nonce( $nonce, 'icgpt_flags_nonce' ) ) return;
					if ( 'product' !== $post->post_type || ! current_user_can( 'edit_post', $post_id ) ) return;

					$enable = isset( $_POST['icgpt_enable_ai'] ) ? '1' : '';				
					update_post_meta( $post_id, self::META_ENABLE_SEARCH,   $enable );
					update_post_meta( $post_id, self::META_ENABLE_CHECKOUT, $enable );
				}    
}