<?php
if ( ! defined('ABSPATH') ) exit;

class ICGPT_Onboarding {	

public function render_section() {
    $feed   = rest_url( 'icgpt/v1/feed' );
    $wh     = rest_url( 'icgpt/v1/webhook/order' );
    $secret = get_option( 'icgpt_webhook_secret', '' );

    echo '<div class="icgpt-onboarding-inline">';
    echo '<p>' . esc_html__( 'Use this guide to connect your WooCommerce store to ChatGPT Instant Checkout.', 'quickshop-ai-for-chatgpt' ) . '</p>';

    echo '<ol class="icgpt-steps">';
    echo '<li>' . esc_html__( 'Go to OpenAI and apply for a merchant account. After approval, you will receive a Merchant ID.', 'quickshop-ai-for-chatgpt' ) . '</li>';

    echo '<li>'.esc_html__('Paste your Merchant ID below and click Save Changes.', 'quickshop-ai-for-chatgpt').'</li>';

    echo '<li>' . esc_html__( 'Copy the Product Feed URL, Webhook URL and Secret Key and paste them into your OpenAI account settings', 'quickshop-ai-for-chatgpt' ) . ': ' .
         '<p>Product Feed<code id="icgpt_feed3">' . esc_html( $feed ) . '</code> ' .
         '<button type="button" class="button icgpt-copy" data-copy="#icgpt_feed3">' . esc_html__( 'Copy', 'quickshop-ai-for-chatgpt' ) . '</button> </p>
		 </li>';
    echo 
         '<div>' . esc_html__( 'Webhook URL:', 'quickshop-ai-for-chatgpt' ) . ' <code id="icgpt_wh3">' . esc_html( $wh ) . '</code> ' .
         '<button type="button" class="button icgpt-copy" data-copy="#icgpt_wh3">' . esc_html__( 'Copy', 'quickshop-ai-for-chatgpt' ) . '</button></div>';

    echo '<li>' .
         esc_html__( 'Edit any product and check "Visible in ChatGPT".', 'quickshop-ai-for-chatgpt' ) . '</li>';

    echo '<li>' .
         esc_html__( 'Click “Send Test Order”. You should see a new order in WooCommerce.', 'quickshop-ai-for-chatgpt' ) . '</li>';

    echo '<li>'  . esc_html__( 'Uncheck "Test mode" and check "Go Live" for the selected products to be reachable in ChatGPT.', 'quickshop-ai-for-chatgpt' ) . '</li>';
    echo '</ol>';

    echo '</div>';
}	
}