<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class ICGPT_Logger {  
    protected static function insert( $level, $message, $context = [] ) {
        global $wpdb;

        $level = sanitize_key( (string) $level );
        $msg   = is_string( $message ) ? $message : wp_json_encode( $message );
        $ctx   = empty( $context ) ? null : wp_json_encode( $context );
        $table = $wpdb->prefix . ICGPT_LOG_TABLE;  
        $wpdb->insert(
            $table,
            [
                'created_at' => current_time( 'mysql', 1 ),
                'level'      => $level,
                'message'    => $msg,
                'context'    => $ctx,
            ],
            [ '%s', '%s', '%s', '%s' ]
        );  
        wp_cache_delete( 'icgpt_logs_50', 'icgpt' );
        wp_cache_delete( 'icgpt_logs_100', 'icgpt' );
    }

    public static function info( $msg, $ctx = [] )    { self::insert( 'info', $msg, $ctx ); }
    public static function warning( $msg, $ctx = [] ) { self::insert( 'warning', $msg, $ctx ); }
    public static function error( $msg, $ctx = [] )   { self::insert( 'error', $msg, $ctx ); }
    public static function get_logs( $limit = 100 ) {
        global $wpdb;

        $limit = absint( $limit );
        if ( $limit <= 0 ) {
            $limit = 100;
        }

        $cache_key = 'icgpt_logs_' . $limit;
        $cached    = wp_cache_get( $cache_key, 'icgpt' );
        if ( false !== $cached ) {
            return $cached;
        }

        $table = $wpdb->prefix . ICGPT_LOG_TABLE;     
        $rows = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT id, created_at, level, message, context
                 FROM `{$table}`
                 ORDER BY id DESC
                 LIMIT %d",
                $limit
            ),
            ARRAY_A
        );    
        wp_cache_set( $cache_key, (array) $rows, 'icgpt', 30 );
        return (array) $rows;
    }
}