<?php
if ( ! defined('ABSPATH') ) exit;

class ICGPT_Admin_Assets {
    public function __construct() {
        add_action('admin_enqueue_scripts', [$this, 'enqueue']);
    }
    public function enqueue($hook) {
        if ( strpos($hook, 'icgpt') === false && strpos($hook, 'woocommerce_page_icgpt') === false ) return;
        wp_enqueue_style('icgpt-admin', ICGPT_URL.'assets/admin.css', [], ICGPT_VERSION);
        wp_enqueue_script('icgpt-admin', ICGPT_URL.'assets/admin.js', ['jquery'], ICGPT_VERSION, true);
        wp_localize_script('icgpt-admin', 'ICGPT', [
            'copied' => __('Copied!', 'quickshop-ai-for-chatgpt')
        ]);
    }
}
