<?php
$icons = Quick_Chat_Buttons::get_svg_icon();
$buttons = Quick_Chat_Buttons::get_buttons();
?>

<?php if(!empty($posts)) { ?>
<div class="kl-container">
    <div class="kl-content">
        <div class="container p-container">
            <div class="filter-card">
                <div class="card-left">
                    <h1><?php esc_html_e("Widgets", "quick-chat-buttons") ?></h1>
                </div>
                <div class="card-right">
                    <a href="javascript:;" class="button button-primary upgrade-widget" data-title="<?php esc_html_e("Creating multiple widgets is a Pro feature", "quick-chat-buttons") ?>"><?php esc_html_e("Create Widget", "quick-chat-buttons") ?></a>
                </div>
            </div>
            <div class="content-card card-margin no-padding">
                <div class="record-table">
                    <div id="ajax-table">
                        <div id="ajax-table-data">
                            <div class="responsive-table">
                                <table class="" cellpadding="0" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th class="status"><?php esc_html_e("Status", "quick-chat-buttons") ?></th>
                                            <th class="list-widget-title"><?php esc_html_e("Name", "quick-chat-buttons") ?></th>
                                            <th class="social-channels"><?php esc_html_e("Channels", "quick-chat-buttons") ?></th>
                                            <th class="edit-item"><?php esc_html_e("Edit", "quick-chat-buttons") ?></th>
                                            <th class="action-col"><?php esc_html_e("Actions", "quick-chat-buttons") ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach($posts as $post) {
                                        $triggerSetting = get_post_meta($post->ID, "trigger_setting", true);
                                        $widgetStatus = isset($triggerSetting['widget_status']) ? $triggerSetting['widget_status'] : 0;
                                        $channelSettings = get_post_meta($post->ID, "channel_setting", true);
                                    ?>
                                        <tr data-id="<?php echo esc_attr($post->ID) ?>"
                                            class="widget-col-<?php echo esc_attr($post->ID) ?>" data-nonce="<?php echo wp_create_nonce("qcb_widget_col_".$post->ID) ?>">
                                            <td class="status">
                                                <div class="switch-box">
                                                    <input type="checkbox" class="sr-only widget-status" id="widget_status_<?php echo esc_attr($post->ID) ?>" value="1" <?php echo checked($widgetStatus, 1) ?>>
                                                    <label for="widget_status_<?php echo esc_attr($post->ID) ?>"></label>
                                                </div>
                                            </td>
                                            <td class="list-widget-title"><?php echo esc_attr($post->post_title) ?></td>
                                            <td class="social-channels">
                                                <?php if(isset($channelSettings) && !empty($channelSettings)) { ?>
                                                    <div class="display-icon">
                                                        <?php
                                                        $icon = "";
                                                        $count = 0;
                                                        $channelTitles = [];
                                                        foreach($channelSettings as $channelKey => $channel ) {
                                                            $setting = $buttons[$channelKey];
                                                            $defaultChannelSetting = Quick_Chat_Buttons::get_channel_setting($setting);
                                                            $channels_setting = shortcode_atts($defaultChannelSetting, $channel);
                                                            $icon = $buttons[$channelKey]['icon'];
                                                            $count++;
                                                            if(count($channelSettings) > 5) {
                                                                if($count <= 4){
                                                                    ?>
                                                                    <span class="channel-icons <?php echo esc_attr($channelKey) ?>-channel-<?php echo esc_attr($post->ID) ?> <?php echo ($channelKey == "instagram" && $channel['bg_color'] != "#df0079" && $channel['bg_color'] != "rgba(223, 0, 121, 1)") ? "" : "channel-slug-". $channelKey ?>"
                                                                          data-kla-tooltip="<?php echo esc_attr($buttons[$channelKey]['title']) ?>"
                                                                          style="background-color:<?php echo esc_attr($channels_setting['bg_color']) ?>">
                                                                        <?php echo $icon; ?>
                                                                    </span>
                                                                <?php }
                                                            } elseif(count($channelSettings) == 5 || count($channelSettings) < 5) { ?>
                                                                <span class="channel-icons <?php echo esc_attr($channelKey) ?>-channel-<?php echo esc_attr($post->ID) ?> <?php echo ($channelKey == "instagram" && $channel['bg_color'] != "#df0079" && $channel['bg_color'] != "rgba(223, 0, 121, 1)") ? "" : "channel-slug-". $channelKey ?>"
                                                                      data-kla-tooltip="<?php echo esc_attr($buttons[$channelKey]['title']) ?>"
                                                                      style="background-color:<?php echo esc_attr($channels_setting['bg_color']) ?>">
                                                                    <?php echo $icon; ?>
                                                                </span>
                                                            <?php }?>
                                                            <?php $channelTitles[] = $buttons[$channelKey]['title'];
                                                        }
                                                        $sliceArray = array_slice($channelTitles, 4);
                                                        $channelst = implode(", ", $sliceArray);
                                                        if (count($channelSettings) > 4 && count($channelSettings) != 5) {
                                                            echo '<span class="channel-icons channel-count" data-kla-tooltip="' . $channelst . '">+' . (count($channelSettings) - 4) . '</span>';
                                                        }
                                                        ?>
                                                    </div>
                                                <?php } ?>
                                            </td>
                                            <td class="edit-item">
                                                <a class="edit-record" data-kla-tooltip="<?php esc_html_e("Edit Widget", "quick-chat-buttons") ?>"
                                                     href="<?php echo esc_url(admin_url('admin.php?page=quick-chat-buttons&task=edit-widget&edit=' . esc_attr($post->ID) . '&nonce=' . wp_create_nonce('edit_widget_' . $post->ID))) ?>">
                                                    <span class="svg-icon"><?php echo $icons['actions']['edit'] ?></span></a>
                                            </td>
                                            <td class="action-col clone-trash-item">
                                                <a class="clone-record upgrade-plan" href="javascript:;" data-kla-tooltip="<?php esc_html_e("Clone Widget", "quick-chat-buttons") ?>" data-title="<?php esc_html_e("Cloning widget is a Pro feature", "quick-chat-buttons") ?>"
                                                   id="upgrade_widget"><span class="svg-icon"><?php echo $icons['actions']['clone'] ?></span></a>

                                                <a class="trash-record" data-kla-tooltip="<?php esc_html_e("Remove", "quick-chat-buttons") ?>"
                                                   id="delete-widget" href="#"><span class="svg-icon"><?php echo $icons['actions']['trash'] ?></span></a>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="klaxon-modal delete-widget">
    <div class="klaxon-modal-bg"></div>
    <div class="klaxon-modal-container small">
        <div class="klaxon-modal-content">
            <button type="button" class="remove-klaxon-modal">
                    <span class="svg-icon">
                        <?php echo $icons['close'] ?>
                    </span>
            </button>
            <div class="modal-title"><?php esc_html_e("Remove Widget", "quick-chat-buttons") ?></div>
            <div class="modal-content">
                <span><?php esc_html_e("Are you sure you want to remove this widget?", "quick-chat-buttons") ?></span>
            </div>
            <div class="modal-footer">
                <button type="button"
                        class="secondary cancel-button"><?php esc_html_e("Cancel", "quick-chat-buttons") ?></button>
                <button type="button" class="primary delete-button save-changes" id="delete_widget"><span
                        class="kl-loader"><?php echo $icons['loader'] ?>
                                </span><?php esc_html_e(" Remove", "quick-chat-buttons") ?>
                </button>
            </div>
        </div>
    </div>
</div>

<div class="klaxon-modal upgrade-plan-modal">
    <div class="klaxon-modal-bg"></div>
    <div class="klaxon-modal-container small">
        <div class="klaxon-modal-content">
            <button type="button" class="remove-klaxon-modal">
            <span class="svg-icon">
                <?php echo $icons['close'] ?>
            </span>
            </button>
            <div class="modal-content text-center">
                <div class="upgrade-modal-title">
                    <?php esc_html_e("Upgrade to Pro 🎉", "quick-chat-buttons") ?>
                </div>
                <div class="upgrade-sub-modal-title upgrade-plan-modal-title">
                    <?php esc_html_e("Creating multiple widgets is a Pro feature", "quick-chat-buttons") ?>
                </div>
                <div class="pro-feature-list">
                    <span class=""><?php esc_html_e("What you will get in Pro Plan?", "quick-chat-buttons") ?></span>
                    <ul>
                        <li>&#9854;&#65039; <?php esc_html_e("Create Unlimited Widgets", "quick-chat-buttons") ?></li>
                        <li>&#128306; <?php esc_html_e("Clone Widget", "quick-chat-buttons") ?></li>
                        <li>&#127919; <?php esc_html_e("Page Targeting", "quick-chat-buttons") ?></li>
                        <li>&#128197; <?php esc_html_e("Date and Time Schedule", "quick-chat-buttons") ?></li>
                        <li>&#9201;&#65039; <?php esc_html_e("Day and Time Schedule", "quick-chat-buttons") ?></li>
                    </ul>
                </div>
                <div class="upgrade-modal-button">
                    <a href="<?php echo esc_url(admin_url("admin.php?page=quick-chat-buttons-go-pro")) ?>" target="_blank"><?php esc_html_e("Upgrade to Pro", "quick-chat-buttons") ?></a>
                </div>
                <div class="upgrade-modal-footer">
                    <span>&#10148; <?php esc_html_e("Starts from less than $1.6/mo", "quick-chat-buttons") ?></span>
                    <span>&#10148; <?php esc_html_e("14 days refund, no questions will be asked", "quick-chat-buttons") ?></span>
                </div>
            </div>
        </div>
    </div>
</div>

<style id="channel_icon_color">
    <?php
    foreach($posts as $post) {
    $channelSettings = get_post_meta($post->ID, "channel_setting", true);
    if(isset($channelSettings) && !empty($channelSettings)) {
    foreach($channelSettings as $channelKey => $channel ) {
        if($channelKey != "slack" || ($channelKey == "slack" && $channel['icon_color'] != "#ffffff" && $channel['icon_color'] != "rgba(255, 255, 255, 1)")) {
    ?>
    .display-icon .<?php echo esc_attr($channelKey) ?>-channel-<?php echo esc_attr($post->ID) ?> svg, .display-icon .<?php echo esc_attr($channelKey) ?>-channel-<?php echo esc_attr($post->ID) ?> svg path {fill: <?php echo esc_attr($channel['icon_color']) ?>}
    <?php } } } } ?>
</style>

<?php } else { ?>
    <style>
        #wpcontent, #wpfooter {
            background-color: #ffffff;
        }
        #wpfooter {
            display: none;
        }
        #wpcontent, #wpbody-content {
            padding: 0;
        }
        .qcb-no-records {
            width: 100%;
            position: relative;
            min-height: 640px;
            background-color: #ffffff;
            height: calc(100vh - 32px);
        }
        .qcb-no-records-box {
            width: 100%;
            margin: 0 auto;
            position: absolute;
            left: 0;
            right: 0;
            height: auto;
            transform: translate(0, -50%);
            top: 50%;
        }
        .qcb-no-records-top {
            width: 240px;
            margin: 0 auto 50px;
        }
        .qcb-no-records-top svg {
            width: 100%;
        }
        .no-records-features {
            max-width: 900px;
            margin: 0 auto;
        }
        .no-records-features ul {
            margin: 0;
            padding: 0;
        }
        .no-records-features ul li {
            display: block;
            padding: 0 0 4px 0;
            font-size: 18px;
            line-height: 28px;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
            font-style: normal;
            font-weight: 500;
        }
        .no-records-features ul li svg {
            stroke: #512DA8;
            display: inline-block;
            vertical-align: bottom;
        }
        .qcb-no-records-bottom {
            text-align: center;
            margin: 40px 0 30px;
            font-size: 16px;
        }
        .qcb-no-records-bottom a {
            font-size: 16px !important;
        }
        .qcb-no-records-title {
            text-align: center;
            padding: 0 0 20px;
            font-size: 28px;
            color: #512DA8;
        }
        .text-color {
            font-weight: bold;
        }
    </style>
    <div class="qcb-no-records">
        <div class="qcb-no-records-box">
            <div class="qcb-no-records-top">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 500 500" style="enable-background:new 0 0 500 500;" xml:space="preserve"> <g id="Background_Complete"> <g> <g> <g> <g> <g> <path style="fill:#EBEBEB;" d="M449.181,315.785c5.579-2.879,12.149-3.253,18.343-2.229c3.328,0.55,6.797,1.546,9.061,4.045        c2.264,2.5,2.693,6.898,0.094,9.046c-1.548,1.279-3.706,1.473-5.713,1.45c-4.849-0.057-10.229-0.91-14.103,2.007        c-2.21,1.664-3.681,4.432-6.324,5.25c-2.585,0.801-5.503-0.725-6.873-3.058c-1.371-2.333-1.417-5.25-0.777-7.879        C442.888,324.417,443.561,318.685,449.181,315.785z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#EBEBEB;" d="M436.399,291.11c3.412,4.872,10.042,3.259,13.117,0.285c3.074-2.974,4.374-7.285,5.556-11.395        c2.703-9.392,5.427-19.245,3.418-28.809c-0.601-2.859-1.67-5.711-3.679-7.832c-2.009-2.121-5.099-3.383-7.924-2.637        c-3.343,0.883-5.421,4.158-6.923,7.273c-4.414,9.156-6.752,19.306-6.786,29.471        C433.161,282.213,433.721,287.191,436.399,291.11"/> </g> </g> </g> <g> <g> <g> <path style="fill:#EBEBEB;" d="M427.03,298.102c3.704-4.396,4.407-10.808,2.759-16.315        c-1.648-5.508-5.372-10.193-9.664-14.018c-5.032-4.485-10.946-7.974-17.304-10.21c-2.502-0.88-5.142-1.574-7.782-1.322        c-2.641,0.252-5.299,1.602-6.531,3.951c-1.821,3.473-0.075,7.686,1.813,11.123c3.327,6.055,7.131,11.848,11.366,17.307        c3.406,4.392,7.309,8.724,12.501,10.709c5.192,1.985,10.585,1.751,13.337-1.849"/> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M436.168,364.612c0.064,0.004,0.168-0.786,0.309-2.214c0.157-1.612,0.354-3.635,0.588-6.042         c0.282-2.542,0.653-5.568,1.359-8.863c0.704-3.287,1.806-6.848,3.221-10.46c1.466-3.591,3.253-6.855,5.342-9.465         c2.074-2.622,4.486-4.52,6.753-5.614c2.26-1.116,4.286-1.57,5.687-1.771c1.413-0.145,2.204-0.256,2.204-0.319         c0.001-0.063-0.792-0.073-2.243-0.035c-1.438,0.096-3.548,0.46-5.93,1.543c-2.389,1.06-4.948,2.987-7.124,5.663         c-2.193,2.665-4.046,6.001-5.537,9.655c-1.44,3.676-2.525,7.274-3.198,10.632c-0.671,3.352-0.978,6.411-1.178,8.975         c-0.192,2.566-0.264,4.644-0.299,6.08C436.089,363.813,436.106,364.608,436.168,364.612z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M436.584,359.963c0.031-0.002,0.051-0.355,0.06-1.028c-0.002-0.772-0.005-1.744-0.008-2.938         c-0.007-2.549-0.006-6.239,0.131-10.795c0.225-9.112,1.01-18.919,2.525-32.745c1.435-13.001,3.361-28.131,5.394-37.968         c0.436-2.237,0.875-4.251,1.288-6.013c0.394-1.767,0.73-3.29,1.055-4.523c0.279-1.16,0.506-2.105,0.687-2.856         c0.147-0.656,0.21-1.005,0.18-1.014c-0.03-0.009-0.152,0.323-0.357,0.963c-0.224,0.74-0.506,1.671-0.853,2.815         c-0.379,1.221-0.766,2.735-1.209,4.494c-0.461,1.756-0.945,3.764-1.423,5.998c-2.011,8.913-4.141,21.371-5.67,35.23         c-1.519,13.855-2.202,26.47-2.263,35.605c-0.054,4.567,0.043,8.265,0.159,10.816c0.073,1.193,0.132,2.165,0.179,2.936         C436.511,359.613,436.553,359.964,436.584,359.963z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M436.645,335.632c0.063-0.002,0.052-1.093-0.022-3.069c-0.113-1.972-0.384-4.823-0.94-8.314         c-0.589-3.483-1.412-7.62-2.704-12.114c-0.56-2.055-1.877-6.978-5.066-14.334c-4.202-9.968-9.91-18.117-14.877-23.165         c-1.165-1.34-2.462-2.306-3.5-3.253c-0.537-0.454-1.012-0.907-1.495-1.265c-0.486-0.335-0.938-0.647-1.358-0.936         c-1.635-1.118-2.55-1.707-2.584-1.654c-0.147,0.199,3.661,2.44,8.469,7.555c4.788,5.104,10.338,13.197,14.505,23.081         c2.324,5.361,3.945,10.143,5.095,14.203c1.328,4.451,2.211,8.545,2.877,11.994c0.634,3.456,1.001,6.278,1.222,8.233         C436.451,334.549,436.583,335.634,436.645,335.632z"/> </g> </g> </g> </g> </g> <g> <g> <g> <polygon style="fill:#E0E0E0;" points="413.128,378.552 415.566,411.953 458.476,411.953 460.914,378.552      "/> </g> </g> </g> <g> <g> <g> <rect x="408.983" y="365.386" style="fill:#E0E0E0;" width="57.051" height="13.165"/> </g> </g> </g> <g> <g> <g> <polygon style="fill:#EBEBEB;" points="408.983,410.675 408.983,414.324 411.664,414.324 465.091,414.324 465.091,410.675             "/> </g> </g> </g> <g> <g> <g> <polygon style="fill:#E0E0E0;" points="414.291,420.747 411.664,414.324 463.047,414.324 459.982,420.747      "/> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#F5F5F5;" d="M460.117,389.468c0.01,0.008-0.058,0.112-0.2,0.307c-0.17,0.226-0.381,0.506-0.641,0.85        c-0.609,0.78-1.447,1.851-2.5,3.199l-0.111,0.142l-0.108-0.149c-1.571-2.173-3.67-5.076-6.141-8.494h0.353        c-1.827,2.587-3.861,5.468-6.046,8.561l-0.19,0.268l-0.212-0.252c-2.231-2.655-4.655-5.538-7.171-8.532l0.413-0.005        c-0.124,0.157-0.259,0.326-0.394,0.496c-2.224,2.788-4.376,5.486-6.412,8.038l-0.214,0.268l-0.197-0.279        c-2.177-3.08-4.211-5.958-6.049-8.559l0.352,0.017c-2.981,3.397-5.509,6.277-7.45,8.488l-0.132,0.151l-0.101-0.17        c-0.982-1.65-1.765-2.966-2.333-3.919c-0.244-0.425-0.441-0.769-0.598-1.044c-0.132-0.239-0.194-0.365-0.183-0.372        c0.011-0.007,0.096,0.106,0.25,0.331c0.174,0.264,0.393,0.595,0.662,1.004c0.596,0.936,1.418,2.228,2.449,3.848l-0.233-0.019        c1.91-2.238,4.397-5.154,7.331-8.591l0.185-0.217l0.167,0.234c1.855,2.59,3.907,5.455,6.103,8.52l-0.411-0.011        c2.031-2.556,4.178-5.258,6.397-8.05c0.135-0.17,0.27-0.339,0.395-0.496l0.204-0.256l0.21,0.251        c2.509,2.999,4.925,5.888,7.151,8.548l-0.401,0.016c2.206-3.078,4.261-5.944,6.106-8.518l0.179-0.25l0.175,0.25        c2.419,3.455,4.473,6.389,6.011,8.586l-0.218-0.007c1.096-1.314,1.966-2.357,2.6-3.118c0.282-0.327,0.511-0.592,0.696-0.806        C460.02,389.549,460.108,389.46,460.117,389.468z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#F5F5F5;" d="M461.511,378.331c0,0.147-10.752,0.267-24.012,0.267c-13.265,0-24.014-0.12-24.014-0.267        c0-0.148,10.749-0.267,24.014-0.267C450.759,378.064,461.511,378.184,461.511,378.331z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#F5F5F5;" d="M463.679,414.684c0,0.147-11.685,0.267-26.096,0.267c-14.416,0-26.099-0.12-26.099-0.267        c0-0.147,11.682-0.267,26.099-0.267C451.994,414.417,463.679,414.537,463.679,414.684z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <rect x="393.836" y="62.558" style="fill:#E0E0E0;" width="61.379" height="63.983"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <rect x="389.679" y="62.558" style="fill:#FAFAFA;" width="61.379" height="63.983"/> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M451.078,126.56H389.66V62.54h61.417V126.56z M389.698,126.522h61.341V62.577h-61.341             V126.522z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <rect x="397.93" y="71.16" style="fill:#FAFAFA;" width="44.877" height="46.78"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M397.93,118.251c0.035,0.042-0.391,0.531-1.107,1.288              c-0.717,0.756-1.724,1.78-2.853,2.892c-1.129,1.112-2.167,2.103-2.932,2.806c-0.765,0.703-1.258,1.119-1.297,1.08              c-0.039-0.039,0.385-0.526,1.102-1.282c0.717-0.756,1.726-1.782,2.859-2.897c1.132-1.115,2.172-2.108,2.937-2.811              C397.404,118.623,397.895,118.209,397.93,118.251z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M442.807,118.136c0.042-0.035,0.531,0.391,1.288,1.107              c0.756,0.717,1.78,1.724,2.892,2.853c1.112,1.129,2.103,2.167,2.806,2.932c0.703,0.765,1.119,1.258,1.08,1.297              c-0.039,0.039-0.526-0.385-1.282-1.101c-0.756-0.717-1.782-1.727-2.898-2.859c-1.115-1.132-2.108-2.172-2.811-2.937              C443.179,118.662,442.766,118.172,442.807,118.136z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M442.685,71.285c-0.035-0.042,0.391-0.531,1.107-1.288              c0.717-0.756,1.724-1.78,2.853-2.892c1.129-1.113,2.167-2.103,2.932-2.807c0.765-0.703,1.258-1.119,1.297-1.08              c0.038,0.039-0.385,0.526-1.102,1.282c-0.717,0.756-1.727,1.782-2.859,2.898c-1.132,1.115-2.172,2.108-2.937,2.812              C443.211,70.913,442.72,71.326,442.685,71.285z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M397.807,71.399c-0.042,0.035-0.531-0.391-1.288-1.107              c-0.756-0.717-1.78-1.724-2.892-2.853c-1.112-1.129-2.103-2.167-2.806-2.932c-0.703-0.765-1.119-1.258-1.08-1.297              c0.039-0.039,0.526,0.384,1.282,1.101c0.756,0.717,1.782,1.727,2.898,2.859c1.115,1.132,2.108,2.172,2.811,2.937              C397.436,70.873,397.849,71.364,397.807,71.399z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M442.685,117.94c-0.003-0.003-0.006-0.08-0.01-0.227c-0.003-0.16-0.006-0.374-0.01-0.653              c-0.005-0.586-0.011-1.43-0.02-2.525c-0.01-2.216-0.026-5.44-0.045-9.534c-0.021-8.193-0.051-19.865-0.088-33.841              l0.173,0.173c-13.064,0.007-28.407,0.016-44.75,0.026h-0.004l0.199-0.199c-0.01,17.17-0.02,33.233-0.028,46.78              l-0.171-0.17c13.411,0.036,24.577,0.066,32.405,0.087c3.911,0.019,6.988,0.034,9.102,0.045              c1.044,0.009,1.848,0.015,2.408,0.02c0.265,0.004,0.47,0.007,0.622,0.01              C442.609,117.934,442.682,117.937,442.685,117.94c0.003,0.003-0.063,0.007-0.198,0.01              c-0.148,0.002-0.347,0.005-0.604,0.01c-0.552,0.004-1.345,0.011-2.376,0.02c-2.105,0.01-5.169,0.025-9.063,0.044              c-7.855,0.021-19.058,0.051-32.514,0.087l-0.171,0l0-0.171c-0.008-13.547-0.018-29.61-0.028-46.78v-0.199h0.199h0.004              c16.343,0.009,31.686,0.018,44.75,0.026h0.174l0,0.173c-0.037,14.021-0.067,25.732-0.088,33.951              c-0.02,4.077-0.035,7.288-0.046,9.495c-0.009,1.081-0.015,1.913-0.02,2.492c-0.004,0.27-0.007,0.479-0.01,0.634              C442.691,117.874,442.688,117.943,442.685,117.94z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <rect x="412.881" y="87.063" style="fill:#EBEBEB;" width="14.975" height="14.975"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <polygon style="fill:#E0E0E0;" points="371.44,95.285 371.44,175.685 255.964,175.685 251.804,95.848       "/> </g> </g> </g> </g> <g> <g> <g> <g> <rect x="269.707" y="77.944" transform="matrix(6.123234e-17 -1 1 6.123234e-17 173.8597 445.2234)" style="fill:#FFFFFF;" width="79.668" height="115.475"/> </g> </g> </g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M367.827,176.064H251.256V95.3h116.571V176.064z M252.352,174.968h114.38V96.396h-114.38        V174.968z"/> </g> </g> </g> </g> <g> <g> <g> <g> <g> <rect x="264.311" y="105.746" style="fill:#FFFFFF;" width="90.462" height="59.872"/> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M354.773,105.746c0,0-0.156,0.01-0.446,0.016c-0.307,0.004-0.732,0.009-1.286,0.015          c-1.146,0.007-2.81,0.018-4.968,0.032c-4.345,0.016-10.663,0.04-18.642,0.07c-15.953,0.032-38.533,0.076-65.12,0.129          l0.262-0.261c0.007,18.293,0.015,38.561,0.024,59.864v0.007l-0.285-0.285c34.125,0.022,65.587,0.042,90.462,0.058          l-0.227,0.227c0.05-18.22,0.091-33.159,0.12-43.562c0.025-5.199,0.044-9.262,0.058-12.046          c0.011-1.376,0.02-2.432,0.025-3.165C354.756,106.127,354.773,105.746,354.773,105.746s0.016,0.349,0.025,1.051          c0.006,0.724,0.014,1.765,0.026,3.123c0.013,2.773,0.033,6.818,0.058,11.995c0.029,10.437,0.069,25.424,0.119,43.703          l0.001,0.227l-0.228,0c-24.875,0.016-56.337,0.036-90.462,0.058l-0.285,0v-0.285v-0.007          c0.008-21.303,0.016-41.572,0.023-59.864l0-0.262l0.262,0.001c26.656,0.052,49.296,0.097,65.291,0.129          c7.954,0.03,14.251,0.054,18.582,0.07c2.136,0.014,3.782,0.025,4.916,0.032c0.542,0.007,0.957,0.012,1.257,0.015          C354.638,105.736,354.773,105.746,354.773,105.746z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M251.804,95.624c0.048-0.062,0.804,0.433,1.985,1.286c1.181,0.853,2.79,2.063,4.527,3.453         c1.737,1.391,3.265,2.706,4.341,3.691c1.076,0.985,1.705,1.634,1.654,1.692c-0.107,0.121-2.884-2.169-6.351-4.938         C254.489,98.042,251.702,95.754,251.804,95.624z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M367.279,95.848c0.098,0.124-2.623,2.44-6.076,5.173c-3.454,2.734-6.333,4.849-6.431,4.725         c-0.098-0.123,2.622-2.439,6.077-5.173C364.302,97.84,367.182,95.724,367.279,95.848z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#FFFFFF;" d="M367.188,175.527c-4.292-3.478-8.583-6.957-12.875-10.435"/> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M354.313,165.092c0.099-0.122,3.062,2.115,6.617,4.996c3.556,2.882,6.357,5.317,6.258,5.439          c-0.099,0.122-3.061-2.114-6.617-4.996C357.016,167.65,354.214,165.214,354.313,165.092z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M251.804,175.516c-0.098-0.124,2.594-2.416,6.012-5.119c3.419-2.704,6.269-4.795,6.367-4.672         c0.098,0.124-2.594,2.415-6.013,5.119C254.752,173.548,251.902,175.639,251.804,175.516z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <rect x="301.114" y="105.963" transform="matrix(6.123234e-17 -1 1 6.123234e-17 176.7149 445.5613)" style="fill:#E0E0E0;" width="20.047" height="56.92"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <rect x="149.994" y="52.836" transform="matrix(1 -0.0054 0.0054 1 -0.3906 0.8274)" style="fill:#E0E0E0;" width="8.205" height="40.829"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <rect x="78.86" y="52.977" transform="matrix(1 -0.0053 0.0053 1 -0.3422 0.4793)" style="fill:#EBEBEB;" width="21.249" height="22.541"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <rect x="100.008" y="52.864" transform="matrix(1 -0.0054 0.0054 1 -0.3419 0.5934)" style="fill:#F5F5F5;" width="21.249" height="22.541"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M78.833,59.259c14.121,0.117,28.277,0.034,42.397-0.195c0.29-0.004,0.289-0.45-0.003-0.451            c-14.121-0.078-28.277-0.009-42.396,0.259C78.582,58.877,78.584,59.257,78.833,59.259L78.833,59.259z"/> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <rect x="65.601" y="75.188" transform="matrix(1 -0.0054 0.0054 1 -0.4507 0.456)" style="fill:#EBEBEB;" width="38.606" height="18.369"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <rect x="104.023" y="74.983" transform="matrix(1 -0.0054 0.0054 1 -0.4491 0.6618)" style="fill:#F5F5F5;" width="38.606" height="18.369"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M65.579,80.401c25.646,0.29,51.383,0.03,77.028-0.38c0.291-0.005,0.289-0.45-0.002-0.452            c-25.648-0.136-51.386-0.12-77.027,0.445C65.328,80.019,65.33,80.398,65.579,80.401L65.579,80.401z"/> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <rect x="51.142" y="93.66" style="fill:#E0E0E0;" width="149.569" height="6.581"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <rect x="75.63" y="96.825" style="fill:#E0E0E0;" width="6.072" height="22.455"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <rect x="166.268" y="96.825" style="fill:#E0E0E0;" width="6.072" height="22.455"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <rect x="158.042" y="37.611" transform="matrix(1 -0.0054 0.0054 1 -0.3491 0.8684)" style="fill:#EBEBEB;" width="8.205" height="56.155"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <rect x="166.29" y="48.076" transform="matrix(1 -0.0054 0.0054 1 -0.378 0.9287)" style="fill:#F5F5F5;" width="12.75" height="45.507"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M178.832,56.809c0,0.122-2.854,0.221-6.375,0.221c-3.521,0-6.375-0.099-6.375-0.221           c0-0.122,2.854-0.221,6.375-0.221C175.978,56.588,178.832,56.687,178.832,56.809z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M178.832,54.898c0,0.122-2.854,0.221-6.375,0.221c-3.521,0-6.375-0.099-6.375-0.221           c0-0.122,2.854-0.221,6.375-0.221C175.978,54.677,178.832,54.776,178.832,54.898z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M178.832,86.702c0,0.122-2.854,0.221-6.375,0.221c-3.521,0-6.375-0.099-6.375-0.221           c0-0.122,2.854-0.221,6.375-0.221C175.978,86.481,178.832,86.58,178.832,86.702z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M178.832,84.79c0,0.122-2.854,0.221-6.375,0.221c-3.521,0-6.375-0.099-6.375-0.221           c0-0.122,2.854-0.221,6.375-0.221C175.978,84.569,178.832,84.668,178.832,84.79z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M172.663,80.619c-0.122,0-0.221-4.591-0.221-10.254c0-5.664,0.099-10.254,0.221-10.254           c0.122,0,0.221,4.59,0.221,10.254C172.884,76.028,172.785,80.619,172.663,80.619z"/> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <rect x="178.97" y="59.217" style="fill:#EBEBEB;" width="13.878" height="34.348"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M164.232,47.176c0,1.303-1.056,2.358-2.358,2.358c-1.303,0-2.358-1.056-2.358-2.358         c0-1.303,1.056-2.358,2.358-2.358C163.176,44.818,164.232,45.874,164.232,47.176z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <rect x="161.145" y="53.663" style="fill:#E0E0E0;" width="1.458" height="33.405"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <polygon style="fill:#EBEBEB;" points="59.964,388.294 48.324,421.672 54.144,421.672 74.514,388.294     "/> </g> <g> <polygon style="fill:#EBEBEB;" points="126.732,388.294 138.372,421.672 132.552,421.672 112.182,388.294     "/> </g> <g> <rect x="61.419" y="296.142" style="fill:#EBEBEB;" width="92.994" height="92.993"/> </g> <g> <rect x="32.283" y="296.142" style="fill:#F5F5F5;" width="92.994" height="92.993"/> </g> <g> <path style="fill:#E0E0E0;" d="M119.034,383.301H38.527v-80.507h80.507V383.301z M39.527,382.301h78.507v-78.507H39.527V382.301      z"/> </g> <g> <g> <path style="fill:#E0E0E0;" d="M39.49,328.267c26.244,0.792,52.791,0.526,79.044,0.028c0.338-0.007,0.338-0.519,0-0.525       c-26.252-0.498-52.8-0.763-79.044,0.028C39.188,327.807,39.188,328.258,39.49,328.267L39.49,328.267z"/> </g> </g> <g> <path style="fill:#EBEBEB;" d="M81.043,316.333c0,1.25-1.013,2.263-2.263,2.263s-2.263-1.013-2.263-2.263      s1.013-2.263,2.263-2.263S81.043,315.083,81.043,316.333z"/> </g> <g> <path style="fill:#EBEBEB;" d="M48.438,352.656c0,1.25-1.013,2.263-2.263,2.263c-1.25,0-2.263-1.013-2.263-2.263      s1.013-2.263,2.263-2.263C47.425,350.392,48.438,351.406,48.438,352.656z"/> </g> </g> </g> <g> <path style="fill:#E0E0E0;" d="M218.362,423.118c-1.951-1.231-4.555-2.381-6.863-2.371c-43.035,0.189-85.914,1.5-128.949,1.69    l-3.082,11.458c4.711,4.928,11.689,7.595,18.485,7.067c5.878-0.457,12.01-3.11,17.419-0.766c3.851,1.669,6.263,5.48,9.503,8.148    c5.665,4.666,13.587,5.576,20.887,4.817c7.299-0.758,14.385-2.969,21.678-3.785c9.32-1.043,18.774,0.211,28.109-0.687    c9.335-0.898,19.184-4.546,24.001-12.593C222.026,431.963,222.437,425.69,218.362,423.118z"/> </g> <g> <path style="fill:#E0E0E0;" d="M263.586,420.747c5.751,7.067,10.802,13.076,17.983,18.683c7.181,5.607,19.869,8.74,28.98,8.637    c8.724-0.099,16.923-3.903,25.422-5.876c13.18-3.061,26.94-1.686,40.38-0.117c13.439,1.568,27.103,3.309,40.425,0.948    c13.323-2.362,26.522-10.061,32.622-22.139L263.586,420.747z"/> </g> </g> <g id="Background_Simple" style="display:none;"> <g style="display:inline;"> <path style="fill:#E0E0E0;" d="M426.586,132.984l-2.318-3.772c-19.542-31.8-54.875-50.97-92.127-48.643    c-4.789,0.299-9.557,0.939-14.261,1.933c-33.87,7.159-63.341,32.451-75.556,64.842c-7.184,19.05-9.191,40.983-22.825,56.104    c-17.743,19.679-47.866,20.297-74.351,19.482c-26.484-0.815-56.628-0.12-74.284,19.637    c-11.058,12.373-14.573,29.969-13.681,46.539c2.361,43.871,33.319,83.098,72.689,102.595    c39.371,19.498,85.725,21.244,128.814,12.667c60.362-12.015,117.766-45.013,152.27-95.978    C445.461,257.426,454.193,187.992,426.586,132.984z"/> </g> </g> <g id="Floor"> <g> <g> <path style="fill:#263238;" d="M467.112,420.747c0,0.144-100.592,0.26-224.65,0.26c-124.101,0-224.671-0.116-224.671-0.26     c0-0.144,100.57-0.26,224.671-0.26C366.52,420.487,467.112,420.603,467.112,420.747z"/> </g> </g> </g> <g id="Character_2"> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#E8505B;" d="M434.474,373.446l16.209,21.967c0,0,27.772-9.098,31.163-5.33l-41.465,32.958            l-26.66-33.192L434.474,373.446z"/> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#E0E0E0;" d="M436.77,403.05c-0.633,0.863-0.469,2.216,0.367,2.883             c0.837,0.668,2.214,0.513,2.862-0.339c0.648-0.852,0.501-2.482-0.405-3.052c-0.906-0.569-2.513-0.3-2.937,0.683"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M478.807,388.423c0.086,0.115-9.045,7.077-20.392,15.547             c-11.351,8.473-20.619,15.247-20.705,15.131c-0.086-0.115,9.043-7.075,20.394-15.549             C469.451,395.083,478.721,388.308,478.807,388.423z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M451.167,394.635c0.155,0.209-0.791,1.112-1.273,2.565             c-0.52,1.441-0.335,2.735-0.587,2.803c-0.22,0.11-0.885-1.351-0.27-3.1C449.636,395.149,451.063,394.412,451.167,394.635             z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M456.987,392.965c0.204,0.161-0.404,1.21-0.411,2.622             c-0.049,1.413,0.518,2.484,0.308,2.637c-0.166,0.184-1.257-0.898-1.215-2.654             C455.696,393.813,456.828,392.774,456.987,392.965z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M463.642,396.23c-0.151,0.191-1.245-0.603-1.608-2.136             c-0.375-1.531,0.236-2.735,0.458-2.634c0.249,0.076,0.106,1.167,0.424,2.421             C463.203,395.142,463.828,396.049,463.642,396.23z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M446.887,390.005c0.062,0.254-1.097,0.716-2.187,1.711             c-1.111,0.972-1.7,2.072-1.945,1.982c-0.235-0.054,0.04-1.504,1.342-2.658             C445.387,389.877,446.86,389.766,446.887,390.005z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M443.973,384.813c0.069,0.083-0.636,0.849-2.1,1.652c-0.729,0.398-1.651,0.789-2.722,1.067            c-0.536,0.138-1.108,0.249-1.707,0.317c-0.291,0.029-0.618,0.086-1.023,0.01c-0.395-0.033-0.953-0.472-0.956-1.011            c-0.041-0.491,0.227-0.93,0.523-1.176c0.3-0.255,0.598-0.391,0.87-0.515c0.555-0.257,1.113-0.449,1.655-0.587            c1.087-0.271,2.099-0.327,2.935-0.267c1.682,0.127,2.618,0.626,2.58,0.721c-0.039,0.14-1.018-0.123-2.592-0.08            c-0.784,0.022-1.716,0.14-2.701,0.431c-0.491,0.148-0.995,0.34-1.495,0.584c-0.535,0.236-0.913,0.532-0.87,0.818            c0.019,0.108,0.037,0.142,0.232,0.198c0.191,0.043,0.463,0.017,0.75-0.01c0.561-0.052,1.099-0.139,1.607-0.247            c1.016-0.218,1.908-0.525,2.638-0.832C443.057,385.27,443.889,384.7,443.973,384.813z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M443.94,385.316c-0.047,0.089-1.033-0.32-2.157-1.582            c-0.556-0.627-1.119-1.475-1.535-2.516c-0.205-0.521-0.371-1.09-0.477-1.693c-0.083-0.607-0.224-1.397,0.495-2.116            c0.401-0.344,1.001-0.294,1.337-0.111c0.362,0.173,0.583,0.393,0.824,0.596c0.465,0.427,0.836,0.912,1.121,1.408            c0.575,0.993,0.799,2.022,0.824,2.87c0.044,1.731-0.613,2.651-0.685,2.595c-0.15-0.048,0.249-1.007,0.046-2.543            c-0.1-0.757-0.363-1.651-0.901-2.491c-0.266-0.419-0.598-0.825-0.999-1.178c-0.418-0.392-0.869-0.617-0.999-0.44            c-0.21,0.161-0.297,0.776-0.187,1.266c0.083,0.545,0.217,1.063,0.383,1.546c0.338,0.962,0.798,1.776,1.254,2.409            C443.202,384.607,444.027,385.197,443.94,385.316z"/> </g> </g> </g> </g> </g> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M397.618,403.621c0,0,9.451,3.264,18.27,3.006c8.268-0.241,26.302,3.205,25.008,13.909       c-1.443,11.938-25.338,6.072-34.572,3.042c-9.234-3.03-18.449-5.878-18.449-5.878L397.618,403.621z"/> </g> <g> <g> <path style="fill:#263238;" d="M417.557,421.535c0.122,0.043,0.87-1.754,1.672-4.014c0.802-2.26,1.352-4.128,1.23-4.171        c-0.122-0.043-0.87,1.754-1.672,4.014C417.986,419.624,417.435,421.491,417.557,421.535z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M414.228,421.294c0.125,0.033,0.721-1.831,1.331-4.161c0.61-2.332,1.003-4.248,0.878-4.281        c-0.125-0.033-0.721,1.83-1.331,4.162C414.496,419.345,414.103,421.261,414.228,421.294z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M411.182,419.662c0.126,0.031,0.632-1.599,1.131-3.64c0.499-2.042,0.801-3.721,0.676-3.752        c-0.126-0.031-0.632,1.599-1.131,3.641C411.359,417.951,411.057,419.631,411.182,419.662z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M406.313,417.806c0.107,0.062,0.963-1.247,1.633-3.046c0.676-1.797,0.888-3.347,0.767-3.37        c-0.132-0.029-0.544,1.447-1.206,3.206C406.853,416.357,406.195,417.741,406.313,417.806z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M405.763,413.312c0.005-0.026-0.435-0.156-1.258-0.237c-0.82-0.075-2.036-0.087-3.487,0.257        c-0.366,0.089-0.75,0.214-1.117,0.439c-0.362,0.216-0.724,0.595-0.799,1.104c-0.138,1.055,0.93,1.956,2.005,1.861        c1.084-0.074,1.984-0.754,2.75-1.499c0.777-0.763,1.388-1.736,1.792-2.812c0.8-2.163,0.682-4.514-0.324-6.311        c-0.152-0.219-0.371-0.438-0.669-0.52c-0.288-0.086-0.62-0.009-0.837,0.155c-0.443,0.33-0.639,0.79-0.764,1.23        c-0.218,0.862-0.256,1.699-0.164,2.443c0.173,1.5,0.78,2.598,1.269,3.259c0.25,0.332,0.472,0.566,0.633,0.713        c0.162,0.146,0.252,0.216,0.263,0.204c0.031-0.03-0.302-0.345-0.746-1.021c-0.431-0.675-0.966-1.755-1.089-3.189        c-0.068-0.711-0.011-1.502,0.209-2.307c0.108-0.377,0.313-0.778,0.622-0.992c0.305-0.22,0.69-0.102,0.918,0.269        c0.87,1.601,1.009,3.879,0.242,5.903c-0.381,1.016-0.954,1.933-1.678,2.652c-0.714,0.711-1.563,1.33-2.45,1.392        c-0.854,0.104-1.7-0.654-1.595-1.375c0.045-0.36,0.298-0.657,0.609-0.854c0.311-0.202,0.663-0.329,1.005-0.423        c1.397-0.374,2.585-0.414,3.395-0.395C405.307,413.281,405.757,413.35,405.763,413.312z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M389.026,416.238c-0.003,0.008,0.077,0.044,0.235,0.107c0.183,0.07,0.416,0.158,0.706,0.269        c0.656,0.235,1.572,0.563,2.736,0.979c2.383,0.833,5.842,2.015,10.151,3.397c4.31,1.375,9.462,2.977,15.273,4.492        c2.897,0.75,6.009,1.487,9.309,1.593c1.644,0.077,3.337-0.004,5.018-0.348c0.835-0.192,1.677-0.408,2.48-0.763        c0.805-0.354,1.585-0.753,2.268-1.417l-0.04,0.036c0.335-0.254,0.688-0.548,0.966-0.911c1.182-1.466,1.45-3.43,1.122-5.165        c-0.339-1.773-1.39-3.279-2.622-4.441c-1.25-1.162-2.689-2.04-4.158-2.723c-0.747-0.313-1.469-0.669-2.215-0.935        c-0.752-0.246-1.481-0.542-2.228-0.738c-5.966-1.692-11.556-1.868-16.152-2.42c-2.309-0.235-4.383-0.547-6.193-0.878        c-1.805-0.357-3.342-0.751-4.575-1.146c-0.609-0.206-1.153-0.391-1.631-0.553c-0.452-0.19-0.839-0.352-1.164-0.488        c-0.296-0.121-0.533-0.218-0.72-0.294c-0.163-0.064-0.249-0.093-0.253-0.086c-0.004,0.007,0.075,0.051,0.232,0.129        c0.182,0.087,0.413,0.199,0.702,0.338c0.321,0.148,0.704,0.325,1.151,0.532c0.476,0.175,1.018,0.374,1.625,0.596        c1.231,0.424,2.771,0.847,4.581,1.23c1.814,0.357,3.896,0.694,6.207,0.951c4.601,0.592,10.183,0.809,16.067,2.504        c0.738,0.197,1.454,0.491,2.195,0.736c0.734,0.264,1.442,0.617,2.177,0.926c1.44,0.674,2.838,1.534,4.036,2.653        c1.182,1.118,2.168,2.549,2.479,4.195c0.309,1.624,0.044,3.46-1.028,4.782c-0.25,0.33-0.57,0.592-0.87,0.822l-0.017,0.013        l-0.024,0.023c-0.566,0.552-1.344,0.973-2.102,1.299c-0.767,0.34-1.582,0.55-2.391,0.737c-1.632,0.336-3.29,0.419-4.907,0.347        c-3.249-0.097-6.319-0.814-9.22-1.551c-5.802-1.488-10.961-3.055-15.28-4.389c-4.318-1.341-7.791-2.475-10.191-3.255        c-1.176-0.382-2.1-0.682-2.763-0.897c-0.296-0.092-0.534-0.167-0.721-0.225C389.113,416.251,389.028,416.23,389.026,416.238z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M423.816,426.253c0.068,0.009,0.239-0.935,0.533-2.452c0.294-1.517,0.73-3.605,1.318-5.886        c0.591-2.281,1.221-4.319,1.698-5.789c0.477-1.47,0.785-2.378,0.721-2.403c-0.056-0.023-0.473,0.844-1.033,2.293        c-0.56,1.448-1.245,3.486-1.839,5.782c-0.592,2.296-0.98,4.41-1.191,5.949C423.811,425.285,423.756,426.245,423.816,426.253z"/> </g> </g> </g> <g> <g> <path style="fill:#263238;" d="M438.299,425.259c-0.028-0.036,0.324-0.301,0.808-0.918c0.475-0.616,1.11-1.579,1.55-2.899       c0.211-0.656,0.389-1.409,0.336-2.2c-0.071-0.8-0.264-1.661-0.598-2.509c-0.663-1.705-1.91-3.368-3.547-4.719       c-1.635-1.366-3.492-2.255-5.242-2.862c-1.752-0.612-3.401-0.956-4.787-1.218c-1.389-0.254-2.524-0.42-3.306-0.549       c-0.783-0.127-1.214-0.211-1.21-0.247c0.004-0.035,0.444-0.019,1.234,0.046c0.791,0.067,1.935,0.178,3.342,0.387       c1.405,0.218,3.082,0.527,4.881,1.127c1.792,0.593,3.724,1.499,5.419,2.915c1.697,1.399,2.991,3.145,3.663,4.947       c0.339,0.9,0.525,1.798,0.581,2.658c0.037,0.881-0.177,1.665-0.419,2.344c-0.505,1.361-1.206,2.316-1.743,2.91       C438.714,425.066,438.312,425.282,438.299,425.259z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#263238;" d="M399.934,402.513c0,0-25.071-38.947-31.425-40.893c-6.354-1.946-17.644-3.469-27.165,0       c-9.521,3.469-36.967,15.114-36.967,15.114l-17.313,5.761c-15.142,5.039-26.366,17.886-29.327,33.567l0,0       c0,0,21.861,17.97,38.401,14.808c16.54-3.162,61.571-23.425,61.571-23.425l0,0c4.802,2.855,12.654,4.105,16.25,5.649       c10.129,4.348,15.536,5.506,15.536,5.506l0,0L399.934,402.513z"/> </g> <g> <g> <path style="fill:#455A64;" d="M370.497,401.608c0.029,0.07-1.125,0.619-2.983,1.519c-1.989,0.973-4.486,2.195-7.247,3.546        c-2.833,1.386-5.421,2.6-7.324,3.414c-1.902,0.817-3.109,1.247-3.135,1.184c-0.029-0.07,1.125-0.618,2.982-1.519        c1.989-0.973,4.486-2.195,7.249-3.547c2.832-1.386,5.42-2.6,7.323-3.413C369.264,401.975,370.471,401.545,370.497,401.608z"/> </g> </g> <g> <g> <path style="fill:#455A64;" d="M377.803,384.642c-0.083,0.023-0.478-1.351-1.29-3.502c-0.809-2.151-2.095-5.062-3.889-8.072        c-1.802-3.007-3.756-5.519-5.267-7.25c-1.509-1.734-2.532-2.732-2.473-2.795c0.025-0.026,0.304,0.198,0.789,0.627        c0.49,0.424,1.161,1.079,1.957,1.921c1.593,1.681,3.619,4.188,5.441,7.23c1.815,3.045,3.063,6.016,3.789,8.215        c0.365,1.099,0.623,2.001,0.765,2.634C377.772,384.28,377.837,384.632,377.803,384.642z"/> </g> </g> <g> <g> <path style="fill:#455A64;" d="M371.206,390.012c0.131,0.018-0.337,1.803-1.949,3.297c-1.597,1.511-3.409,1.86-3.418,1.728        c-0.054-0.149,1.575-0.694,3.062-2.108C370.41,391.538,371.061,389.948,371.206,390.012z"/> </g> </g> </g> <g> <path style="fill:#263238;" d="M445.603,381.241c0,0-53.321-78.941-57.405-81.169c-1.871-1.02-4.921-1.314-7.677-1.332      c-3.671-0.024-7.233,1.233-10.109,3.515l-47.064,44.803l-13.819,30.096l29.302,15.787l42.395-40.434l40.178,49.74      L445.603,381.241z"/> </g> <g> <g> <path style="fill:#455A64;" d="M375.147,367.694c-0.015,0.01-0.186-0.19-0.497-0.581c-0.307-0.393-0.782-0.957-1.44-1.635       c-1.303-1.346-3.427-3.191-6.574-4.412c-1.568-0.594-3.386-1.023-5.358-0.944c-1.974,0.054-4.063,0.479-6.201,1.119       c-2.139,0.643-4.345,1.48-6.651,2.293c-2.303,0.821-4.687,1.67-7.129,2.54c-9.76,3.439-18.593,6.551-25.049,8.826       c-3.174,1.092-5.76,1.982-7.611,2.618c-0.864,0.286-1.556,0.514-2.078,0.687c-0.477,0.152-0.73,0.223-0.736,0.206       c-0.006-0.017,0.236-0.121,0.701-0.305c0.514-0.196,1.194-0.455,2.045-0.779c1.837-0.674,4.404-1.617,7.555-2.774       c6.443-2.312,15.257-5.475,24.997-8.97c2.443-0.867,4.828-1.713,7.132-2.53c2.307-0.806,4.517-1.634,6.686-2.272       c2.166-0.634,4.3-1.054,6.326-1.09c2.034-0.063,3.911,0.403,5.502,1.032c3.201,1.294,5.317,3.215,6.588,4.617       c0.643,0.706,1.095,1.295,1.376,1.71C375.019,367.463,375.161,367.684,375.147,367.694z"/> </g> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M355.648,333.955l61.8-19.649c3.846-1.223,6.117-5.186,5.226-9.122l-1.746-7.719l-52.419,2.652      l-44.342-31.394c-2.74-1.94-5.887-3.23-9.2-3.772l-8.785-1.436l-27.995-6.349l-29.082,28.568      c-2.466,2.422-3.913,5.694-4.048,9.148l-1.383,35.625c-0.209,5.388-0.009,10.785,0.6,16.142l5.757,50.702      c0,0,1.614,26.089,12.91,22.055c0,0,12.703-24.359,27.227-33.234c14.524-8.876,34.902-15.985,34.902-15.985l-3.176-48.38      l0.421-10.274L355.648,333.955z"/> </g> <g style="opacity:0.4;"> <path d="M355.578,334.029l61.793-19.647c3.85-1.224,6.123-5.191,5.232-9.132l-1.744-7.712l-52.419,2.652l-44.342-31.393      c-2.74-1.94-5.887-3.23-9.201-3.772l-8.784-1.436l-27.995-6.349l-29.082,28.568c-2.466,2.422-3.914,5.694-4.048,9.148      l-1.383,35.625c-0.209,5.388-0.009,10.785,0.6,16.142l5.757,50.702c0,0,1.614,26.089,12.91,22.055      c0,0,12.318-23.765,26.201-32.575C302.455,378.413,325,370.261,325,370.261l-3.086-48.664l0.332-9.989L355.578,334.029z"/> </g> <g> <g> <path style="fill:#FAFAFA;" d="M306.383,301.91c-0.128-0.066,0.641-1.807,1.716-3.889c1.076-2.082,2.051-3.716,2.179-3.65       c0.128,0.066-0.641,1.807-1.716,3.889C307.486,300.342,306.511,301.976,306.383,301.91z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M331.997,288.073c-0.082,0.118-2.172-1.19-4.667-2.922c-2.496-1.732-4.452-3.232-4.37-3.35       c0.082-0.118,2.171,1.19,4.667,2.922C330.122,286.454,332.079,287.954,331.997,288.073z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M340.99,304.095c0.012,0.143-1.885,0.419-4.236,0.616c-2.352,0.197-4.268,0.24-4.28,0.097       c-0.012-0.143,1.884-0.419,4.236-0.616C339.062,303.995,340.978,303.952,340.99,304.095z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M351.914,318.246c-0.143,0.014-0.477-2.263-0.745-5.084c-0.268-2.822-0.37-5.12-0.227-5.133       c0.143-0.014,0.477,2.262,0.745,5.084C351.955,315.934,352.057,318.232,351.914,318.246z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M372.865,308.519c0.091,0.111-1.631,1.673-3.846,3.488c-2.216,1.816-4.085,3.197-4.176,3.086       c-0.091-0.111,1.631-1.673,3.846-3.489C370.904,309.789,372.774,308.408,372.865,308.519z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M412.803,313.81c-0.096,0.107-1.789-1.241-3.782-3.013c-1.994-1.772-3.532-3.295-3.436-3.402       c0.096-0.107,1.789,1.241,3.782,3.013C411.36,312.179,412.898,313.702,412.803,313.81z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M291.725,289.279c-0.087-0.114,1.694-1.623,3.978-3.368c2.285-1.747,4.207-3.069,4.294-2.955       c0.087,0.114-1.693,1.622-3.978,3.369C293.735,288.07,291.813,289.393,291.725,289.279z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M269.214,298.314c-0.099,0.104-1.378-0.954-2.857-2.364c-1.479-1.41-2.597-2.637-2.498-2.741       c0.099-0.104,1.378,0.954,2.857,2.364C268.195,296.983,269.314,298.21,269.214,298.314z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M272.136,278.109c0.039,0.138-2.437,0.952-5.529,1.817c-3.093,0.865-5.631,1.454-5.669,1.316       c-0.039-0.138,2.436-0.952,5.529-1.817C269.559,278.56,272.097,277.971,272.136,278.109z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M284.34,308.76c-0.142-0.02,0.015-1.996,0.352-4.414c0.337-2.419,0.726-4.362,0.868-4.342       c0.142,0.02-0.015,1.996-0.352,4.414C284.871,306.835,284.482,308.78,284.34,308.76z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M320.217,271.5c-0.017,0.143-2.264-0.002-5.02-0.324c-2.756-0.322-4.977-0.698-4.96-0.841       c0.017-0.143,2.264,0.002,5.02,0.324C318.013,270.98,320.234,271.357,320.217,271.5z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M311.35,326.285c-0.133-0.056,0.628-2.172,1.698-4.725c1.071-2.555,2.046-4.58,2.179-4.525       c0.133,0.056-0.628,2.171-1.699,4.726C312.458,324.315,311.483,326.341,311.35,326.285z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M297.11,333.131c-0.136,0.068-1.408-2.282-3.187-5.044c-1.771-2.769-3.376-4.904-3.258-4.999       c0.104-0.088,1.907,1.92,3.697,4.718C296.159,330.597,297.233,333.073,297.11,333.131z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M261.447,324.083c-0.062,0.115-2.155-1.023-4.209-3.089c-2.066-2.055-3.203-4.149-3.087-4.211       c0.131-0.086,1.438,1.837,3.456,3.842C259.61,322.643,261.533,323.952,261.447,324.083z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M258.513,341.321c0.061,0.13-1.522,1.001-3.535,1.945c-2.014,0.944-3.695,1.604-3.757,1.473       c-0.061-0.13,1.522-1.001,3.536-1.945C256.77,341.85,258.452,341.191,258.513,341.321z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M272.089,345.461c-0.132-0.057,0.703-2.275,1.864-4.953c1.161-2.679,2.21-4.804,2.342-4.747       c0.132,0.057-0.702,2.275-1.864,4.954C273.269,343.393,272.22,345.518,272.089,345.461z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M268.264,367.135c-0.13,0.078-1.452-1.933-3.263-4.274c-1.804-2.347-3.413-4.137-3.304-4.243       c0.095-0.097,1.89,1.549,3.717,3.925C267.246,364.912,268.383,367.067,268.264,367.135z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M291.019,356.932c0.15-0.006,0.341,2.389,0.734,5.318c0.385,2.931,0.824,5.293,0.678,5.326       c-0.134,0.033-0.805-2.297-1.194-5.258C290.841,359.36,290.881,356.935,291.019,356.932z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M284.71,378.824c0.116,0.095-1.332,2.013-2.985,4.462c-1.66,2.446-2.901,4.503-3.032,4.431       c-0.122-0.064,0.925-2.252,2.601-4.723C282.963,380.521,284.605,378.735,284.71,378.824z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M307.012,360.296c-0.133,0.055-1.302-2.448-2.611-5.591c-1.31-3.144-2.263-5.737-2.13-5.792       c0.133-0.055,1.302,2.448,2.611,5.592C306.191,357.647,307.145,360.24,307.012,360.296z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M321.1,360.363c0.12,0.08-1.087,2.107-2.694,4.528c-1.608,2.422-3.009,4.32-3.128,4.24       c-0.12-0.079,1.086-2.107,2.694-4.528C319.58,362.182,320.98,360.283,321.1,360.363z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M319.832,341.099c-0.033,0.14-1.204-0.019-2.615-0.354c-1.411-0.336-2.527-0.721-2.494-0.861       c0.033-0.14,1.204,0.019,2.615,0.354C318.749,340.574,319.865,340.96,319.832,341.099z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M263.586,391.76c-0.1,0.103-1.868-1.449-3.947-3.466c-2.081-2.018-3.685-3.737-3.585-3.84       c0.1-0.103,1.867,1.448,3.948,3.467C262.081,389.938,263.686,391.657,263.586,391.76z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M262.421,403.141c0.098,0.105-1.293,1.553-3.107,3.232c-1.814,1.68-3.363,2.955-3.461,2.85       c-0.098-0.105,1.293-1.552,3.107-3.232C260.773,404.311,262.323,403.035,262.421,403.141z"/> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M337.527,202.567c-4.121-2.507-9.799,0.305-14.156-1.764         c-2.646-1.256-4.181-4.018-6.306-6.034c-3.177-3.015-8.331-4.686-12.606-3.731c-4.274,0.955-7.237,2.385-8.828,6.466         c-2.94-2.856-9.793,0.014-12.817,3.698c-3.025,3.684-3.637,8.134-3.67,12.901c-0.057,8.207,1.518,16.421,4.605,24.025         c0.274,0.673,0.781,1.471,1.495,1.334c0.494-0.095,0.778-0.605,0.978-1.067c1.704-3.932,2.252-8.248,2.953-12.476         c0.701-4.228,1.615-8.537,3.927-12.146c2.312-3.608,6.313-6.417,10.592-6.182c3.161,0.173,6.036,1.95,8.328,4.134         c2.292,2.184,4.129,4.793,6.24,7.152c2.111,2.359,4.603,4.529,7.633,5.444c3.03,0.915,6.686,0.309,8.7-2.133         c2.014-2.442,1.555-6.759-1.283-8.161c2.819,0.45,5.834-1.317,6.82-3.997C341.119,207.35,339.967,204.051,337.527,202.567z"/> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#FFBE9D;" d="M305.402,270.927l1.831-8.983c0,0,12.265,0.743,14.998-11.085                       c1.32-5.712,3.081-17.693,4.549-28.557c1.579-11.684-6.077-22.62-17.595-25.133l-1.144-0.25                       c-12.497-1.971-21.152,7.541-22.776,20.088l-9.272,48.087c-1.56,8.093,3.705,15.928,11.787,17.54l0,0                       C295.875,284.25,303.753,279.016,305.402,270.927z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M307.249,261.94c0,0-7.629-1.026-14.504-7.767c0,0,1.793,9.333,13.861,10.846                       L307.249,261.94z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M321.712,230.457c-0.163,0.901-1.061,1.506-2.006,1.353                          c-0.943-0.154-1.576-1.007-1.413-1.908c0.163-0.901,1.061-1.507,2.004-1.354                          C321.242,228.701,321.875,229.556,321.712,230.457z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M322.966,227.544c-0.258,0.175-1.334-1.055-3.158-1.447                           c-1.816-0.419-3.358,0.227-3.507-0.039c-0.076-0.12,0.225-0.472,0.9-0.769                           c0.665-0.297,1.733-0.495,2.867-0.242c1.134,0.254,1.998,0.88,2.453,1.428                           C322.988,227.026,323.091,227.467,322.966,227.544z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M303.766,226.864c-0.164,0.901-1.062,1.506-2.006,1.352                          c-0.943-0.153-1.576-1.006-1.413-1.908c0.164-0.901,1.062-1.507,2.005-1.354                          C303.296,225.108,303.929,225.963,303.766,226.864z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M304.976,223.976c-0.258,0.175-1.336-1.055-3.159-1.447                           c-1.816-0.418-3.358,0.227-3.507-0.039c-0.075-0.12,0.223-0.472,0.901-0.769                           c0.665-0.298,1.733-0.495,2.867-0.243c1.134,0.254,1.998,0.88,2.454,1.428                           C304.997,223.458,305.101,223.899,304.976,223.976z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M308.642,238.935c0.014-0.106,1.19-0.054,3.077,0.112                          c0.476,0.054,0.937,0.057,1.084-0.243c0.183-0.312,0.098-0.857-0.01-1.447                          c-0.192-1.222-0.392-2.502-0.603-3.844c-0.811-5.463-1.289-9.913-1.069-9.944                          c0.221-0.031,1.056,4.372,1.867,9.835c0.189,1.345,0.37,2.627,0.541,3.853                          c0.061,0.567,0.233,1.233-0.157,1.879c-0.201,0.32-0.598,0.498-0.914,0.513                          c-0.318,0.026-0.581-0.026-0.815-0.063C309.775,239.282,308.627,239.04,308.642,238.935z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M303.003,239.026c0.3,0.047-0.128,2.027,1.259,3.8                          c1.383,1.777,3.54,2.015,3.496,2.295c0,0.13-0.554,0.282-1.449,0.112c-0.879-0.161-2.093-0.719-2.942-1.804                          c-0.845-1.087-1.039-2.332-0.929-3.159C302.543,239.427,302.87,238.985,303.003,239.026z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M307.195,214.676c-0.288,0.456-2.056-0.176-4.251-0.384                      c-2.191-0.253-4.051-0.003-4.238-0.509c-0.08-0.241,0.322-0.641,1.124-0.969                      c0.795-0.328,1.997-0.543,3.312-0.406c1.314,0.14,2.445,0.6,3.155,1.087                      C307.013,213.982,307.323,214.458,307.195,214.676z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M323.446,222.123c-0.411,0.344-1.573-0.36-3.078-0.709                      c-1.493-0.402-2.849-0.33-3.048-0.827c-0.083-0.238,0.208-0.609,0.852-0.879                      c0.635-0.27,1.626-0.389,2.657-0.131c1.03,0.259,1.847,0.83,2.28,1.369                      C323.55,221.487,323.632,221.952,323.446,222.123z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#FFBE9D;" d="M284.317,226.001c-0.183-0.132-7.623-4.188-9.133,3.977                  c-1.51,8.165,6.999,7.996,7.056,7.765C282.298,237.511,284.317,226.001,284.317,226.001z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M280.318,234.188c-0.031-0.033-0.161,0.073-0.422,0.139                   c-0.254,0.064-0.671,0.063-1.067-0.175c-0.804-0.476-1.277-1.98-1.045-3.459c0.116-0.747,0.403-1.426,0.775-1.963                   c0.36-0.551,0.823-0.897,1.272-0.894c0.451-0.02,0.71,0.297,0.767,0.545c0.067,0.248-0.015,0.402,0.026,0.424                   c0.019,0.025,0.201-0.105,0.197-0.454c-0.004-0.168-0.064-0.379-0.227-0.571c-0.167-0.196-0.44-0.33-0.748-0.353                   c-0.638-0.073-1.312,0.402-1.72,0.991c-0.444,0.586-0.783,1.346-0.914,2.184c-0.252,1.655,0.306,3.35,1.423,3.91                   c0.547,0.256,1.058,0.171,1.341,0.025C280.267,234.383,280.344,234.208,280.318,234.188z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#263238;" d="M329.832,220.364c-5.527,0.251-11.108-2.351-14.469-6.747          c-2.351-3.076-3.81-7.078-7.183-8.979c-2.27-1.28-5.089-1.344-7.587-0.599c-2.498,0.745-4.714,2.232-6.704,3.915          c0.977,6.527-2.03,12.92-4.956,18.836c-0.323,0.654-0.692,1.354-1.352,1.665c-1.12,0.528-2.43-0.361-3.076-1.419          c-1.033-1.693-1.121-3.785-1.047-5.767c0.169-4.514,1.041-9.04,2.947-13.135c1.906-4.095,4.885-7.747,8.741-10.1          c4.818-2.941,10.838-3.699,16.334-2.411c5.496,1.288,10.451,4.538,14.127,8.821c1.706,1.987,3.18,4.261,3.728,6.822"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#455A64;" d="M340.309,206.167c0,0-0.006,0.259-0.226,0.687c-0.215,0.421-0.676,1.009-1.498,1.424         c-0.817,0.422-1.98,0.569-3.251,0.35c-0.635-0.108-1.306-0.275-1.985-0.563c-0.671-0.292-1.362-0.725-1.858-1.408         c-0.481-0.667-0.784-1.595-0.514-2.51c0.269-0.932,1.202-1.563,2.173-1.694c0.49-0.072,1.008-0.037,1.499,0.132         c0.49,0.17,0.938,0.505,1.256,0.929c0.66,0.852,0.824,2.025,0.589,3.098c-0.23,1.092-0.964,2.074-1.927,2.696         c-0.965,0.633-2.122,0.964-3.302,1.026c-2.383,0.128-4.764-0.838-6.764-2.265c-2.028-1.424-3.674-3.206-5.209-4.919         c-1.539-1.712-3.033-3.357-4.681-4.659c-1.634-1.31-3.453-2.221-5.276-2.571c-1.824-0.352-3.594-0.203-5.123,0.188         c-3.088,0.808-5.171,2.506-6.446,3.716c-0.645,0.616-1.101,1.14-1.406,1.498c-0.305,0.358-0.461,0.551-0.474,0.541         c-0.006-0.004,0.026-0.058,0.095-0.158c0.069-0.099,0.169-0.25,0.315-0.436c0.285-0.376,0.725-0.921,1.358-1.56         c1.253-1.255,3.334-3.018,6.485-3.883c1.56-0.417,3.374-0.59,5.26-0.241c1.888,0.346,3.773,1.279,5.447,2.608         c1.688,1.32,3.202,2.979,4.746,4.686c1.537,1.709,3.163,3.461,5.146,4.853c1.956,1.394,4.242,2.315,6.507,2.199         c1.117-0.055,2.21-0.368,3.106-0.952c0.898-0.581,1.557-1.458,1.774-2.452c0.22-0.98,0.07-2.045-0.508-2.796         c-0.551-0.779-1.541-1.076-2.419-0.942c-0.878,0.113-1.686,0.664-1.918,1.449c-0.244,0.784,0.01,1.63,0.447,2.249         c0.443,0.628,1.087,1.05,1.726,1.338c0.646,0.285,1.303,0.46,1.919,0.576c1.233,0.234,2.35,0.114,3.141-0.267         c0.799-0.376,1.264-0.924,1.495-1.321C340.248,206.412,340.286,206.16,340.309,206.167z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#455A64;" d="M279.847,207.87c0.051-0.077,0.807,0.661,2.336,1.183c0.761,0.249,1.72,0.398,2.779,0.31         c1.056-0.073,2.215-0.363,3.36-0.8c2.297-0.91,3.862-2.663,4.666-4.042c0.824-1.398,1.009-2.417,1.087-2.394         c0.024,0.005-0.002,0.26-0.111,0.711c-0.113,0.449-0.331,1.09-0.723,1.826c-0.763,1.459-2.358,3.326-4.767,4.282         c-1.191,0.454-2.377,0.739-3.488,0.796c-1.108,0.07-2.117-0.118-2.899-0.414c-0.784-0.302-1.355-0.675-1.717-0.963         C280.006,208.076,279.831,207.889,279.847,207.87z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#455A64;" d="M278.921,213.816c0.027-0.071,0.927,0.346,2.476,0.593c1.533,0.254,3.762,0.248,5.987-0.612         c2.224-0.862,3.877-2.359,4.839-3.579c0.978-1.225,1.363-2.14,1.431-2.105c0.023,0.01-0.049,0.247-0.233,0.654         c-0.183,0.408-0.496,0.978-0.967,1.628c-0.926,1.296-2.608,2.89-4.922,3.786c-2.313,0.894-4.63,0.849-6.187,0.514         c-0.786-0.164-1.402-0.374-1.811-0.553C279.123,213.965,278.91,213.839,278.921,213.816z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M297.23,230.403c-0.114-0.002-0.204-0.104-0.202-0.229c0.002-0.124,0.096-0.223,0.21-0.221         c0.114,0.002,0.204,0.104,0.202,0.229C297.438,230.306,297.344,230.405,297.23,230.403z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M300.885,230.373c-0.113-0.002-0.203-0.119-0.201-0.262c0.003-0.143,0.096-0.256,0.21-0.254         c0.113,0.002,0.203,0.119,0.201,0.262C301.092,230.261,300.998,230.375,300.885,230.373z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M303.242,230.827c-0.113-0.01-0.191-0.168-0.175-0.354c0.017-0.185,0.122-0.327,0.235-0.317         c0.113,0.01,0.191,0.169,0.175,0.354C303.46,230.695,303.355,230.837,303.242,230.827z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M298.465,232.962c-0.111-0.024-0.189-0.101-0.173-0.173c0.016-0.071,0.118-0.109,0.229-0.084         c0.111,0.024,0.188,0.101,0.173,0.172C298.679,232.949,298.576,232.987,298.465,232.962z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M301.821,232.918c-0.113-0.014-0.191-0.13-0.174-0.258c0.017-0.128,0.121-0.22,0.234-0.205         c0.113,0.015,0.191,0.13,0.174,0.258C302.038,232.841,301.933,232.933,301.821,232.918z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M318.874,234.56c-0.114-0.002-0.204-0.108-0.202-0.236c0.002-0.128,0.096-0.231,0.21-0.229         c0.114,0.002,0.204,0.107,0.202,0.236C319.081,234.459,318.987,234.562,318.874,234.56z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M321.294,234.86c-0.113-0.013-0.191-0.139-0.174-0.281c0.017-0.142,0.122-0.247,0.235-0.234         c0.113,0.013,0.191,0.139,0.174,0.281C321.512,234.769,321.407,234.874,321.294,234.86z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M316.765,234.161c-0.114-0.002-0.204-0.085-0.203-0.184c0.002-0.1,0.095-0.179,0.209-0.177         c0.114,0.002,0.204,0.085,0.203,0.184C316.972,234.084,316.878,234.163,316.765,234.161z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M318.007,236.918c-0.111,0.023-0.223-0.063-0.249-0.192c-0.026-0.129,0.043-0.251,0.154-0.274         c0.111-0.023,0.223,0.063,0.249,0.192C318.187,236.773,318.118,236.896,318.007,236.918z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M320.122,236.956c-0.101-0.053-0.146-0.164-0.102-0.249c0.044-0.085,0.162-0.111,0.263-0.058         c0.1,0.053,0.146,0.164,0.102,0.249C320.34,236.982,320.222,237.008,320.122,236.956z"/> </g> </g> </g> </g> </g> <g> <g> <g> <path style="fill:#263238;" d="M425.796,276.118l-2.467-0.803c-0.435-0.141-0.894-0.164-1.34-0.063       c-2.82,0.64-13.698,3.109-17.843,4.08c-1.09,0.255-1.998,0.992-2.477,2.004l-16.765,34.946       c-0.432,0.901-0.241,1.977,0.476,2.673l0,0L425.796,276.118z"/> </g> <g> <path style="fill:#455A64;" d="M425.796,276.118l-18.41,37.151l-22.006,5.892l18.75-36.681       c0.416-0.817,1.169-1.411,2.061-1.627L425.796,276.118z"/> </g> </g> <g> <g> <g> <g> <path style="fill:#FFBE9D;" d="M427.43,292.172c-0.434-0.587,3.795-20.194,2.575-20.736c-1.22-0.542-1.788-0.323-2.588,0.855         c-0.8,1.178-5.644,12.729-5.644,12.729l-2.127-0.792c-0.571-0.213-1.181-0.28-1.785-0.195         c-3.198,0.454-13.67,1.976-13.608,2.44c0,0-0.204,4.048,3.455,3.234l-5.178,1.647c0,0-1.761,2.996,1.379,3.489h3.599         l-5.621,1.086c0,0,0.557,3.103,2.593,3.31c2.012,0.205,7.516-0.569,7.516-0.569l1.258,2.759l-5.867,11.839l9.879-3.344         c0,0,5.286-2.71,4.879-5.421c0,0,3.795-2.168,3.795-5.15C425.939,299.355,429.734,295.289,427.43,292.172z"/> </g> </g> <g> <g> <path style="fill:#EB996E;" d="M425.134,291.561c-0.055,0.064-0.853-0.618-2.303-1.466c-0.726-0.419-1.611-0.887-2.637-1.286         c-1.03-0.39-2.189-0.732-3.453-0.688c-2.548,0.016-4.842,0.528-6.48,0.9c-1.642,0.387-2.644,0.688-2.669,0.619         c-0.024-0.066,0.942-0.492,2.575-0.975c1.631-0.466,3.939-1.046,6.574-1.065c1.334-0.046,2.59,0.337,3.631,0.764         c1.052,0.437,1.938,0.95,2.653,1.418C424.455,290.728,425.176,291.519,425.134,291.561z"/> </g> </g> <g> <g> <path style="fill:#EB996E;" d="M421.548,296.503c-0.076,0.043-0.458-0.767-1.472-1.719c-0.506-0.461-1.179-0.975-2.023-1.218         c-0.85-0.207-1.888-0.198-2.933-0.073c-2.105,0.298-4.02,0.812-5.411,1.062c-1.375,0.275-2.296,0.428-2.237,0.348         c-0.095-0.059,0.799-0.34,2.152-0.706c1.38-0.343,3.248-0.91,5.433-1.221c1.098-0.126,2.16-0.134,3.13,0.129         c0.962,0.309,1.646,0.898,2.148,1.417C421.334,295.596,421.603,296.488,421.548,296.503z"/> </g> </g> </g> <g> <g> <path style="fill:#EB996E;" d="M427.134,291.885c-0.073,0.025-0.337-0.635-0.777-1.678c-0.449-1.026-1.083-2.492-2.313-3.636        c-1.238-1.137-2.766-1.617-3.83-1.962c-1.082-0.331-1.766-0.526-1.748-0.602c0.015-0.065,0.719,0.001,1.844,0.246        c1.1,0.26,2.728,0.693,4.087,1.934c1.341,1.253,1.937,2.817,2.305,3.888C427.059,291.169,427.197,291.863,427.134,291.885z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#FFBE9D;" d="M367.324,308.002l16.091-16.851l13.289-4.738l4.117,1.57l9.642-1.866        c1.516-0.293,2.737,1.436,1.81,2.672c-0.095,0.126-0.199,0.224-0.315,0.282c-0.924,0.462-13.52,4.507-13.52,4.507        l16.178-1.271c0,0,1.721,0.834,0.334,2.105c-1.387,1.271-6.847,2.774-10.396,3.465c-1.818,0.354-6.276,2.537-6.276,2.537        s13.448,2.292,13.333,3.332c-0.116,1.04,0.116,1.502-1.04,1.618c-1.156,0.116-12.48-0.347-14.213,0.116        c-1.733,0.462-7.742,8.551-10.978,10.284c-3.236,1.733-6.471,0-6.471,0L375.904,319l-7.395-10.284"/> </g> <g> <g> <path style="fill:#EB996E;" d="M368.509,308.715c0.005-0.004,0.052,0.051,0.139,0.161c0.098,0.128,0.222,0.291,0.381,0.499         c0.345,0.465,0.832,1.123,1.461,1.973c1.284,1.761,3.147,4.314,5.523,7.573l-0.206-0.013c0.915-0.994,1.92-2.086,2.99-3.249         c0.046-0.05,0.118-0.062,0.176-0.035l0.009,0.004c1.338,0.626,3.007,0.941,4.648,0.59c0.819-0.176,1.619-0.527,2.337-1.039         c0.721-0.52,1.401-1.144,2.084-1.793c1.352-1.316,2.681-2.781,4.076-4.295c0.699-0.756,1.412-1.527,2.174-2.285         c0.386-0.375,0.776-0.752,1.226-1.093l0.348-0.249l0.428-0.196c0.29-0.059,0.576-0.102,0.852-0.119         c2.228-0.153,4.502-0.103,6.849-0.085c1.172,0.018,2.36,0.036,3.563,0.055c0.601,0.007,1.205,0.014,1.814,0.022         c0.592-0.013,1.264,0.052,1.705-0.144c0.183-0.077,0.212-0.286,0.235-0.603l0.029-0.469c0.001-0.057,0.027-0.212,0.01-0.19         c0.03,0.073-0.015,0.003-0.041-0.016c-0.432-0.289-1.081-0.472-1.661-0.654c-1.199-0.351-2.441-0.638-3.696-0.914         c-2.513-0.545-5.097-1.032-7.728-1.489c-0.138-0.023-0.232-0.153-0.209-0.292c0.014-0.083,0.07-0.152,0.14-0.187         c1.374-0.663,2.772-1.303,4.227-1.878c0.728-0.278,1.471-0.565,2.27-0.716c0.764-0.15,1.529-0.324,2.294-0.508         c1.529-0.372,3.064-0.795,4.571-1.315c0.752-0.262,1.502-0.545,2.209-0.896c0.344-0.182,0.704-0.366,0.976-0.606         c0.271-0.238,0.522-0.54,0.51-0.824c0.02-0.347-0.35-0.706-0.722-0.901l0.134,0.025c-5.538,0.433-10.949,0.857-16.178,1.266         c-0.141,0.011-0.263-0.094-0.274-0.234c-0.009-0.12,0.067-0.227,0.176-0.263c2.461-0.797,4.882-1.582,7.256-2.351         c1.184-0.392,2.357-0.781,3.517-1.165c0.577-0.198,1.152-0.395,1.723-0.591c0.281-0.1,0.573-0.203,0.833-0.309         c0.147-0.059,0.228-0.089,0.305-0.177c0.084-0.081,0.146-0.203,0.215-0.308c0.234-0.454,0.161-1.019-0.14-1.44         c-0.298-0.426-0.804-0.681-1.308-0.672c-1.078,0.163-2.262,0.422-3.366,0.624c-2.238,0.429-4.418,0.848-6.533,1.253         c-0.042,0.008-0.084,0.003-0.121-0.01c-1.415-0.543-2.78-1.067-4.113-1.578l0.147,0.002         c-4.876,1.724-9.328,3.298-13.301,4.703l0.068-0.044c-5.038,5.226-9.076,9.416-11.873,12.318         c-1.384,1.421-2.46,2.525-3.209,3.293c-0.357,0.358-0.635,0.638-0.839,0.844c-0.191,0.188-0.291,0.281-0.297,0.275         c-0.006-0.006,0.082-0.11,0.261-0.31c0.196-0.214,0.462-0.505,0.804-0.877c0.733-0.783,1.787-1.909,3.142-3.357         c2.77-2.928,6.769-7.155,11.757-12.428c0.019-0.02,0.044-0.035,0.068-0.044c3.966-1.426,8.409-3.023,13.276-4.773         c0.049-0.018,0.102-0.016,0.147,0.002c1.336,0.507,2.702,1.025,4.119,1.562l-0.121-0.01c2.114-0.413,4.292-0.838,6.529-1.275         c1.137-0.209,2.21-0.46,3.441-0.643c0.668-0.016,1.327,0.322,1.711,0.869c0.392,0.535,0.504,1.313,0.18,1.938         c-0.091,0.146-0.167,0.295-0.299,0.427c-0.124,0.143-0.326,0.236-0.459,0.284c-0.297,0.122-0.574,0.219-0.863,0.323         c-0.573,0.198-1.149,0.397-1.729,0.597c-1.161,0.387-2.334,0.778-3.519,1.173c-2.374,0.773-4.795,1.561-7.256,2.363         l-0.098-0.497c5.229-0.413,10.639-0.839,16.177-1.276l0.009-0.001c0.045-0.004,0.088,0.006,0.125,0.026         c0.262,0.139,0.476,0.298,0.675,0.519c0.191,0.217,0.348,0.522,0.341,0.856c-0.011,0.558-0.376,0.925-0.69,1.212         c-0.342,0.297-0.715,0.481-1.083,0.678c-0.743,0.369-1.507,0.655-2.272,0.922c-1.532,0.528-3.077,0.953-4.62,1.327         c-0.772,0.186-1.543,0.36-2.316,0.511c-0.744,0.139-1.465,0.415-2.184,0.689c-1.432,0.564-2.829,1.202-4.19,1.856         l-0.069-0.479c2.64,0.462,5.225,0.953,7.749,1.505c1.261,0.28,2.507,0.569,3.73,0.93c0.614,0.205,1.208,0.337,1.821,0.742         c0.078,0.092,0.18,0.114,0.223,0.353c0.015,0.172-0.009,0.176-0.01,0.273l-0.03,0.461c-0.013,0.16-0.022,0.329-0.085,0.52         c-0.056,0.193-0.227,0.394-0.41,0.477c-0.713,0.29-1.317,0.165-1.929,0.194c-0.61-0.009-1.217-0.018-1.819-0.027         c-1.203-0.022-2.391-0.044-3.562-0.065c-2.338-0.026-4.627-0.082-6.804,0.059c-0.275,0.016-0.532,0.055-0.78,0.103         l-0.316,0.147l-0.316,0.225c-0.417,0.313-0.806,0.682-1.186,1.049c-0.754,0.744-1.469,1.509-2.17,2.261         c-1.401,1.506-2.742,2.968-4.114,4.289c-0.695,0.652-1.386,1.281-2.138,1.816c-0.76,0.535-1.609,0.9-2.474,1.08         c-1.742,0.353-3.449,0.02-4.864-0.656l0.184-0.031c-1.081,1.153-2.095,2.236-3.019,3.222         c-0.05,0.054-0.134,0.058-0.188,0.008l-0.019-0.021c-2.332-3.29-4.16-5.869-5.421-7.647         c-0.605-0.867-1.074-1.538-1.405-2.013c-0.147-0.217-0.262-0.387-0.352-0.52C368.541,308.78,368.504,308.719,368.509,308.715         z"/> </g> </g> </g> <g> <g> <path style="fill:#EB996E;" d="M388.371,291.823c-0.021-0.061,0.931-0.444,2.525-1.03c1.594-0.586,3.832-1.374,6.383-2.246        l0.031-0.008c0.613-0.126,1.25-0.258,1.901-0.392c3.093-0.631,5.899-1.174,7.935-1.542c2.036-0.368,3.302-0.56,3.317-0.489        c0.014,0.07-1.226,0.39-3.243,0.85c-2.017,0.46-4.811,1.06-7.904,1.691c-0.651,0.132-1.289,0.26-1.902,0.384l0.031-0.008        c-2.558,0.852-4.816,1.579-6.439,2.079S388.391,291.884,388.371,291.823z"/> </g> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M278.689,292.044l43.361,37.588l44.66-25.56c0,0,14.086,7.462,11.092,19.923l-39.529,31.297       c-11.444,9.061-27.543,9.32-39.272,0.632l-15.108-11.191l-34.252-28.752c0,0-5.648-18.289,6.724-23.938       C268.738,286.396,278.689,292.044,278.689,292.044z"/> </g> <g style="opacity:0.4;"> <path d="M278.689,292.044l43.361,37.588l44.66-25.56c0,0,14.086,7.462,11.092,19.923l-39.529,31.297       c-11.444,9.061-27.543,9.32-39.272,0.632l-15.108-11.191l-34.252-28.752c0,0-5.648-18.289,6.724-23.938       C268.738,286.396,278.689,292.044,278.689,292.044z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M284.688,297.244c0,0,0.238,0.18,0.682,0.553c0.455,0.386,1.11,0.941,1.963,1.664       c1.729,1.483,4.254,3.647,7.495,6.427c6.495,5.603,15.852,13.674,27.352,23.595l-0.227-0.022       c12.667-7.267,27.896-16.003,44.634-25.605l0.122-0.07l0.124,0.068c3.474,1.918,6.762,4.531,9.047,8.035       c2.238,3.488,3.29,7.95,2.169,12.188l-0.018,0.068l-0.067,0.053c-3.923,3.107-8.076,6.396-12.283,9.728       c-7.677,6.076-15.172,12.008-22.405,17.733l0.014-0.012c-6.019,5.41-13.314,8.959-20.71,10.338       c-3.7,0.622-7.467,0.729-10.988-0.125c-3.499-0.907-6.713-2.344-9.707-3.966c-5.996-3.26-11.034-7.309-15.635-11.106       c-4.563-3.851-8.791-7.42-12.636-10.665c-7.666-6.498-13.802-11.7-18.038-15.291c-2.096-1.79-3.719-3.176-4.832-4.126       c-0.538-0.466-0.951-0.824-1.243-1.076c-0.278-0.244-0.412-0.378-0.412-0.378s0.155,0.11,0.442,0.342       c0.299,0.245,0.721,0.59,1.272,1.042c1.126,0.936,2.768,2.299,4.888,4.06c4.258,3.563,10.428,8.726,18.136,15.174       c3.857,3.23,8.097,6.782,12.674,10.615c4.607,3.777,9.639,7.797,15.596,11.017c2.967,1.6,6.178,3.023,9.603,3.903       c3.443,0.83,7.148,0.72,10.795,0.102c7.292-1.369,14.517-4.893,20.451-10.237l0.008-0.007l0.006-0.005       c7.231-5.728,14.723-11.662,22.398-17.741c4.208-3.331,8.362-6.619,12.285-9.725l-0.085,0.121       c0.54-1.971,0.537-4.115,0.159-6.118c-0.378-2.018-1.189-3.923-2.267-5.632c-2.217-3.406-5.432-5.978-8.86-7.873l0.245-0.001       c-16.757,9.568-32.004,18.273-44.686,25.514l-0.122,0.07l-0.105-0.092c-11.452-9.975-20.77-18.092-27.238-23.726       c-3.211-2.814-5.712-5.006-7.425-6.507c-0.837-0.742-1.479-1.311-1.926-1.707C284.9,297.453,284.688,297.244,284.688,297.244z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M264.412,313.928c-0.143,0.009-0.405-2.18-0.583-4.888c-0.179-2.71-0.207-4.914-0.063-4.923       c0.143-0.01,0.404,2.179,0.583,4.889C264.527,311.715,264.556,313.919,264.412,313.928z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M286.737,317.843c-0.071,0.125-2.383-1.055-5.164-2.635c-2.782-1.581-4.978-2.963-4.907-3.088       c0.071-0.125,2.383,1.055,5.164,2.635C284.611,316.335,286.808,317.718,286.737,317.843z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M289.74,331.317c-0.001,0.144-2.331,0.251-5.205,0.24c-2.875-0.011-5.204-0.137-5.204-0.281       c0.001-0.144,2.331-0.251,5.206-0.24C287.411,331.047,289.741,331.173,289.74,331.317z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M302.881,336.828c-0.144-0.004-0.194-2.205-0.113-4.915c0.081-2.711,0.264-4.904,0.407-4.9       c0.144,0.004,0.194,2.205,0.113,4.915C303.207,334.638,303.024,336.832,302.881,336.828z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M320.375,350.79c-0.014,0.143-2.221,0.047-4.93-0.214c-2.709-0.261-4.894-0.589-4.88-0.732       c0.014-0.143,2.221-0.048,4.93,0.214C318.204,350.319,320.389,350.647,320.375,350.79z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M334.586,342.762c-0.141-0.028,0.191-2.318,0.741-5.115c0.55-2.798,1.111-5.043,1.252-5.015       c0.141,0.028-0.191,2.318-0.741,5.115C335.288,340.544,334.727,342.79,334.586,342.762z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M358.425,325.629c-0.025,0.142-2.568-0.188-5.678-0.736c-3.112-0.548-5.613-1.108-5.588-1.249       c0.025-0.142,2.567,0.188,5.679,0.737C355.948,324.928,358.45,325.487,358.425,325.629z"/> </g> </g> <g> <g> <path style="fill:#FAFAFA;" d="M365.784,319.863c-0.143-0.015-0.048-2.024,0.211-4.486c0.26-2.463,0.586-4.447,0.729-4.432       s0.048,2.023-0.211,4.486C366.254,317.894,365.927,319.879,365.784,319.863z"/> </g> </g> </g> <g> <g> <path style="fill:#263238;" d="M276.726,291.409c-0.056,0.104-1.563-1.095-4.479-1.829c-2.875-0.749-7.151-0.973-11.53,0.326      c-2.181,0.646-4.125,1.679-5.629,2.942c-1.528,1.243-2.616,2.678-3.488,3.895c-0.857,1.234-1.495,2.276-1.956,2.984      c-0.459,0.71-0.728,1.093-0.759,1.074c-0.031-0.019,0.179-0.437,0.585-1.178c0.408-0.74,0.998-1.813,1.826-3.087      c0.843-1.257,1.923-2.75,3.485-4.056c1.536-1.326,3.549-2.411,5.786-3.072c4.494-1.331,8.861-1.039,11.777-0.182      c1.466,0.427,2.594,0.956,3.316,1.408c0.374,0.204,0.627,0.424,0.81,0.55C276.648,291.317,276.737,291.395,276.726,291.409z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M323.701,285.312c0.036,0.003,0.02,0.625-0.04,1.745c-0.065,1.207-0.152,2.807-0.257,4.745      c-0.214,4.006-0.445,9.543-0.621,15.662c-0.163,6.082-0.311,11.584-0.421,15.677c-0.071,1.94-0.13,3.543-0.174,4.751      c-0.054,1.121-0.101,1.741-0.137,1.74c-0.036-0.001-0.057-0.622-0.066-1.744c0.002-1.209,0.005-2.812,0.008-4.754      c0.029-4.014,0.093-9.559,0.268-15.685c0.177-6.124,0.466-11.665,0.775-15.67c0.153-2.002,0.298-3.621,0.423-4.737      C323.581,285.924,323.665,285.309,323.701,285.312z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M319.196,269.119c0.052-0.039,0.557,0.508,1.231,1.501c0.675,0.991,1.494,2.446,2.16,4.158      c0.663,1.713,1.041,3.34,1.211,4.527c0.172,1.188,0.168,1.932,0.104,1.938c-0.162,0.022-0.481-2.92-1.8-6.277      C320.811,271.599,319.062,269.212,319.196,269.119z"/> </g> </g> </g> </g> <g id="Character_1"> <g> <g> <path style="fill:#E8505B;" d="M81.925,416.076c0,0-9.773,2.112-18.498,0.804c-8.181-1.227-26.496,0.042-26.49,10.824     c0.007,12.025,24.431,9.054,33.961,7.148c9.53-1.906,19.019-3.633,19.019-3.633L81.925,416.076z"/> <g> <path style="fill:#263238;" d="M59.99,431.48c-0.126,0.028-0.655-1.845-1.18-4.185c-0.526-2.34-0.85-4.259-0.724-4.288      c0.126-0.028,0.655,1.845,1.181,4.185C59.792,429.532,60.116,431.452,59.99,431.48z"/> </g> <g> <path style="fill:#263238;" d="M63.324,431.639c-0.128,0.018-0.497-1.904-0.825-4.291c-0.328-2.388-0.489-4.337-0.361-4.355      c0.128-0.018,0.497,1.903,0.825,4.291C63.29,429.671,63.452,431.621,63.324,431.639z"/> </g> <g> <path style="fill:#263238;" d="M66.543,430.382c-0.128,0.015-0.437-1.663-0.688-3.749c-0.252-2.087-0.352-3.79-0.223-3.806      c0.128-0.015,0.436,1.663,0.688,3.75C66.571,428.662,66.671,430.366,66.543,430.382z"/> </g> <g> <path style="fill:#263238;" d="M71.599,429.12c-0.113,0.049-0.808-1.353-1.257-3.219c-0.457-1.865-0.482-3.43-0.359-3.438      c0.134-0.013,0.367,1.502,0.814,3.327C71.236,427.618,71.724,429.07,71.599,429.12z"/> </g> <g> <path style="fill:#263238;" d="M72.682,424.725c-0.002-0.027,0.45-0.103,1.277-0.085c0.823,0.023,2.032,0.157,3.431,0.671      c0.352,0.132,0.719,0.302,1.057,0.569c0.333,0.258,0.648,0.677,0.661,1.191c0.011,1.064-1.157,1.831-2.213,1.608      c-1.067-0.203-1.88-0.985-2.551-1.816c-0.68-0.851-1.171-1.89-1.443-3.006c-0.536-2.243-0.138-4.564,1.075-6.227      c0.177-0.199,0.42-0.391,0.726-0.436c0.296-0.051,0.616,0.065,0.813,0.253c0.4,0.381,0.541,0.861,0.612,1.312      c0.114,0.882,0.051,1.717-0.129,2.445c-0.351,1.468-1.085,2.486-1.649,3.084c-0.288,0.299-0.536,0.506-0.713,0.633      c-0.179,0.125-0.276,0.184-0.286,0.171c-0.027-0.034,0.341-0.306,0.863-0.925c0.508-0.618,1.168-1.627,1.462-3.036      c0.152-0.698,0.191-1.49,0.068-2.316c-0.062-0.387-0.218-0.81-0.499-1.059c-0.277-0.254-0.673-0.183-0.943,0.158      c-1.055,1.485-1.465,3.731-0.944,5.832c0.257,1.054,0.716,2.033,1.349,2.834c0.624,0.791,1.393,1.507,2.267,1.674      c0.836,0.206,1.766-0.446,1.748-1.175c-0.001-0.363-0.218-0.688-0.503-0.921c-0.285-0.237-0.619-0.406-0.947-0.54      c-1.343-0.538-2.517-0.72-3.323-0.798C73.138,424.748,72.683,424.763,72.682,424.725z"/> </g> <g> <path style="fill:#263238;" d="M88.95,429.627c0.002,0.008-0.082,0.034-0.246,0.078c-0.19,0.048-0.432,0.108-0.733,0.182      c-0.68,0.155-1.628,0.371-2.833,0.645c-2.465,0.542-6.041,1.303-10.483,2.161c-4.443,0.851-9.75,1.826-15.7,2.637      c-2.966,0.398-6.143,0.759-9.432,0.47c-1.642-0.12-3.313-0.403-4.941-0.945c-0.806-0.29-1.616-0.605-2.371-1.053      c-0.757-0.448-1.484-0.937-2.082-1.678l0.036,0.04c-0.302-0.292-0.618-0.626-0.85-1.02c-0.998-1.597-1.031-3.579-0.497-5.262      c0.548-1.72,1.772-3.09,3.134-4.096c1.38-1.005,2.914-1.704,4.453-2.207c0.779-0.221,1.538-0.489,2.311-0.664      c0.776-0.155,1.535-0.361,2.3-0.467c6.125-0.967,11.696-0.476,16.325-0.474c2.321,0.043,4.417-0.02,6.254-0.133      c1.835-0.139,3.408-0.347,4.679-0.592c0.629-0.132,1.192-0.25,1.685-0.354c0.471-0.134,0.875-0.249,1.214-0.346      c0.309-0.085,0.556-0.153,0.75-0.207c0.17-0.044,0.258-0.063,0.261-0.055c0.003,0.008-0.08,0.042-0.245,0.101      c-0.191,0.065-0.434,0.148-0.737,0.251c-0.337,0.109-0.738,0.239-1.207,0.391c-0.493,0.117-1.055,0.25-1.685,0.398      c-1.273,0.274-2.852,0.51-4.695,0.674c-1.844,0.138-3.951,0.224-6.276,0.203c-4.639,0.039-10.207-0.412-16.251,0.568      c-0.756,0.107-1.502,0.314-2.267,0.468c-0.761,0.175-1.506,0.441-2.272,0.66c-1.51,0.497-3.001,1.184-4.324,2.152      c-1.307,0.969-2.457,2.272-2.963,3.869c-0.5,1.576-0.457,3.43,0.45,4.87c0.209,0.357,0.495,0.656,0.766,0.921l0.015,0.015      l0.021,0.026c0.496,0.615,1.218,1.126,1.932,1.541c0.721,0.429,1.505,0.735,2.286,1.018c1.58,0.528,3.216,0.809,4.831,0.93      c3.237,0.291,6.371-0.053,9.339-0.44c5.938-0.784,11.247-1.725,15.695-2.534c4.447-0.816,8.031-1.528,10.507-2.015      c1.213-0.238,2.166-0.426,2.85-0.56c0.305-0.057,0.55-0.102,0.743-0.138C88.861,429.63,88.948,429.62,88.95,429.627z"/> </g> <g> <path style="fill:#263238;" d="M53.212,435.417c-0.069,0.001-0.125-0.956-0.237-2.498c-0.111-1.541-0.294-3.667-0.606-6.001      c-0.314-2.335-0.696-4.434-0.995-5.95c-0.298-1.516-0.495-2.454-0.429-2.472c0.058-0.016,0.369,0.894,0.752,2.4      c0.383,1.505,0.82,3.609,1.136,5.96c0.314,2.351,0.446,4.496,0.472,6.048C53.333,434.457,53.273,435.417,53.212,435.417z"/> </g> <polygon style="opacity:0.4;" points="78.917,416.596 85.11,432.108 89.916,431.218 80.712,416.076    "/> </g> <g> <g> <g> <g> <g> <g> <path style="fill:#E8505B;" d="M147.013,378.277l13.613-30.37l-7.881-26.059c-2.39-7.903-1.831-16.405,1.573-23.927          l13.269-28.369l9.204-4.828l21.852-3.759c0.841,0.28,29.074,11.725,29.074,11.725l6.262,7.821l-22.49,65.599          c0,0,15.254,33.377,13.341,48.678L147.013,378.277z"/> </g> </g> <g style="opacity:0.3;"> <g> <g> <path d="M208.753,313.172c-1.699,6.584-3.397,13.168-5.096,19.752c-0.312,1.21-0.704,2.535-1.759,3.205           c-0.727,0.462-1.632,0.517-2.493,0.558c-8.265,0.393-16.531,0.787-24.796,1.181c-1.39,0.066-2.805,0.137-4.113,0.613           c-1.308,0.476-2.516,1.428-2.95,2.751c-0.699,2.131,0.752,4.325,2.2,6.038c12.441,14.712,32.794,24.039,51.939,26.202           l-10.042-28.74l3.371-16.853L208.753,313.172z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M173.028,326.559c0,0,0.125,0.009,0.362,0.04c0.271,0.037,0.613,0.083,1.033,0.139           c0.896,0.127,2.195,0.296,3.802,0.49c3.213,0.39,7.664,0.835,12.595,1.105c4.933,0.267,9.406,0.309,12.643,0.27           c1.618-0.018,2.928-0.046,3.832-0.074c0.424-0.011,0.768-0.019,1.042-0.026c0.238-0.005,0.364,0,0.364,0           s-0.125,0.013-0.363,0.026c-0.273,0.013-0.618,0.03-1.041,0.05c-0.904,0.044-2.214,0.085-3.833,0.116           c-3.238,0.062-7.715,0.035-12.651-0.232c-4.934-0.271-9.388-0.73-12.599-1.144c-1.606-0.206-2.904-0.39-3.798-0.531           c-0.419-0.066-0.759-0.121-1.03-0.163C173.15,326.586,173.028,326.559,173.028,326.559z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M152.503,312.654c0,0,0.196,0.008,0.569,0.036c0.4,0.032,0.943,0.075,1.629,0.13           c1.445,0.112,3.484,0.271,5.993,0.466c5.062,0.376,12.059,0.825,19.796,1.153c7.74,0.325,14.751,0.468,19.826,0.52           c2.516,0.017,4.562,0.031,6.01,0.041c0.688,0.004,1.233,0.006,1.634,0.008c0.374,0.003,0.57,0.012,0.57,0.012           s-0.196,0.009-0.57,0.014c-0.401,0.004-0.946,0.009-1.634,0.016c-1.419,0.014-3.473,0.015-6.011,0           c-5.076-0.029-12.09-0.157-19.831-0.482c-7.739-0.328-14.737-0.792-19.798-1.191c-2.53-0.199-4.577-0.374-5.99-0.507           c-0.685-0.065-1.228-0.116-1.627-0.154C152.697,312.68,152.503,312.654,152.503,312.654z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M157.664,300.735c0,0,0.179,0.006,0.52,0.029c0.37,0.027,0.866,0.064,1.489,0.109           c1.326,0.096,3.189,0.23,5.478,0.396c4.626,0.32,11.022,0.7,18.092,0.974c7.073,0.271,13.479,0.383,18.116,0.42           c2.295,0.011,4.163,0.02,5.492,0.027c0.625,0.002,1.123,0.004,1.493,0.005c0.341,0.003,0.521,0.011,0.521,0.011           s-0.179,0.01-0.521,0.015c-0.37,0.005-0.868,0.011-1.493,0.019c-1.297,0.016-3.173,0.022-5.493,0.014           c-4.638-0.013-11.046-0.111-18.121-0.382c-7.072-0.274-13.468-0.668-18.093-1.012c-2.313-0.171-4.184-0.321-5.475-0.437           c-0.623-0.056-1.118-0.101-1.488-0.134C157.842,300.758,157.664,300.735,157.664,300.735z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M160.923,290.397c0.001-0.036,2.013-0.019,4.495,0.038c2.482,0.057,4.493,0.132,4.492,0.168           c-0.001,0.036-2.013,0.019-4.495-0.038C162.934,290.507,160.923,290.432,160.923,290.397z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M198.2,285.276c0-0.004,0.059-0.01,0.171-0.016c0.15-0.006,0.311-0.013,0.492-0.021           c0.499-0.014,1.103-0.032,1.811-0.052c1.609-0.033,3.684-0.077,5.977-0.124c2.294-0.033,4.369-0.063,5.979-0.086           c0.708-0.004,1.313-0.008,1.812-0.011c0.181,0.001,0.343,0.003,0.492,0.003c0.113,0.002,0.172,0.006,0.172,0.01           s-0.059,0.01-0.172,0.016c-0.15,0.006-0.312,0.013-0.493,0.021c-0.499,0.014-1.103,0.032-1.811,0.052           c-1.609,0.034-3.683,0.077-5.977,0.124c-2.293,0.033-4.367,0.063-5.976,0.086c-0.709,0.004-1.313,0.008-1.812,0.011           c-0.181-0.001-0.343-0.002-0.493-0.003C198.259,285.284,198.2,285.281,198.2,285.276z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M149.532,372.71c0,0,0.242,0.001,0.702,0.016c0.483,0.017,1.156,0.04,2.011,0.07           c1.771,0.057,4.292,0.138,7.397,0.238c6.246,0.179,14.878,0.338,24.412,0.307c9.537-0.035,18.169-0.254,24.413-0.476           c3.104-0.122,5.624-0.22,7.394-0.29c0.855-0.036,1.527-0.064,2.01-0.084c0.46-0.018,0.701-0.02,0.701-0.02           s-0.241,0.02-0.7,0.046c-0.483,0.026-1.155,0.062-2.009,0.108c-1.745,0.094-4.271,0.209-7.393,0.331           c-6.245,0.246-14.877,0.479-24.416,0.514c-9.536,0.031-18.169-0.142-24.415-0.345c-3.123-0.1-5.65-0.198-7.396-0.279           c-0.855-0.04-1.527-0.072-2.01-0.094C149.773,372.728,149.532,372.71,149.532,372.71z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M155.488,360.524c0.001-0.036,13.459,0.261,30.056,0.663           c16.603,0.402,30.057,0.757,30.056,0.793c-0.001,0.036-13.456-0.261-30.059-0.663           C168.944,360.914,155.487,360.559,155.488,360.524z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M160.625,347.907c0,0,0.183-0.006,0.531-0.005c0.377,0.003,0.885,0.008,1.523,0.013           c1.354,0.022,3.26,0.053,5.602,0.092c4.73,0.092,11.263,0.26,18.476,0.532c7.216,0.269,13.743,0.618,18.463,0.948           c2.359,0.178,4.268,0.317,5.585,0.449c0.636,0.06,1.141,0.108,1.517,0.143c0.346,0.034,0.528,0.059,0.528,0.059           s-0.183-0.007-0.53-0.033c-0.376-0.029-0.882-0.069-1.518-0.119c-1.318-0.116-3.227-0.242-5.587-0.408           c-4.72-0.306-11.247-0.641-18.462-0.91c-7.212-0.273-13.744-0.454-18.473-0.57c-2.341-0.056-4.247-0.101-5.601-0.133           c-0.638-0.016-1.146-0.028-1.523-0.038C160.808,347.919,160.625,347.907,160.625,347.907z"/> </g> </g> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M171.002,268.409c0,0-19.04,4.221-21.25,24.697l-2.35,20.92l8.144,2.495L171.002,268.409z"/> </g> </g> <g> <g> <g> <path style="fill:#263238;" d="M153.219,320.339c-0.01,0.004-0.059-0.104-0.141-0.315c-0.078-0.212-0.21-0.521-0.337-0.933          c-0.246-0.825-0.544-2.046-0.659-3.588c-0.25-3.072,0.361-7.431,2.395-11.697c0.507-1.061,1.075-2.073,1.646-3.012          c0.561-0.95,1.098-1.869,1.58-2.759c0.977-1.773,1.66-3.462,2.14-4.916c0.48-1.454,0.826-2.648,1.079-3.468          c0.119-0.381,0.217-0.694,0.295-0.944c0.071-0.215,0.113-0.326,0.124-0.323s-0.011,0.12-0.061,0.341          c-0.063,0.255-0.141,0.572-0.237,0.96c-0.216,0.831-0.528,2.034-0.983,3.505c-0.454,1.469-1.126,3.193-2.095,4.986          c-0.478,0.9-1.011,1.824-1.569,2.778c-0.572,0.951-1.123,1.937-1.627,2.99c-2.01,4.217-2.647,8.507-2.459,11.545          c0.085,1.525,0.345,2.739,0.552,3.568C153.097,319.877,153.244,320.329,153.219,320.339z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M155.001,279.326c-0.001-0.036,3.136-0.148,7.006-0.25c3.871-0.102,7.009-0.156,7.01-0.121          s-3.135,0.148-7.006,0.25C158.141,279.307,155.002,279.361,155.001,279.326z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M149.824,295.056c0.001-0.009,0.125-0.003,0.349,0.016c0.3,0.026,0.613,0.054,0.946,0.083          c0.799,0.071,1.903,0.159,3.125,0.225c1.222,0.065,2.329,0.096,3.131,0.111c0.334,0.007,0.648,0.013,0.95,0.019          c0.224,0.005,0.348,0.013,0.349,0.022c0,0.009-0.124,0.019-0.348,0.029c-0.224,0.01-0.549,0.018-0.951,0.022          c-0.803,0.008-1.913-0.008-3.138-0.074c-1.224-0.066-2.329-0.169-3.127-0.263c-0.399-0.047-0.721-0.089-0.943-0.124          C149.946,295.088,149.823,295.065,149.824,295.056z"/> </g> </g> </g> </g> <g> <g> <g> <g> <path style="fill:#E8505B;" d="M233.978,280.511c3.772,4.123,4.74,10.506,4.74,17.396c0,8.05,0,35.388,0,35.388          l-30.317-0.567l0.928-31.632"/> </g> </g> <g> <g> <g> <path style="fill:#263238;" d="M237.75,333.452c0,0.005-0.051,0.01-0.149,0.013c-0.117,0.002-0.261,0.004-0.438,0.007           c-0.41-0.001-0.974-0.002-1.688-0.003c-1.494-0.017-3.615-0.04-6.237-0.07c-5.306-0.089-12.634-0.211-20.843-0.348           l-0.163-0.003l0.004-0.163c0.021-0.787,0.044-1.628,0.067-2.476c0.258-8.78,0.492-16.727,0.662-22.509           c0.1-2.859,0.18-5.181,0.237-6.816c0.034-0.784,0.061-1.403,0.081-1.851c0.012-0.195,0.021-0.354,0.029-0.48           c0.008-0.108,0.015-0.163,0.021-0.163c0.005,0.001,0.009,0.057,0.012,0.166c0.001,0.128,0.002,0.287,0.003,0.484           c-0.005,0.45-0.012,1.07-0.021,1.857c-0.032,1.637-0.078,3.962-0.135,6.823c-0.146,5.78-0.346,13.724-0.567,22.5           c-0.023,0.847-0.046,1.687-0.068,2.474l-0.158-0.165c8.208,0.177,15.536,0.336,20.842,0.451           c2.622,0.071,4.742,0.129,6.235,0.169c0.714,0.026,1.277,0.046,1.687,0.061c0.177,0.01,0.321,0.017,0.437,0.024           C237.7,333.44,237.75,333.447,237.75,333.452z"/> </g> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M209.527,309.208c0,0,0.099,0,0.285,0.012c0.224,0.016,0.493,0.036,0.815,0.059          c0.761,0.056,1.772,0.132,2.998,0.223c4.491,0.323,5.599,0.384,9.9,0.566c3.87,0.162,7.376,0.237,9.914,0.268          c1.229,0.012,2.243,0.023,3.006,0.03c0.323,0.004,0.592,0.007,0.817,0.01c0.187,0.004,0.285,0.012,0.285,0.012          s-0.098,0.009-0.285,0.014c-0.225,0.004-0.494,0.009-0.817,0.014c-0.763,0.003-1.777,0.006-3.006,0.011          c-2.539-0.008-6.047-0.068-9.919-0.231c-3.871-0.164-7.371-0.399-9.901-0.605c-1.225-0.108-2.235-0.197-2.995-0.264          c-0.321-0.033-0.59-0.06-0.813-0.083C209.624,309.225,209.527,309.208,209.527,309.208z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M210.221,296.533c0,0,1.397-0.503,3.722-1.091c4.731-1.204,5.428-1.209,9.234-1.518          c3.651-0.289,6.973-0.186,9.36,0.027c2.389,0.211,3.848,0.484,3.848,0.484s-0.093-0.004-0.268-0.023          c-0.213-0.025-0.466-0.055-0.766-0.091c-0.664-0.087-1.628-0.186-2.821-0.279c-2.385-0.19-5.699-0.278-9.342,0.011          c-3.641,0.295-6.898,0.911-9.223,1.478c-1.163,0.282-2.099,0.533-2.741,0.725c-0.291,0.083-0.535,0.153-0.742,0.212          C210.313,296.514,210.221,296.533,210.221,296.533z"/> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <polygon style="fill:#263238;" points="153.066,320.877 145.04,306.071 120.628,306.071 119.854,307.54 140.52,341.899           163.915,343.028         "/> </g> </g> <g> <g> <polygon style="fill:#455A64;" points="152.292,322.346 144.267,307.54 119.854,307.54 139.746,343.368 163.142,344.496                   "/> </g> </g> <g> <g> <path style="fill:#EBEBEB;" d="M132.247,313.756c0.529,0.423,1.3,0.338,1.724-0.19c0.424-0.528,0.338-1.3-0.19-1.724          c-0.529-0.423-1.3-0.338-1.724,0.19C131.634,312.561,131.719,313.332,132.247,313.756z"/> </g> </g> </g> <g> <g> <path style="fill:#FFBE9D;" d="M236.161,333.452v21.469c0,4.723-1.853,9.197-5.047,12.183l0,0         c-3.892,3.639-9.208,4.552-13.861,2.38l-49.735-25.251l4.872-19.004l40.012,15.109l0.415-7.168L236.161,333.452z"/> </g> </g> <g> <g> <path style="fill:#FFBE9D;" d="M175.338,327.267l-3.862-4.792c-2.543-3.155-6.377-4.99-10.43-4.99h-3.372l-2.301,2.589         c0,0-16.51,0.719-17.119,2.756l-0.015,0.657l-0.009,0.384l14.122,0.949c0,0-12.013-0.038-12.732-0.011         c-0.791,0.03-3.352-0.201-3.3,1.208c0.043,1.159,1.414,2.073,3.491,2.376c0.854,0.125,11.259,1.029,11.259,1.029         s-10.926-0.105-11.454-0.107c-1.284-0.006-1.121,2.053-0.358,2.311c0.603,0.204,15.273,4.485,15.273,4.485         s-2.467,1.654-4.48,1.51c-2.014-0.144-5.466-2.733-6.185-1.51c-0.719,1.223-0.575,1.942-0.144,2.23         c0.432,0.288,5.178,2.733,6.76,3.164c1.582,0.432,14.499,2.476,14.499,2.476l4.663,0.751L175.338,327.267z"/> </g> </g> <g> <g> <g> <path style="fill:#FFBE9D;" d="M123.266,313.314c0,0-2.554,0.89-1.254,4.171c1.902,4.802,5.181,8.202,5.181,8.202          s-0.452,1.695,1.017,2.939c0,0-1.808,0.452-0.678,3.504c0,0-1.243,3.165,2.147,4.521c0,0-0.904,2.599,2.374,3.843          c3.278,1.243,6.442-0.906,6.442-0.906L123.266,313.314z"/> </g> </g> <g> <g> <path style="fill:#FFBE9D;" d="M128.445,325.438c2.32,0.626,4.87,1.126,7.016,1.94c0.706,0.268,1.406,0.282,1.874,0.875          c0.468,0.593,0.576,1.536,0.041,2.069c-0.472,0.469-1.227,0.46-1.888,0.38c-2.476-0.299-4.847-1.149-7.193-1.993"/> </g> </g> <g> <g> <path style="fill:#FFBE9D;" d="M129.371,329.31c2.32,0.626,4.87,1.126,7.016,1.94c0.706,0.268,1.406,0.282,1.874,0.875          c0.468,0.593,0.576,1.537,0.041,2.069c-0.472,0.469-1.227,0.46-1.887,0.381c-2.476-0.3-4.847-1.149-7.193-1.993"/> </g> </g> <g> <g> <path style="fill:#FFBE9D;" d="M130.69,333.295c2.32,0.626,4.87,1.126,7.016,1.94c0.706,0.268,1.406,0.282,1.874,0.875          c0.468,0.593,0.576,1.537,0.041,2.069c-0.472,0.469-1.227,0.46-1.888,0.38c-2.476-0.3-4.847-1.149-7.193-1.993"/> </g> </g> <g> <g> <g> <path style="fill:#EB996E;" d="M128.434,328.789c0.038-0.098,1.676,0.476,3.732,1.047c2.055,0.577,3.753,0.935,3.735,1.038           c-0.014,0.094-1.755-0.106-3.832-0.689C129.991,329.608,128.397,328.877,128.434,328.789z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#EB996E;" d="M128.003,332.207c0.036-0.097,1.912,0.524,4.246,1.206c2.334,0.687,4.248,1.177,4.226,1.278           c-0.019,0.094-1.979-0.239-4.328-0.931C129.798,333.074,127.968,332.297,128.003,332.207z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#EB996E;" d="M129.525,336.601c0.024-0.097,1.81,0.266,3.987,0.81c2.178,0.544,3.924,1.064,3.9,1.161           c-0.024,0.097-1.809-0.265-3.988-0.81C131.247,337.218,129.501,336.698,129.525,336.601z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#EB996E;" d="M126.515,324.964c0.037-0.099,2.092,0.597,4.677,1.262c2.585,0.673,4.719,1.06,4.703,1.165           c-0.007,0.047-0.552,0.012-1.424-0.118c-0.871-0.129-2.068-0.36-3.37-0.697c-1.302-0.337-2.46-0.715-3.285-1.025           C126.992,325.242,126.499,325.009,126.515,324.964z"/> </g> </g> </g> </g> <g> <g> <g> <path style="fill:#EB996E;" d="M149.752,320.273c-0.001-0.1,2.594-0.195,5.793-0.212c3.201-0.017,5.795,0.05,5.796,0.151          c0.001,0.1-2.593,0.195-5.794,0.212C152.347,320.44,149.752,320.373,149.752,320.273z"/> </g> </g> </g> </g> </g> <g> <g> <g> <path style="fill:#EB996E;" d="M218.155,353.306c-0.061-0.006,0.04-0.833-0.042-2.16c-0.035-0.664-0.146-1.448-0.33-2.305        c-0.201-0.853-0.485-1.776-0.883-2.706c-0.41-0.926-0.893-1.762-1.381-2.49c-0.502-0.718-1.002-1.333-1.464-1.811        c-0.916-0.963-1.591-1.452-1.554-1.501c0.013-0.018,0.189,0.093,0.497,0.31c0.312,0.211,0.733,0.562,1.219,1.031        c0.491,0.465,1.019,1.077,1.545,1.801c0.512,0.734,1.014,1.585,1.433,2.532c0.408,0.951,0.69,1.898,0.878,2.773        c0.172,0.878,0.26,1.682,0.267,2.358c0.012,0.675-0.018,1.222-0.076,1.595C218.216,353.105,218.177,353.309,218.155,353.306z"/> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M165.554,260.206c-0.081-0.021,0.347-0.659,0.146-1.869c-0.104-0.592-0.366-1.301-0.85-2.01         c-0.485-0.709-1.203-1.401-2.021-2.159c-0.818-0.75-1.731-1.652-2.422-2.823c-0.695-1.161-1.206-2.545-1.407-4.058         c-0.207-1.508-0.066-3.159,0.462-4.725c0.509-1.575,1.318-3.064,2.113-4.565c0.801-1.497,1.531-2.973,1.946-4.48         c0.428-1.503,0.465-3.016,0.091-4.395c-0.754-2.772-2.407-4.958-3.245-7.067c-0.92-2.089-1.005-4.046-0.685-5.281         c0.149-0.624,0.366-1.077,0.54-1.361c0.173-0.286,0.297-0.413,0.314-0.402c0.067,0.035-0.364,0.611-0.571,1.82         c-0.217,1.2-0.065,3.021,0.883,5.014c0.862,2.019,2.569,4.149,3.426,7.103c0.424,1.473,0.397,3.169-0.051,4.759         c-0.431,1.602-1.188,3.132-1.992,4.637c-0.799,1.506-1.588,2.957-2.078,4.444c-0.507,1.48-0.648,2.993-0.475,4.413         c0.17,1.419,0.629,2.728,1.26,3.832c0.628,1.114,1.454,1.976,2.255,2.756c0.794,0.783,1.519,1.527,2.005,2.311         c0.485,0.781,0.723,1.555,0.789,2.198c0.063,0.647-0.048,1.152-0.174,1.465C165.691,260.079,165.568,260.214,165.554,260.206         z"/> </g> </g> </g> <g> <g> <path style="fill:#263238;" d="M204.304,246.759c0.952,2.428,3.547,4.041,6.155,4.048c2.608,0.007,5.117-1.48,6.568-3.647        c1.451-2.167,1.885-4.934,1.411-7.499c-0.214-1.161-0.605-2.32-0.47-3.493c0.192-1.663,1.402-3.036,1.816-4.658        c0.747-2.92-1.388-6.005-4.166-7.173c-2.779-1.168-5.967-0.807-8.87,0.003"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M161.988,212.983c-2.677,2.692-1.656,6.225-0.406,8.618c1.25,2.393,2.749,4.818,2.778,7.517        c0.029,2.76-1.487,5.269-2.244,7.923c-0.954,3.346-0.667,7.031,0.795,10.188c1.102,2.379,2.823,4.428,3.938,6.801        c1.115,2.373,1.527,5.36,0.01,7.499c1.445-0.232,2.65-1.33,3.298-2.643c0.648-1.313,0.806-2.815,0.776-4.279        c-0.115-5.557-2.777-10.956-2.111-16.475c0.387-3.208,1.893-6.288,1.68-9.512c-0.213-3.235-2.111-6.071-3.483-9.008        c-1.372-2.938-2.185-6.601-0.356-9.279"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M168.567,202.443c-3.279,0.424-6.531,2.14-8.117,5.042c-1.585,2.902-1.04,7.009,1.669,8.905        c2.555,1.788,6.178,1.198,8.802-0.486c1.936-1.242,3.548-3.073,4.251-5.264c0.702-2.191,0.406-4.744-1.017-6.552        c-1.423-1.808-4.017-2.695-6.17-1.884"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M165.89,202.107c1.445-3.99,4.992-7.002,8.989-8.427c3.997-1.425,8.396-1.398,12.566-0.614        c4.17,0.784,8.164,2.295,12.132,3.798c2.889,1.094,5.841,2.225,8.189,4.232c2.324,1.986,3.91,4.721,4.965,7.59        c1.983,5.391,2.066,9.338-0.258,14.591c-1.011,2.287-0.188,4.846-1.094,7.176c-0.906,2.33-5.111,5.103-3.805,7.235"/> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#FFBE9D;" d="M205.617,263.757l-1.854-54.693c-0.079-2.291-1.897-4.141-4.186-4.258l-23.717-4.648                c-7.536-0.387-12.019,9.108-12.086,16.654c-0.074,8.383,0.165,18.621,1.492,24.801                c2.669,12.427,12.362,13.503,12.362,13.503c0-0.025,0.274,4.85,0.528,9.227l-0.662,0.022l-2.872,1.503                c0,0-4.052,25.674,10.842,23.508c5.922-0.861,28.517-22.246,28.517-22.246L205.617,263.757z"/> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M167.064,225.209c0.016,0.85,0.749,1.538,1.638,1.538                         c0.887,0,1.594-0.688,1.579-1.539c-0.016-0.85-0.749-1.539-1.636-1.539                         C167.756,223.669,167.048,224.359,167.064,225.209z"/> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M166.233,221.197c0.21,0.199,1.38-0.768,3.11-0.857                          c1.727-0.114,3.045,0.707,3.221,0.486c0.087-0.099-0.137-0.466-0.711-0.839                          c-0.566-0.371-1.515-0.711-2.592-0.648c-1.077,0.064-1.962,0.51-2.461,0.944                          C166.289,220.719,166.129,221.108,166.233,221.197z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M183.437,224.287c0.016,0.851,0.749,1.539,1.637,1.538                         c0.887-0.001,1.595-0.688,1.579-1.539c-0.016-0.85-0.749-1.539-1.636-1.539                         C184.129,222.747,183.421,223.437,183.437,224.287z"/> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M183.299,221.412c0.211,0.199,1.382-0.768,3.11-0.857                          c1.727-0.114,3.045,0.707,3.221,0.486c0.087-0.099-0.134-0.466-0.711-0.839                          c-0.566-0.372-1.515-0.711-2.592-0.649c-1.077,0.064-1.962,0.51-2.461,0.945                          C183.357,220.934,183.197,221.323,183.299,221.412z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M177.715,234.58c0.003-0.099-1.083-0.226-2.837-0.355                         c-0.444-0.022-0.867-0.087-0.958-0.384c-0.121-0.314,0.038-0.8,0.224-1.325                         c0.358-1.091,0.732-2.235,1.124-3.434c1.555-4.887,2.655-8.896,2.458-8.957                         c-0.197-0.061-1.618,3.851-3.173,8.738c-0.373,1.205-0.73,2.353-1.069,3.451                         c-0.14,0.511-0.397,1.096-0.135,1.746c0.137,0.324,0.474,0.546,0.761,0.606                         c0.288,0.071,0.536,0.063,0.756,0.064C176.626,234.73,177.714,234.679,177.715,234.58z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M177.627,255.115c0,0,8.462,0.088,16.545-5.386c0,0-3.769,8.848-16.378,8.354                        L177.627,255.115z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M182.256,216.389c0.196,0.461,1.911,0.145,3.954,0.28                     c2.046,0.094,3.714,0.599,3.961,0.163c0.109-0.208-0.2-0.635-0.886-1.055c-0.681-0.419-1.751-0.795-2.976-0.864                     c-1.225-0.067-2.331,0.186-3.054,0.527C182.525,215.78,182.171,216.17,182.256,216.389z"/> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M166.643,216.968c0.326,0.376,1.495-0.096,2.927-0.192                     c1.428-0.147,2.661,0.121,2.918-0.305c0.112-0.206-0.101-0.589-0.651-0.932                     c-0.543-0.342-1.433-0.598-2.416-0.515c-0.983,0.084-1.817,0.487-2.293,0.916                     C166.643,216.37,166.499,216.783,166.643,216.968z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#EB996E;" d="M178.673,238.517c0.539-0.798,1.532-1.274,2.548-1.22                 c0.704,0.038,1.43,0.337,1.886,0.884c0.456,0.547,0.589,1.352,0.232,1.916c-0.402,0.636-1.304,0.826-2.086,0.649                 c-0.782-0.177-1.472-0.648-2.128-1.119c-0.182-0.13-0.368-0.266-0.486-0.452c-0.119-0.185-0.156-0.435-0.03-0.6"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <g> <path style="fill:#263238;" d="M182.589,235.525c-0.263-0.001-0.172,1.75-1.603,3.074                  c-1.428,1.328-3.306,1.232-3.306,1.478c-0.019,0.111,0.434,0.318,1.223,0.297c0.774-0.015,1.889-0.325,2.765-1.135                  c0.873-0.811,1.211-1.85,1.232-2.571C182.926,235.932,182.708,235.509,182.589,235.525z"/> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> </g> <g> <g> <path style="fill:#263238;" d="M165.678,205.471c0.82,3.933,7.125,4.228,11.02,3.245c2.78,3.239,7.297,4.89,11.51,4.206        c0.573-0.093,1.174-0.224,1.72-0.027c0.578,0.208,0.966,0.737,1.361,1.208c1.764,2.106,4.335,3.518,7.059,3.877        c0.753,3.931,4.141,7.215,8.093,7.846c0,0,1.251-0.709,0.513-5.749c-0.739-5.04-0.782-15.608-0.782-15.608l-14.073-5.459        l-16.578-2.135C175.521,196.874,164.29,198.816,165.678,205.471z"/> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M212.275,223.856c-0.109,0.023-0.029-1.387-1.05-3.474c-0.516-1.024-1.346-2.194-2.629-3.148         c-1.271-0.952-3.002-1.686-4.96-1.771l-0.219-0.01l-0.067-0.215c-0.612-1.966-1.681-4.096-3.568-5.564         c-1.82-1.442-4.692-2.05-6.927-0.773l-0.369,0.211l-0.168-0.407c-0.058-0.141-0.121-0.294-0.184-0.447         c-1.504-3.539-5.149-5.66-8.424-5.799c-0.832-0.031-1.616,0.055-2.423,0.203c-0.8,0.134-1.656,0.257-2.484,0.026         c-0.836-0.238-1.433-0.808-1.935-1.305c-0.502-0.517-0.961-0.97-1.486-1.306c-2.132-1.368-4.407-1.182-5.722-0.773         c-1.366,0.428-1.971,1.003-2.015,0.937c-0.016-0.02,0.129-0.159,0.428-0.408c0.317-0.217,0.794-0.553,1.496-0.803         c1.345-0.507,3.738-0.817,6.098,0.606c1.203,0.667,1.971,2.089,3.3,2.459c1.334,0.347,2.968-0.432,4.771-0.319         c3.53,0.119,7.434,2.346,9.08,6.194c0.068,0.167,0.137,0.333,0.2,0.487l-0.537-0.196c2.601-1.465,5.747-0.739,7.738,0.853         c2.044,1.622,3.128,3.891,3.734,5.946l-0.286-0.224c2.104,0.126,3.923,0.948,5.241,1.992c1.332,1.048,2.16,2.31,2.646,3.398         c0.492,1.096,0.66,2.03,0.725,2.659C212.337,223.518,212.302,223.855,212.275,223.856z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M189.871,211.821c0.013,0.041-0.337,0.208-1.013,0.398c-0.675,0.191-1.691,0.357-2.959,0.331         c-2.492-0.019-6.182-1.088-8.803-4.12l0.462,0.084c-0.127,0.066-0.264,0.138-0.402,0.209         c-1.838,0.901-3.851,1.111-5.585,0.837c-1.748-0.273-3.191-1.043-4.216-1.861c-1.034-0.825-1.674-1.696-2.043-2.321         c-0.368-0.631-0.487-1.02-0.447-1.039c0.118-0.084,0.774,1.453,2.807,2.941c1.011,0.722,2.376,1.386,3.999,1.603         c1.612,0.218,3.47,0.001,5.159-0.827c0.127-0.066,0.253-0.131,0.369-0.192l0.27-0.14l0.193,0.224         c2.437,2.832,5.88,3.937,8.266,4.085C188.362,212.215,189.841,211.68,189.871,211.821z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M182.397,204.806c-0.017,0.219-1.838,0.164-3.941,0.786c-2.112,0.596-3.622,1.613-3.754,1.437         c-0.134-0.136,1.275-1.504,3.547-2.15C180.516,204.215,182.438,204.62,182.397,204.806z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M177.627,204.663c-0.155,0.142-0.826-0.353-1.667-0.889c-0.837-0.544-1.565-0.948-1.501-1.148         c0.056-0.192,0.971-0.078,1.902,0.524C177.295,203.747,177.779,204.533,177.627,204.663z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M197.516,210.852c-0.067,0.208-1.681-0.217-3.675-0.037c-1.997,0.152-3.518,0.838-3.618,0.643         c-0.113-0.155,1.377-1.211,3.557-1.383C195.957,209.885,197.602,210.68,197.516,210.852z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M201.366,217.368c0.018,0.189-2.351,0.423-5.127-0.389c-2.782-0.793-4.66-2.254-4.545-2.405         c0.116-0.188,2.092,0.937,4.751,1.692C199.097,217.045,201.368,217.148,201.366,217.368z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M210.195,221.683c-0.158,0.152-1.388-1.084-3.369-1.643c-1.969-0.601-3.673-0.227-3.723-0.44         c-0.097-0.171,1.721-0.935,3.932-0.272C209.253,219.966,210.369,221.591,210.195,221.683z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M208.933,203.693c-0.06,0.024-0.223-0.409-0.705-1.051c-0.485-0.636-1.355-1.435-2.651-2.067         c-2.583-1.256-6.651-2.038-11.077-1.841c-4.448,0.198-8.384,1.275-11.181,2.128c-2.8,0.874-4.51,1.512-4.551,1.406         c-0.018-0.046,0.384-0.266,1.137-0.604c0.753-0.339,1.857-0.799,3.248-1.3c2.776-0.987,6.757-2.168,11.315-2.371         c4.546-0.198,8.694,0.675,11.354,2.118c1.329,0.724,2.209,1.644,2.644,2.368C208.9,203.21,208.968,203.684,208.933,203.693z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M210.335,210.428c-0.139,0.057-0.525-1.516-2.13-3.424c-1.562-1.906-4.494-3.972-8.195-4.811         c-3.713-0.83-7.227-0.507-9.709-0.2c-2.497,0.325-4.038,0.624-4.062,0.512c-0.02-0.087,1.478-0.568,3.982-1.031         c2.487-0.441,6.085-0.867,9.954-0.005c3.876,0.877,6.914,3.126,8.44,5.206c0.777,1.036,1.241,1.985,1.47,2.666         C210.319,210.022,210.376,210.417,210.335,210.428z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M163.683,218.311c-0.012,0.067-1.161-0.246-2.416-1.601c-1.233-1.295-2.464-3.839-1.891-6.683         c0.619-2.835,2.769-4.669,4.419-5.359c1.694-0.735,2.872-0.561,2.856-0.494c0.017,0.135-1.109,0.161-2.626,0.966         c-1.488,0.762-3.373,2.51-3.922,5.04c-0.515,2.536,0.508,4.894,1.564,6.19C162.732,217.717,163.753,218.194,163.683,218.311z         "/> </g> </g> </g> <g> <g> <g> <path style="fill:#263238;" d="M215.937,235.11c-0.07-0.114,1.199-0.785,2.994-2.131c0.876-0.687,1.857-1.613,2.527-2.89         c0.679-1.257,0.9-2.909,0.216-4.415c-0.645-1.506-1.907-2.625-3.225-3.129c-1.339-0.506-2.694-0.467-3.764-0.24         c-2.175,0.488-3.238,1.536-3.314,1.415c-0.029-0.032,0.195-0.316,0.709-0.718c0.518-0.387,1.339-0.899,2.481-1.207         c1.128-0.309,2.608-0.421,4.124,0.108c1.507,0.536,2.936,1.77,3.671,3.479c0.787,1.707,0.497,3.679-0.296,5.031         c-0.775,1.39-1.87,2.331-2.818,2.989c-0.959,0.658-1.792,1.076-2.368,1.354C216.295,235.029,215.962,235.154,215.937,235.11z         "/> </g> </g> </g> <g> <g> <g> <path style="fill:#263238;" d="M216.522,235.182c0.047-0.019,0.256,0.364,0.579,1.082c0.32,0.718,0.761,1.771,1.177,3.125         c0.407,1.352,0.799,3.024,0.788,4.931c-0.01,1.885-0.429,4.046-1.689,5.911c-1.27,1.859-3.251,3.043-5.194,3.291         c-1.967,0.295-3.757-0.556-4.742-1.617c-1.03-1.057-1.425-2.251-1.468-3.054c-0.053-0.814,0.124-1.241,0.156-1.231         c0.067,0.008-0.005,0.446,0.131,1.193c0.125,0.739,0.566,1.8,1.548,2.717c0.96,0.924,2.529,1.61,4.281,1.315         c1.728-0.254,3.527-1.348,4.674-3.031c1.152-1.702,1.574-3.711,1.619-5.505c0.048-1.808-0.275-3.437-0.61-4.779         C217.057,236.847,216.402,235.226,216.522,235.182z"/> </g> </g> </g> </g> <g> <g> <g> <path style="fill:#263238;" d="M197.111,211.722c-1.564,3.115-0.367,6.889,1.235,9.985c1.602,3.096,3.647,6.162,3.781,9.645        c0.225,5.834-4.988,10.993-4.268,16.787c0.428,3.447,3.184,6.481,6.574,7.239c-2.76-1.856-3.011-5.915-1.956-9.069        c1.055-3.154,6.16-11.467,6.9-14.71c2.486-10.892,1.425-12.158-2.383-15.988"/> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M207.612,219.487c0.008,0.089-0.767,0.267-2.023,0.086c-1.242-0.171-2.969-0.793-4.414-2.126         c-1.445-1.335-2.203-3.006-2.474-4.23c-0.281-1.238-0.165-2.024-0.076-2.023c0.119-0.008,0.2,0.749,0.594,1.872         c0.385,1.117,1.156,2.604,2.473,3.82c1.317,1.214,2.861,1.865,4.005,2.159C206.849,219.348,207.61,219.367,207.612,219.487z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M203.076,251.913c-0.017,0.021-0.149-0.064-0.388-0.248c-0.237-0.186-0.561-0.496-0.916-0.951         c-0.689-0.902-1.501-2.487-1.474-4.597c0.004-1.043,0.254-2.201,0.848-3.3c0.598-1.094,1.512-2.04,2.424-2.999         c0.923-0.957,1.803-1.987,2.356-3.274c0.565-1.273,0.844-2.729,0.778-4.205c-0.065-1.481-0.487-2.887-1.194-4.101         c-0.692-1.226-1.586-2.29-2.433-3.314c-1.749-2.016-3.136-4.072-3.95-5.95c-0.836-1.875-1.127-3.541-1.176-4.679         c-0.047-1.144,0.089-1.767,0.127-1.762c0.158-0.027-0.219,2.598,1.54,6.215c0.859,1.801,2.225,3.735,3.998,5.723         c0.864,1.015,1.798,2.096,2.546,3.397c0.764,1.289,1.24,2.841,1.306,4.437c0.071,1.597-0.236,3.169-0.858,4.544         c-0.609,1.392-1.595,2.516-2.532,3.456c-0.935,0.953-1.814,1.839-2.381,2.824c-0.558,0.98-0.823,2.034-0.859,3.004         c-0.094,1.961,0.59,3.495,1.178,4.409C202.627,251.464,203.124,251.859,203.076,251.913z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#455A64;" d="M208.884,219.077c0.03-0.032,0.336,0.184,0.8,0.675c0.467,0.486,1.05,1.292,1.558,2.398         c1.035,2.192,1.498,5.727,0.398,9.298c-1.11,3.556-3.169,6.265-4.708,8.064c-1.566,1.803-2.669,2.781-2.737,2.717         c-0.087-0.079,0.878-1.19,2.318-3.057c1.417-1.865,3.34-4.552,4.397-7.947c1.042-3.389,0.692-6.731-0.166-8.866         C209.903,220.186,208.769,219.174,208.884,219.077z"/> </g> </g> </g> </g> </g> <g> <g> <g> <g> <g> <path style="fill:#455A64;" d="M107.074,393.717c-0.077,0.104-7.883-5.588-17.433-12.71         c-9.553-7.125-17.232-12.984-17.155-13.087c0.077-0.104,7.882,5.586,17.435,12.712         C99.47,387.754,107.151,393.613,107.074,393.717z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M223.559,394.789l-23.616-19.413l0,0c-2.604-14.463-15.929-25.271-31.378-23.863h0         c-5.822,0.53-11.35,2.796-15.869,6.504l-13.69,10.729c-21.28-5.803-53.63-14.874-70.255-19.549         c-6.798-1.911-14.088-0.808-20.016,3.029l-0.312,0.202c-8.702,5.633-12.937,16.118-10.587,26.214v0         c1.492,6.411,5.486,11.952,11.098,15.39c8.398,5.145,21.403,13.08,32.585,19.767l-1.484,1.163l9.881,16.255l20.346-6.273         c13.753-1.962,42.788-5.739,42.788-5.739l-8.303-4.893l1.9-0.586c15.812,13.472,35.149,19.674,59.087,9.223         C217.551,417.413,224.926,404.103,223.559,394.789z"/> </g> <g> <g> <path style="fill:#455A64;" d="M183.094,392.623c0.005,0.006-0.06,0.067-0.192,0.179c-0.154,0.127-0.35,0.288-0.594,0.489          c-0.555,0.443-1.33,1.061-2.314,1.847c-0.507,0.401-1.068,0.843-1.68,1.326c-0.613,0.487-1.336,0.937-2.082,1.464          c-0.755,0.517-1.56,1.07-2.414,1.655c-0.429,0.29-0.863,0.6-1.323,0.897c-0.469,0.282-0.95,0.572-1.442,0.868          c-1.975,1.179-4.106,2.529-6.521,3.749c-1.198,0.627-2.42,1.31-3.711,1.948c-1.302,0.617-2.642,1.252-4.015,1.903          c-5.532,2.521-11.727,5.058-18.369,7.316c-13.271,4.573-25.541,7.865-34.329,10.53c-2.203,0.648-4.189,1.255-5.928,1.805          c-1.743,0.538-3.244,1.002-4.46,1.416c-1.196,0.389-2.138,0.695-2.813,0.914c-0.302,0.093-0.545,0.168-0.736,0.227          c-0.167,0.049-0.253,0.07-0.256,0.062c-0.003-0.007,0.079-0.044,0.24-0.107c0.187-0.07,0.424-0.159,0.72-0.271          c0.669-0.239,1.601-0.573,2.786-0.998c1.208-0.44,2.701-0.93,4.438-1.492c1.733-0.575,3.714-1.204,5.912-1.872          c8.769-2.747,21.023-6.09,34.272-10.655c6.631-2.255,12.815-4.773,18.342-7.266c1.373-0.643,2.712-1.271,4.013-1.88          c1.291-0.63,2.512-1.304,3.711-1.922c2.417-1.202,4.55-2.531,6.531-3.688c0.494-0.291,0.976-0.575,1.447-0.852          c0.461-0.291,0.897-0.595,1.328-0.88c0.858-0.573,1.668-1.114,2.428-1.621c0.751-0.515,1.48-0.954,2.099-1.429          c0.62-0.47,1.187-0.901,1.701-1.291c1.006-0.755,1.797-1.349,2.365-1.775c0.256-0.186,0.461-0.335,0.623-0.453          C183.013,392.665,183.089,392.617,183.094,392.623z"/> </g> </g> <g> <g> <path style="fill:#455A64;" d="M184.857,400.223c0.012,0.03-0.249,0.165-0.733,0.384c-0.483,0.222-1.195,0.511-2.084,0.842          c-1.779,0.663-4.29,1.45-7.125,2.061c-2.837,0.608-5.45,0.922-7.344,1.048c-0.947,0.064-1.715,0.092-2.246,0.089          c-0.531-0.001-0.825-0.016-0.826-0.049c-0.003-0.072,1.165-0.159,3.042-0.37c1.877-0.209,4.46-0.573,7.276-1.176          c2.814-0.607,5.319-1.336,7.116-1.916C183.729,400.557,184.83,400.156,184.857,400.223z"/> </g> </g> <g> <g> <path style="fill:#455A64;" d="M149.787,360.749c0.079,0.102-15.472,12.322-34.73,27.29          c-19.265,14.974-34.941,27.025-35.021,26.923c-0.079-0.102,15.469-12.319,34.733-27.293          C134.028,372.701,149.708,360.647,149.787,360.749z"/> </g> </g> </g> </g> <g> <g> <path style="fill:#455A64;" d="M205.709,413.19c-0.018,0-0.034-0.175-0.049-0.506c-0.01-0.391-0.023-0.87-0.038-1.449        c-0.013-1.258-0.067-3.078-0.177-5.323c-0.214-4.489-0.783-10.683-2.039-17.425c-1.268-6.742-2.979-12.722-4.404-16.985        c-0.71-2.132-1.317-3.849-1.76-5.026c-0.196-0.546-0.357-0.996-0.489-1.365c-0.107-0.314-0.155-0.483-0.138-0.49        c0.017-0.007,0.097,0.148,0.235,0.45c0.157,0.359,0.348,0.798,0.581,1.33c0.502,1.156,1.164,2.857,1.92,4.981        c1.518,4.244,3.294,10.237,4.567,17.009c1.262,6.771,1.775,13,1.895,17.506c0.063,2.254,0.062,4.079,0.012,5.338        c-0.024,0.58-0.044,1.059-0.06,1.45C205.746,413.017,205.727,413.191,205.709,413.19z"/> </g> </g> <g> <g> <path style="fill:#455A64;" d="M145.733,412.944c0.006-0.006,0.075,0.044,0.202,0.149c0.149,0.127,0.332,0.283,0.556,0.475        c0.493,0.412,1.175,1.069,2.119,1.838c1.895,1.525,4.717,3.657,8.538,5.742c3.813,2.081,8.642,4.07,14.244,5.356        c0.694,0.186,1.41,0.311,2.135,0.437c0.724,0.125,1.454,0.27,2.197,0.383c1.495,0.155,3.012,0.407,4.576,0.448        c3.117,0.229,6.363,0.097,9.649-0.288c0.82-0.114,1.635-0.228,2.445-0.341c0.801-0.164,1.597-0.326,2.387-0.487        c1.581-0.318,3.111-0.76,4.599-1.233c2.967-0.974,5.738-2.191,8.222-3.622c4.998-2.836,8.753-6.57,11.146-10.179        c2.434-3.606,3.569-7,4.115-9.356c0.265-1.186,0.406-2.121,0.482-2.757c0.036-0.293,0.064-0.531,0.088-0.725        c0.023-0.163,0.039-0.247,0.048-0.246c0.009,0.001,0.011,0.085,0.005,0.25c-0.01,0.195-0.022,0.436-0.037,0.731        c-0.043,0.642-0.152,1.588-0.389,2.79c-0.489,2.388-1.583,5.84-4.007,9.517c-2.382,3.68-6.166,7.497-11.212,10.39        c-2.509,1.461-5.308,2.701-8.304,3.692c-1.502,0.482-3.047,0.93-4.644,1.254c-0.798,0.163-1.602,0.328-2.412,0.494        c-0.818,0.114-1.642,0.229-2.47,0.345c-3.319,0.389-6.598,0.519-9.744,0.281c-1.578-0.046-3.109-0.303-4.617-0.466        c-0.749-0.117-1.485-0.266-2.215-0.395c-0.731-0.129-1.452-0.259-2.152-0.45c-5.645-1.322-10.497-3.364-14.314-5.501        c-3.824-2.141-6.628-4.331-8.491-5.91c-0.928-0.796-1.59-1.479-2.061-1.916c-0.211-0.207-0.382-0.376-0.521-0.513        C145.782,413.014,145.726,412.95,145.733,412.944z"/> </g> </g> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M156.899,417.754c-4.099-2.186-8.7-0.894-12.622,0.428c-2.61,0.88-5.323,2.273-7.974,1.527      c-1.917-0.54-3.343-2.093-4.807-3.444c-5.906-5.447-14.049-8.417-22.087-7.914c-2.283,0.143-4.514,1.062-6.066,2.742      c-4.026,4.36-0.989,10.035,2.608,13.701c6.351,6.473,14.999,10.645,24.019,11.587c7.496,0.783,17.805-0.253,25.408-3.508      c4.687-2.007,7.092-7.536,4.633-12.003C159.293,419.569,158.246,418.473,156.899,417.754z"/> <g style="opacity:0.4;"> <path d="M156.89,421.244c-4.099-2.186-8.7-0.894-12.622,0.428c-2.61,0.88-5.323,2.273-7.974,1.527       c-1.917-0.54-3.343-2.093-4.807-3.444c-5.906-5.447-14.049-8.417-22.087-7.914c-2.283,0.143-4.514,1.062-6.066,2.742       c-0.892,0.966-1.42,1.998-1.69,3.056c0.596,2.621,2.36,5.18,4.298,7.155c6.351,6.473,15,10.645,24.019,11.587       c7.496,0.783,17.805-0.253,25.408-3.508c2.818-1.206,4.8-3.688,5.408-6.445c-0.159-0.703-0.406-1.398-0.775-2.068       C159.284,423.059,158.237,421.962,156.89,421.244z"/> </g> </g> <g> <path style="fill:#263238;" d="M160.776,426.429c-0.075,0.025-0.055-1.002-1.005-2.428c-0.477-0.697-1.185-1.482-2.193-2.145      c-0.992-0.671-2.277-1.251-3.768-1.442c-3.043-0.357-6.569,0.924-10.487,1.983c-1.936,0.513-4.051,1.297-6.366,1.006      c-1.131-0.147-2.265-0.522-3.275-1.134c-1.007-0.603-1.923-1.349-2.815-2.119c-3.375-3.296-7.38-5.359-11.209-6.66      c-1.915-0.643-3.797-1.066-5.577-1.295c-1.782-0.235-3.459-0.264-4.961-0.029c-1.499,0.233-2.802,0.726-3.837,1.339      c-1.031,0.625-1.796,1.348-2.351,1.993c-1.088,1.317-1.455,2.218-1.514,2.184c0,0,0.29-0.933,1.348-2.321      c0.541-0.68,1.305-1.448,2.355-2.119c1.053-0.659,2.393-1.195,3.935-1.461c1.542-0.267,3.27-0.258,5.08-0.04      c1.814,0.213,3.73,0.626,5.681,1.266c1.952,0.635,3.935,1.503,5.884,2.597c0.963,0.561,1.946,1.143,2.864,1.864      c0.912,0.715,1.775,1.5,2.661,2.264c0.884,0.764,1.778,1.49,2.735,2.065c0.95,0.578,1.998,0.925,3.063,1.07      c2.145,0.283,4.201-0.45,6.165-0.961c3.899-1.021,7.487-2.298,10.668-1.88c3.158,0.503,5.191,2.4,6.092,3.857      c0.462,0.745,0.668,1.404,0.759,1.851C160.786,426.187,160.79,426.428,160.776,426.429z"/> </g> <g> <path style="fill:#263238;" d="M160.776,426.429c-0.075,0.025-0.055-1.002-1.005-2.428c-0.477-0.697-1.185-1.482-2.193-2.145      c-0.992-0.671-2.277-1.251-3.768-1.442c-3.043-0.357-6.569,0.924-10.487,1.983c-1.936,0.513-4.051,1.297-6.366,1.006      c-1.131-0.147-2.265-0.522-3.275-1.134c-1.007-0.603-1.923-1.349-2.815-2.119c-3.375-3.296-7.38-5.359-11.209-6.66      c-1.915-0.643-3.797-1.066-5.577-1.295c-1.782-0.235-3.459-0.264-4.961-0.029c-1.499,0.233-2.802,0.726-3.837,1.339      c-1.031,0.625-1.796,1.348-2.351,1.993c-1.088,1.317-1.455,2.218-1.514,2.184c0,0,0.29-0.933,1.348-2.321      c0.541-0.68,1.305-1.448,2.355-2.119c1.053-0.659,2.393-1.195,3.935-1.461c1.542-0.267,3.27-0.258,5.08-0.04      c1.814,0.213,3.73,0.626,5.681,1.266c1.952,0.635,3.935,1.503,5.884,2.597c0.963,0.561,1.946,1.143,2.864,1.864      c0.912,0.715,1.775,1.5,2.661,2.264c0.884,0.764,1.778,1.49,2.735,2.065c0.95,0.578,1.998,0.925,3.063,1.07      c2.145,0.283,4.201-0.45,6.165-0.961c3.899-1.021,7.487-2.298,10.668-1.88c3.158,0.503,5.191,2.4,6.092,3.857      c0.462,0.745,0.668,1.404,0.759,1.851C160.786,426.187,160.79,426.428,160.776,426.429z"/> </g> <g> <path style="fill:#263238;" d="M109.943,425.442c-0.038-0.062,0.753-0.634,2.099-1.454c1.345-0.82,3.253-1.874,5.43-2.899      c2.178-1.023,4.208-1.82,5.697-2.332c1.49-0.513,2.435-0.757,2.458-0.688c0.026,0.076-0.873,0.449-2.32,1.052      c-1.448,0.603-3.439,1.451-5.602,2.467c-2.162,1.017-4.085,2.009-5.473,2.74C110.846,425.056,109.985,425.51,109.943,425.442z"/> </g> <g> <path style="fill:#263238;" d="M111.351,429.541c-0.066-0.137,3.518-2.007,8.005-4.176c4.488-2.17,8.179-3.817,8.245-3.681      s-3.517,2.006-8.006,4.176C115.109,428.03,111.417,429.678,111.351,429.541z"/> </g> <g> <path style="fill:#263238;" d="M128.331,431.319c-0.081,0.129-4.449-2.477-9.754-5.82c-5.307-3.344-9.542-6.158-9.461-6.286      c0.081-0.129,4.448,2.477,9.755,5.82C124.176,428.376,128.412,431.19,128.331,431.319z"/> </g> <g> <path style="fill:#263238;" d="M130.789,427.066c-0.049,0.061-0.853-0.503-2.138-1.429c-1.285-0.926-3.057-2.206-5.041-3.582      c-1.985-1.375-3.805-2.586-5.124-3.464c-1.318-0.879-2.129-1.433-2.088-1.501c0.037-0.063,0.919,0.374,2.294,1.171      c1.375,0.796,3.238,1.961,5.232,3.342c1.992,1.382,3.736,2.718,4.964,3.726C130.117,426.336,130.835,427.009,130.789,427.066z"/> </g> </g> </g> </g> <g id="Speech_Bubbles"> <g> <g> <g> <path style="fill:#FAFAFA;" d="M451.513,210.603h-88.12c-2.449,0-4.434,1.985-4.434,4.434v29.572      c0,2.449,1.985,4.434,4.434,4.434h12.503v9.814l10.213-9.814h65.404c2.449,0,4.434-1.985,4.434-4.434v-29.572      C455.946,212.588,453.961,210.603,451.513,210.603z"/> </g> <g> <g> <path style="fill:#263238;" d="M451.513,210.603c0,0,0.182-0.015,0.538,0.013c0.354,0.034,0.888,0.134,1.52,0.445       c0.623,0.312,1.346,0.871,1.866,1.774c0.255,0.45,0.455,0.983,0.54,1.577c0.081,0.6,0.045,1.226,0.059,1.891       c0.018,5.344,0.043,13.093,0.076,22.789c0.003,1.214,0.005,2.457,0.008,3.731c-0.001,0.639-0.002,1.285-0.003,1.938       c-0.02,0.676-0.193,1.357-0.509,1.973c-0.63,1.231-1.87,2.19-3.305,2.426c-0.728,0.118-1.423,0.059-2.131,0.076       c-0.708,0.001-1.422,0.002-2.144,0.004c-5.772,0.008-11.971,0.017-18.54,0.026c-13.141,0.01-27.757,0.021-43.378,0.033       l0.176-0.071c-3.24,3.116-6.697,6.44-10.21,9.817l-0.438,0.421l0-0.608c0-3.111-0.001-6.447-0.001-9.814l0.26,0.26       c-1.777,0-3.691,0-5.614,0c-2.395-0.004-4.777-0.008-7.142-0.013c-1.25-0.059-2.456-0.652-3.271-1.588       c-0.833-0.92-1.231-2.212-1.169-3.405c0.001-4.657,0.003-9.245,0.004-13.754c0.002-4.508,0.004-8.937,0.006-13.275l0.001-1.622       c-0.001-0.526-0.01-1.107,0.123-1.66c0.245-1.108,0.921-2.1,1.833-2.748c0.899-0.664,2.072-0.939,3.13-0.878       c1.048,0.001,2.091,0.002,3.126,0.002c16.568,0.021,31.489,0.04,44.025,0.056c12.52,0.035,22.656,0.063,29.68,0.083       c3.492,0.021,6.207,0.038,8.069,0.049c0.911,0.011,1.609,0.02,2.099,0.026C451.27,210.585,451.513,210.603,451.513,210.603       s-0.242,0.018-0.715,0.027c-0.49,0.006-1.188,0.015-2.099,0.026c-1.862,0.011-4.577,0.028-8.069,0.049       c-7.024,0.02-17.16,0.048-29.68,0.083c-12.536,0.016-27.457,0.035-44.025,0.056c-1.036,0.001-2.078,0.002-3.126,0.002       c-1.034-0.053-2.021,0.196-2.845,0.791c-0.816,0.581-1.42,1.47-1.637,2.461c-0.118,0.494-0.111,0.999-0.109,1.549l0.001,1.622       c0.002,4.337,0.004,8.766,0.007,13.275c0.001,4.509,0.003,9.097,0.004,13.754c-0.053,1.132,0.3,2.227,1.041,3.062       c0.726,0.833,1.797,1.358,2.908,1.411c2.356,0.004,4.728,0.008,7.114,0.011c1.923,0,3.837,0,5.614,0h0.26v0.26       c0,3.367-0.001,6.703-0.001,9.814l-0.438-0.187c3.515-3.375,6.973-6.697,10.216-9.811l0.074-0.071l0.102,0       c15.621,0.012,30.238,0.023,43.378,0.033c6.569,0.009,12.768,0.018,18.54,0.026c0.721,0.001,1.436,0.002,2.144,0.004       c0.706-0.013,1.422,0.043,2.067-0.063c1.318-0.21,2.463-1.089,3.049-2.222c0.643-1.136,0.456-2.471,0.488-3.745       c0.003-1.273,0.006-2.517,0.008-3.731c0.032-9.696,0.058-17.444,0.076-22.789c-0.006-0.664,0.035-1.3-0.036-1.87       c-0.076-0.574-0.261-1.092-0.503-1.532c-0.492-0.882-1.187-1.44-1.79-1.759C452.283,210.519,451.496,210.659,451.513,210.603z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#E8505B;" d="M443.867,241.604c0.109,0.094-1.239,1.826-3.01,3.867c-0.322,0.365-0.632,0.717-0.934,1.06       l-0.183,0.208l-0.185-0.199c-1.374-1.479-2.315-2.603-2.23-2.684c0.085-0.081,1.169,0.905,2.59,2.339l-0.368,0.009       c0.296-0.347,0.601-0.704,0.917-1.074C442.235,243.089,443.759,241.51,443.867,241.604z"/> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M446.639,241.604c0.109,0.094-0.939,1.479-2.339,3.093c-0.609,0.702-1.184,1.331-1.641,1.802       l-0.166,0.171l-0.136-0.168c-0.554-0.684-0.872-1.143-0.812-1.198c0.06-0.054,0.486,0.307,1.111,0.927l-0.302,0.003       c0.402-0.519,0.944-1.177,1.552-1.879C445.307,242.742,446.53,241.51,446.639,241.604z"/> </g> </g> </g> <g> <g> <path style="fill:#263238;" d="M445.031,224.727c0,0.144-16.826,0.26-37.577,0.26c-20.758,0-37.58-0.117-37.58-0.26      s16.822-0.26,37.58-0.26C428.205,224.467,445.031,224.583,445.031,224.727z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M445.031,230.488c0,0.144-16.826,0.26-37.577,0.26c-20.758,0-37.58-0.117-37.58-0.26      c0-0.144,16.822-0.26,37.58-0.26C428.205,230.228,445.031,230.344,445.031,230.488z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M403.309,236.25c0,0.036-0.468,0.07-1.314,0.101c-0.95,0.022-2.151,0.05-3.583,0.083      c-3.025,0.047-7.204,0.076-11.82,0.076c-4.617,0-8.797-0.029-11.822-0.076c-1.432-0.033-2.633-0.061-3.582-0.083      c-0.846-0.031-1.314-0.065-1.314-0.101c0-0.036,0.468-0.07,1.314-0.101c0.95-0.022,2.15-0.05,3.582-0.083      c3.025-0.047,7.205-0.076,11.822-0.076c4.616,0,8.795,0.029,11.82,0.076c1.432,0.033,2.633,0.061,3.583,0.083      C402.842,236.18,403.309,236.214,403.309,236.25z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M408.502,156.296h-49.186c-2.449,0-4.434,1.985-4.434,4.434v29.572      c0,2.449,1.985,4.434,4.434,4.434h12.503h10.213h26.471c2.449,0,4.434-1.985,4.434-4.434V160.73      C412.936,158.281,410.951,156.296,408.502,156.296z"/> </g> <g> <g> <path style="fill:#263238;" d="M408.502,156.296c0,0,0.162-0.012,0.48,0c0.315,0.035,0.793,0.098,1.367,0.349       c0.565,0.253,1.245,0.683,1.792,1.427c0.559,0.723,0.948,1.788,0.895,2.979c0.02,4.714,0.048,11.495,0.083,19.863       c0.005,2.097,0.011,4.294,0.017,6.582c0.001,0.572,0.003,1.15,0.004,1.734c-0.009,0.581,0.036,1.169-0.058,1.797       c-0.184,1.233-0.906,2.401-1.978,3.128c-0.535,0.362-1.153,0.614-1.801,0.726c-0.662,0.114-1.296,0.064-1.929,0.077       c-1.274,0.002-2.568,0.004-3.881,0.006c-2.627,0.004-5.33,0.007-8.101,0.011c-11.09,0.006-23.279,0.013-36.073,0.02       c-1.703,0.011-3.344-0.979-4.134-2.462c-0.391-0.735-0.59-1.586-0.564-2.398c0-0.785,0-1.567,0-2.346       c0.001-3.116,0.003-6.187,0.004-9.204c0.005-6.034,0.01-11.854,0.015-17.4c-0.096-1.406,0.429-2.936,1.503-3.877       c0.522-0.48,1.148-0.846,1.82-1.046c0.672-0.213,1.394-0.204,2.033-0.197c2.626,0.005,5.176,0.009,7.642,0.013       c4.929,0.011,9.522,0.022,13.717,0.032c8.369,0.035,15.148,0.063,19.862,0.083c2.326,0.021,4.141,0.037,5.4,0.049       c0.599,0.011,1.066,0.02,1.404,0.026C408.34,156.278,408.502,156.296,408.502,156.296s-0.162,0.018-0.478,0.027       c-0.339,0.006-0.805,0.015-1.404,0.026c-1.259,0.011-3.074,0.028-5.4,0.049c-4.714,0.02-11.493,0.048-19.862,0.083       c-4.195,0.01-8.788,0.02-13.717,0.032c-2.466,0.004-5.016,0.009-7.642,0.013c-0.669-0.005-1.291-0.009-1.899,0.183       c-0.605,0.181-1.166,0.512-1.635,0.946c-0.965,0.871-1.429,2.177-1.342,3.533c0.005,5.545,0.01,11.366,0.015,17.4       c0.001,3.017,0.003,6.088,0.004,9.204c0,0.779,0,1.561,0.001,2.346c-0.023,0.76,0.156,1.488,0.502,2.15       c0.705,1.318,2.161,2.198,3.677,2.188c12.794,0.007,24.983,0.014,36.073,0.021c2.772,0.004,5.475,0.007,8.101,0.011       c1.313,0.002,2.607,0.004,3.881,0.006c0.638-0.009,1.277,0.037,1.854-0.064c0.587-0.1,1.147-0.325,1.634-0.652       c0.975-0.657,1.635-1.716,1.807-2.836c0.087-0.55,0.051-1.148,0.061-1.732c0.001-0.584,0.003-1.161,0.004-1.734       c0.006-2.288,0.012-4.484,0.017-6.582c0.035-8.369,0.063-15.149,0.083-19.863c0.065-1.166-0.291-2.173-0.818-2.887       c-0.514-0.729-1.165-1.161-1.71-1.423C409.182,156.24,408.491,156.345,408.502,156.296z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#E8505B;" d="M401.654,182.358c0.109,0.094-1.281,1.874-3.103,3.974c-0.331,0.376-0.651,0.739-0.961,1.091       l-0.183,0.208l-0.185-0.199c-1.415-1.521-2.385-2.676-2.3-2.757c0.085-0.081,1.198,0.936,2.66,2.412l-0.368,0.009       c0.304-0.356,0.618-0.724,0.944-1.105C399.98,183.89,401.545,182.264,401.654,182.358z"/> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M404.506,182.358c0.109,0.094-0.971,1.517-2.412,3.178c-0.626,0.722-1.218,1.37-1.687,1.855       l-0.166,0.171l-0.136-0.168c-0.571-0.703-0.9-1.174-0.839-1.229c0.06-0.055,0.496,0.319,1.138,0.958l-0.302,0.003       c0.414-0.534,0.972-1.211,1.599-1.933C403.141,183.534,404.397,182.264,404.506,182.358z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#E8505B;" d="M390.924,176.429c-0.061-0.94-0.471-1.837-1.064-2.569c-0.58-0.717-1.355-1.299-2.246-1.539       c-0.946-0.255-1.995-0.102-2.829,0.412c-0.496,0.306-0.912,0.738-1.209,1.239c-0.244-0.47-0.589-0.887-1.011-1.208       c-0.78-0.594-1.809-0.849-2.775-0.687c-0.91,0.152-1.738,0.655-2.386,1.312c-0.661,0.671-1.157,1.524-1.31,2.453       c-0.191,1.164-0.028,2.456,0.53,3.496c0.589,1.098,1.583,2.01,2.617,2.704c1.739,1.167,4.032,2.635,4.032,2.635       s2.067-1.394,3.913-2.385c1.097-0.59,2.175-1.4,2.869-2.435C390.711,178.876,391,177.606,390.924,176.429z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#E8505B;" d="M397.255,168.615c-0.032-0.483-0.242-0.944-0.546-1.32c-0.298-0.368-0.696-0.667-1.154-0.79       c-0.486-0.131-1.025-0.052-1.454,0.212c-0.255,0.157-0.468,0.379-0.621,0.637c-0.125-0.241-0.303-0.456-0.519-0.62       c-0.401-0.305-0.929-0.436-1.426-0.353c-0.467,0.078-0.893,0.336-1.225,0.674c-0.34,0.344-0.594,0.783-0.673,1.26       c-0.098,0.598-0.014,1.262,0.272,1.796c0.303,0.564,0.813,1.032,1.344,1.389c0.893,0.6,2.071,1.353,2.071,1.353       s1.062-0.716,2.01-1.225c0.564-0.303,1.118-0.719,1.474-1.251C397.146,169.872,397.294,169.219,397.255,168.615z"/> </g> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M233.932,135.693h-88.12c-2.449,0-4.434,1.985-4.434,4.434v29.572      c0,2.449,1.985,4.434,4.434,4.434h12.503v9.814l10.213-9.814h65.404c2.449,0,4.434-1.985,4.434-4.434v-29.572      C238.365,137.678,236.38,135.693,233.932,135.693z"/> </g> <g> <g> <path style="fill:#263238;" d="M233.932,135.693c0,0,0.182-0.015,0.538,0.012c0.354,0.034,0.888,0.134,1.52,0.445       c0.623,0.312,1.346,0.871,1.866,1.774c0.255,0.45,0.455,0.983,0.54,1.577c0.081,0.6,0.045,1.226,0.059,1.891       c0.018,5.344,0.043,13.093,0.076,22.789c0.003,1.214,0.005,2.457,0.008,3.731c-0.001,0.639-0.002,1.285-0.003,1.938       c-0.02,0.676-0.193,1.357-0.509,1.973c-0.63,1.231-1.87,2.19-3.305,2.426c-0.728,0.118-1.424,0.059-2.131,0.076       c-0.708,0.001-1.423,0.002-2.144,0.004c-5.772,0.008-11.971,0.017-18.54,0.026c-13.141,0.01-27.757,0.021-43.378,0.033       l0.176-0.071c-3.24,3.116-6.697,6.44-10.209,9.817l-0.438,0.421l0-0.608c0-3.111-0.001-6.447-0.001-9.814l0.26,0.26       c-1.777,0-3.691,0-5.614,0c-2.395-0.004-4.777-0.009-7.142-0.013c-1.25-0.059-2.456-0.652-3.271-1.588       c-0.833-0.92-1.231-2.212-1.169-3.405c0.001-4.657,0.003-9.245,0.004-13.754c0.002-4.508,0.004-8.937,0.006-13.275l0.001-1.622       c-0.002-0.526-0.01-1.107,0.123-1.66c0.245-1.109,0.921-2.1,1.833-2.748c0.899-0.664,2.072-0.94,3.13-0.878       c1.048,0.001,2.09,0.002,3.126,0.003c16.568,0.021,31.489,0.04,44.025,0.056c12.52,0.035,22.656,0.063,29.68,0.083       c3.492,0.021,6.207,0.038,8.069,0.049c0.911,0.011,1.609,0.02,2.099,0.026C233.689,135.676,233.932,135.693,233.932,135.693       s-0.242,0.018-0.715,0.027c-0.49,0.006-1.188,0.015-2.099,0.026c-1.862,0.011-4.577,0.028-8.069,0.049       c-7.024,0.02-17.16,0.048-29.68,0.083c-12.536,0.016-27.457,0.035-44.025,0.056c-1.036,0.001-2.078,0.002-3.126,0.002       c-1.034-0.053-2.021,0.196-2.845,0.791c-0.816,0.581-1.42,1.47-1.638,2.461c-0.117,0.494-0.111,0.999-0.109,1.549l0.001,1.622       c0.002,4.337,0.004,8.766,0.006,13.275c0.001,4.509,0.003,9.097,0.004,13.754c-0.053,1.132,0.3,2.228,1.041,3.062       c0.726,0.833,1.797,1.358,2.908,1.411c2.356,0.004,4.728,0.008,7.114,0.011c1.923,0,3.837,0,5.614,0h0.26v0.26       c-0.001,3.367-0.001,6.703-0.001,9.814l-0.438-0.187c3.515-3.375,6.973-6.697,10.216-9.811l0.074-0.071l0.102,0       c15.621,0.012,30.238,0.023,43.378,0.033c6.569,0.009,12.768,0.018,18.54,0.026c0.721,0.001,1.436,0.002,2.144,0.004       c0.706-0.013,1.422,0.043,2.067-0.063c1.318-0.21,2.463-1.089,3.049-2.222c0.643-1.136,0.456-2.471,0.488-3.745       c0.003-1.273,0.006-2.517,0.008-3.731c0.032-9.696,0.058-17.444,0.076-22.789c-0.006-0.664,0.035-1.3-0.036-1.87       c-0.076-0.574-0.261-1.092-0.503-1.532c-0.492-0.882-1.187-1.44-1.79-1.759C234.702,135.609,233.915,135.749,233.932,135.693z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#E8505B;" d="M226.286,166.694c0.109,0.094-1.239,1.826-3.01,3.867c-0.322,0.365-0.632,0.717-0.934,1.06       l-0.183,0.208l-0.185-0.199c-1.374-1.479-2.315-2.603-2.23-2.684c0.085-0.081,1.169,0.905,2.59,2.339l-0.368,0.009       c0.296-0.347,0.601-0.704,0.917-1.074C224.654,168.179,226.178,166.6,226.286,166.694z"/> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M229.058,166.694c0.109,0.094-0.938,1.479-2.339,3.093c-0.609,0.702-1.184,1.331-1.641,1.802       l-0.166,0.171l-0.136-0.168c-0.554-0.684-0.872-1.143-0.812-1.198c0.06-0.055,0.486,0.307,1.111,0.927l-0.302,0.003       c0.402-0.519,0.944-1.177,1.552-1.879C227.726,167.832,228.949,166.6,229.058,166.694z"/> </g> </g> </g> <g> <g> <path style="fill:#263238;" d="M227.45,149.817c0,0.144-16.826,0.26-37.576,0.26c-20.758,0-37.58-0.117-37.58-0.26      s16.822-0.26,37.58-0.26C210.624,149.557,227.45,149.673,227.45,149.817z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M227.45,155.578c0,0.144-16.826,0.261-37.576,0.261c-20.758,0-37.58-0.117-37.58-0.261      c0-0.144,16.822-0.26,37.58-0.26C210.624,155.318,227.45,155.435,227.45,155.578z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M185.728,161.34c0,0.036-0.468,0.07-1.314,0.101c-0.95,0.022-2.151,0.05-3.583,0.083      c-3.025,0.047-7.204,0.076-11.82,0.076c-4.617,0-8.797-0.029-11.822-0.076c-1.432-0.033-2.633-0.061-3.582-0.083      c-0.846-0.031-1.314-0.065-1.314-0.101c0-0.036,0.468-0.07,1.314-0.101c0.95-0.022,2.15-0.05,3.582-0.083      c3.025-0.047,7.205-0.076,11.822-0.076c4.616,0,8.795,0.029,11.82,0.076c1.432,0.033,2.633,0.061,3.583,0.083      C185.26,161.27,185.728,161.304,185.728,161.34z"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M90.318,238.939h49.187c2.449,0,4.434,1.985,4.434,4.434v29.572c0,2.449-1.985,4.434-4.434,4.434      h-12.503v9.814l-10.213-9.814H90.318c-2.449,0-4.434-1.985-4.434-4.434v-29.572C85.885,240.924,87.87,238.939,90.318,238.939z"/> </g> <g> <g> <path style="fill:#263238;" d="M90.318,238.939c0.004,0.032-0.468-0.011-1.306,0.24c-0.802,0.265-2.054,0.96-2.71,2.521       c-0.153,0.386-0.26,0.814-0.304,1.273c-0.031,0.455-0.008,0.959-0.011,1.474c0.006,1.037,0.012,2.164,0.019,3.379       c0.01,2.435,0.022,5.219,0.034,8.319c0.009,3.104,0.02,6.524,0.03,10.225c0.004,1.852,0.009,3.774,0.014,5.761       c0.006,0.501-0.02,1.001,0.059,1.469c0.075,0.476,0.231,0.943,0.465,1.373c0.473,0.858,1.262,1.555,2.205,1.912       c0.932,0.394,2.012,0.251,3.108,0.276c1.089-0.002,2.192-0.004,3.31-0.005c2.236-0.003,4.529-0.007,6.876-0.01       c4.693-0.005,9.599-0.01,14.681-0.015l0.1,0l0.072,0.069c3.263,3.132,6.698,6.428,10.219,9.808l-0.435,0.185       c-0.001-3.121-0.002-6.445-0.003-9.814l0-0.26h0.26c1.781,0,3.692,0,5.616,0c1.719,0,3.427,0,5.125,0       c0.838-0.021,1.725,0.052,2.488-0.067c0.78-0.135,1.52-0.499,2.096-1.037c0.583-0.529,1.008-1.23,1.206-1.984       c0.219-0.741,0.129-1.569,0.149-2.401c0.001-1.648,0.002-3.283,0.002-4.904c0.005-6.482,0.01-12.734,0.015-18.692       c0.002-1.489,0.003-2.96,0.005-4.411c0.071-1.404-0.558-2.754-1.628-3.572c-0.53-0.406-1.147-0.699-1.798-0.812       c-0.637-0.117-1.339-0.063-2.023-0.077c-1.368-0.002-2.715-0.005-4.04-0.007c-5.296-0.011-10.229-0.022-14.736-0.032       c-8.993-0.035-16.277-0.063-21.337-0.083c-2.502-0.021-4.452-0.038-5.801-0.049c-0.646-0.011-1.148-0.02-1.509-0.026       C90.493,238.957,90.318,238.939,90.318,238.939s0.174-0.018,0.514-0.027c0.361-0.006,0.862-0.015,1.509-0.026       c1.349-0.011,3.3-0.028,5.801-0.049c5.06-0.02,12.344-0.048,21.337-0.083c4.506-0.01,9.44-0.02,14.736-0.032       c1.324-0.002,2.671-0.005,4.04-0.007c0.681,0.015,1.37-0.049,2.106,0.079c0.721,0.123,1.408,0.446,1.996,0.894       c1.188,0.89,1.893,2.43,1.817,3.934c0.002,1.451,0.003,2.922,0.005,4.411c0.005,5.957,0.01,12.21,0.015,18.692       c0.001,1.621,0.001,3.256,0.002,4.904l0.001,1.239c-0.008,0.427-0.04,0.875-0.165,1.296c-0.222,0.85-0.7,1.637-1.354,2.232       c-0.647,0.604-1.479,1.014-2.357,1.167c-0.906,0.134-1.722,0.052-2.578,0.076c-1.697,0-3.406,0-5.125,0       c-1.924,0-3.834,0-5.616,0l0.26-0.26c-0.001,3.369-0.002,6.693-0.003,9.814l0,0.604l-0.435-0.419       c-3.517-3.384-6.948-6.685-10.207-9.82l0.172,0.069c-5.082-0.005-9.988-0.01-14.681-0.015c-2.346-0.003-4.64-0.007-6.876-0.01       c-1.118-0.002-2.221-0.004-3.31-0.006c-0.545-0.001-1.085-0.002-1.622-0.004c-0.563-0.003-1.12-0.112-1.637-0.311       c-1.037-0.397-1.9-1.167-2.415-2.11c-0.255-0.473-0.425-0.986-0.505-1.508c-0.085-0.531-0.053-1.04-0.058-1.531       c0.005-1.988,0.009-3.91,0.014-5.761c0.011-3.701,0.021-7.12,0.03-10.225c0.013-3.099,0.024-5.883,0.034-8.319       c0.007-1.215,0.013-2.342,0.019-3.379c0.009-0.52-0.009-1.006,0.031-1.491c0.053-0.478,0.17-0.922,0.336-1.32       c0.707-1.61,2.014-2.295,2.838-2.539C89.85,238.868,90.318,238.939,90.318,238.939z"/> </g> </g> </g> <g> <g> <circle style="fill:#263238;" cx="104.277" cy="258.324" r="2.702"/> </g> <g> <path style="fill:#263238;" d="M117.614,258.324c0,1.492-1.21,2.702-2.702,2.702c-1.492,0-2.702-1.21-2.702-2.702      s1.21-2.702,2.702-2.702C116.404,255.622,117.614,256.832,117.614,258.324z"/> </g> <g> <circle style="fill:#263238;" cx="125.546" cy="258.324" r="2.702"/> </g> </g> </g> <g> <g> <g> <path style="fill:#FAFAFA;" d="M134.973,183.321H60.962c-2.449,0-4.434,1.985-4.434,4.434v29.572      c0,2.449,1.985,4.434,4.434,4.434H98.29h10.213h26.471c2.449,0,4.434-1.985,4.434-4.434v-29.572      C139.407,185.306,137.422,183.321,134.973,183.321z"/> </g> <g> <g> <path style="fill:#263238;" d="M134.973,183.321c0,0,0.207-0.023,0.608,0.02c0.398,0.041,1.005,0.164,1.691,0.567       c0.681,0.389,1.442,1.097,1.89,2.18c0.487,1.098,0.295,2.472,0.346,3.94c0.02,5.965,0.048,14.565,0.083,25.183       c0.001,0.665,0.003,1.337,0.004,2.017c0.014,0.7-0.131,1.428-0.447,2.081c-0.607,1.318-1.908,2.345-3.412,2.584       c-0.765,0.116-1.485,0.053-2.227,0.072c-0.74,0.001-1.487,0.003-2.241,0.004c-1.508,0.002-3.044,0.005-4.607,0.007       c-6.252,0.008-12.932,0.016-19.959,0.024c-14.059,0.006-29.513,0.013-45.734,0.02c-1.073-0.005-2.141-0.377-2.968-1.054       c-0.826-0.677-1.411-1.633-1.631-2.673c-0.11-0.522-0.101-1.06-0.101-1.547l0-1.495c0-0.995,0-1.986,0.001-2.974       c0.001-3.951,0.003-7.844,0.004-11.669c0.002-3.825,0.004-7.583,0.006-11.263l0.001-1.376       c-0.003-0.458,0.028-0.961,0.163-1.419c0.239-0.933,0.791-1.766,1.513-2.38c0.729-0.61,1.639-0.986,2.575-1.071       c0.933-0.042,1.786-0.01,2.674-0.019c14.056,0.021,26.715,0.04,37.353,0.056c10.618,0.035,19.217,0.063,25.182,0.083       c2.958,0.021,5.262,0.038,6.846,0.049c0.769,0.011,1.36,0.02,1.781,0.026C134.768,183.303,134.973,183.321,134.973,183.321       s-0.206,0.018-0.607,0.027c-0.42,0.006-1.012,0.015-1.781,0.026c-1.585,0.011-3.889,0.028-6.846,0.049       c-5.965,0.02-14.563,0.048-25.182,0.083c-10.638,0.016-23.297,0.035-37.353,0.056c-0.869,0.01-1.785-0.018-2.63,0.022       c-0.839,0.078-1.651,0.416-2.304,0.963c-0.646,0.551-1.139,1.298-1.351,2.132c-0.236,0.815-0.111,1.747-0.143,2.668       c0.002,3.68,0.004,7.438,0.006,11.263c0.001,3.825,0.003,7.718,0.004,11.669c0,0.988,0,1.979,0.001,2.974       c0.029,0.982-0.071,2.03,0.09,2.935c0.196,0.923,0.716,1.773,1.45,2.376c0.737,0.603,1.683,0.931,2.639,0.937       c16.221,0.007,31.675,0.014,45.734,0.02c7.028,0.008,13.707,0.016,19.959,0.024c1.563,0.003,3.099,0.005,4.607,0.007       c0.754,0.001,1.501,0.003,2.241,0.004c0.735-0.014,1.49,0.044,2.161-0.059c1.373-0.212,2.569-1.148,3.13-2.354       c0.623-1.198,0.359-2.609,0.422-3.933c0.035-10.618,0.063-19.218,0.083-25.183c-0.035-1.481,0.167-2.834-0.287-3.883       c-0.417-1.051-1.143-1.753-1.8-2.147c-0.661-0.408-1.253-0.547-1.644-0.604C135.18,183.334,134.973,183.337,134.973,183.321z"/> </g> </g> </g> <g> <g> <path style="fill:#263238;" d="M130.825,198.865c0,0.144-14.442,0.26-32.252,0.26c-17.817,0-32.255-0.117-32.255-0.26      c0-0.144,14.438-0.26,32.255-0.26C116.383,198.605,130.825,198.721,130.825,198.865z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M130.825,203.434c0,0.144-14.442,0.26-32.252,0.26c-17.817,0-32.255-0.117-32.255-0.26      c0-0.144,14.438-0.26,32.255-0.26C116.383,203.174,130.825,203.29,130.825,203.434z"/> </g> </g> <g> <g> <path style="fill:#263238;" d="M100.406,208.016c0,0.036-0.477,0.07-1.34,0.101c-0.965,0.022-2.19,0.05-3.653,0.083      c-3.084,0.047-7.345,0.076-12.051,0.076c-4.707,0-8.969-0.029-12.053-0.076c-1.463-0.033-2.687-0.061-3.653-0.083      c-0.862-0.031-1.339-0.065-1.339-0.101c0-0.036,0.477-0.07,1.339-0.101c0.965-0.022,2.19-0.05,3.653-0.083      c3.084-0.047,7.345-0.076,12.053-0.076c4.706,0,8.967,0.029,12.051,0.076c1.463,0.033,2.688,0.061,3.653,0.083      C99.929,207.946,100.406,207.98,100.406,208.016z"/> </g> </g> <g> <g> <g> <path style="fill:#E8505B;" d="M129.765,211.608c0.109,0.094-1.281,1.874-3.103,3.974c-0.331,0.376-0.651,0.739-0.961,1.091       l-0.183,0.208l-0.185-0.199c-1.415-1.521-2.385-2.676-2.3-2.757c0.085-0.081,1.198,0.935,2.66,2.412l-0.368,0.009       c0.304-0.356,0.619-0.724,0.944-1.105C128.091,213.141,129.656,211.514,129.765,211.608z"/> </g> </g> <g> <g> <path style="fill:#E8505B;" d="M132.617,211.608c0.109,0.094-0.971,1.517-2.412,3.178c-0.626,0.722-1.218,1.37-1.687,1.855       l-0.165,0.171l-0.137-0.168c-0.571-0.703-0.9-1.174-0.84-1.229c0.06-0.055,0.496,0.319,1.139,0.958l-0.302,0.003       c0.414-0.534,0.972-1.211,1.599-1.933C131.252,212.784,132.508,211.514,132.617,211.608z"/> </g> </g> </g> </g> </g> </svg>
            </div>
            <div class="qcb-no-records-middle">
                <h2 class="qcb-no-records-title"><?php esc_html_e("Welcome to Quick Chat Buttons", "quick-chat-buttons") ?> &#129395;</h2>
                <div class="no-records-features">
                    <ul>
                        <li><?php echo $icons['check'] ?><?php esc_html_e(" Add and display ", "quick-chat-buttons") ?>
                            <span class="text-color"><?php esc_html_e("multi social", "quick-chat-buttons") ?></span><?php esc_html_e(" channels on your website so that your visitors can ", "quick-chat-buttons") ?>
                            <span class="text-color"><?php esc_html_e("quickly contact", "quick-chat-buttons") ?></span><?php esc_html_e(" you and share their ", "quick-chat-buttons") ?>
                            <span class="text-color"><?php esc_html_e("requirements.", "quick-chat-buttons") ?></span>
                        </li>
                        <li><?php echo $icons['check'] ?><span
                                    class="text-color"><?php esc_html_e(" Customize", "quick-chat-buttons") ?></span><?php esc_html_e(" your ", "quick-chat-buttons") ?>
                            <span class="text-color"><?php esc_html_e("widget", "quick-chat-buttons") ?></span><?php esc_html_e(" channels style according to your ", "quick-chat-buttons") ?>
                            <span class="text-color"><?php esc_html_e("requirement.", "quick-chat-buttons") ?></span>
                        </li>
                        <li>
                            <?php echo $icons['check'] ?><?php esc_html_e(" Display  your channels on ", "quick-chat-buttons") ?>
                            <span class="text-color"><?php esc_html_e("mobile, desktop", "quick-chat-buttons") ?></span><?php esc_html_e(" or ", "quick-chat-buttons") ?>
                            <span class="text-color"><?php esc_html_e("both.", "quick-chat-buttons") ?></span></li>
                    </ul>
                </div>
            </div>
            <div class="qcb-no-records-bottom">
                <a href="javascript:;"
                   class="button button-primary create-widget"><i
                            class="fas fa-plus"></i> <?php esc_html_e(" Create Your First Widget", "quick-chat-buttons"); ?>
                </a>
            </div>
        </div>
    </div>
<?php } ?>

<div class="klaxon-modal add-widget-modal">
    <div class="klaxon-modal-bg"></div>
    <div class="klaxon-modal-container small">
        <form method="post" id="qcb_form_setting"
              action="<?php echo admin_url("admin-ajax.php") ?>">
            <div class="klaxon-modal-content">
                <button type="button" class="remove-klaxon-modal">
                        <span class="svg-icon">
                            <?php echo $icons['close'] ?>
                        </span>
                </button>
                <div class="modal-title"><?php esc_html_e("Create Widget", "quick-chat-buttons") ?></div>
                <div class="modal-content padding-tb">
                    <div class="form-field">
                        <label for="widget_title" class="form-label"><?php esc_html_e("Widget Title:", "quick-chat-buttons") ?></label>
                        <div class="form-input d-grid">
                            <input type="text" name="widget_title" value="" class="input-field is-required"
                                   data-name="Widget title" id="widget_title"
                                   placeholder="Enter widget title">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button"
                            class="secondary cancel-button"><?php esc_html_e("Cancel", "quick-chat-buttons") ?></button>
                    <button type="submit" class="primary create-widget-btn save-changes"><span
                                class="kl-loader"><?php echo $icons['loader'] ?></span><?php esc_html_e(" Create Widget", "quick-chat-buttons") ?>
                    </button>
                    <input type="hidden" name="action" value="save_qcb_widget_title">
                    <input type="hidden" name="nonce" value="<?php echo wp_create_nonce("save_qcb_widget_title") ?>">
                </div>
            </div>
        </form>
    </div>
</div>