<?php
/**
 * Plugin Name: Queue Ajax Calls Performantly
 * Plugin URI:
 * Description: Provides a way to queue Ajax calls in a considerably more performantly then the usual mechanism. Uses WP MU plugin. Moreover, allows processing these Ajax calls as a batch instead of running the whole WP system for each Ajax call.
 * Version: 1.1.3
 * Author: eddr
 * Author URI: https://earlybirds.info/
 * Developer: eddr
 * Developer URI: https://earlybirds.info/
 * Text Domain: queue-ajax-calls-performantly
 * Domain Path: /languages
 * Requires PHP: 7.4
 * Requires at least: 5.8
 *
 * @package QACP
 *
 * License: GPL-3.0-or-later
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

defined( 'ABSPATH' ) || die();

require_once 'class-qacp.php';

/**
 * Starter function for the QACP plugin.
 *
 * @return object The QACP instance.
 */
function qacp() {

	global $_qacp;

	// Instantiate only once.
	//
	if ( ! isset( $_qacp ) ) {

		$_qacp = QACP::instance();
	}

	return $_qacp;
}

$_qacp = qacp();
