<?php
/**
 * This file is intended to be saved as an mu-plugin
 *
 * @package QACP
 */

if ( ! defined( 'ABSPATH' ) ) {
	// Exit if accessed directly.
	exit;
}

/**
 * Cleans PHPSESSID cookie for security reasons.
 *
 * @return array Cookies array.
 */
function qacp_clean_cookie_for_db() {

	$_cookie = $_COOKIE;
	unset( $_cookie['PHPSESSID'] );

	return $_cookie;
}

/**
 * Checks if the QACP plugin is active.
 *
 * @return bool True if the plugin is active, false otherwise.
 */
function qacp_is_plugin_active() {

	$_active = in_array(
		'qacp/qacp.php',
		apply_filters( 'active_plugins', get_option( 'active_plugins' ) )
	);

	return $_active;
}

if ( wp_doing_ajax()
	&& qacp_is_plugin_active() ) {

	$_options_file_name = '{QACP_PLUGIN_PATH}options.php';
	$_class_processors_file_name = '{QACP_PLUGIN_PATH}class-processors.php';
	$_class_processor_base_file_name = '{QACP_PLUGIN_PATH}processors/class-processor-base.php';

	if ( file_exists( $_options_file_name )
		&& file_exists( $_class_processors_file_name )
		&& file_exists( $_class_processor_base_file_name ) ) {

		require_once $_options_file_name;

		$_allowed_actions = \QACP\Options\get_ajax_actions_to_process( true );
		// phpcs:ignore
		$_current_action = sanitize_text_field( wp_unslash( $_POST['action'] ?? '' ) );
		$_action_status = isset( $_allowed_actions[ $_current_action ] ) ? 1 : 0;

		if ( ( \QACP\Options\get_is_enabled() )
			&& ( 1 === $_action_status ) ) {

			require_once ABSPATH . 'wp-includes/default-constants.php';
			require_once ABSPATH . 'wp-includes/pluggable.php';
			wp_cookie_constants();

			// Loading this class in order to process the the $_POST data.
			//
			require_once $_class_processor_base_file_name;
			require_once $_class_processors_file_name;

			$_logged_in_value = sanitize_text_field( wp_unslash( isset( $_COOKIE[ LOGGED_IN_COOKIE ] ) ) ? wp_unslash( $_COOKIE[ LOGGED_IN_COOKIE ] ) : 0 );

			$_uid = ( 0 !== $_logged_in_value ) ?
			wp_validate_auth_cookie( $_logged_in_value, 'logged_in' ) : 0;

			$_processors = new \QACP\Processors();

			// The Processor key is actually the Class name to load.
			//
			$_processor_key = $_processors->get_key_by_action( $_current_action );

			if ( ! empty( $_processor_key ) ) {

				$_processor_ob = $_processors->generate_processor_instance_by_action_key( $_processor_key );

				if ( ! empty( $_processor_ob )
					&& ! empty( $_processor_ob->get_data_map() ) ) {

					$_nonce_not_verified = ! $_processor_ob->verify_ajax_nonce();

					if ( $_nonce_not_verified ) {

						wp_die( 'nonce error' );
					}

					global $wpdb;

					$_current_timestamp = time();

					// phpcs:ignore
					$_action_data = $_processors->process_ajax_post_data( $_current_action, $_POST );

					$_all_data = array(
						'current_time' => $_current_timestamp,
						'cookie' => array_map( 'sanitize_text_field', qacp_clean_cookie_for_db() ),
						'action_data' => $_action_data,
					);

					$_table_name = $wpdb->prefix . 'qacp_queue';

					$res = $wpdb->insert(
						$_table_name,
						array(
							'data' => serialize( $_all_data ),
							'user_id' => $_uid,
							'event_time' => $_current_timestamp,
							'action' => $_current_action,
						),
						array(
							'%s',
							'%d',
							'%s',
							'%s',
						)
					); // db call ok.

					$_bypass = 0;
					if ( 1 !== $_bypass ) {

						die();
					}
				}
			}
		}
	}
}
