<?php
/**
 * Processor base class.
 *
 * @package QACP
 */

namespace QACP\Processors;

/**
 * Base Processor.
 */
abstract class Processor_Base {

	/**
	 * Associated action name.
	 *
	 * @var string action name.
	 */
	protected $_action_name = '';

	/**
	 * Cookies array. Used for storing the current cookies temporarily.
	 *
	 * @var mixed The cookies.
	 */
	private $_cookies = null;

	/**
	 * Returns the action name.
	 *
	 * @return string The action name.
	 */
	public function get_action_name() {

		return $this->_action_name;
	}
	/**
	 * Class constructor
	 *
	 * @param string $p_action_name The associated action name.
	 */
	public function __construct( $p_action_name = '' ) {

		$this->_action_name = $p_action_name;

		/**
		 * Remember to add action to the right hook in order for the processing to take place.
		 */

		add_action( 'qacp_process_one_entry_' . $this->_action_name, array( $this, 'process_entry' ), 20 );
	}

	/**
	 * Processes one ajax call entry.
	 *
	 * @param mixed $p_entry Event data entry.
	 * @return boolean true if processed, false otherwise.
	 */
	abstract public function process_entry( $p_entry );

	/**
	 * Returns the data map for the AJAX call.
	 *
	 * @return array The data map.
	 */
	abstract public function get_data_map();
	/**
	 * Registers the data map for the AJAX call.
	 *
	 * @return void
	 */
	public function register_data_map() {

		$_data_map = $this->get_data_map();

		$_processors = \QACP\Processors();
		$_processors->register_ajax_data_map( $this->_action_name, $_data_map );
	}

	/**
	 * Checks nonce.
	 *
	 * @return book true if verified, false otherwise.
	 */
	abstract public function verify_ajax_nonce();
}
