<?php
/**
 * Handling process of the queue.
 *
 * @package QACP
 */

namespace QACP\ProcessQueue;

//
// Hooking to cron events.
//
add_action( 'qacp_queue_processing', __NAMESPACE__ . '\process_next_batch' );

/**
 * Handling queue processing
 */

global $_qacp_processing_queue;

/**
 * Get QACP table name.
 */
function get_table_name_full() {

	global $wpdb;
	$_table_name = $wpdb->prefix . 'qacp_queue';
	return $_table_name;
}
/**
 * Returns plugin's table name.
 *
 * @return string The table name.
 */
function get_table_name() {

	$_table_name = 'qacp_queue';
	return $_table_name;
}

/**
 * Marks entry as sent.
 *
 * @param int $p_entry The entry data.
 * @return void
 */
function mark_event_finished( $p_entry ) {

	global $wpdb;

	$_event_id = $p_entry['id'];

	$wpdb->update(
		$wpdb->prefix . 'qacp_queue',
		array( 'sent' => 1 ),
		array( 'id' => $_event_id ),
		null,
		array( '%d' )
	); // db call ok.
}

/**
 * Processes the next batch of events.
 *
 * @param [type] $p_batch_size number of events to process.
 * @param array  $p_args additional arguments.
 * @return void
 */
function process_next_batch( $p_batch_size = null, $p_args = array() ) {

	global $wpdb;

	$_swap_die_handler = true;

	$_batch_size = empty( $p_batch_size ) ? \QACP\Options\get_cron_requests_num_to_process() : $p_batch_size;

	$_entries = $wpdb->get_results(
		$wpdb->prepare(
			// phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared
			"select * from {$wpdb->prefix}qacp_queue WHERE sent is NULL Order By `id` ASC LIMIT %d",
			$_batch_size
		),
		ARRAY_A
	); // db call ok.

	// Simulate ajax.
	//
	add_filter( 'wp_doing_ajax', '__return_true', 9999 );

	// Query Monitor bypass.
	//
	add_filter( 'user_has_cap', __NAMESPACE__ . '\disable_qm_for_user', 10, 4 );

	do_action( 'qacp_before_batch_processing' );

	if ( ! empty( $_entries ) ) {

		// prevent wp_die in order to keep the loop running.
		//
		if ( $_swap_die_handler ) {

			remove_all_filters( 'wp_die_handler' );

			// Prevent wp_die from killing the loop.
			//
			add_filter( 'wp_die_handler', __NAMESPACE__ . '\swap_die_handlers' );
			add_filter( 'wp_die_ajax_handler', __NAMESPACE__ . '\swap_die_handlers' );
			add_filter( 'wp_die_json_handler', __NAMESPACE__ . '\swap_die_handlers' );
			add_filter( 'wp_die_jsonp_handler', __NAMESPACE__ . '\swap_die_handlers' );

		}

		add_action( 'qacp_mark_event_finished', __NAMESPACE__ . '\mark_event_finished', 10 );

		global $_qacp_processing_queue;
		$_qacp_processing_queue = true;

		foreach ( $_entries as $entry ) {

			$_action_name = $entry['action'];

			do_action( "qacp_before_process_entry_{$_action_name}", $entry );
			do_action( 'qacp_before_process_entry', $entry );

			/**
			 * Hook to 'qacp_process_one_entry' to process your data.
			 *
			 * $entry contains:
			 * 1. 'cookie' - cookies there were when the call was made.
			 * 2. 'event' - event name.
			 * 3. 'data' - Ajax call data.
			 * 4. 'event_time' - time of the event call.
			 * 5. 'action' - action name.
			 */

			// Non class based approach.
			// It's important to make a smart use.
			//
			do_action( "qacp_process_one_entry_{$_action_name}", $entry );
			do_action( 'qacp_process_one_entry', $entry );

			// Mark event as done, if processed.
			//
			do_action( 'qacp_mark_event_finished', $entry );

			do_action( "qacp_after_process_entry_{$_action_name}", $entry );
			do_action( 'qacp_after_process_entry', $entry );
		}

		$_qacp_processing_queue = false;

		if ( $_swap_die_handler ) {

			remove_filter( 'wp_die_ajax_handler', __NAMESPACE__ . '\swap_die_handlers' );
			remove_filter( 'wp_die_handler', __NAMESPACE__ . '\swap_die_handlers' );
			remove_filter( 'wp_die_json_handler', __NAMESPACE__ . '\swap_die_handlers' );
			remove_filter( 'wp_die_jsonp_handler', __NAMESPACE__ . '\swap_die_handlers' );
		}
	}
	remove_filter( 'wp_doing_ajax', '__return_true', 9999 );
	do_action( 'qacp_after_batch_processing' );
}

/**
 * Prevent wp from dying.
 *
 * @param string $p_message death message.
 * @param string $p_title death title.
 * @param array  $args additional arguments.
 * @return bool false.
 */
function die_handler( $p_message, $p_title = '', $args = array() ) {

	return false;
}

/**
 * Intermediate function is necessary to customize wp_die.
 * Intended to prevent early death by other plugins while the queue is running.
 *
 * @return string the handler for the new die function.
 */
function swap_die_handlers() {

	return __NAMESPACE__ . '\die_handler';
}

/**
 * Disables QM for user so no HTML is outputted.
 *
 * @param array    $p_user_caps user capabilities.
 * @param array    $p_required_caps required user capabilities.
 * @param array    $p_args additional arguments.
 * @param \WP_User $p_user user object.
 * @return array the user caps.
 */
function disable_qm_for_user( array $p_user_caps, array $p_required_caps, array $p_args, \WP_User $p_user ) {

	$p_user_caps['view_query_monitor'] = false;

	return $p_user_caps;
}
